/****************************************************************
**
** Attal : Lords of Doom
**
** attalServer.cpp
** the server : manage connections
**
** Version : $Id: attalServer.cpp,v 1.45 2006/08/09 11:36:00 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 28/10/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "attalServer.h"


// generic include files
// include files for QT
#include <QTcpSocket>

// application specific includes
#include "libCommon/artefact.h"
#include "libCommon/artefactManager.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericEvent.h"
#include "libCommon/genericMapCreature.h"
#include "libCommon/log.h"
#include "libCommon/priceMarket.h"
#include "libCommon/unit.h"


extern DataTheme DataTheme;

//
// ----- AttalPlayerSocket -----
//

AttalPlayerSocket::AttalPlayerSocket( )
	: AttalSocket(), _player( 0 )
{
}

bool AttalPlayerSocket::canSee( int row, int col )
{
	bool ret = false;

	if( _player ) {
		ret = _player->canSee( row, col );
	}

	return ret;
}

bool AttalPlayerSocket::canSee( GenericCell * cell )
{
	bool ret = false;

	if( _player ) {
		ret = _player->canSee( cell );
	}

	return ret;
}


//
// ----- AttalServer -----
//

AttalServer::AttalServer( int port )
	: QTcpServer( 0 )
{	
	listen( QHostAddress::Any, port );
	_num = 0;
	_currentSocket = 0;
	//_theSockets.setAutoDelete( true );
	_mapper = new QSignalMapper( this );
	connect( _mapper, SIGNAL( mapped( int ) ), SIGNAL( sig_readEvent( int ) ) );	
}

AttalServer::~AttalServer()
{
	while (!_theSockets.isEmpty()) {
		delete _theSockets.takeFirst();
	}
}

void AttalServer::incomingConnection( int socketDescriptor )
{
	
	AttalPlayerSocket * uneso = new AttalPlayerSocket();
	GenericPlayer * player = new GenericPlayer();
	uneso->setSocketDescriptor( socketDescriptor );

	uneso->setPlayer( player );
	//uneso->setSocket( num_socket );

	_theSockets.append( uneso );
	_mapper->setMapping( uneso, _theSockets.count()-1 );
	connect( uneso, SIGNAL( readyRead() ), _mapper, SLOT( map() ) );
	connect( uneso, SIGNAL( connectionClosed() ), SLOT( slot_socketClose() ) );
	emit sig_newPlayer( uneso );

	uneso->sendConnectionOk();
}

void AttalServer::slot_socketClose()
{
	AttalPlayerSocket * uneso =(AttalPlayerSocket*)sender();
	if( uneso->getPlayer()) {
		sendMessage(uneso->getPlayer()->getName() + "  disconnect");
		emit sig_endConnection( uneso->getPlayer()->getName() );
	}
	closeConnectionSocket( uneso );
}

void AttalServer::closeConnectionSocket(AttalPlayerSocket * uneso)
{

	uneso->setPlayer( 0 );

	/// old stuff _theSockets.remove( uneso ); -> now _theSockets.removeAt( it );
	int it = _theSockets.indexOf( uneso );
	if (it != -1) {
		_theSockets.removeAt( it );
	}
	
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_mapper->setMapping( _theSockets[ i ], i );
		_theSockets[ i ]->sendConnectionId( i );
	}
	
	/* was if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			num=_theSockets.find(ite.current());
			_mapper->setMapping( ite.current(), num);
			ite.current()->sendConnectionId(num);
		}
	}*/
}

void AttalServer::closeConnectionPlayer( QString name )
{
	AttalPlayerSocket * uneso = NULL;
	
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		if( _theSockets[ i]->getPlayer()->getName() == name ) {
			uneso =  _theSockets[ i];
			sendMessage(uneso->getPlayer()->getName() + "  kicked");
			emit sig_endConnection( uneso->getPlayer()->getName() );
			break;
		}
	}
	if(uneso) {
		uneso->close();
	}
}

void AttalServer::sendConnectionId( char num )
{
	_theSockets.at( num )->sendConnectionId( num );
}

void AttalServer::sendConnectionPlayer( GenericPlayer * dest, GenericPlayer * player )
{
	findSocket( dest )->sendConnectionPlayer( player );
}

void AttalServer::getSocketData( int num )
{
	_num = num;
	_theSockets.at( num )->readData();
}

void AttalServer::copyData( AttalSocket* data )
{
	_theSockets.at( _num )->copyData( data );
}

uchar AttalServer::getCla1()
{
	return _theSockets.at( _num )->getCla1();
}

uchar AttalServer::getCla2()
{
	return _theSockets.at( _num )->getCla2();
}

uchar AttalServer::getCla3()
{
	return _theSockets.at( _num )->getCla3();
}

int AttalServer::readInt()
{
	return _theSockets.at( _num )->readInt();
}

unsigned char AttalServer::readChar()
{
	return _theSockets.at( _num )->readChar();
}

bool AttalServer::isData( int num )
{
	return (_theSockets.at(num)->bytesAvailable() > 0);
}

void AttalServer::startGame()
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendBegGame( nbSockets );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );
	
	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendBegGame( _theSockets.count() );
		}
	}*/
}

void AttalServer::playerLose( GenericPlayer * player )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendLostGame( player );
	}
	/* was
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendLostGame( player );
		}
	}*/
}

void AttalServer::playerWin( GenericPlayer * player )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendWinGame( player );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendWinGame( player );
		}
	}
	*/
}

void AttalServer::sendGameInfoPlayer()
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_currentSocket->sendGameInfoPlayerTeam( _theSockets[ i ]->getPlayer() );
	}
	/* was
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			_currentSocket->sendGameInfoPlayerTeam( ite.current()->getPlayer() );
		}
	}
	*/
}

void AttalServer::sendGameCalendar(Calendar * calendar)
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_currentSocket->sendGameCalendar( calendar );
	}
}

void AttalServer::sendConnectionName(const QString & name, int num )
{
	_theSockets.at( num )->sendConnectionName( name );
}

void AttalServer::endGame()
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendEndGame();
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendEndGame();
		}
	}*/
}

void AttalServer::sendTavernInfo( uchar nbLord )
{
	_currentSocket->sendTavernInfo( nbLord );
}

void AttalServer::sendTavernLord( GenericLord * lord )
{
	_currentSocket->sendTavernLord( lord );
}

void AttalServer::beginTurn()
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendTurnPlaying( _currentSocket->getPlayer() );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendTurnPlaying( _currentSocket->getPlayer() );
		}
	}*/
}

void AttalServer::sendLordPlTurn( int count )
{
	_currentSocket->sendLordPlTurn( count );
}

void AttalServer::startFight( GenericLord * myLord, GenericPlayer * opponent, GenericLord * opponentLord )
{
	int i;

	_currentSocket->sendFightInit( FIGHTER_ATTACK, myLord );
	_currentSocket->sendFightLord( FIGHTER_DEFENSE, opponentLord );
	for( i = 0; i < MAX_UNIT; i++ ) {
		if( opponentLord->getUnit( i ) ) {
			_currentSocket->sendFightNewUnit( FIGHTER_DEFENSE, i, opponentLord->getUnit( i ) );
		}
	}

	AttalPlayerSocket * opponentSocket = findSocket( opponent );
	opponentSocket->sendFightInit( FIGHTER_DEFENSE, opponentLord );
	opponentSocket->sendFightLord( FIGHTER_ATTACK, myLord );
	for( i = 0; i < MAX_UNIT; i++ ) {
		if( myLord->getUnit( i ) ) {
			opponentSocket->sendFightNewUnit( FIGHTER_ATTACK, i, myLord->getUnit( i ) );
		}
	}

}

void AttalServer::startFight( GenericLord * myLord, GenericFightUnit * opponentUnits[MAX_UNIT] )
{
	_currentSocket->sendFightInit( FIGHTER_ATTACK, myLord );
	_currentSocket->sendFightCreature();

	for( int i = 0; i < MAX_UNIT; i++ ) {
		if( opponentUnits[i] ) {
			_currentSocket->sendFightNewUnit( FIGHTER_DEFENSE, i, opponentUnits[i] );
		}
	}
}

void AttalServer::moveUnit( GenericPlayer * player, CLASS_FIGHTER fighter, int num, GenericFightCell * cell )
{
	AttalPlayerSocket * sock = findSocket( player );
	sock->sendFightUnitMove( fighter, num, cell );
}

void AttalServer::updateUnit( GenericPlayer * player, CLASS_FIGHTER fighter, int num, GenericFightUnit * unit )
{
	AttalPlayerSocket * sock = findSocket( player );
	sock->sendFightModifyUnit( fighter, num, unit );
}

void AttalServer::damageUnit( GenericPlayer * player,
			      CLASS_FIGHTER attacker,
			      int numAttacker,
			      CLASS_ATTACK_TYPE attackType,
			      CLASS_FIGHTER defender,
			      int numDefender,
			      uint damage )
{
	AttalPlayerSocket * sock = findSocket( player );
	sock->sendFightDamageUnit( attacker,
				   numAttacker,
				   attackType,
				   defender,
				   numDefender,
				   damage );
}

void AttalServer::activateUnit( GenericPlayer * player, CLASS_FIGHTER fighter, int num )
{
	AttalPlayerSocket * sock = findSocket( player );
	sock->sendFightActivate( fighter, num );
}

void AttalServer::endFight(GenericPlayer * attackPlayer, GenericPlayer * defendPlayer, FightResultStatus result )
{
	AttalPlayerSocket * current = findSocket( attackPlayer );
	current->sendFightEnd( result );

	if( defendPlayer ) {
		current = findSocket( defendPlayer );
		current->sendFightEnd( result );
	}
}

void AttalServer::sendMessage( QString msg )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendMessage( msg );
	}
	/*
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendMessage( msg );
		}
	}*/
}

void AttalServer::sendFightMessage( QString msg, GenericPlayer * attackPlayer, GenericPlayer * defendPlayer )
{
	AttalPlayerSocket * current = findSocket( attackPlayer );
	current->sendMessage( msg );

	if( defendPlayer ) {
		current = findSocket( defendPlayer );
		current->sendMessage( msg );
	}
}

void AttalServer::sendPlayerResource( char ressource, int nb )
{
	_currentSocket->sendPlayerResource( ressource, nb );
}

void AttalServer::sendPlayerPrice( char ressource, int price )
{
	_currentSocket->sendPlayerPrice( ressource, price );
}

void AttalServer::sendPlayerResources( GenericPlayer * player )
{
	AttalPlayerSocket * current = findSocket( player );
	for( int i = 0; i < DataTheme.resources.count(); i++ ) {
		current->sendPlayerResource( i, player->getResource( i ) );
	}
}

void AttalServer::sendPlayerPrices( GenericPlayer * player )
{
	AttalPlayerSocket * current = findSocket( player );
	uint nbRes = DataTheme.resources.count();
	int price;
	for( uint i = 0; i < nbRes; i++ ) {
		price = player->getPriceMarket()->getResourcePrice( i );
		current->sendPlayerPrice( i, price );
	}
}


void AttalServer::sendPlayerPopulation( GenericPlayer * player )
{
	AttalPlayerSocket * current = findSocket( player );
	uint population	 = player->getPopulation();
	current->sendPlayerPopulation( population );
}



/*!

*/

void AttalServer::sendSizeMap( int h, int w )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendSizeMap( h, w );
	}
	
	/* was 
 	QListIterator<AttalPlayerSocket> ite( _theSockets );
	
	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendSizeMap( h, w );
		}
	}	
	*/   
}

void AttalServer::sendCell( GenericCell * cell )
{
	_currentSocket->sendCell( cell );
}

void AttalServer::sendAskNone( const QString & msg, bool toAll )
{
	if( toAll ) {
		uint nbSockets = (uint) _theSockets.count();
		for( uint i = 0; i < nbSockets; ++i ) {
			_theSockets[ i ]->sendAskNone( msg );
		}
		/* was
		QListIterator<AttalPlayerSocket> ite( _theSockets );
		
		if( !ite.isEmpty() ) {
			for( ite.atFirst(); ite.current(); ++ite ) {
				ite.current()->sendAskNone( msg );
			}
		}*/
	} else {
		_currentSocket->sendAskNone( msg );
	}
}

void AttalServer::sendAskChest()
{
	_currentSocket->sendAskChest();
}

void AttalServer::sendAskCreatureJoin( GenericMapCreature * creature )
{
	_currentSocket->sendAskCreatureJoin( creature );
}
	
void AttalServer::sendAskCreatureMercenary( GenericMapCreature * creature )
{
	_currentSocket->sendAskCreatureMercenary( creature );
}

void AttalServer::sendAskCreatureFlee( GenericMapCreature * creature )
{
	_currentSocket->sendAskCreatureFlee( creature );
}

void AttalServer::updateUnits( GenericLord * lord )
{
	if( lord ) {
		if( _currentSocket->getPlayer() == lord->getOwner() ) {
			_currentSocket->sendLordUnits( lord );
		} else {
			/// XXX: would be better to send category of units and not real values
			_currentSocket->sendLordUnits( lord );
		}
	}
}

void AttalServer::updateUnit( GenericLord * lord , int num)
{
	if( lord ) {
		if( _currentSocket->getPlayer() == lord->getOwner() ) {
			_currentSocket->sendLordUnit( lord , num );
		} else {
			/// XXX: would be better to send category of units and not real values
			_currentSocket->sendLordUnit( lord , num);
		}
	}
}

void AttalServer::newLord( GenericLord * lord )
{
	if( lord ) {
		if( _currentSocket->getPlayer() == lord->getOwner() ) {
			_currentSocket->sendLordNew( lord );
			_currentSocket->sendLordBaseCharac( lord, MOVE );
			_currentSocket->sendLordBaseCharac( lord, MAXMOVE );
			_currentSocket->sendLordBaseCharac( lord, TECHNICPOINT );
			_currentSocket->sendLordBaseCharac( lord, MAXTECHNICPOINT );
			_currentSocket->sendLordBaseCharac( lord, MORALE );
			_currentSocket->sendLordBaseCharac( lord, LUCK );
			_currentSocket->sendLordBaseCharac( lord, EXPERIENCE );
			_currentSocket->sendLordBaseCharac( lord, ATTACK );
			_currentSocket->sendLordBaseCharac( lord, DEFENSE );
			_currentSocket->sendLordBaseCharac( lord, POWER );
			_currentSocket->sendLordBaseCharac( lord, KNOWLEDGE );
			_currentSocket->sendLordBaseCharac( lord, CHARISMA );
			_currentSocket->sendLordUnits( lord );

			for( uint i = 0; i < lord->getArtefactManager()->getArtefactNumber(); i++ ) {
				_currentSocket->sendArtefactLord( lord->getArtefactManager()->getArtefact( i ), true );
			}
			for( uint j = 0; j < lord->getMachineNumber(); j++ ) {
				_currentSocket->sendLordMachine( lord, lord->getMachine( j ) );
			}
		} else {
			_currentSocket->sendLordVisit( lord );
			/// XXX: would be better to send category of units and not real values
			_currentSocket->sendLordUnits( lord );
		}
	}
}

void AttalServer::sendLordVisit( GenericLord * lord, GenericPlayer * player, bool state )
{
	AttalPlayerSocket * socket = findSocket( player );
 	socket->sendLordVisit( lord, state );
}

void AttalServer::updateLordBaseUnits( GenericBase * base ,GenericLord * lord , int flag)
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		if( _theSockets[ i ] != _currentSocket ) {
			//_theSockets[ i ]->sendExchangeBaseUnitCl( base, unit1, lord, unit2 );
			if( flag == 0 || flag == 2 ) {
				for( int i = 0; i < MAX_UNIT; ++i ) {
					_theSockets[ i ]->sendBaseUnit( base, base->getUnit( i ) );
				}
			}	
			if( flag == 1 || flag == 2 ) {
				_theSockets[ i ]->sendLordUnits( lord );
			}
		}
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			if( ite.current() != _currentSocket ) {
				if(flag==0 || flag==2){
					for( int i = 0; i < MAX_UNIT; i++ ) {
						ite.current()->sendBaseUnit( base, base->getUnit(i) );
					}
				}
				if(flag==1 || flag==2){
					ite.current()->sendLordUnits(lord);
				}
			}
		}
	}*/
}
	
void AttalServer::updateLord( GenericLord * lord )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendLordBaseCharac( lord, MOVE );
		_theSockets[ i ]->sendLordBaseCharac( lord, MAXMOVE );
		_theSockets[ i ]->sendLordBaseCharac( lord, TECHNICPOINT );
		_theSockets[ i ]->sendLordBaseCharac( lord, MAXTECHNICPOINT );
		_theSockets[ i ]->sendLordBaseCharac( lord, MORALE );
		_theSockets[ i ]->sendLordBaseCharac( lord, LUCK );
		_theSockets[ i ]->sendLordBaseCharac( lord, EXPERIENCE );
		_theSockets[ i ]->sendLordBaseCharac( lord, ATTACK );
		_theSockets[ i ]->sendLordBaseCharac( lord, DEFENSE );
		_theSockets[ i ]->sendLordBaseCharac( lord, POWER );
		_theSockets[ i ]->sendLordBaseCharac( lord, KNOWLEDGE );
		_theSockets[ i ]->sendLordUnits( lord );

		for( uint j = 0; j < lord->getArtefactManager()->getArtefactNumber(); j++ ) {
			_theSockets[ i ]->sendArtefactLord( lord->getArtefactManager()->getArtefact( j ), true );
		}
		for( uint k = 0; k < lord->getMachineNumber(); k++ ) {
			_theSockets[ i ]->sendLordMachine( lord, lord->getMachine( k ) );
		}
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
				ite.current()->sendLordBaseCharac( lord, MOVE );
				ite.current()->sendLordBaseCharac( lord, MAXMOVE );
				ite.current()->sendLordBaseCharac( lord, TECHNICPOINT );
				ite.current()->sendLordBaseCharac( lord, MAXTECHNICPOINT );
				ite.current()->sendLordBaseCharac( lord, MORALE );
				ite.current()->sendLordBaseCharac( lord, LUCK );
				ite.current()->sendLordBaseCharac( lord, EXPERIENCE );
				ite.current()->sendLordBaseCharac( lord, ATTACK );
				ite.current()->sendLordBaseCharac( lord, DEFENSE );
				ite.current()->sendLordBaseCharac( lord, POWER );
				ite.current()->sendLordBaseCharac( lord, KNOWLEDGE );
				ite.current()->sendLordBaseCharac( lord, CHARISMA );
				ite.current()->sendLordUnits( lord );

				for( uint i = 0; i < lord->getArtefactManager()->getArtefactNumber(); i++ ) {
					ite.current()->sendArtefactLord( lord->getArtefactManager()->getArtefact( i ), true );
				}
				for( uint j = 0; j < lord->getMachineNumber(); j++ ) {
					ite.current()->sendLordMachine( lord, lord->getMachine( j ) );
				}
		}
	}*/
}

void AttalServer::sendLordRemove( GenericLord * lord )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendLordRemove( lord );
	}
	
	/* was 
    	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendLordRemove( lord );
		}
	}*/
}

void AttalServer::sendCreatureRemove( GenericCell * cell )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendDelCreature( cell );
	}
	/* was
    	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendDelCreature( cell );
		}
	}*/
}

void AttalServer::setGarrison( GenericLord * lord, bool state )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendLordGarrison( lord, state );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendLordGarrison( lord, state );
		}
	}
	*/
}


void AttalServer::newBase( GenericBase * base )
{
   	//QListIterator<AttalPlayerSocket> ite( _theSockets );

	//if( !ite.isEmpty() ) {
	//	for( ite.atFirst(); ite.current(); ++ite ) {
	//		ite.current()->sendBaseNew( base );
			// XXX: send info only for owner... ?
			//if( ite.current() == _currentSocket ) {
	//			for( uint i = 0; i < base->getBuildingCount(); i++ ) {
	//				ite.current()->sendBaseBuilding( base, base->getBuilding( i ), true );
	//			}
		//	}
	//	}
	//}

	_currentSocket->sendBaseNew( base );
	for( uint i = 0; i < base->getBuildingCount(); i++ ) {
		_currentSocket->sendBaseBuilding( base, base->getBuilding( i ), true );
	}
	for(int i = 0; i < MAX_UNIT; i++ ) {
		_currentSocket->sendBaseUnit( base, base->getUnit(i) );
	}
	_currentSocket->sendBaseName( base );
}

void AttalServer::updateBaseBuilding( GenericBase * base, GenericInsideBuilding * building , GenericPlayer * player )
{
	AttalPlayerSocket * socket = findSocket( player );

	bool found = false;
	for( uint i = 0; i < base->getBuildingCount(); i++ ) {
		GenericInsideBuilding * build = base->getBuilding( i );
		if( build == building ) {
			socket->sendBaseBuilding( base, build, true );
			found = true;
		}
	}
	if( ! found ) {
		socket->sendBaseBuilding( base, building, false );
	}
}

void AttalServer::sendBaseUnit( GenericBase * base, Creature * creature, int number )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendBaseUnit( base, creature, number );
	}
	/* was
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendBaseUnit( base, creature, number );
		}
	}*/
}

void AttalServer::sendBasePopulation( GenericBase * base , GenericPlayer * player)
{
 	AttalPlayerSocket * socket = findSocket( player );

	socket->sendBasePopulation( base );
}

void AttalServer::sendBaseProduction( GenericBase * base , GenericPlayer * player)
{
 	AttalPlayerSocket * socket = findSocket( player );

	int creatCount = base->getCreatureNumber();
	int i = 0;
	for( i = 0; i < creatCount; i ++) {
		socket->sendBaseProduction(base , base->getCreatureProduced(i));
	}
}

void AttalServer::sendLordExchange( GenericLord * lord1, GenericLord * lord2 )
{
	_currentSocket->sendExchangeStart( lord1, lord2 );
}

void AttalServer::sendExchangeUnit( GenericLord * lord1, uchar unit1, GenericLord * lord2, uchar unit2 )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendExchangeUnit( lord1, unit1, lord2, unit2 );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			//if( ite.current() != _currentSocket ) {
				ite.current()->sendExchangeUnit( lord1, unit1, lord2, unit2 );
			//}
		}
	}*/
}

void AttalServer::sendExchangeArtefact( GenericLord * /* lord1 */, int /* item */, GenericLord * /* lord2 */ )
{
	/// XXX: _currentSocket->sendExchangeArtefact( lord1, item, lord2 ); unused ??
}

void AttalServer::sendExchangeBaseUnitCl( GenericBase * base, uchar unit1, GenericLord * lord, uchar unit2 )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendExchangeBaseUnitCl( base, unit1, lord, unit2 );
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			//if( ite.current() != _currentSocket ) {
				ite.current()->sendExchangeBaseUnitCl( base, unit1, lord, unit2 );
			//}
		}
	}*/
}

void AttalServer::ownBase( GenericBase * base, GenericPlayer * player )
{
 	AttalPlayerSocket * socket = findSocket( player );

	/// XXX: owner could be computed in AttalSocket
	GenericPlayer * owner = base->getOwner();
 	socket->sendBaseOwner( base, owner );
	socket->sendBasePopulation( base );
}

/*!

*/

void AttalServer::newBuilding( GenericBuilding * build )
{
   	//QListIterator<AttalPlayerSocket> ite( _theSockets );

	//if( !ite.isEmpty() ) {
	//	for( ite.atFirst(); ite.current(); ++ite ) {
	//		ite.current()->sendBuildingNew( build );
	//	}
	//}
	_currentSocket->sendBuildingNew( build );
}


void AttalServer::ownBuilding( GenericBuilding * build, GenericPlayer * player )
{
 	AttalPlayerSocket * socket = findSocket( player );

	/// XXX: owner could be computed in AttalSocket
	GenericPlayer * owner = build->getOwner();
 	socket->sendBuildingOwner( build, owner );
}

void AttalServer::ownArtefact( GenericLordArtefact * artefact, GenericPlayer * player )
{
       AttalPlayerSocket * current = findSocket( player );
       current->sendArtefactLord( artefact, true );
}

void AttalServer::newCreature( GenericMapCreature * creature )
{
	_currentSocket->sendNewCreature( creature );
}

void AttalServer::updateCreature( GenericMapCreature * creature )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		if( _theSockets[ i ]->canSee( creature->getCell() ) ) {
			_theSockets[ i ]->sendUpdateCreature( creature );
		}
	}
	/* was
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			if( ite.current()->canSee( creature->getCell() ) ) {
				ite.current()->sendUpdateCreature( creature );
			}
		}
	}*/
}

void AttalServer::delCreature( GenericCell * cell )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendDelCreature( cell );
	}
	/*
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			ite.current()->sendDelCreature( cell );
		}
	}*/
}

void AttalServer::newEvent( GenericEvent * event )
{
/*	QListIterator<AttalPlayerSocket> ite( _theSockets );
        if( !ite.isEmpty() ) {
                for( ite.atFirst(); ite.current(); ++ite ) {
			if( ite.current()->canSee( event->getCell() ) ) {
                        	ite.current()->sendNewEvent( event );
			}
                }
        }
*/
	if( _currentSocket->canSee( event->getCell() ) ) {
		_currentSocket->sendNewEvent( event );
	}
}

void AttalServer::delEvent( GenericEvent * event )
{
	/// XXX: for all players ?!??
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		_theSockets[ i ]->sendDelEvent( event );
	}
	/* was
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			/// XXX: not for all players!!
			ite.current()->sendDelEvent( event );
		}
	}*/
}

AttalPlayerSocket * AttalServer::findSocket( GenericPlayer * player )
{
	uint nbSockets = (uint) _theSockets.count();
	for( uint i = 0; i < nbSockets; ++i ) {
		if( _theSockets[ i ]->getPlayer() == player ) {
			return _theSockets[ i ];
		}
	}
	/* was
  	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			if ( ite.current()->getPlayer() == player )
				return ite.current();
		}
	}*/
	
	logEE( "Socket not found" );
	return 0;
}



/*!

*/

void AttalServer::sendMvt( GenericPlayer * /*dest*/, int lord, int i, int j )
{
	/// XXX: useless dest ?
	uint nbSockets = (uint) _theSockets.count();
	for( uint k = 0; k < nbSockets; ++k ) {
		if( _theSockets[ k ]->canSee( i, j ) ) {
			_theSockets[ k ]->sendMvt( lord, i, j );
		}
	}
	/* was 
	QListIterator<AttalPlayerSocket> ite( _theSockets );

	if( !ite.isEmpty() ) {
		for( ite.atFirst(); ite.current(); ++ite ) {
			if( ite.current()->canSee( i, j ) ) {
				ite.current()->sendMvt( lord, i, j );
			}
		}
	}*/
}

void AttalServer::sendLordCharac( GenericPlayer * player, GenericLord * lord, LordCharac charac )
{
	AttalPlayerSocket * current = findSocket( player );
	current->sendLordBaseCharac( lord, charac );
}





