/****************************************************************
**
** Attal : Lords of Doom
**
** mapView.cpp
** subclass of QCanvasSprite that handles mouse event ...
**
** Version : $Id: mapView.h,v 1.4 2005/12/26 18:27:43 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef MAPVIEW_H
#define MAPVIEW_H
 
 
// generic include files
// include files for QT
#include <Q3Canvas>
//Added by qt3to4:
#include <QMouseEvent>

// application specific includes
#include "libClient/map.h"
#include "libClient/cell.h"
 
/*              ------------------------------
 *                         MapView
 *              ------------------------------ */



/** subclass of QCanvasSprite that handles mouse event ... in the map */
class MapView : public Q3CanvasView
{
	Q_OBJECT
public:
	/** Constructor */
	MapView( Map * map, QWidget * parent = 0, const char * name = 0, Qt::WFlags f = 0 );

	void goToPosition(Cell * cell);

signals:
	/** Signal if the mouse has moved */
	void sig_mouseMoved( Cell *cell );
	
	/** Signal if the mouse has been pressed (right button)*/
	void sig_mouseRightPressed( Cell *cell );
	
	/** Signal if the mouse has been pressed (left button)*/
	void sig_mouseLeftPressed( Cell *cell );
	
	void sig_mouseReleased();
	
	void sig_viewportChanged( int, int, int, int );
	
	//void sig_mapviewChanged( int, int );
			
protected:
	/** reimplemented : handles mouse event */
	void contentsMouseMoveEvent ( QMouseEvent * event );
	void contentsMouseReleaseEvent( QMouseEvent * event );
	void contentsMousePressEvent( QMouseEvent * event );
	void contentsMouseDoubleClickEvent( QMouseEvent * event );
	void resizeEvent( QResizeEvent * event );
	
	bool _press;
	Map * _map;
};
 
#endif // MAPVIEW_H   
