/****************************************************************
**
** Attal : Lords of Doom
**
** imageTheme.cpp
** manage images in theme
**
** Version : $Id: imageTheme.cpp,v 1.50 2006/05/03 17:16:50 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 10/06/2001
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "imageTheme.h"

// generic include files

// include files for QT
#include <QImage>
#include <QPixmap>
#include <QTime>

#include <Q3PointArray>
#include <Q3PtrList>
#include <Q3Canvas>
#include <Q3ValueList>

// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericMapCreature.h"
#include "libCommon/log.h"
#include "libCommon/unit.h"

ImageTheme ImageTheme;

extern DataTheme DataTheme;
extern QString IMAGE_PATH;

//
// ----- CreaturePixmap -----
//
//old code remove it?
/*
CreaturePixmap::CreaturePixmap( Q3PtrList<QPixmap> pix, Q3PtrList<QPoint> hotspots )
{
	_pixmaps[0] = new Q3CanvasPixmapArray( pix, hotspots );

	Q3PtrList<QPixmap> newList;
	newList.setAutoDelete( true );
	for( uint i=0; i<pix.count(); i++ ) {
		Q3CanvasPixmap oldPix( *pix.at(i), *hotspots.at(i) );
		Q3CanvasPixmap * newPix;
		QImage newImg;
		if( !oldPix.isNull() ) {
			newImg = oldPix.toImage().mirrored( true, false );
			newPix = new Q3CanvasPixmap( newImg );
			newList.append( newPix );
		} else {
			newList.append( new QPixmap() );
		}
	}
	_pixmaps[1] = new Q3CanvasPixmapArray( newList, hotspots );
}
*/

CreaturePixmap::CreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots )
{
	_pixmaps[0] = new Q3CanvasPixmapArray( pix, hotspots );

	Q3ValueList<QPixmap> newList;
	for( int i = 0; i < pix.count(); i++ ) {
		Q3CanvasPixmap oldPix( pix[ i ], hotspots.at(i) );
		QImage newImg;
		if( !oldPix.isNull() ) {
			newImg = (QImage) oldPix.toImage().mirrored( true, false );
			Q3CanvasPixmap newPix(newImg);
			newList.append( newPix ) ;
		} else {
			newList.append( QPixmap() );
		}
	}
	_pixmaps[1] = new Q3CanvasPixmapArray( newList, hotspots );
}

CreaturePixmap::CreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots , const Q3ValueList<QPixmap> & newpix)
{
	_pixmaps[0] = new Q3CanvasPixmapArray( pix, hotspots );
	_pixmaps[1] = new Q3CanvasPixmapArray( newpix, hotspots );
}

CreaturePixmap::~CreaturePixmap()
{
	if( _pixmaps[0] ) {
		delete _pixmaps[0];
	}

	if( _pixmaps[1] ) {
		delete _pixmaps[1];
	}
}

Q3CanvasPixmapArray * CreaturePixmap::operator[]( uint i )
{
	return _pixmaps[i%2];
}

//
// ----- MapCreaturePixmap -----
//

MapCreaturePixmap::MapCreaturePixmap( Q3PtrList<QPixmap> pix, Q3PtrList<QPoint> hotspots )
{
	_pixmaps[0] = new Q3CanvasPixmapArray( pix, hotspots );

	Q3PtrList<QPixmap> newList;
	for( uint i=0; i<pix.count(); i++ ) {
		Q3CanvasPixmap oldPix( * pix.at( i ), * hotspots.at(i) );
		Q3CanvasPixmap * newPix;
		QImage newImg;
		if( !oldPix.isNull() ) {
			newImg = oldPix.toImage().mirrored( true, false );
			newPix = new Q3CanvasPixmap( newImg );
			newList.append( newPix );
		} else {
			newList.append( new QPixmap() );
		}
	}
	_pixmaps[1] = new Q3CanvasPixmapArray( newList, hotspots );
}

MapCreaturePixmap::MapCreaturePixmap( const Q3ValueList<QPixmap> & pix, const Q3PointArray & hotspots )
{
	_pixmaps[0] = new Q3CanvasPixmapArray( pix, hotspots );

	Q3ValueList<QPixmap> newList;
	for( int i = 0; i < pix.count(); i++ ) {
		Q3CanvasPixmap oldPix( pix[ i ], hotspots.at(i) );
		QImage newImg;
		if( !oldPix.isNull() ) {
			newImg = oldPix.toImage().mirrored( true, false );
			Q3CanvasPixmap newPix(newImg);
			newList.append( newPix ) ;
		} else {
			newList.append( QPixmap() );
		}
	}
	_pixmaps[1] = new Q3CanvasPixmapArray( newList, hotspots );

}

MapCreaturePixmap::~MapCreaturePixmap()
{
	if( _pixmaps[0] ) {
		delete _pixmaps[0];
	}

	if( _pixmaps[1] ) {
		delete _pixmaps[1];
	}
}

Q3CanvasPixmapArray * MapCreaturePixmap::operator[]( uint i )
{
	return _pixmaps[i%2];
}


//
// ----- ImageTheme -----
//

/*
ImageTheme:
call init() to allocate resource (in class constructor)
call explicitly clean() to deallocate resources (in class destructor)
*/

ImageTheme::ImageTheme()
{
	cells = 0;
	lords = 0;
	bases = 0;
	buildings = 0;
	insideBuildings = 0;
	skills = 0;
	transition = 0;
	decoration = 0;
	creatures = 0;
	artefacts = 0;
	events = 0;
	chest = 0;
	mapCreatures = 0;
	pathCells = 0;
	deadCreature = 0;
	_insideBase = 0;
	_artefactIcon = 0;
	_resourceIcon = 0;
	_resourceSmallIcon = 0;
	_flags = 0;
	_mapFlags = 0;
	_sound = 0;
	_okPixmap = 0;
	_cancelPixmap = 0;
	_lordPixmap = 0;
	_lordSmallPixmap = 0;
	_baseSmallPixmap = 0;
	_isLoaded = false;
}

ImageTheme::~ImageTheme()
{
	//clear();
}

QPixmap * ImageTheme::getInsideBase( uint num )
{
	QPixmap * ret = 0;
	if( (int)num < DataTheme.bases.count() ) {
		if( _insideBase[num] == 0 ) {
			QString name = IMAGE_PATH + "base/race_" + QString::number( num ) + "/insideBase.png";
			_insideBase[num] = new QPixmap( name );
		}
		ret = _insideBase[num];
	}

	return ret;
}

QPixmap * ImageTheme::getArtefactIcon( uint num )
{
	QPixmap * ret;
	if( (int)num < DataTheme.artefacts.count() ) {
		if( _artefactIcon[num] == 0 ) {
			QString name = IMAGE_PATH + "artefacts/artefactIcon_" + QString::number( num ) + ".png";
			_artefactIcon[num] = new QPixmap( name );
		}
		ret = _artefactIcon[num];
	} else {
		logEE( "artefact %d pixmap not found", num );
		ret = new QPixmap(); /// XXX: memory leak...
	}

	return ret;
}

QPixmap * ImageTheme::getResourceIcon( uint num )
{
	QPixmap * ret;
	if( (int)num < DataTheme.resources.count() ) {
		if( _resourceIcon[num] == 0 ) {
			QString name;
			name.sprintf( "ressources/ress_%02d.png", num + 1 );
			_resourceIcon[num] = new QPixmap( IMAGE_PATH + name );
		}
		ret = _resourceIcon[num];
	} else {
		logEE( "artefact %d pixmap not found", num );
		ret = new QPixmap();
	}

	return ret;
}

QPixmap * ImageTheme::getResourceSmallIcom( uint num )
{
	QPixmap * ret;
	if( (int)num < DataTheme.resources.count() ) {
		if( _resourceSmallIcon[num] == 0 ) {
			QString name;
			name.sprintf( "ressources/smallResource_%02d.png", num + 1 );
			_resourceSmallIcon[num] = new QPixmap( IMAGE_PATH + name );
		}
		ret = _resourceSmallIcon[num];
	} else {
		logEE( "artefact %d pixmap not found", num );
		ret = new QPixmap();
	}

	return ret;
}

bool ImageTheme::init()
{
	QTime timems;
	
	timems.start();
	_isLoaded = initSkills();
	_isLoaded = _isLoaded && initCreatures();
	logDD("Load Creatures %d ms",timems.restart());
	_isLoaded = _isLoaded && initCells();
	logDD( "Load Cells %d ms", timems.restart() );
	_isLoaded = _isLoaded && initBuildings();
	logDD( "Load Buildings %d ms", timems.restart() );
	_isLoaded = _isLoaded && initDecorations();
	logDD( "Load Decorations %d ms", timems.restart() );
	_isLoaded = _isLoaded && initTransitions();
	logDD( "Load Transitions %d ms", timems.restart() );
	_isLoaded = _isLoaded && initArtefacts();
	logDD( "Load Artefacts %d ms", timems.restart() );
	_isLoaded = _isLoaded && initResources();
	logDD( "Load Resources %d ms", timems.restart() );
	_isLoaded = _isLoaded && initBonus();
	logDD( "Load Bonus %d ms", timems.restart() );
	_isLoaded = _isLoaded && initChest();
	logDD( "Load Chests %d ms", timems.restart() );
	_isLoaded = _isLoaded && initMapCreatures();
	logDD( "Load MapCreatures %d ms", timems.restart() );
	_isLoaded = _isLoaded && initEvents();
	logDD( "Load Events %d ms", timems.restart() );
	_isLoaded = _isLoaded && initTeams();
	logDD( "Load Teams %d ms", timems.restart() );
	_isLoaded = _isLoaded && initLords();
	logDD( "Load Lords %d ms", timems.restart() );
	_isLoaded = _isLoaded && initBases();
	logDD( "Load Bases %d ms", timems.restart() );
	_isLoaded = _isLoaded && initSound();

	return isLoaded();
}

void ImageTheme::save()
{

}

void ImageTheme::clear()
{
	int cpt = 0;
	uint nbCells = DataTheme.tiles.count();
	uint nbRaces = DataTheme.countRace();
	uint nbLord = DataTheme.lords.count();
	uint nbTeams = DataTheme.teams.count();

	if( cells ) {
		for( uint i = 0; i < nbCells; i++ ) {
			delete cells[i];
		}
		delete [] cells;
		cells = 0;
	}
  	if( pathCells ) {
		delete pathCells ;
		 pathCells  = 0;
	}

	if( lords ) {
		delete lords;
		lords = 0;
	}
	
	if( chest ) {
		delete chest;
		chest = 0;
	}
	
	if( bases ) {
		delete bases;
		bases = 0;
	}

	if( buildings ) {
		uint nbBuildings = DataTheme.buildings.count();
		for( uint i = 0; i < nbBuildings; i++ ) {
			delete buildings[ i ];
		}
		delete [] buildings;
		buildings = 0;
	}

	if( insideBuildings ) {
		uint nbBases = DataTheme.bases.count();
		for( uint i = 0; i < nbBases; i++ ) {
			delete insideBuildings[ i ];
		}
		delete [] insideBuildings;
		insideBuildings = 0;
	}

	if( skills ) {
		delete skills;
		skills = 0;
	}

	if( transition ) {
		for( uint i = 1; i <= nbCells; i++ ) {
			delete transition[ i - 1 ];
		}
		delete [] transition;
		transition = 0;
	}

	if( decoration ) {
		for( int i = 1; i < DataTheme.decorations.count(); i++ ) {
			delete decoration[ i - 1 ];
		}
		delete [] decoration;
		decoration = 0;
	}

	if( creatures ) {
		uint nbCreatures;
		for( uint i = 0; i < nbRaces; i++ ) {
			nbCreatures = DataTheme.creatures.getRace( i )->count();
			for( uint j = 0; j < nbCreatures; j++ ) {
				delete creatures[cpt];
				cpt++;
			}
		}
		delete [] creatures;
		creatures = 0;
	}
	
	if( deadCreature ) {
		delete deadCreature;
		deadCreature = 0;
	}

	if( artefacts ) {
		delete artefacts;
		artefacts = 0;
	}

	if( _artefactIcon ) {
		uint nbArtefacts = DataTheme.artefacts.count();
		for( uint i = 0; i < nbArtefacts; i++ ) {
			if( _artefactIcon[i] != 0 ) {
				delete _artefactIcon[i];
				_artefactIcon[i] = 0;
			}
		}
		delete [] _artefactIcon;
		_artefactIcon = 0;
	}

	if( _resourceIcon ) {
		uint nbRes = DataTheme.resources.count();
		for( uint i = 0; i < nbRes; i++ ) {
			if( _resourceIcon[i] != 0 ) {
				delete _resourceIcon[i];
				_resourceIcon[i] = 0;
			}
		}
		delete [] _resourceIcon;
		_resourceIcon = 0 ;
	}

	if( _resourceSmallIcon ) {
		uint nbRes = DataTheme.resources.count();
		for( uint i = 0; i < nbRes; i++ ) {
			if( _resourceSmallIcon[i] != 0 ) {
				delete _resourceSmallIcon[i];
				_resourceSmallIcon[i] = 0;
			}
		}
		delete [] _resourceSmallIcon;
		_resourceSmallIcon = 0;
	}

	if( bonus ) {
		for( uint i = 0; i < 4; i++ ) {
			delete bonus[i];
		}
		delete [] bonus;
		bonus = 0;
	}
	
	if( events ) {
		for( uint i = 0; i < 3; i++ ) {
			delete events[i];
		}
		delete [] events;
		events = 0;
	}
	
	if( mapCreatures ) {
		uint nbCreatures;
		for( uint i = 0; i < nbRaces; i++ ) {
			nbCreatures = DataTheme.creatures.getRace( i )->count();
			for( uint j = 0; j < nbCreatures; j++ ) {
				delete mapCreatures[i][j];
			}
			delete [] mapCreatures[i];
		}
		delete [] mapCreatures;
		mapCreatures = 0;
	}

	if( _insideBase ) {
		delete [] _insideBase;
		_insideBase = 0;
	}

	if( _flags ) {
		for( uint i = 0; i < nbTeams; i++ ) {
			delete _flags[ i ];
		}
		delete [] _flags;
		_flags = 0;
	}
	
	if( _mapFlags ) {
		for( uint i = 0; i < 1; i++ ) {
			for( uint j = 0; j < nbTeams; j++ ) {
				delete _mapFlags[i][j];
			}
			delete [] _mapFlags[i];
		}
		delete [] _mapFlags;
		_mapFlags = 0;
	}
	
	if(_lordPixmap) {
		for( uint i = 0; i < nbLord; i++ ) {
			delete _lordPixmap[i];
		}
		delete [] _lordPixmap;
		_lordPixmap = 0;
	}

	if(_lordSmallPixmap) {
		for( uint i = 0; i < nbLord; i++ ) {
			delete _lordSmallPixmap[i];
		}
		delete [] _lordSmallPixmap;
		_lordSmallPixmap = 0;
	}
	
	if( _sound ) {
		delete _sound;
	}
	_sound = 0;
	
	if( _baseSmallPixmap ) {
			delete _baseSmallPixmap[ 0 ];
			delete [] _baseSmallPixmap;
			_baseSmallPixmap = 0;
	}

	delete _okPixmap;
	_okPixmap = 0;

	delete _cancelPixmap;
	_cancelPixmap = 0;
}

QString ImageTheme::getPhotoCreature( GenericFightUnit * unit )
{
	QString pix = IMAGE_PATH + "units/race_" + QString::number( unit->getRace() ) + "/level_" + QString::number( unit->getLevel() ) + "/face.png";
	//logDD("Pixmap: %s", pix.toLatin1() );
	return  pix;
}

QPixmap * ImageTheme::getFlag( uint num )
{
	QPixmap * ret = 0;

	if( (int)num < DataTheme.teams.count() ) {
		if( ! _flags[num] ) {
			_flags[ num ] = new QPixmap( IMAGE_PATH + "players/flag_" + QString::number( num ) + ".png" );
		}
		ret = _flags[num];
	}

	return ret;
}

QPixmap * ImageTheme::getLordPixmap( uint num )
{
	if( (int)num <= DataTheme.lords.count() ) {
		if( ! _lordPixmap[num] ) {
			QString name;
			name.sprintf( "lords/lord_%03d.png", num );
			_lordPixmap[num] = new QPixmap( IMAGE_PATH + name );
		}
		return _lordPixmap[num];
	} else {
		logEE("There is not so many lords");
	}

	return 0;
}

QPixmap * ImageTheme::getLordSmallPixmap( uint num )
{
	if( (int)num <= DataTheme.lords.count() ) {
		if( ! _lordSmallPixmap[num] ) {
			QString name;
			name.sprintf( "lords/smallLord_%03d.png", num );
			_lordSmallPixmap[num] = new QPixmap( IMAGE_PATH + name );
		}
		return _lordSmallPixmap[num];
	} else {
		logEE("There is not so many lords");
	}

	return 0;
}

QPixmap * ImageTheme::getBaseSmallPixmap( uint /*num*/ )
{
	/// XXX: TODO
	logEE( "not finished" );
	return _baseSmallPixmap[ 0 ];
}

Q3CanvasPixmapArray * ImageTheme::getMapFlag( uint type, uint teamId )
{
	return _mapFlags[ type ][ teamId ];
}

const uint NB_FLAGTYPE = 1;

bool ImageTheme::initTeams()
{
	uint i, j;
	uint nbTeams = DataTheme.teams.count();
	QString fileName;
	
	_flags = new QPixmap * [ nbTeams ];
	for( i = 0; i < nbTeams; i++ ) {
		_flags[i] = 0;
	}
	
	/// XXX: NB_FLAGTYPE = 1 = nb of type of flags (only one for the moment but will be extended if managed in dataTheme
	_mapFlags = new Q3CanvasPixmapArray ** [ NB_FLAGTYPE ];
	
	for( i = 0; i < NB_FLAGTYPE; i++ ) {
		_mapFlags[ i ] = new Q3CanvasPixmapArray * [ nbTeams ];
		for( j = 0; j < nbTeams; j++ ) {
			Q3PointArray listPointFlag( 1 );
			Q3ValueList<QPixmap> listPixmapFlag;
			/// XXX: for the moment, only one pixmap, but maybe one day it will be animated...
			fileName.sprintf( "players/mapFlag_%d_%d_0.png", i, j );
			listPixmapFlag.append( QPixmap( IMAGE_PATH + fileName.toLatin1() ) );
			listPointFlag.setPoint( 0, 0, 0 );
			_mapFlags[ i ][ j ] = new Q3CanvasPixmapArray( listPixmapFlag, listPointFlag );
		}
	}

	return true;
}

bool ImageTheme::initSkills()
{
	Q3PointArray listPointSkill( 2 );
	Q3ValueList<QPixmap> listPixmapSkill;
	listPixmapSkill.append( QPixmap( IMAGE_PATH + "technics/technic_1_1.png" ) );
	listPointSkill.setPoint( 0, 0, 0 );
	listPixmapSkill.append( QPixmap( IMAGE_PATH + "technics/technic_1_2.png" ) );
	listPointSkill.setPoint( 1, 0, 0 );
	skills = new Q3CanvasPixmapArray( listPixmapSkill, listPointSkill );

	return true;
}

bool ImageTheme::initCells()
{
	QString name;

	cells = new Q3CanvasPixmapArray * [DataTheme.tiles.count()];

	Q3PointArray listPointUnknown( 1 ); 
	Q3ValueList<QPixmap> listPixmapUnknown;
	listPixmapUnknown.append( QPixmap( IMAGE_PATH + "tiles/unknown.png" ) );
	listPointUnknown.setPoint( 0, 0, 0 );
	cells[ 0 ] = new Q3CanvasPixmapArray( listPixmapUnknown, listPointUnknown );

	for( int i = 1; i < DataTheme.tiles.count(); i++ ) {
		uint nbTiles = DataTheme.tiles.at( i )->getDiversificationNumber();
		
		Q3PointArray listPointCell( 2 * nbTiles );
		Q3ValueList<QPixmap> listPixmapCell;

		for( uint j = 0; j < nbTiles; j++ ) {
			name.sprintf( "tiles/tile_%d_%d.png", i, j );
			QPixmap pixmap( IMAGE_PATH + name.toLatin1() );
			listPixmapCell.append( pixmap );
			listPointCell.setPoint( 2 * j, 0, 0 );
			listPixmapCell.append( gridCell(pixmap , 255,255,255) );
			listPointCell.setPoint( (2 * j) + 1, 0, 0 );

		}
		cells[i] = new Q3CanvasPixmapArray( listPixmapCell, listPointCell );
	}

	Q3PointArray listPointPathCell( 66 );
	Q3ValueList<QPixmap> listPixmapPathCell;
	
	for( int i = 0; i < 33; i++ ) {
		QString name = "misc/arrow-" + QString::number( i ) + ".png";
		listPixmapPathCell.append( QPixmap( IMAGE_PATH + name.toLatin1() ) );
		listPointPathCell.setPoint( i, 0, 0 );
	}
	for( int i = 0; i < 33; i++ ) {
		QString name = "misc/arrowFar-" + QString::number( i ) + ".png";
		listPixmapPathCell.append( QPixmap( IMAGE_PATH + name.toLatin1() ) );
		listPointPathCell.setPoint( 33 + i, 0, 0 );
	}
	pathCells = new Q3CanvasPixmapArray( listPixmapPathCell, listPointPathCell );

	return true;
}

bool ImageTheme::initCreatures()
{
	int cpt = 0;
	creatures = new CreaturePixmap * [DataTheme.creatures.count()];
	QString fileName;
	QPixmap creatPix;
	QPixmap newPix;
	QImage newImg;

	uint nbRaces = DataTheme.countRace();
	int nbLevels, nbFrames;
	for( uint i = 0; i < nbRaces; ++i ) {
		nbLevels = DataTheme.creatures.getRace( i )->count();
		for( int j = 0; j < nbLevels; ++j ) {
			Q3ValueList<QPixmap> listPixmapFightUnit;
			if ( DataTheme.creatures.at( i ,j )->isAnimated () ) {
				Q3ValueList<QPixmap> newList;
				nbFrames = DataTheme.creatures.at( i ,j )->getNumFrames();
				Q3PointArray listPointFightUnit(nbFrames);
				QString numFrame = "00";
				for( int fr = 0; fr < nbFrames; ++fr ) {
					numFrame.sprintf( "%02d", fr + 1 );
					fileName = "units/race_" + QString::number( i ) + "/level_" + QString::number( j ) + "/creature_" + numFrame + ".png";
					creatPix = QPixmap( IMAGE_PATH + fileName );
					listPixmapFightUnit.append( creatPix );
					listPointFightUnit.setPoint( fr, 0, 0  );

					if( !creatPix.isNull() ) {
						newImg = (QImage) creatPix.toImage().mirrored( true, false );
						newPix	= QPixmap::fromImage( newImg );
						newList.append( newPix ) ;
					} else {
						newList.append( QPixmap() );
					}
				}
				creatures[cpt] = new CreaturePixmap( listPixmapFightUnit , listPointFightUnit , newList );
			} else {
				Q3PointArray listPointFightUnit(2);
				listPixmapFightUnit.append( QPixmap( IMAGE_PATH + "units/race_" + QString::number( i ) + "/level_" + QString::number( j ) + "/creature.png" ) );
				listPointFightUnit.setPoint( 0 ,0, 0 ) ;
				/* necessary to have two image one normal and one highlighted */
				listPixmapFightUnit.append( QPixmap( IMAGE_PATH + "units/race_" + QString::number( i ) + "/level_" + QString::number( j ) + "/creature.png" ) );
				listPointFightUnit.setPoint( 1, 0, 0 );
				creatures[cpt] = new CreaturePixmap( listPixmapFightUnit , listPointFightUnit );
			}
			cpt++;
		}
	}

	Q3PointArray listPointDead( 1 );
	Q3ValueList<QPixmap> listPixmapDead;
	listPixmapDead.append( QPixmap( IMAGE_PATH + "units/dead.png" ) );
	listPointDead.setPoint( 0, 0, -70 );
	deadCreature = new Q3CanvasPixmapArray( listPixmapDead, listPointDead );

	return true;
}

bool ImageTheme::initLords()
{
	uint nbLord = DataTheme.lords.count();
	uint i;

	Q3PointArray listPointLord( 1 );
	Q3ValueList<QPixmap> listPixmapLord;
	listPixmapLord.append( QPixmap( IMAGE_PATH + "units/lord.png" ) );
	listPointLord.setPoint( 0, 0, 0 );
	lords = new Q3CanvasPixmapArray( listPixmapLord , listPointLord );

	_lordPixmap = new QPixmap * [ nbLord ];
	for( i = 0; i < nbLord; i++ ) {
		_lordPixmap[i] = 0;
	}

	_lordSmallPixmap = new QPixmap * [ nbLord ];
	for( i = 0; i < nbLord; i++ ) {
		_lordSmallPixmap[i] = 0;
	}

	return true;
}

bool ImageTheme::initBases()
{
	uint i;
	uint nbBases = DataTheme.bases.count();
	
	_insideBase = new QPixmap * [DataTheme.bases.count()];
	for( i = 0; i < nbBases; i++ ) {
		_insideBase[i] = 0;
	}

	Q3PointArray listPointBase( nbBases );
	Q3ValueList<QPixmap> listPixmapBase;
	for( i = 0; i < nbBases; i++ ) {
		listPixmapBase.append( QPixmap( IMAGE_PATH + "base/race_" + QString::number( i ) + "/base.png" ) );
		listPointBase.setPoint( i, 0, 0 );
	}
	bases = new Q3CanvasPixmapArray( listPixmapBase, listPointBase );

	_baseSmallPixmap = new QPixmap * [1];
	_baseSmallPixmap[0] = new QPixmap( IMAGE_PATH + "base/smallBase.png" );

	return true;
}

bool ImageTheme::initArtefacts()
{
	uint i;
	uint nbArtefacts = DataTheme.artefacts.count();

	_artefactIcon = new QPixmap * [ nbArtefacts ];
	for( i = 0; i < nbArtefacts; i++ ) {
		_artefactIcon[i] = 0;
	}
	 
	Q3PointArray listPointArtefact( nbArtefacts );
	Q3ValueList<QPixmap> listPixmapArtefact;
	for( i = 0; i < nbArtefacts; i++ ) {
		listPixmapArtefact.append( QPixmap( IMAGE_PATH + "artefacts/artefactItem_" + QString::number( i ) + ".png" ) );
		listPointArtefact.setPoint( i, 0, 0 );
	}
	artefacts = new Q3CanvasPixmapArray( listPixmapArtefact, listPointArtefact );

	return true;
}

bool ImageTheme::initResources()
{
	_resourceIcon = new QPixmap * [DataTheme.resources.count()];
	_resourceSmallIcon = new QPixmap * [DataTheme.resources.count()];
	for( int i = 0; i < DataTheme.resources.count(); i++ ) {
		_resourceIcon[i] = 0;
		_resourceSmallIcon[i] = 0;
	}

	return true;
}

bool ImageTheme::initBonus()
{
	uint j;
	uint nbResources = DataTheme.resources.count();
	QString name;
	bonus = new Q3CanvasPixmapArray * [ 4 ];

	Q3PointArray listPointBonus0( nbResources );
	Q3ValueList<QPixmap> listPixmapBonus0;
	for( j = 0; j < nbResources; j++ ) {
		name.sprintf( "ressources/smallResource_%02d.png", j+1 );
		listPixmapBonus0.append( QPixmap( IMAGE_PATH + name ) );
		listPointBonus0.setPoint( j, 0, 0 );
	}
	bonus[0] = new Q3CanvasPixmapArray( listPixmapBonus0, listPointBonus0 );

	Q3PointArray listPointBonus1( 1 );
	Q3ValueList<QPixmap> listPixmapBonus1;
	name = "events/event1.png";
	listPixmapBonus1.append( QPixmap( IMAGE_PATH + name ) );
	listPointBonus1.setPoint( 0, 0, 0 );
	bonus[1] = new Q3CanvasPixmapArray( listPixmapBonus1, listPointBonus1 );

	Q3PointArray listPointBonus2( 1 );
	Q3ValueList<QPixmap> listPixmapBonus2;
	name = "events/event1.png";
	listPixmapBonus2.append( QPixmap( IMAGE_PATH + name ) );
	listPointBonus2.setPoint( 0, 0, 0 );
	bonus[2] = new Q3CanvasPixmapArray( listPixmapBonus2, listPointBonus2 );

	Q3PointArray listPointBonus3( 1 );
	Q3ValueList<QPixmap> listPixmapBonus3;
	name = "events/scroll.png";
	listPixmapBonus3.append( QPixmap( IMAGE_PATH + name ) );
	listPointBonus3.setPoint( 0, 0, 0 );
	bonus[3] = new Q3CanvasPixmapArray( listPixmapBonus3, listPointBonus3 );

	return true;
}

bool ImageTheme::initChest()
{
	Q3PointArray listPointChest( 1 );
	Q3ValueList<QPixmap> listPixmapChest;
	listPixmapChest.append( QPixmap( IMAGE_PATH + "events/chest.png" ) );
	listPointChest.setPoint( 0, 0, 0 );
	chest = new Q3CanvasPixmapArray( listPixmapChest, listPointChest );

	return true;
}

bool ImageTheme::initBuildings()
{
	uint nbBuildings, nbBases;
	buildings = new Q3CanvasPixmapArray * [ DataTheme.buildings.count() ];
	for( int i = 0; i < DataTheme.buildings.count(); i++ ) {
		nbBuildings = DataTheme.buildings.at( i )->getNbFrame();
		Q3PointArray listPointBuilding( nbBuildings );
		Q3ValueList<QPixmap> listPixmapBuilding;
		for( uint j = 0; j < nbBuildings; j++ ) {
			QString name = "building/building_" + QString::number( i ) + "_" + QString::number( j ) + ".png";
			listPixmapBuilding.append( QPixmap( IMAGE_PATH + name ) );
			listPointBuilding.setPoint( j, 0, 0 );
		}
		buildings[i] = new Q3CanvasPixmapArray( listPixmapBuilding, listPointBuilding );
	}

	nbBases = DataTheme.bases.count();
	insideBuildings = new Q3CanvasPixmapArray * [ nbBases ];
	for( uint i = 0; i < nbBases; i++ ) {
		nbBuildings = DataTheme.bases.at( i )->getBuildingCount();
		Q3PointArray listPointInside( nbBuildings );
		Q3ValueList<QPixmap> listPixmapInside;
		for( uint j = 0; j < nbBuildings; j++ ) {
			listPixmapInside.append( QPixmap( IMAGE_PATH + "base/race_" + QString::number( i ) + "/inside_" + QString::number( j ) + ".png" ) );
			listPointInside.setPoint( j, 0, 0 );

		}
		insideBuildings[i] = new Q3CanvasPixmapArray( listPixmapInside, listPointInside );
	}

	return true;
}

bool ImageTheme::initTransitions()
{
	uint i, j;
	uint nbTransitions = DataTheme.tiles.count();
	
	transition = new Q3CanvasPixmapArray * [ nbTransitions ];
	for( i = 1; i <= nbTransitions; i++ ) {
		Q3PointArray listPointTransition( 2 * NB_TRANSITION );
		Q3ValueList<QPixmap> listPixmapTransition;
		for( j = 1; j <= NB_TRANSITION; j++ ) {
			QString name = "tiles/transi_" + QString::number( i ) + "_" + QString::number( j ) + ".png";
			QPixmap pixmap( IMAGE_PATH + name.toLatin1() );
			listPixmapTransition.append( pixmap );
			listPointTransition.setPoint( 2 * (j - 1), 0, 0 );
			listPixmapTransition.append( gridCell(pixmap , 255,255,255) );
			listPointTransition.setPoint( (2 * (j - 1)) + 1, 0, 0 );

		}
		transition[i-1] = new Q3CanvasPixmapArray( listPixmapTransition, listPointTransition );
	}

	return true;
}

bool ImageTheme::initDecorations()
{
	uint i, j;
	uint nbDecoGroups = DataTheme.decorations.count();
	uint nbDeco;
	
	decoration = new Q3CanvasPixmapArray * [ nbDecoGroups ];
	for( i = 1; i < nbDecoGroups; i++ ) {
		DecorationGroup * group = DataTheme.decorations.at( i );
		nbDeco = group->count();
		Q3PointArray listPointDeco( nbDeco );
		Q3ValueList<QPixmap> listPixmapDeco;
		
		for( j = 0; j < nbDeco; j++ ) {
			listPixmapDeco.append( QPixmap( IMAGE_PATH + "decor/decoration_" + QString::number( i ) + "_" + QString::number( j ) + ".png" ) );
			listPointDeco.setPoint( j, 0, 0 );
		}
		
		decoration[ i-1 ] = new Q3CanvasPixmapArray( listPixmapDeco, listPointDeco );
	}

	return true;
}

bool ImageTheme::initEvents()
{
	uint i;
	events = new Q3CanvasPixmapArray * [ 3 ];
	QString fileName;

	Q3PointArray listPointEvent( 1 );
	Q3ValueList<QPixmap> listPixmapEvent;
	fileName = "events/event1.png";
	listPixmapEvent.append( QPixmap( IMAGE_PATH + fileName ) );
	listPointEvent.setPoint( 0, 0, 0 );
	events[ 0 ] = new Q3CanvasPixmapArray( listPixmapEvent, listPointEvent );

	uint nbRes = DataTheme.resources.count();
	Q3PointArray listPointEvent2( nbRes );
	Q3ValueList<QPixmap> listPixmapEvent2;
	for( i = 0; i < nbRes; ++i ) {
		fileName.sprintf( "ressources/smallResource_%02d.png", i+1 );
		listPixmapEvent2.append( QPixmap( IMAGE_PATH + fileName ) );
		listPointEvent2.setPoint( i, 0, 0 );
	}
	events[ 1 ] = new Q3CanvasPixmapArray( listPixmapEvent2, listPointEvent2 );

	Q3PointArray listPointEvent3( 1 );
	Q3ValueList<QPixmap> listPixmapEvent3;
	fileName = "events/chest.png";
	listPixmapEvent3.append( QPixmap( IMAGE_PATH + fileName ) );
	listPointEvent3.setPoint( 0, 0, 0 );
	events[ 2 ] = new Q3CanvasPixmapArray( listPixmapEvent3, listPointEvent3 );

	return true;
}

bool ImageTheme::initMapCreatures()
{
	mapCreatures = new MapCreaturePixmap ** [ DataTheme.countRace() ];
	for( uint i = 0; i < DataTheme.countRace(); i++ ) {
		mapCreatures[i] = new MapCreaturePixmap * [ DataTheme.creatures.getRace( i )->count() ];
		for( int j = 0; j < DataTheme.creatures.getRace( i )->count(); j++ ) {
			Q3PointArray listPointMapCreature( 1 );
			Q3ValueList<QPixmap> listPixmapMapCreature;
			QString name = "units/race_" + QString::number( i ) + "/level_" + QString::number( j ) + "/creatureMap.png";
			listPixmapMapCreature.append( QPixmap( IMAGE_PATH + name ) );
			listPointMapCreature.setPoint( 0, 0, 0 );
			mapCreatures[i][j] = new MapCreaturePixmap( listPixmapMapCreature, listPointMapCreature );
		}
	}

	return true;
}

QPixmap * ImageTheme::getMapCreature( uint race, uint level, bool rightLooking )
{
	return ( ( * ( mapCreatures[race][level] ) )[0] )->image( rightLooking?1:0 );
}

QPixmap * ImageTheme::getMapCreature( GenericMapCreature * creature, bool rightLooking )
{
	return getMapCreature( creature->getRace(), creature->getLevel(), rightLooking );
}

CreaturePixmap * ImageTheme::getCreature ( uint race, uint level )
{
	int nCnt = 0;
	for( uint i = 0; i < race; i++ ) {
		nCnt += DataTheme.creatures.getRace( i )->count();
	}

	nCnt += level;

	return ( creatures[nCnt] );
}

bool ImageTheme::initSound()
{
	_sound = new AttalSound();
	_sound->init();

	return true;
}

void ImageTheme::playMusicMap()
{
	_sound->playMusicMap();
}

void ImageTheme::endMusic()
{
	_sound->endMusic();
}

void ImageTheme::playMusicBase( uint race )
{
	_sound->playMusicBase( race );
}

void ImageTheme::playMusicFight()
{
	_sound->playMusicFight();
}

void ImageTheme::playSound( AttalSound::SoundType snd )
{
	_sound->playSound( snd );
}

QPixmap ImageTheme::gridCell( QPixmap pixmap, int r, int g ,int b )
{
	QImage image = pixmap.toImage();

	int w = image.width();
	int h = image.height();

	if(w == 0 && h == 0)
	{
		return pixmap;
	}
	
	QPixmap newpixmap;
	QImage img( w, h, 32 );
	img.setAlphaBuffer( TRUE );

	for ( int x = 0; x < w; x++ ) {
		for ( int y = 0; y < h; y++ ) {
			QRgb pixel = (x<w && y<h) ? image.pixel( x, y ) : 0;
			if(x == 0 || y == 0 || x == w || y == h) {
				int alpha = qAlpha(pixel);
				img.setPixel( x, y, qRgba( r, g, b , alpha) );
			} else {
				img.setPixel( x, y, pixel  );
			}
		}
	}
	newpixmap = QPixmap::fromImage(img);
	return newpixmap;
}

QPixmap * ImageTheme::getOkPixmap()
{
	if( ! _okPixmap ) {
		_okPixmap = new QPixmap( IMAGE_PATH + "misc/yes.png" );
	}

	return _okPixmap;
}

QPixmap * ImageTheme::getCancelPixmap()
{
	if( ! _cancelPixmap ) {
		_cancelPixmap = new QPixmap( IMAGE_PATH + "misc/no.png" );
	}

	return _cancelPixmap;
}





