/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.h
** draw bases and buildings on the map
**
** Version : $Id: graphicalBuilding.h,v 1.3 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 26/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#ifndef GRAPHICALBUILDING_H
#define GRAPHICALBUILDING_H
 
// generic include files
// include files for QT
#include <Q3Canvas>

// application specific includes
#include "libClient/cell.h"
#include "libClient/flag.h"

class GenericPlayer;

/** Build the graphical part of the Lord */
class GraphicalBuilding : public Q3CanvasSprite
{
public:
	/** Constructor */
	GraphicalBuilding( Q3Canvas * canvas );
	
	GraphicalBuilding( Q3CanvasPixmapArray * array, Q3Canvas * canvas );
	
	virtual ~GraphicalBuilding();

	/** Set the Lord on the cell */
	virtual void setPosition( Cell *cell, int offsetRow=0, int offsetCol=0 );
	
	/** Advance animation */
	void advance( int stage );
	
	/** return RTTI */
	int rtti() const { return RTTI; };
	
	static const int RTTI;

	void setType( int type );

	void setAnimation( int nbFrame, int freq );
	
	virtual void setOwner( GenericPlayer * player );

protected:
	Q3CanvasPixmap * imageAdvanced() const;
	
	Flag * _flag;
	int _frame, _nbFrame, _freq, _clock;

};

/** Graphical aspect of the base on the map */
class GraphicalBase : public GraphicalBuilding
{
public:
	/** Constructor */
	GraphicalBase( Q3Canvas * canvas );

	/** Sets the race of the base */
	void setRace( int );
};

#endif // GRAPHICALBUILDING_H
