/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.cpp
** draw bases and buildings on the map
**
** Version : $Id: graphicalBuilding.cpp,v 1.4 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 26/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalBuilding.h"

// generic include files
// include files for QT
#include <QRect>
// application specific includes
#include "conf.h"

#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"

/** rtti number for GraphicalLord class */
const int GraphicalBuilding::RTTI = 1000;

extern ImageTheme ImageTheme;

//
// ----- GraphicalBuilding -----
//

/** add comments here */
GraphicalBuilding::GraphicalBuilding( Q3Canvas * canvas )
	: Q3CanvasSprite( ImageTheme.buildings[ 0 ], canvas )
{
 	collisions( true );
 	setFrame( 0 );
	setAnimated( true );
	setZ( CAN_BUILDING );
	show();
	_frame = 0;
	_nbFrame = 1;
	_freq = 1;
	_clock = 0;
	
	_flag = new Flag( canvas );
	_flag->hide();
}

GraphicalBuilding::GraphicalBuilding( Q3CanvasPixmapArray * array, Q3Canvas * canvas )
	: Q3CanvasSprite( array, canvas )
{
 	collisions( true );
 	setFrame( 0 );
	setZ( CAN_BUILDING );
	show();
	_frame = 0;
	_nbFrame = 1;
	_freq = 1;
	_clock = 0;
	
	_flag = new Flag( canvas );
	_flag->hide();
}

GraphicalBuilding::~GraphicalBuilding()
{
	if( _flag ) {
		delete _flag;
	}
}


void GraphicalBuilding::setPosition( Cell * cell, int offsetRow, int offsetCol )
{
	QRect rect = cell->boundingRect();
	move( rect.x() + ( offsetCol * rect.width() ),
	      rect.y() + rect.height() - boundingRect().height() + ( offsetRow * rect.height() ) );
	      
	if( _flag ) {
		_flag->move( rect.x() + ( offsetCol * rect.width() ),
			rect.y() + rect.height() - boundingRect().height() + ( offsetRow * rect.height() ) );
		_flag->setZ( CAN_LORD + cell->getRow() + 1 );
	}

	canvas()->update();
}

void GraphicalBuilding::advance( int /*stage*/ )
{
	_clock++;
	if( _clock == _freq ) {
		_clock = 0;
		_frame++;
		if( _frame == _nbFrame ) {
			_frame = 0;
		}
		setFrame( _frame );
	}
}

Q3CanvasPixmap* GraphicalBuilding::imageAdvanced() const
{
	/// logDD("imageAdvanced");
	return image();
}

void GraphicalBuilding::setType( int type )
{
	setSequence( ImageTheme.buildings[ type ] );
	setFrame( 0 );
}

void GraphicalBuilding::setAnimation( int nbFrame, int freq )
{
	_nbFrame = nbFrame;
	_freq = freq;
	if( _nbFrame == 1 ) {
		setAnimated( false );
	} else {
		setAnimated( true );
	}
}

void GraphicalBuilding::setOwner( GenericPlayer * player )
{
	if( player ) {
		_flag->show();
		_flag->setOwner( player );
	} else {
		_flag->hide();
	}
}

//
// ----- GraphicalBase -----
//

GraphicalBase::GraphicalBase( Q3Canvas * canvas )
	: GraphicalBuilding( ImageTheme.bases, canvas )
{
 	collisions( true );
 	setFrame( 0 );
	setZ( CAN_BUILDING );
	show();
}

void GraphicalBase::setRace( int race )
{
	setFrame( race );
}
