/*
** General include-file for atsar
**
** Author:      Gerlof Langeveld - AT Computing, Nijmegen, Holland
** E-mail:      gerlof@ATComputing.nl
** Date:        Januar  1995
** LINUX-port:  Februar 1999
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public License as published by the
** Free Software Foundation; either version 2, or (at your option) any
** later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
*/

#define	ATMAGIC		0xfeedbabe

#define	ATOUTF		"/var/log/atsar/atsa%02d"
#define	ATEXEC		"/usr/local/bin/atsadc"
#define	MAXNET		32	/* must be power of 2 !! */


/*
** statistics definition structures
*/ 
struct countdef	{ /* defines the kernel counters needed         */
	char		*kname;		/* name of  counterset	*/
	unsigned short	ksize;		/* size of  counterset	*/
	unsigned short	kinst;		/* number of instances	*/
};

struct fetchdef {
	struct countdef cdef;
	void	(*initcnt)();	/* optional countdef initialisation 	*/
	void	(*getcnt)();	/* mandatory counter fetch-function  	*/
};

struct funcdef { /* defines the counter sets being printed	        */
	char	active;		/* activation of this option		*/
	char	flag;		/* flag on command line 		*/
	void	(*prihead)();	/* print header of list			*/
	int	(*priline)();	/* print counters per line (excl. time)	*/
	char	*about;		/* statistics about what            	*/
};


/*
** header of statistics file
*/
struct filehdr {
	long		magic;		/* magic number to verify 	     */
	int		hdrsize;	/* size of filehdr itself            */
	int		oncecnt;	/* number of vars only read once     */
	int		oncenames;	/* size   of varnames read once	     */
	int		oncevars;	/* size   of varcounters read once   */
	int		sampcnt;	/* number of vars read each sample   */
	int		sampnames;	/* size   of varnames for sample     */
	int		sampvars;	/* size   of first stats counters    */
	int		hertz;		/* # clock ticks per second          */
	int		numcpu;		/* # processors on measured system   */
	struct utsname	utsinfo;	/* general info of measured system   */
};

/*
** header for a set of counters per sample
*/
struct samphdr {
	time_t	curtim;		/* current date/time			*/
	clock_t	curlbolt;	/* current ticks since boot		*/
	int	cntsize;	/* size of counters which follow	*/
};
