/* This file is part of the 'atomes' software
 
'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>                                                

Copyright (C) 2022-2024 by CNRS and University of Strasbourg */

/*!
* @file charmm22_prot_metals.c
* @short 
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'charmm22_prot_metals.c'
*
* Contains:
*

  CHARMM-charmm22_prot_metals force field, data from taken from:

       - the file: 'charmm22_prot_metals'
       - distributed in: 'toppar_c36_jul16_mass_orig.tgz'

  This file contains several tables:

    Atoms      : charmm22_prot_metals_atoms[98][5]
    Bonds      : charmm22_prot_metals_bonds[139][5]
    Angles     : charmm22_prot_metals_angles[345][8]
    Dihedrals  : charmm22_prot_metals_dihedrals[452][8]
    Impropers  : charmm22_prot_metals_impropers[43][8]
    Non bonded : charmm22_prot_metals_vdw[98][6]

*/

#include "global.h"

int charmm22_prot_metals_objects[14] = {98, 0, 0, 139, 0, 0, 345, 0, 452, 0 , 0, 43, 98, 0};
int charmm22_prot_metals_dim[14] = {5, 0, 0, 5, 0, 0, 8, 0, 8, 0, 0, 8, 6, 0};

/*
 Atoms
  0= Element, 1= Mass, 2= Key, 3= Description, 4= charmm22_prot_metals info
*/
char * charmm22_prot_metals_atoms[98][5]= {{"H", "1.00800", "H", "polar H", "1"},
                                     {"H", "1.00800", "HC", "N-ter H", "2"},
                                     {"H", "1.00800", "HA", "nonpolar H", "3"},
                                     {"H", "1.00800", "HT", "TIPS3P WATER HYDROGEN", "4"},
                                     {"H", "1.00800", "HP", "aromatic H", "5"},
                                     {"H", "1.00800", "HB", "backbone H", "6"},
                                     {"H", "1.00800", "HR1", "his he1, (+) his HG,HD2", "7"},
                                     {"H", "1.00800", "HR2", "(+) his HE1", "8"},
                                     {"H", "1.00800", "HR3", "neutral his HG, HD2", "9"},
                                     {"H", "1.00800", "HS", "thiol hydrogen", "10"},
                                     {"H", "1.00800", "HE1", "for alkene; RHC=CR", "11"},
                                     {"H", "1.00800", "HE2", "for alkene; H2C=CR", "12"},
                                     {"H", "1.00800", "HA1", "alkane, CH, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "13"},
                                     {"H", "1.00800", "HA2", "alkane, CH2, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "14"},
                                     {"H", "1.00800", "HA3", "alkane, CH3, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "15"},
                                     {"H", "1.00800", "HF1", "Aliphatic H on fluorinated C (see toppar_all22_prot_fluoro_alkanes.str)", "16"},
                                     {"H", "1.00800", "HF2", "Aliphatic H on fluorinated C (see toppar_all22_prot_fluoro_alkanes.str)", "17"},
                                     {"C", "12.01100", "C", "carbonyl C, peptide backbone", "20"},
                                     {"C", "12.01100", "CA", "aromatic C", "21"},
                                     {"C", "12.01100", "CT1", "aliphatic sp3 C for CH", "22"},
                                     {"C", "12.01100", "CT2", "aliphatic sp3 C for CH2", "23"},
                                     {"C", "12.01100", "CT3", "aliphatic sp3 C for CH3", "24"},
                                     {"C", "12.01100", "CPH1", "his CG and CD2 carbons", "25"},
                                     {"C", "12.01100", "CPH2", "his CE1 carbon", "26"},
                                     {"C", "12.01100", "CPT", "trp C between rings", "27"},
                                     {"C", "12.01100", "CY", "TRP C in pyrrole ring", "28"},
                                     {"C", "12.01100", "CP1", "tetrahedral C (proline CA)", "29"},
                                     {"C", "12.01100", "CP2", "tetrahedral C (proline CB/CG)", "30"},
                                     {"C", "12.01100", "CP3", "tetrahedral C (proline CD)", "31"},
                                     {"C", "12.01100", "CC", "carbonyl C, asn,asp,gln,glu,cter,ct2", "32"},
                                     {"C", "12.01100", "CD", "carbonyl C, pres aspp,glup,ct1", "33"},
                                     {"C", "12.01100", "CPA", "heme alpha-C", "34"},
                                     {"C", "12.01100", "CPB", "heme beta-C", "35"},
                                     {"C", "12.01100", "CPM", "heme meso-C", "36"},
                                     {"C", "12.01100", "CM", "heme CO carbon", "37"},
                                     {"C", "12.01100", "CS", "thiolate carbon", "38"},
                                     {"C", "12.01100", "CE1", "for alkene; RHC=CR", "39"},
                                     {"C", "12.01100", "CE2", "for alkene; H2C=CR", "40"},
                                     {"C", "12.01100", "CST", "CO2 carbon ", "41"},
                                     {"C", "12.01100", "CT", "aliphatic sp3 C, new LJ params, no hydrogens (see toppar_all22_prot_aliphatic_c27.str)", "42"},
                                     {"C", "12.01100", "CT1x", "aliphatic sp3 C for CH, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "43"},
                                     {"C", "12.01100", "CT2x", "aliphatic sp3 C for CH2, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "44"},
                                     {"C", "12.01100", "CT3x", "aliphatic sp3 C for CH3, new LJ params (see toppar_all22_prot_aliphatic_c27.str)", "45"},
                                     {"C", "12.01100", "CN", "C for cyano group (see toppar_all22_prot_pyridines.str)", "46"},
                                     {"C", "12.01100", "CAP", "aromatic C for pyrimidines (see toppar_all22_prot_pyridines.str)", "47"},
                                     {"C", "12.01100", "COA", "carbonyl C for pyrimidines (see toppar_all22_prot_pyridines.str)", "48"},
                                     {"C", "12.01100", "C3", "cyclopropyl carbon", "49"},
                                     {"N", "14.00700", "N", "proline N", "50"},
                                     {"N", "14.00700", "NR1", "neutral his protonated ring nitrogen", "51"},
                                     {"N", "14.00700", "NR2", "neutral his unprotonated ring nitrogen", "52"},
                                     {"N", "14.00700", "NR3", "charged his ring nitrogen", "53"},
                                     {"N", "14.00700", "NH1", "peptide nitrogen", "54"},
                                     {"N", "14.00700", "NH2", "amide nitrogen", "55"},
                                     {"N", "14.00700", "NH3", "ammonium nitrogen", "56"},
                                     {"N", "14.00700", "NC2", "guanidinium nitroogen", "57"},
                                     {"N", "14.00700", "NY", "TRP N in pyrrole ring", "58"},
                                     {"N", "14.00700", "NP", "Proline ring NH2+ (N-terminal)", "59"},
                                     {"N", "14.00700", "NPH", "heme pyrrole N", "60"},
                                     {"N", "14.00700", "NC", "N for cyano group (see toppar_all22_prot_pyridines.str)", "61"},
                                     {"O", "15.99900", "O", "carbonyl oxygen", "70"},
                                     {"O", "15.99900", "OB", "carbonyl oxygen in acetic acid", "71"},
                                     {"O", "15.99900", "OC", "carboxylate oxygen", "72"},
                                     {"O", "15.99900", "OH1", "hydroxyl oxygen", "73"},
                                     {"O", "15.99940", "OS", "ester oxygen", "74"},
                                     {"O", "15.99940", "OT", "TIPS3P WATER OXYGEN", "75"},
                                     {"O", "15.99900", "OM", "heme CO/O2 oxygen", "76"},
                                     {"O", "15.99900", "OST", "CO2 oxygen", "77"},
                                     {"O", "15.99900", "OCA", "carbonyl O for pyrimidines (see toppar_all22_prot_pyridines.str)", "78"},
                                     {"S", "32.06000", "S", "sulphur", "81"},
                                     {"S", "32.06000", "SM", "sulfur C-S-S-C type", "82"},
                                     {"S", "32.06000", "SS", "thiolate sulfur", "83"},
                                     {"He", "4.00260", "HE", "helium", "85"},
                                     {"Ne", "20.17970", "NE", "neon", "86"},
                                     {"C", "12.01100", "CF1", "monofluoromethyl (see toppar_all22_prot_fluoro_alkanes.str)", "87"},
                                     {"C", "12.01100", "CF2", "difluoromethyl (see toppar_all22_prot_fluoro_alkanes.str)", "88"},
                                     {"C", "12.01100", "CF3", "trifluoromethyl (see toppar_all22_prot_fluoro_alkanes.str)", "89"},
                                     {"Fe", "55.84700", "FE", "heme iron 56", "90"},
                                     {"Cl", "35.45300", "CLAL", "Chlorine Atom (see toppar_all22_prot_aldehydes.str)", "91"},
                                     {"F", "18.99800", "FA", "aromatic flourine (see toppar_all22_prot_pyridines.str)", "92"},
                                     {"F", "18.99800", "F1", "Fluorine, monofluoro (see toppar_all22_prot_fluoro_alkanes.str)", "93"},
                                     {"F", "18.99800", "F2", "Fluorine, difluoro (see toppar_all22_prot_fluoro_alkanes.str)", "94"},
                                     {"F", "18.99800", "F3", "Fluorine, trifluoro (see toppar_all22_prot_fluoro_alkanes.str)", "95"},
                                     {"D", "0.00000", "DUM", "dummy atom", "99"},
                                     {"Na", "22.989770", "SOD", "Sodium Ion", "100"},
                                     {"Mg", "24.305000", "MG", "Magnesium Ion", "101"},
                                     {"P", "39.102000", "POT", "Potassium Ion! check masses", "102"},
                                     {"Cs", "132.900000", "CES", "Cesium Ion", "103"},
                                     {"Ca", "40.080000", "CAL", "Calcium Ion", "104"},
                                     {"Cl", "35.450000", "CLA", "Chloride Ion", "105"},
                                     {"Zn", "65.370000", "ZN", "zinc (II) cation", "106"},
                                     {"Ag", "107.868200", "AG", "Silver metal (HH et al. 2008) ", "107"},
                                     {"Al", "26.981539", "AL", "Aluminium metal (HH et al. 2008)", "108"},
                                     {"Au", "196.966500", "AU", "Gold metal (HH et al. 2008)", "109"},
                                     {"Cu", "63.546000", "CU", "Copper metal (HH et al. 2008)", "110"},
                                     {"Ni", "58.693400", "NI", "Nickel metal (HH et al. 2008)", "111"},
                                     {"Pb", "207.200000", "PB", "Lead metal (HH et al. 2008)", "112"},
                                     {"Pd", "106.420000", "PD", "Palladium metal (HH et al. 2008)", "113"},
                                     {"Pt", "195.084000", "PT", "Platinum metal (HH et al. 2008)", "114"}};

/*
 Quadratic bonds
  0= Key_a, 1= Key_b, 2= R0 (A), 3= Kb (kcal mol^-1 A^2), 4= charmm22_prot_metals info

  V(R) = Kb x (R - R0)^2
*/
char * charmm22_prot_metals_bonds[139][5]= {{"CST", "OST", "937.96", "1.1600", "to Sulfate (PSUL) link"},
                                      {"SS", "FE", "250.0", "2.3200", "bond length optimized to reproduce "},
                                      {"C", "C", "600.000", "1.3350", "Heme vinyl substituent (KK, from propene (JCS))"},
                                      {"CA", "CA", "305.000", "1.3750", "benzene, JES 8/25/89"},
                                      {"CE1", "CE1", "440.000", "1.3400", "for butene; from propene, yin/adm jr., 12/95"},
                                      {"CE1", "CE2", "500.000", "1.3420", "for propene, yin/adm jr., 12/95"},
                                      {"CE1", "CT2", "365.000", "1.5020", "for butene; from propene, yin/adm jr., 12/95"},
                                      {"CE1", "CT3", "383.000", "1.5040", "for butene, yin/adm jr., 12/95"},
                                      {"CE2", "CE2", "510.000", "1.3300", "for ethene, yin/adm jr., 12/95"},
                                      {"CP1", "C", "250.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CP1", "CC", "250.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CP1", "CD", "200.000", "1.4900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CP2", "CP1", "222.500", "1.5270", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CP2", "CP2", "222.500", "1.5370", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CP3", "CP2", "222.500", "1.5370", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"CPB", "CE1", "450.000", "1.3800", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                      {"CPB", "CPA", "299.800", "1.4432", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"CPB", "CPB", "340.700", "1.3464", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"CPH1", "CPH1", "410.000", "1.3600", "histidine, adm jr., 6/27/90"},
                                      {"CPM", "CPA", "360.000", "1.3716", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"CPT", "CA", "305.000", "1.3680", "adm jr., 12/30/91, for jwk"},
                                      {"CPT", "CPT", "360.000", "1.4000", "jr., 12/30/91, for jwk"},
                                      {"CT1", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                                      {"CT1", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                      {"CT1", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"CT1", "CT1", "222.500", "1.5000", "alkane update, adm jr., 3/2/92"},
                                      {"CT2", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                                      {"CT2", "CA", "230.000", "1.4900", "phe,tyr, JES 8/25/89"},
                                      {"CT2", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                      {"CT2", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"CT2", "CPB", "230.000", "1.4900", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                      {"CT2", "CPH1", "229.630", "1.5000", "his, adm jr., 7/22/89, FC from CT2CT, BL from crystals"},
                                      {"CT2", "CT1", "222.500", "1.5380", "alkane update, adm jr., 3/2/92"},
                                      {"CT2", "CT2", "222.500", "1.5300", "alkane update, adm jr., 3/2/92"},
                                      {"CT3", "C", "250.000", "1.4900", "Ala Dipeptide ab initio calc's (LK) fixed from 10/90 (5/91)"},
                                      {"CT3", "CA", "230.000", "1.4900", "toluene, adm jr. 3/7/92"},
                                      {"CT3", "CC", "200.000", "1.5220", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                      {"CT3", "CD", "200.000", "1.5220", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"CT3", "CPB", "230.000", "1.4900", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                      {"CT3", "CPH1", "229.630", "1.5000", "his, adm jr., 7/22/89, FC from CT2CT, BL from crystals"},
                                      {"CT3", "CS", "190.000", "1.5310", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                      {"CT3", "CT1", "222.500", "1.5380", "alkane update, adm jr., 3/2/92"},
                                      {"CT3", "CT2", "222.500", "1.5280", "alkane update, adm jr., 3/2/92"},
                                      {"CT3", "CT3", "222.500", "1.5300", "alkane update, adm jr., 3/2/92"},
                                      {"CY", "CA", "350.000", "1.3650", "jr., 5/08/91, indole CCDB structure search"},
                                      {"CY", "CPT", "350.000", "1.4400", "jr., 12/30/91, for jwk"},
                                      {"CY", "CT2", "230.000", "1.5100", "Kb from alkane freq.. b0 from TRP crystal"},
                                      {"FE", "CM", "258.000", "1.9000", "Heme (6-liganded): CO ligand (KK 05/13/91)"},
                                      {"FE", "CPM", "0.000", "3.3814", "Heme (6-liganded): for ic para only (KK 05/13/91)"},
                                      {"H", "CD", "330.000", "1.1100", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"HA", "CA", "340.000", "1.0830", "trp, adm jr., 10/02/89"},
                                      {"HA", "CC", "317.130", "1.1000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                      {"HA", "CP2", "309.000", "1.1110", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"HA", "CP3", "309.000", "1.1110", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"HA", "CPM", "367.600", "1.0900", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"HA", "CS", "300.000", "1.1110", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                      {"HA", "CT1", "309.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                                      {"HA", "CT2", "309.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                                      {"HA", "CT3", "322.000", "1.1110", "alkane update, adm jr., 3/2/92"},
                                      {"HA", "CY", "330.000", "1.0800", "JWK 05/14/91 new r0 from indole"},
                                      {"HE1", "CE1", "360.500", "1.1000", "for propene, yin/adm jr., 12/95"},
                                      {"HE2", "CE2", "365.000", "1.1000", "for ethene, yin/adm jr., 12/95"},
                                      {"HB", "CP1", "330.000", "1.0800", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"HB", "CT1", "330.000", "1.0800", "Alanine Dipeptide ab initio calc's (LK)"},
                                      {"HB", "CT2", "330.000", "1.0800", "Alanine Dipeptide ab initio calc's (LK)"},
                                      {"HB", "CT3", "330.000", "1.0800", "Alanine Dipeptide ab initio calc's (LK)"},
                                      {"HP", "CA", "340.000", "1.0800", "phe,tyr JES 8/25/89"},
                                      {"HP", "CY", "350.000", "1.0800", "jr., 12/30/91, for jwk"},
                                      {"HR1", "CPH1", "375.000", "1.0830", "his, adm jr., 6/27/90"},
                                      {"HR1", "CPH2", "340.000", "1.0900", "his, adm jr., 6/28/29"},
                                      {"HR2", "CPH2", "333.000", "1.0700", "his, adm jr., 6/27/90"},
                                      {"HR3", "CPH1", "365.000", "1.0830", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                      {"HT", "HT", "0.000", "1.5139", "FROM TIPS3P GEOMETRY (FOR SHAKE/W PARAM)"},
                                      {"N", "C", "260.000", "1.3000", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"N", "CP1", "320.000", "1.4340", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"N", "CP3", "320.000", "1.4550", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"NC2", "C", "463.000", "1.3650", "403.0->463.0, 1.305->1.365 guanidinium (KK)"},
                                      {"NC2", "CT2", "261.000", "1.4900", "arg, (DS)"},
                                      {"NC2", "CT3", "261.000", "1.4900", "methylguanidinium, adm jr., 3/26/92"},
                                      {"NC2", "HC", "455.000", "1.0000", "405.0->455.0 GUANIDINIUM (KK)"},
                                      {"NH1", "C", "370.000", "1.3450", "Alanine Dipeptide ab initio calc's (LK)"},
                                      {"NH1", "CT1", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                                      {"NH1", "CT2", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                                      {"NH1", "CT3", "320.000", "1.4300", "NMA Gas and Liquid Phase IR Spectra (LK)"},
                                      {"NH1", "H", "440.000", "0.9970", "Alanine Dipeptide ab initio calc's (LK)"},
                                      {"NH1", "HC", "405.000", "0.9800", "(DS)"},
                                      {"NH2", "CC", "430.000", "1.3600", "adm jr. 4/10/91, acetamide"},
                                      {"NH2", "CT2", "240.000", "1.4550", "from NH2 CT3, neutral glycine, adm jr."},
                                      {"NH2", "CT3", "240.000", "1.4550", "methylamine geom/freq, adm jr., 6/2/92"},
                                      {"NH2", "H", "480.000", "1.0000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                      {"NH2", "HC", "460.000", "1.0000", "methylamine geom/freq, adm jr., 6/2/92"},
                                      {"NH3", "CT1", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                      {"NH3", "CT2", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                      {"NH3", "CT3", "200.000", "1.4800", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                      {"NH3", "HC", "403.000", "1.0400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                      {"NP", "CP1", "320.000", "1.4850", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"NP", "CP3", "320.000", "1.5020", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"NP", "HC", "460.000", "1.0060", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                      {"NPH", "CPA", "377.200", "1.3757", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"NPH", "FE", "270.200", "1.9580", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                      {"NR1", "CPH1", "400.000", "1.3800", "his, ADM JR., 7/20/89"},
                                      {"NR1", "CPH2", "400.000", "1.3600", "his, ADM JR., 7/20/89"},
                                      {"NR1", "H", "466.000", "1.0000", "his, ADM JR., 7/20/89"},
                                      {"NR2", "CPH1", "400.000", "1.3800", "his, ADM JR., 7/20/89"},
                                      {"NR2", "CPH2", "400.000", "1.3200", "his, ADM JR., 7/20/89"},
                                      {"NR2", "FE", "65.000", "2.2000", "Heme (6-liganded): His ligand (KK 05/13/91)"},
                                      {"NR3", "CPH1", "380.000", "1.3700", "his, adm jr., 6/28/90"},
                                      {"NR3", "CPH2", "380.000", "1.3200", "his, adm jr., 6/27/90"},
                                      {"NR3", "H", "453.000", "1.0000", "his, adm jr., 6/27/90"},
                                      {"NY", "CA", "270.000", "1.3700", "jr., 12/30/91, for jwk"},
                                      {"NY", "CPT", "270.000", "1.3750", "jr., 12/30/91, for jwk"},
                                      {"NY", "H", "465.000", "0.9760", "indole JWK 08/28/89"},
                                      {"O", "C", "620.000", "1.2300", "Peptide geometry, condensed phase (LK)"},
                                      {"O", "CC", "650.000", "1.2300", "adm jr. 4/10/91, acetamide"},
                                      {"OB", "CC", "750.000", "1.2200", "adm jr., 10/17/90, acetic acid vibrations and geom."},
                                      {"OB", "CD", "750.000", "1.2200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"OC", "CA", "525.000", "1.2600", "adm jr. 8/27/91, phenoxide"},
                                      {"OC", "CC", "525.000", "1.2600", "adm jr. 7/23/91, acetic acid"},
                                      {"OC", "CT2", "450.000", "1.3300", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                      {"OC", "CT3", "450.000", "1.3300", "methoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                      {"OH1", "CA", "334.300", "1.4110", "MeOH, EMB 10/10/89,"},
                                      {"OH1", "CD", "230.000", "1.4000", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"OH1", "CT1", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                                      {"OH1", "CT2", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                                      {"OH1", "CT3", "428.000", "1.4200", "methanol vib fit EMB 11/21/89"},
                                      {"OH1", "H", "545.000", "0.9600", "EMB 11/21/89 methanol vib fit"},
                                      {"OM", "CM", "1115.000", "1.1280", "Heme (6-liganded): CO ligand (KK 05/13/91)"},
                                      {"OM", "FE", "250.000", "1.8000", "Heme (6-liganded): O2 ligand (KK 05/13/91)"},
                                      {"OM", "OM", "600.000", "1.2300", "Heme (6-liganded): O2 ligand (KK 05/13/91)"},
                                      {"OS", "CD", "150.000", "1.3340", "adm jr. 5/02/91, acetic acid pure solvent"},
                                      {"OS", "CT3", "340.000", "1.4300", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                      {"OT", "HT", "450.000", "0.9572", "FROM TIPS3P GEOM"},
                                      {"S", "CT2", "198.000", "1.8180", "fitted to C-S s 9/26/92 (FL)"},
                                      {"S", "CT3", "240.000", "1.8160", "fitted to C-S s 9/26/92 (FL)"},
                                      {"S", "HS", "275.000", "1.3250", "methanethiol pure solvent, adm jr., 6/22/92"},
                                      {"SM", "CT2", "214.000", "1.8160", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                      {"SM", "CT3", "214.000", "1.8160", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                      {"SM", "SM", "173.000", "2.0290", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                      {"SS", "CS", "205.000", "1.8360", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"}};

/*
 Quadratic angles:
  0= Key_a, 1= Key_b, 2= Key_c, 3= Ktheta (kcal mol^-1 rad^2), 4= Theta0 (deg)

  V(Theta) = Ktheta * (Theta - Theta0)^2

 Urey-Bradley angles:
  5= Kub (kcal mol^-1 A^2), 6= S0 (A), 7= charmm22_prot_metals info

  V(S) = Kub x (S - S0)^2
*/
char * charmm22_prot_metals_angles[345][8]= {{"OST", "CST", "OST", "3000.00", "180.0000", " ", " ", "to Sulfate (PSUL) link"},
                                       {"CS", "SS", "FE", "50.0", "100.6", " ", " ", "angle optimized to reproduce"},
                                       {"SS", "FE", "NPH", "100.0", "90.0", " ", " ", "jr., 7/01"},
                                       {"CA", "CA", "CA", "40.000", "120.00", "35.00", "2.41620", "JES 8/25/89"},
                                       {"CE1", "CE1", "CT2", "48.00", "123.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                       {"CE1", "CE1", "CT3", "48.00", "123.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                       {"CE1", "CT2", "CT3", "32.00", "112.20", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                       {"CE2", "CE1", "CT2", "48.00", "126.00", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                       {"CE2", "CE1", "CT3", "47.00", "125.20", " ", " ", "for propene, yin/adm jr., 12/95"},
                                       {"CP1", "N", "C", "60.000", "117.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP2", "CP1", "C", "52.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP2", "CP1", "CC", "52.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP2", "CP1", "CD", "50.000", "112.3000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP2", "CP2", "CP1", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP3", "CP2", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP3", "N", "C", "60.000", "117.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP3", "N", "CP1", "100.000", "114.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CP3", "NP", "CP1", "100.000", "111.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"CPA", "CPB", "CE1", "70.000", "126.7400", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CPA", "CPM", "CPA", "94.200", "125.1200", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"CPA", "NPH", "CPA", "139.300", "103.9000", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"CPB", "CE1", "CE2", "70.000", "121.5000", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CPB", "CPB", "CE1", "70.000", "126.7500", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CPB", "CPB", "CPA", "30.800", "106.5100", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"CPH2", "NR1", "CPH1", "130.000", "107.5000", " ", " ", "his, adm jr., 6/27/90"},
                                       {"CPH2", "NR2", "CPH1", "130.000", "104.0000", " ", " ", "his, adm jr., 6/27/90"},
                                       {"CPH2", "NR3", "CPH1", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                       {"CPM", "CPA", "CPB", "61.600", "124.0700", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"CPT", "CA", "CA", "60.000", "118.0000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"CPT", "CPT", "CA", "60.000", "122.0000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"CPT", "CY", "CA", "120.000", "107.40", "25.00", "2.26100", "jr., 12/30/91, for jwk"},
                                       {"CPT", "NY", "CA", "110.000", "108.0000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"CT1", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"CT1", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"CT1", "CT1", "CT1", "53.350", "111.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT1", "CT2", "CA", "51.800", "107.5000", " ", " ", "PARALLH19 (JES)"},
                                       {"CT1", "CT2", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"CT1", "CT2", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"CT1", "CT2", "CPH1", "58.350", "113.0000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2CT, U-B omitted"},
                                       {"CT1", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"CT1", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"CT2", "CA", "CA", "45.800", "122.3000", " ", " ", "PARALLH19 (JES)"},
                                       {"CT2", "CPB", "CPA", "65.000", "126.7400", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CT2", "CPB", "CPB", "65.000", "126.7500", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CT2", "CPH1", "CPH1", "45.800", "130.0000", " ", " ", "his, ADM JR., 7/22/89, FC=>CT2CA CA,BA=> CRYSTALS"},
                                       {"CT2", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"CT2", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"CT2", "CT1", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"CT2", "CT1", "CT1", "53.350", "111.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT2", "CT2", "C", "52.000", "108.0000", " ", " ", "from CT2 CT1 C, for lactams, adm jr."},
                                       {"CT2", "CT2", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"CT2", "CT2", "CD", "52.000", "108.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"CT2", "CT2", "CPB", "70.000", "113.0000", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CT2", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"CT2", "CT2", "CT2", "58.350", "113.60", "11.16", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT2", "CT3", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"CT2", "CY", "CA", "45.800", "129.4000", " ", " ", "jr., 5/08/91, indole CCDB structure search"},
                                       {"CT2", "CY", "CPT", "45.800", "124.0000", " ", " ", "jr., 5/08/91, indole CCDB structure search"},
                                       {"CT2", "NC2", "C", "62.300", "120.0000", " ", " ", "107.5->120.0 to make planar Arg (KK)"},
                                       {"CT2", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"CT2", "OS", "CD", "40.000", "109.60", "30.00", "2.26510", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"CT3", "CA", "CA", "45.800", "122.3000", " ", " ", "toluene, adm jr., 3/7/92"},
                                       {"CT3", "CPB", "CPA", "65.000", "126.7400", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CT3", "CPB", "CPB", "65.000", "126.7500", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"CT3", "CPH1", "CPH1", "45.800", "130.0000", " ", " ", "his, ADM JR., 7/22/89, FC=>CT2CA CA,BA=> CRYSTALS"},
                                       {"CT3", "CT1", "C", "52.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"CT3", "CT1", "CC", "52.000", "108.0000", " ", " ", "adm jr. 4/09/92, for ALA cter"},
                                       {"CT3", "CT1", "CT1", "53.350", "108.50", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT3", "CT1", "CT2", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT3", "CT1", "CT3", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT3", "CT2", "CA", "51.800", "107.5000", " ", " ", "ethylbenzene, adm jr., 3/7/92"},
                                       {"CT3", "CT2", "CPH1", "58.350", "113.0000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2CT, U-B omitted"},
                                       {"CT3", "CT2", "CT1", "58.350", "113.50", "11.16", "2.56100", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"CT3", "CT2", "CT2", "58.000", "115.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT3", "CT2", "CT3", "53.350", "114.00", "8.00", "2.56100", "alkane update, adm jr., 3/2/92"},
                                       {"CT3", "NC2", "C", "62.300", "120.0000", " ", " ", "methylguanidinium, adm jr., 3/26/92"},
                                       {"CT3", "NH1", "C", "50.000", "120.0000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"CT3", "OS", "CD", "40.000", "109.60", "30.00", "2.26510", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"CT3", "S", "CT2", "34.000", "95.0000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                       {"CY", "CPT", "CA", "160.000", "130.6000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"CY", "CPT", "CPT", "110.000", "107.4000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"CY", "CT2", "CT1", "58.350", "114.0000", " ", " ", "from TRP crystal, JWK"},
                                       {"CY", "CT2", "CT3", "58.350", "114.0000", " ", " ", "from TRP crystal, JWK"},
                                       {"FE", "NPH", "CPA", "96.150", "128.0500", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"FE", "NR2", "CPH1", "30.000", "133.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"FE", "NR2", "CPH2", "30.000", "123.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"H", "NH1", "C", "34.000", "123.0000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"H", "NH1", "CT1", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                       {"H", "NH1", "CT2", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                       {"H", "NH1", "CT3", "35.000", "117.0000", " ", " ", "NMA Vibrational Modes (LK)"},
                                       {"H", "NH2", "CC", "50.000", "120.0000", " ", " ", "his, adm jr. 8/13/90 acetamide geometry and vibrations"},
                                       {"H", "NH2", "H", "23.000", "120.0000", " ", " ", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                       {"H", "NR1", "CPH1", "30.000", "125.50", "20.00", "2.15000", "his, adm jr., 6/27/90"},
                                       {"H", "NR1", "CPH2", "30.000", "127.00", "20.00", "2.14000", "his, adm jr., 6/27/90"},
                                       {"H", "NR3", "CPH1", "25.000", "126.00", "15.00", "2.13000", "his, adm jr., 6/27/90"},
                                       {"H", "NR3", "CPH2", "25.000", "126.00", "15.00", "2.09000", "his, adm jr., 6/27/90"},
                                       {"H", "NY", "CA", "28.000", "126.0000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"H", "NY", "CPT", "28.000", "126.0000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"H", "OH1", "CA", "65.000", "108.0000", " ", " ", "JES 8/25/89 phenol"},
                                       {"H", "OH1", "CD", "55.000", "115.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"H", "OH1", "CT1", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                       {"H", "OH1", "CT2", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                       {"H", "OH1", "CT3", "57.500", "106.0000", " ", " ", "methanol vib fit EMB 11/21/89"},
                                       {"HA", "CA", "CA", "29.000", "120.00", "25.00", "2.15250", "trp, adm jr., 10/02/89"},
                                       {"HA", "CA", "CPT", "41.000", "122.0000", " ", " ", "jr., 5/08/91, indole CCDB structure search"},
                                       {"HA", "CA", "CY", "32.000", "125.00", "25.00", "2.17300", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"HA", "CP2", "CP1", "33.430", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CP2", "CP2", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CP2", "CP3", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CP2", "HA", "35.500", "109.00", "5.40", "1.80200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CP3", "CP2", "26.500", "110.10", "22.53", "2.17900", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CP3", "HA", "35.500", "109.00", "5.40", "1.80200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HA", "CPM", "CPA", "12.700", "117.4400", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"HA", "CPM", "FE", "0.000", "180.0000", " ", " ", "Heme (6-liganded): for ic para only (KK 05/13/91)"},
                                       {"HA", "CS", "CT3", "34.600", "110.10", "22.53", "2.17900", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"HA", "CS", "HA", "35.500", "108.40", "14.00", "1.77500", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"HA", "CT1", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                       {"HA", "CT1", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"HA", "CT1", "CT1", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT1", "CT2", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT1", "CT3", "34.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT1", "HA", "35.500", "109.00", "5.40", "1.80200", "based on HA CT2 HA"},
                                       {"HA", "CT2", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                       {"HA", "CT2", "CA", "49.300", "107.5000", " ", " ", "PARALLH19 (JES)"},
                                       {"HA", "CT2", "CC", "33.000", "109.50", "30.00", "2.16300", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"HA", "CT2", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"HA", "CT2", "CE1", "45.00", "111.50", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                       {"HA", "CT2", "CPB", "50.000", "109.5000", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"HA", "CT2", "CPH1", "33.430", "109.5000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2HA, U-B OMITTED"},
                                       {"HA", "CT2", "CT1", "33.430", "110.10", "22.53", "2.17900", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"HA", "CT2", "CT2", "26.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT2", "CT3", "34.600", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT2", "CY", "33.430", "109.5000", " ", " ", "ADM JR., 10/02/89, from CT2CT2HA (U-B OMITTED), FOR JOANNA"},
                                       {"HA", "CT2", "HA", "35.500", "109.00", "5.40", "1.80200", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT3", "C", "33.000", "109.50", "30.00", "2.16300", "alanine dipeptide, LK, replaced, adm jr., 5/09/91"},
                                       {"HA", "CT3", "CA", "49.300", "107.5000", " ", " ", "toluene, adm jr. 3/7/92"},
                                       {"HA", "CT3", "CC", "33.000", "109.50", "30.00", "2.16300", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"HA", "CT3", "CD", "33.000", "109.50", "30.00", "2.16300", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"HA", "CT3", "CE1", "42.00", "111.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                       {"HA", "CT3", "CPB", "50.000", "109.5000", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"HA", "CT3", "CPH1", "33.430", "109.5000", " ", " ", "his, ADM JR., 7/22/89, from CT2CT2HA, U-B OMITTED"},
                                       {"HA", "CT3", "CS", "34.600", "110.10", "22.53", "2.17900", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"HA", "CT3", "CT1", "33.430", "110.10", "22.53", "2.17900", "alkane frequencies (MJF), alkane geometries (SF)"},
                                       {"HA", "CT3", "CT2", "34.600", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT3", "CT3", "37.500", "110.10", "22.53", "2.17900", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CT3", "HA", "35.500", "108.40", "5.40", "1.80200", "alkane update, adm jr., 3/2/92"},
                                       {"HA", "CY", "CA", "20.000", "126.40", "25.00", "2.18600", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"HA", "CY", "CPT", "32.000", "126.40", "25.00", "2.25500", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"HE1", "CE1", "CE1", "52.00", "119.50", " ", " ", "for 2-butene, yin/adm jr., 12/95"},
                                       {"HE1", "CE1", "CE2", "42.00", "118.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                       {"HE1", "CE1", "CT2", "40.00", "116.00", " ", " ", "for 1-butene; from propene, yin/adm jr., 12/95"},
                                       {"HE1", "CE1", "CT3", "22.00", "117.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                       {"HE1", "CE1", "CPB", "50.000", "120.0000", " ", " ", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                       {"HE2", "CE2", "CE1", "45.00", "120.50", " ", " ", "for propene, yin/adm jr., 12/95"},
                                       {"HE2", "CE2", "CE2", "55.50", "120.50", " ", " ", "for ethene, yin/adm jr., 12/95"},
                                       {"HE2", "CE2", "HE2", "19.00", "119.00", " ", " ", "for propene, yin/adm jr., 12/95"},
                                       {"HB", "CP1", "C", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HB", "CP1", "CC", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HB", "CP1", "CD", "50.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HB", "CP1", "CP2", "35.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HB", "CT1", "C", "50.000", "109.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT1", "CC", "50.000", "109.5000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"HB", "CT1", "CD", "50.000", "109.5000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"HB", "CT1", "CT1", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT1", "CT2", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT1", "CT3", "35.000", "111.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT2", "C", "50.000", "109.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT2", "CC", "50.000", "109.5000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"HB", "CT2", "CD", "50.000", "109.5000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"HB", "CT2", "HB", "36.000", "115.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HB", "CT3", "C", "50.000", "109.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"HC", "NC2", "C", "49.000", "120.0000", " ", " ", "35.3->49.0 GUANIDINIUM (KK)"},
                                       {"HC", "NC2", "CT2", "40.400", "120.0000", " ", " ", "107.5->120.0 to make planar Arg (KK)"},
                                       {"HC", "NC2", "CT3", "40.400", "120.0000", " ", " ", "methylguanidinium, adm jr., 3/26/92"},
                                       {"HC", "NC2", "HC", "25.000", "120.0000", " ", " ", "40.0->25.0 GUANIDINIUM (KK)"},
                                       {"HC", "NH2", "CT2", "50.000", "111.0000", " ", " ", "from HC NH2 CT3, neutral glycine, adm jr."},
                                       {"HC", "NH2", "CT3", "50.000", "111.0000", " ", " ", "methylamine geom/freq, adm jr., 6/2/92"},
                                       {"HC", "NH2", "HC", "39.000", "106.5000", " ", " ", "40.0->25.0 GUANIDINIUM (KK)"},
                                       {"HC", "NH3", "CT1", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"HC", "NH3", "CT2", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"HC", "NH3", "CT3", "30.000", "109.50", "20.00", "2.07400", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"HC", "NH3", "HC", "44.000", "109.5000", " ", " ", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"HC", "NP", "CP1", "33.000", "109.50", "4.00", "2.05600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HC", "NP", "CP3", "33.000", "109.50", "4.00", "2.05600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HC", "NP", "HC", "51.000", "107.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"HP", "CA", "CA", "30.000", "120.00", "22.00", "2.15250", "JES 8/25/89 benzene"},
                                       {"HP", "CA", "CPT", "30.000", "122.00", "22.00", "2.14600", "jr., 12/30/91, for jwk"},
                                       {"HP", "CA", "CY", "32.000", "125.00", "25.00", "2.17300", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"HP", "CY", "CA", "32.000", "126.40", "25.00", "2.18600", "jr., 12/30/91, for jwk"},
                                       {"HP", "CY", "CPT", "32.000", "126.40", "25.00", "2.25500", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"HR1", "CPH1", "CPH1", "22.000", "130.00", "15.00", "2.21500", "adm jr., 6/27/90, his"},
                                       {"HR3", "CPH1", "CPH1", "25.000", "130.00", "20.00", "2.20000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                       {"HS", "S", "CT2", "38.800", "95.0000", " ", " ", "methanethiol pure solvent, adm jr., 6/22/92"},
                                       {"HS", "S", "CT3", "43.000", "95.0000", " ", " ", "methanethiol pure solvent, adm jr., 6/22/92"},
                                       {"HT", "OT", "HT", "55.000", "104.5200", " ", " ", "TIP3P GEOMETRY, ADM JR."},
                                       {"N", "C", "CP1", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "C", "CT1", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "C", "CT2", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "C", "CT3", "20.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP1", "C", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP1", "CC", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP1", "CD", "50.000", "108.2000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP1", "CP2", "70.000", "110.8000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP1", "HB", "48.000", "112.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP3", "CP2", "70.000", "110.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"N", "CP3", "HA", "48.000", "108.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NC2", "C", "NC2", "52.000", "120.00", "90.00", "2.36420", "changed from 60.0/120.3 for guanidinium (KK)"},
                                       {"NC2", "CT2", "CT2", "67.700", "107.5000", " ", " ", "arg, (DS)"},
                                       {"NC2", "CT2", "HA", "51.500", "107.5000", " ", " ", "arg, (DS)"},
                                       {"NC2", "CT3", "HA", "51.500", "107.5000", " ", " ", "methylguanidinium, adm jr., 3/26/92"},
                                       {"NH1", "C", "CP1", "80.000", "116.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NH1", "C", "CT1", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"NH1", "C", "CT2", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"NH1", "C", "CT3", "80.000", "116.5000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"NH1", "CT1", "C", "50.000", "107.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT1", "CC", "50.000", "107.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"NH1", "CT1", "CD", "50.000", "107.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"NH1", "CT1", "CT1", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT1", "CT2", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT1", "CT3", "70.000", "113.5000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT1", "HB", "48.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT2", "C", "50.000", "107.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT2", "CC", "50.000", "107.0000", " ", " ", "adm jr. 5/20/92, for asn,asp,gln,glu and cters"},
                                       {"NH1", "CT2", "CD", "50.000", "107.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"NH1", "CT2", "CT2", "70.000", "113.5000", " ", " ", "from NH1 CT1 CT2, for lactams, adm jr."},
                                       {"NH1", "CT2", "HA", "51.500", "109.5000", " ", " ", "from NH1 CT3 HA, for lactams, adm jr."},
                                       {"NH1", "CT2", "HB", "48.000", "108.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"NH1", "CT3", "HA", "51.500", "109.5000", " ", " ", "NMA crystal (JCS)"},
                                       {"NH2", "CC", "CP1", "80.000", "112.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NH2", "CC", "CT1", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                       {"NH2", "CC", "CT2", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                       {"NH2", "CC", "CT3", "50.000", "116.50", "50.00", "2.45000", "adm jr. 8/13/90 acetamide geometry and vibrations"},
                                       {"NH2", "CC", "HA", "44.000", "111.00", "50.00", "1.98000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                       {"NH2", "CT2", "HA", "38.000", "109.50", "50.00", "2.14000", "NH2 CT3 HA, neutral lysine"},
                                       {"NH2", "CT2", "HB", "38.000", "109.50", "50.00", "2.14000", "NH2 CT3 HA, neutral glycine, adm jr."},
                                       {"NH2", "CT2", "CD", "52.000", "108.0000", " ", " ", "CT2 CT2 CD, neutral glycine, adm jr."},
                                       {"NH2", "CT2", "CT2", "67.700", "110.0000", " ", " ", "NH3 CT2 CT2, neutral lysine"},
                                       {"NH2", "CT3", "HA", "38.000", "109.50", "50.00", "2.14000", "methylamine geom/freq, adm jr., 6/2/92"},
                                       {"NH3", "CT1", "C", "43.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                       {"NH3", "CT1", "CC", "43.700", "110.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"NH3", "CT1", "CT1", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                       {"NH3", "CT1", "CT2", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                       {"NH3", "CT1", "CT3", "67.700", "110.0000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                       {"NH3", "CT1", "HB", "51.500", "107.5000", " ", " ", "new aliphatics, adm jr., 2/3/92"},
                                       {"NH3", "CT2", "C", "43.700", "110.0000", " ", " ", "alanine (JCS)"},
                                       {"NH3", "CT2", "CC", "43.700", "110.0000", " ", " ", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                       {"NH3", "CT2", "CD", "43.700", "110.0000", " ", " ", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"NH3", "CT2", "CT2", "67.700", "110.0000", " ", " ", "alanine (JCS)"},
                                       {"NH3", "CT2", "HA", "45.000", "107.50", "35.00", "2.10100", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"NH3", "CT2", "HB", "51.500", "107.5000", " ", " ", "for use on NTER -- from NH3 CT2HA (JCS) -- (LK)"},
                                       {"NH3", "CT3", "HA", "45.000", "107.50", "35.00", "2.10100", "new stretch and bend; methylammonium (KK 03/10/92)"},
                                       {"NP", "CP1", "C", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP1", "CC", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP1", "CD", "50.000", "106.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP1", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP1", "HB", "51.500", "107.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP3", "CP2", "70.000", "108.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NP", "CP3", "HA", "51.500", "109.1500", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"NPH", "CPA", "CPB", "122.000", "111.5400", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"NPH", "CPA", "CPM", "88.000", "124.3900", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"NPH", "FE", "CM", "50.000", "90.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"NPH", "FE", "CPM", "0.000", "45.0000", " ", " ", "Heme (6-liganded): for ic para only (KK 05/13/91)"},
                                       {"NPH", "FE", "NPH", "14.390", "90.0000", " ", " ", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                       {"NR1", "CPH1", "CPH1", "130.000", "106.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                       {"NR1", "CPH1", "CT2", "45.800", "124.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                       {"NR1", "CPH1", "CT3", "45.800", "124.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                       {"NR1", "CPH1", "HR3", "25.000", "124.00", "20.00", "2.14000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                       {"NR1", "CPH2", "HR1", "25.000", "122.50", "20.00", "2.14000", "his, adm jr., 6/27/90"},
                                       {"NR2", "CPH1", "CPH1", "130.000", "110.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                       {"NR2", "CPH1", "CT2", "45.800", "120.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                       {"NR2", "CPH1", "HR3", "25.000", "120.00", "20.00", "2.14000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                       {"NR2", "CPH2", "HR1", "25.000", "125.00", "20.00", "2.12000", "his, adm jr., 6/27/90"},
                                       {"NR2", "CPH2", "NR1", "130.000", "112.5000", " ", " ", "his, adm jr., 6/27/90"},
                                       {"NR2", "FE", "CM", "50.000", "180.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"NR2", "FE", "NPH", "50.000", "90.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"NR3", "CPH1", "CPH1", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                       {"NR3", "CPH1", "CT2", "45.800", "122.0000", " ", " ", "his, ADM JR., 7/22/89, FC FROM CA CT2CT"},
                                       {"NR3", "CPH1", "HR1", "22.000", "122.00", "15.00", "2.18000", "his, adm jr., 6/27/90"},
                                       {"NR3", "CPH2", "HR2", "32.000", "126.00", "25.00", "2.14000", "his, adm jr., 6/27/90"},
                                       {"NR3", "CPH2", "NR3", "145.000", "108.0000", " ", " ", "his, ADM JR., 7/20/89"},
                                       {"NY", "CA", "CY", "120.000", "110.00", "25.00", "2.24000", "jr., 12/30/91, for jwk"},
                                       {"NY", "CA", "HA", "32.000", "125.00", "25.00", "2.17700", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"NY", "CA", "HP", "32.000", "125.00", "25.00", "2.17700", "JWK 05/14/91 new theta0 and r0UB from indole"},
                                       {"NY", "CPT", "CA", "160.000", "130.6000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"NY", "CPT", "CPT", "110.000", "107.4000", " ", " ", "jr., 12/30/91, for jwk"},
                                       {"O", "C", "CP1", "80.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"O", "C", "CT1", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"O", "C", "CT2", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"O", "C", "CT3", "80.000", "121.0000", " ", " ", "Alanine Dipeptide ab initio calc's (LK)"},
                                       {"O", "C", "H", "50.000", "121.7000", " ", " ", "acetaldehyde (JCS)"},
                                       {"O", "C", "N", "80.000", "122.5000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"O", "C", "NH1", "80.000", "122.5000", " ", " ", "NMA Vib Modes (LK)"},
                                       {"O", "CC", "CP1", "80.000", "118.0000", " ", " ", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"O", "CC", "CT1", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                       {"O", "CC", "CT2", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                       {"O", "CC", "CT3", "15.000", "121.00", "50.00", "2.44000", "adm jr. 4/10/91, acetamide update"},
                                       {"O", "CC", "HA", "44.000", "122.0000", " ", " ", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                       {"O", "CC", "NH2", "75.000", "122.50", "50.00", "2.37000", "adm jr. 4/10/91, acetamide update"},
                                       {"OB", "CD", "CP1", "70.000", "125.00", "20.00", "2.44200", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"OB", "CD", "CT1", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"OB", "CD", "CT2", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"OB", "CD", "CT3", "70.000", "125.00", "20.00", "2.44200", "adm jr. 5/02/91, acetic acid pure solvent"},
                                       {"OC", "CA", "CA", "40.000", "120.0000", " ", " ", "adm jr. 8/27/91, phenoxide"},
                                       {"OC", "CC", "CP1", "40.000", "118.00", "50.00", "2.38800", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"OC", "CC", "CT1", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                       {"OC", "CC", "CT2", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                       {"OC", "CC", "CT3", "40.000", "118.00", "50.00", "2.38800", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                       {"OC", "CC", "OC", "100.000", "124.00", "70.00", "2.22500", "adm jr. 7/23/91, correction, ACETATE (KK)"},
                                       {"OC", "CT2", "CT3", "65.000", "122.0000", " ", " ", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"OC", "CT2", "HA", "65.000", "118.3000", " ", " ", "ethoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"OC", "CT3", "HA", "65.000", "118.3000", " ", " ", "methoxide 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"OH1", "CA", "CA", "45.200", "120.0000", " ", " ", "PARALLH19 WITH [122.3] (JES)"},
                                       {"OH1", "CD", "CT2", "55.000", "110.5000", " ", " ", "adm jr, 10/17/90, acetic acid vibrations"},
                                       {"OH1", "CD", "CT3", "55.000", "110.5000", " ", " ", "adm jr, 10/17/90, acetic acid vibrations"},
                                       {"OH1", "CD", "OB", "50.000", "123.00", "210.00", "2.26200", "adm jr, 10/17/90, acetic acid vibrations"},
                                       {"OH1", "CT1", "CT1", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT1", "CT3", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT1", "HA", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT2", "CT1", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT2", "CT2", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT2", "CT3", "75.700", "110.1000", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT2", "HA", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OH1", "CT3", "HA", "45.900", "108.8900", " ", " ", "MeOH, EMB, 10/10/89"},
                                       {"OM", "CM", "FE", "35.000", "180.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"OM", "FE", "NPH", "5.000", "90.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"OM", "OM", "FE", "0.000", "180.0000", " ", " ", "Heme (6-liganded): ligand links (KK 05/13/91)"},
                                       {"OS", "CD", "CP1", "55.000", "109.00", "20.00", "2.32600", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                       {"OS", "CD", "CT1", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                       {"OS", "CD", "CT2", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                       {"OS", "CD", "CT3", "55.000", "109.00", "20.00", "2.32600", "adm jr., 4/05/91, for PRES CT1 from methylacetate"},
                                       {"OS", "CD", "OB", "90.000", "125.90", "160.00", "2.25760", "adm jr. 3/19/92, from lipid methyl acetate"},
                                       {"OS", "CT2", "HA", "60.000", "109.5000", " ", " ", "adm jr. 4/05/91, for PRES CT1 from methyl acetate"},
                                       {"OS", "CT3", "HA", "60.000", "109.5000", " ", " ", "adm jr. 4/05/91, for PRES CT1 from methyl acetate"},
                                       {"S", "CT2", "CT1", "58.000", "112.5000", " ", " ", "as in expt.MeEtS and DALC crystal, 5/15/92"},
                                       {"S", "CT2", "CT2", "58.000", "114.5000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                       {"S", "CT2", "CT3", "58.000", "114.5000", " ", " ", "expt. MeEtS, 3/26/92 (FL)"},
                                       {"S", "CT2", "HA", "46.100", "111.3000", " ", " ", "vib. freq. and HF/6-31G* geo. (DTN) 8/24/90"},
                                       {"S", "CT3", "HA", "46.100", "111.3000", " ", " ", "vib. freq. and HF/6-31G* geo. (DTN) 8/24/90"},
                                       {"SM", "CT2", "CT1", "58.000", "112.5000", " ", " ", "as in expt.MeEtS and DALC crystal, 5/15/92"},
                                       {"SM", "CT2", "HA", "38.000", "111.0000", " ", " ", "new S-S atom type 8/24/90"},
                                       {"SM", "CT3", "HA", "38.000", "111.0000", " ", " ", "new S-S atom type 8/24/90"},
                                       {"SM", "SM", "CT2", "72.500", "103.3000", " ", " ", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                       {"SM", "SM", "CT3", "72.500", "103.3000", " ", " ", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                       {"SS", "CS", "CT3", "55.000", "118.0000", " ", " ", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                       {"SS", "CS", "HA", "40.000", "112.3000", " ", " ", "methylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"}};

/*
 Dihedrals
  0-3= Keys, 4= Kchi (kcal mol^-1), 5= n (multi), 6= delta (deg), 7= charmm22_prot_metals info

  V(chi) = Kchi x (1 + cos (n x (chi) - delta))
*/
char * charmm22_prot_metals_dihedrals[452][8]= {{"X", "FE", "SS", "X", "0.0000", "4", "0.00", "jr., 7/01"},
                                          {"X", "CS", "SS", "X", "0.0000", "3", "0.20", "methanethiol, HS S CT3 HA"},
                                          {"C", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"C", "CT2", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"C", "N", "CP1", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CA", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89"},
                                          {"CA", "CPT", "CPT", "CA", "3.1000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CA", "CT2", "CT1", "C", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                          {"CA", "CY", "CPT", "CA", "3.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"CA", "NY", "CPT", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CC", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CC", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                          {"CC", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"CC", "CT2", "NH1", "C", "0.2000", "1", "180.00", "Alanine dipeptide; NMA; acetate; etc. adm jr., 3/3/93c"},
                                          {"CD", "CP1", "N", "C", "0.0000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CD", "CT1", "NH1", "C", "0.2000", "1", "180.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"CD", "CT2", "NH1", "C", "0.2000", "1", "180.00", "Alanine dipeptide; NMA; acetate; etc. backbon adm jr., 3/3/93c"},
                                          {"CE1", "CE1", "CT3", "HA", "0.0300", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                          {"CE2", "CE1", "CT2", "CT3", "0.5000", "1", "180.00", "1-butene, adm jr., 2/00 update"},
                                          {"CE2", "CE1", "CT2", "CT3", "1.3000", "3", "180.00", "1-butene, adm jr., 2/00 update"},
                                          {"CE2", "CE1", "CT2", "HA", "0.1200", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                          {"CE2", "CE1", "CT3", "HA", "0.0500", "3", "180.00", "for propene, yin/adm jr., 12/95"},
                                          {"CP1", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP1", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP2", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP2", "CP3", "N", "C", "0.0000", "3", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP2", "CP3", "N", "CP1", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP2", "CP3", "NP", "CP1", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "N", "C", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "N", "C", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "N", "CP1", "C", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "N", "CP1", "CC", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "N", "CP1", "CP2", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "NP", "CP1", "C", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "NP", "CP1", "CC", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "NP", "CP1", "CD", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CP3", "NP", "CP1", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CPH2", "NR1", "CPH1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"CPH2", "NR2", "CPH1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"CPH2", "NR3", "CPH1", "CPH1", "12.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"CPT", "CA", "CA", "CA", "3.1000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CPT", "CPT", "CA", "CA", "3.1000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CPT", "CPT", "CY", "CA", "4.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CPT", "CPT", "NY", "CA", "5.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CT1", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT1", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT1", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT1", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT1", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT1", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT1", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"CT1", "CT2", "CA", "CA", "0.2300", "2", "180.00", "ethylbenzene ethyl rotation, adm jr. 3/7/92"},
                                          {"CT1", "CT2", "CPH1", "CPH1", "0.2000", "1", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT1", "CT2", "CPH1", "CPH1", "0.2700", "2", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT1", "CT2", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT1", "CT2", "CY", "CA", "0.2300", "2", "180.00", "from ethylbenzene, adm jr., 3/7/92"},
                                          {"CT1", "CT2", "CY", "CPT", "0.2300", "2", "180.00", "from ethylbenzene, adm jr., 3/7/92"},
                                          {"CT1", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT1", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT2", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT2", "C", "NH1", "CT2", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT2", "C", "NH1", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT2", "C", "NH1", "CT3", "1.6000", "1", "0.00", "from CT2 C NH1 CT2, adm jr. 10/21/96"},
                                          {"CT2", "C", "NH1", "CT3", "2.5000", "2", "180.00", "from CT2 C NH1 CT2, adm jr. 10/21/96"},
                                          {"CT2", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89 toluene and ethylbenzene"},
                                          {"CT2", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR1 CPH2"},
                                          {"CT2", "CPH1", "NR2", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR2 CPH2"},
                                          {"CT2", "CPH1", "NR3", "CPH2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"CT2", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"CT2", "CT2", "CPH1", "CPH1", "0.4000", "1", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. ADM JR., 9/4/89"},
                                          {"CT2", "CT2", "CT2", "CT2", "0.1500", "1", "0.00", "alkane update, adm jr., 3/2/92, butane trans/gauche"},
                                          {"CT2", "CT2", "NH1", "C", "1.8000", "1", "0.00", "from CT2 CT1 NH1 C, for lactams, adm jr."},
                                          {"CT2", "CY", "CPT", "CA", "3.0000", "2", "180.00", "JWK"},
                                          {"CT2", "CY", "CPT", "CPT", "3.0000", "2", "180.00", " "},
                                          {"CT2", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT2", "NH1", "C", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT2", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT2", "SM", "SM", "CT2", "1.0000", "1", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                          {"CT2", "SM", "SM", "CT2", "4.1000", "2", "0.00", "mp 6-311G** dimethyldisulfide, 3/26/92 (FL)"},
                                          {"CT2", "SM", "SM", "CT2", "0.9000", "3", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                          {"CT3", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "C", "NH1", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT3", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT3", "C", "NH1", "CT2", "1.6000", "1", "0.00", "for acetylated GLY N-terminus, adm jr."},
                                          {"CT3", "C", "NH1", "CT2", "2.5000", "2", "180.00", "for acetylated GLY N-terminus, adm jr."},
                                          {"CT3", "C", "NH1", "CT3", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT3", "C", "NH1", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT3", "CA", "CA", "CA", "3.1000", "2", "180.00", "toluene, adm jr., 3/7/92"},
                                          {"CT3", "CE1", "CE2", "HE2", "5.2000", "2", "180.00", "for propene, yin/adm jr., 12/95"},
                                          {"CT3", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM HA CPH1 NR1 CPH2"},
                                          {"CT3", "CT1", "NH1", "C", "1.8000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"CT3", "CT2", "CA", "CA", "0.2300", "2", "180.00", "ethylbenzene ethyl rotation, adm jr. 3/7/92"},
                                          {"CT3", "CT2", "CPH1", "CPH1", "0.2000", "1", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT3", "CT2", "CPH1", "CPH1", "0.2700", "2", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT3", "CT2", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-ethylimidazole 4-21G rot bar, adm jr. 3/4/92"},
                                          {"CT3", "CT2", "CT2", "CT2", "0.1500", "1", "0.00", "alkane update, adm jr., 3/2/92, butane trans/gauche"},
                                          {"CT3", "CT2", "CT2", "CT3", "0.1500", "1", "0.00", "alkane update, adm jr., 3/2/92, butane trans/gauche"},
                                          {"CT3", "CT2", "CY", "CA", "0.2300", "2", "180.00", "from ethylbenzene, adm jr., 3/7/92"},
                                          {"CT3", "CT2", "CY", "CPT", "0.2300", "2", "180.00", "from ethylbenzene, adm jr., 3/7/92"},
                                          {"CT3", "CT2", "S", "CT3", "0.2400", "1", "180.00", "expt. MeEtS, 3/26/92 (FL)"},
                                          {"CT3", "CT2", "S", "CT3", "0.3700", "3", "0.00", "DTN 8/24/90"},
                                          {"CT3", "NH1", "C", "CP1", "1.6000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"CT3", "NH1", "C", "CT1", "1.6000", "1", "0.00", "Revised to adjust NMA cis/trans energy difference. (LK)"},
                                          {"CT3", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"CT3", "S", "CT2", "CT2", "0.2400", "1", "180.00", "expt. MeEtS, 3/26/92 (FL)"},
                                          {"CT3", "S", "CT2", "CT2", "0.3700", "3", "0.00", "expt. MeEtS, 3/26/92 (FL)"},
                                          {"CT3", "SM", "SM", "CT3", "1.0000", "1", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                          {"CT3", "SM", "SM", "CT3", "4.1000", "2", "0.00", "mp 6-311G** dimethyldisulfide, 3/26/92 (FL)"},
                                          {"CT3", "SM", "SM", "CT3", "0.9000", "3", "0.00", "improved CSSC dihedral in DMDS 5/15/92 (FL)"},
                                          {"CY", "CA", "NY", "CPT", "5.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CY", "CPT", "CA", "CA", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"CY", "CPT", "CPT", "CA", "10.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"H", "NH1", "C", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"H", "NH1", "C", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"H", "NH1", "C", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"H", "NH1", "C", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"H", "NH1", "CT1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH1", "CT1", "CC", "0.0000", "1", "0.00", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                          {"H", "NH1", "CT1", "CD", "0.0000", "1", "0.00", "adm jr. 5/02/91, acetic acid pure solvent"},
                                          {"H", "NH1", "CT1", "CT1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH1", "CT1", "CT2", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH1", "CT1", "CT3", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH1", "CT2", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH1", "CT2", "CC", "0.0000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                          {"H", "NH1", "CT2", "CD", "0.0000", "1", "0.00", "adm jr. 5/02/91, acetic acid pure solvent"},
                                          {"H", "NH1", "CT2", "CT2", "0.0000", "1", "0.00", "from H NH1 CT2 CT3, for lactams, adm jr."},
                                          {"H", "NH1", "CT2", "CT3", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"H", "NH2", "CC", "CT1", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                          {"H", "NH2", "CC", "CT2", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                          {"H", "NH2", "CC", "CT3", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                          {"H", "NH2", "CC", "CP1", "2.5000", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"H", "NR1", "CPH1", "CPH1", "1.0000", "2", "180.00", "his, adm jr., 7/20/89"},
                                          {"H", "NR1", "CPH1", "CT2", "1.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HA CPH1 NR1 H"},
                                          {"H", "NR1", "CPH1", "CT3", "1.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HA CPH1 NR1 H"},
                                          {"H", "NR3", "CPH1", "CPH1", "1.4000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"H", "NR3", "CPH1", "CT2", "3.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HC NR3 CPH1 HA"},
                                          {"H", "NR3", "CPH1", "CT3", "3.0000", "2", "180.00", "his, adm jr., 7/22/89, FROM HC NR3 CPH1 HA"},
                                          {"H", "NY", "CA", "CY", "0.8000", "2", "180.00", "jr., 12/30/91, for jwk"},
                                          {"H", "NY", "CPT", "CA", "0.8000", "2", "180.00", "jr., 12/30/91, for jwk"},
                                          {"H", "NY", "CPT", "CPT", "0.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"H", "OH1", "CA", "CA", "0.9900", "2", "180.00", "phenol OH rot bar, 3.37 kcal/mole, adm jr. 3/7/92"},
                                          {"H", "OH1", "CT1", "CT1", "1.3300", "1", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT1", "CT1", "0.1800", "2", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT1", "CT1", "0.3200", "3", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT1", "CT3", "1.3300", "1", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT1", "CT3", "0.1800", "2", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT1", "CT3", "0.3200", "3", "0.00", "2-propanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT1", "1.3000", "1", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT1", "0.3000", "2", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT1", "0.4200", "3", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT2", "1.3000", "1", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT2", "0.3000", "2", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT2", "0.4200", "3", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT3", "1.3000", "1", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT3", "0.3000", "2", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"H", "OH1", "CT2", "CT3", "0.4200", "3", "0.00", "ethanol OH hf/6-31g* torsional surface, adm jr., 3/2/93"},
                                          {"HA", "CA", "CA", "CA", "3.5000", "2", "180.00", "adm jr., 10/02/89"},
                                          {"HA", "CA", "CA", "CPT", "3.5000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CA", "CA", "HA", "2.5000", "2", "180.00", "ADM JR., 10/02/89"},
                                          {"HA", "CA", "CPT", "CPT", "3.0000", "2", "180.00", "TRP (JES)"},
                                          {"HA", "CA", "CPT", "CY", "4.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CA", "CY", "CPT", "1.2000", "2", "180.00", "JWK"},
                                          {"HA", "CA", "CY", "CT2", "1.2000", "2", "180.00", "JWK"},
                                          {"HA", "CA", "NY", "CPT", "3.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CA", "NY", "H", "1.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CC", "NH2", "H", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                          {"HA", "CP3", "N", "C", "0.0000", "3", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HA", "CP3", "N", "CP1", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HA", "CP3", "NP", "CP1", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HA", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                          {"HA", "CT2", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. adm jr., 9/4/89"},
                                          {"HA", "CT2", "CY", "CA", "0.2500", "2", "180.00", "JWK"},
                                          {"HA", "CT2", "CY", "CPT", "0.2500", "2", "180.00", "JWK"},
                                          {"HA", "CT2", "NH1", "C", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"HA", "CT2", "NH1", "H", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"HA", "CT2", "S", "CT3", "0.2800", "3", "0.00", "DTN 8/24/90"},
                                          {"HA", "CT3", "CPH1", "CPH1", "0.0000", "3", "0.00", "4-methylimidazole 4-21G//6-31G* rot bar. adm jr., 9/4/89"},
                                          {"HA", "CT3", "CS", "HA", "0.1600", "3", "0.00", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                          {"HA", "CT3", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                          {"HA", "CT3", "NH1", "C", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"HA", "CT3", "NH1", "H", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"HA", "CT3", "S", "CT2", "0.2800", "3", "0.00", "DTN 8/24/90"},
                                          {"HA", "CY", "CA", "CPT", "1.2000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CY", "CA", "HA", "1.2000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CY", "CPT", "CA", "3.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"HA", "CY", "CPT", "CPT", "3.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"HE1", "CE1", "CE1", "HE1", "1.0000", "2", "180.00", "2-butene, adm jr., 8/98 update"},
                                          {"CT3", "CE1", "CE1", "HE1", "1.0000", "2", "180.00", "2-butene, adm jr., 8/98 update"},
                                          {"HE1", "CE1", "CE2", "HE2", "5.2000", "2", "180.00", "for propene, yin/adm jr., 12/95"},
                                          {"HE1", "CE1", "CT2", "HA", "0.0000", "3", "0.00", "butene, adm jr., 2/00 update"},
                                          {"HE1", "CE1", "CT2", "CT3", "0.1200", "3", "0.00", "for butene, yin/adm jr., 12/95"},
                                          {"HE1", "CE1", "CT3", "HA", "0.0000", "3", "0.00", "butene, adm jr., 2/00 update"},
                                          {"HE2", "CE2", "CE1", "CT2", "5.2000", "2", "180.00", "for butene, yin/adm jr., 12/95"},
                                          {"HE2", "CE2", "CE1", "CPB", "5.2000", "2", "180.00", "for vinyl, from butene, yin/adm jr., 12/95"},
                                          {"HB", "CP1", "N", "C", "0.8000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HB", "CP1", "N", "CP3", "0.1000", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HB", "CP1", "NP", "CP3", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HB", "CT1", "NH1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HB", "CT1", "NH1", "H", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HB", "CT2", "NH1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HB", "CT2", "NH1", "H", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HB", "CT3", "NH1", "C", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HB", "CT3", "NH1", "H", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"HC", "NH2", "CT2", "CT2", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral lysine"},
                                          {"HC", "NH2", "CT2", "HA", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral lysine"},
                                          {"HC", "NH2", "CT2", "HB", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral glycine, adm jr."},
                                          {"HC", "NH2", "CT2", "CD", "0.1100", "3", "0.00", "X CT3 NH2 X, neutral glycine, adm jr."},
                                          {"HC", "NP", "CP1", "C", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP1", "CC", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP1", "CD", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP1", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP1", "HB", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP3", "CP2", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HC", "NP", "CP3", "HA", "0.0800", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"HP", "CA", "CA", "CA", "4.2000", "2", "180.00", "JES 8/25/89 benzene"},
                                          {"HP", "CA", "CA", "CPT", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HP", "CA", "CA", "CT2", "4.2000", "2", "180.00", "JES 8/25/89 toluene and ethylbenzene"},
                                          {"HP", "CA", "CA", "CT3", "4.2000", "2", "180.00", "toluene, adm jr., 3/7/92"},
                                          {"HP", "CA", "CA", "HP", "2.4000", "2", "180.00", "JES 8/25/89 benzene"},
                                          {"HP", "CA", "CPT", "CPT", "3.0000", "2", "180.00", "JWK indole 05/14/91"},
                                          {"HP", "CA", "CPT", "CY", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HP", "CA", "CY", "CPT", "2.0000", "2", "180.00", "jr., 12/30/91, for jwk"},
                                          {"HP", "CA", "CY", "CT2", "1.2000", "2", "180.00", "JWK indole 05/14/91"},
                                          {"HP", "CA", "NY", "CPT", "2.0000", "2", "180.00", "jr., 12/30/91, for jwk"},
                                          {"HP", "CA", "NY", "H", "0.4000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HP", "CY", "CA", "HP", "1.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HP", "CY", "CPT", "CA", "2.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HP", "CY", "CPT", "CPT", "2.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"HR1", "CPH1", "CPH1", "CT2", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH1", "CPH1", "CT3", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH1", "CPH1", "HR1", "1.0000", "2", "180.00", "his, adm jr., 6/27/90, his"},
                                          {"HR1", "CPH1", "NR3", "CPH2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH1", "NR3", "H", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH2", "NR1", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH2", "NR1", "H", "1.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR1", "CPH2", "NR2", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR2", "CPH2", "NR3", "CPH1", "3.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"HR2", "CPH2", "NR3", "H", "0.0000", "2", "180.00", "his, adm jr., 6/27/90, YES, 0.0"},
                                          {"HR3", "CPH1", "CPH1", "CT2", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HR3", "CPH1", "CPH1", "CT3", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HR3", "CPH1", "CPH1", "HR3", "2.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HR3", "CPH1", "NR1", "CPH2", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HR3", "CPH1", "NR1", "H", "1.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HR3", "CPH1", "NR2", "CPH2", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"HS", "S", "CT2", "CT1", "0.2400", "1", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                          {"HS", "S", "CT2", "CT1", "0.1500", "2", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                          {"HS", "S", "CT2", "CT1", "0.2700", "3", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                          {"HS", "S", "CT2", "CT3", "0.2400", "1", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                          {"HS", "S", "CT2", "CT3", "0.1500", "2", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                          {"HS", "S", "CT2", "CT3", "0.2700", "3", "0.00", "ethanethiol C-C-S-H surface, adm jr., 4/18/93"},
                                          {"HS", "S", "CT2", "HA", "0.2000", "3", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                          {"HS", "S", "CT3", "HA", "0.2000", "3", "0.00", "methanethiol pure solvent, adm jr., 6/22/92"},
                                          {"N", "C", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CP1", "HB", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CP1", "HB", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT1", "CT1", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT1", "CT2", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT1", "CT3", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT1", "HB", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT2", "HB", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "C", "CT3", "HA", "0.0000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"N", "CT1", "CT2", "CA", "0.0400", "3", "0.00", "2.7 kcal/mole CH3 rot in ethylbenzene, adm jr, 3/7/92"},
                                          {"NH1", "C", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CP1", "HB", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CP1", "HB", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "C", "CT1", "CT1", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                          {"NH1", "C", "CT1", "CT2", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                          {"NH1", "C", "CT1", "CT3", "0.0000", "1", "0.00", "ala dipeptide corrxn for new C VDW Rmin, 4/10/93 (LK)"},
                                          {"NH1", "C", "CT1", "HB", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"NH1", "C", "CT1", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                          {"NH1", "C", "CT2", "CT2", "0.0000", "1", "0.00", "from NH1 C CT1 CT2, for lactams, adm jr."},
                                          {"NH1", "C", "CT2", "HA", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"NH1", "C", "CT2", "HB", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"NH1", "C", "CT2", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                          {"NH1", "C", "CT3", "HA", "0.0000", "3", "0.00", "LK for autogenerate dihe, sp2-methyl, no dihedral potential"},
                                          {"NH1", "CT1", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH1", "CT2", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "CP2", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "HB", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "HB", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH2", "CC", "CT2", "HA", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                          {"NH3", "CT1", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH3", "CT1", "C", "NH1", "0.6000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93"},
                                          {"NH3", "CT1", "CC", "NH2", "0.4000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                          {"NH3", "CT2", "C", "N", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NH3", "CT2", "C", "NH1", "0.4000", "1", "0.00", "adm jr. 3/24/92, for PRES GLYP"},
                                          {"NH3", "CT2", "CC", "NH2", "0.4000", "1", "0.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                          {"NP", "CP1", "C", "N", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NP", "CP1", "C", "NH1", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NP", "CP1", "CC", "NH2", "0.3000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"NR1", "CPH1", "CPH1", "CT2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR1 CPH1 CPH1 HA"},
                                          {"NR1", "CPH1", "CPH1", "CT3", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR1 CPH1 CPH1 HA"},
                                          {"NR1", "CPH1", "CPH1", "HR3", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"NR1", "CPH1", "CT2", "CT1", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR1", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR1", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR1", "CPH1", "CT2", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR1", "CPH1", "CT3", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR1", "CPH2", "NR2", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"NR2", "CPH1", "CPH1", "CT2", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR2 CPH1 CPH1 HA"},
                                          {"NR2", "CPH1", "CPH1", "CT3", "3.0000", "2", "180.00", "his, ADM JR., 7/22/89, FROM NR2 CPH1 CPH1 HA"},
                                          {"NR2", "CPH1", "CPH1", "HR3", "3.0000", "2", "180.00", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                          {"NR2", "CPH1", "CPH1", "NR1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"NR2", "CPH1", "CT2", "CT1", "0.1900", "3", "0.00", "HIS CB-CG TORSION,"},
                                          {"NR2", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "HIS CB-CG TORSION,"},
                                          {"NR2", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "HIS CB-CG TORSION,"},
                                          {"NR2", "CPH1", "CT2", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR2", "CPH1", "CT3", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR2", "CPH2", "NR1", "CPH1", "14.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"NR2", "CPH2", "NR1", "H", "1.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"NR3", "CPH1", "CPH1", "CT2", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"NR3", "CPH1", "CPH1", "CT3", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"NR3", "CPH1", "CPH1", "HR1", "2.5000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"NR3", "CPH1", "CPH1", "NR3", "12.0000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"NR3", "CPH1", "CT2", "CT1", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR3", "CPH1", "CT2", "CT2", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR3", "CPH1", "CT2", "CT3", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR3", "CPH1", "CT2", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR3", "CPH1", "CT3", "HA", "0.1900", "3", "0.00", "4-METHYLIMIDAZOLE 4-21G//6-31G* ROT BAR. ADM JR., 9/4/89"},
                                          {"NR3", "CPH2", "NR3", "CPH1", "12.0000", "2", "180.00", "his, ADM JR., 7/20/89"},
                                          {"NR3", "CPH2", "NR3", "H", "1.4000", "2", "180.00", "his, adm jr., 6/27/90"},
                                          {"NY", "CA", "CY", "CPT", "4.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"NY", "CA", "CY", "CT2", "3.5000", "2", "180.00", "JWK"},
                                          {"NY", "CA", "CY", "HA", "3.5000", "2", "180.00", "JWK 09/05/89"},
                                          {"NY", "CA", "CY", "HP", "3.5000", "2", "180.00", "JWK indole 05/14/91"},
                                          {"NY", "CPT", "CA", "CA", "2.8000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"NY", "CPT", "CA", "HA", "4.0000", "2", "180.00", "JWK 09/05/89"},
                                          {"NY", "CPT", "CA", "HP", "3.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"NY", "CPT", "CPT", "CA", "10.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"NY", "CPT", "CPT", "CY", "5.0000", "2", "180.00", "JWK 05/14/91 fit to indole"},
                                          {"O", "C", "CP1", "CP2", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "CP1", "HB", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "CP1", "HB", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "CT1", "CT1", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"O", "C", "CT1", "CT2", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"O", "C", "CT1", "CT3", "1.4000", "1", "0.00", "ala dipeptide update for new C VDW Rmin, adm jr., 3/3/93c"},
                                          {"O", "C", "CT1", "HB", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"O", "C", "CT1", "NH1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"O", "C", "CT1", "NH3", "0.0000", "1", "0.00", "Backbone parameter set made complete RLD 8/8/90"},
                                          {"O", "C", "CT2", "CT2", "1.4000", "1", "0.00", "from O C CT1 CT2, for lactams, adm jr."},
                                          {"O", "C", "CT2", "HA", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                          {"O", "C", "CT2", "HB", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"O", "C", "CT2", "NH1", "0.0000", "1", "0.00", "Alanine Dipeptide ab initio calc's (LK)"},
                                          {"O", "C", "CT2", "NH3", "0.0000", "1", "0.00", "Backbone parameter set made complete RLD 8/8/90"},
                                          {"O", "C", "CT3", "HA", "0.0000", "3", "180.00", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                          {"O", "C", "N", "CP1", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "N", "CP1", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "N", "CP3", "2.7500", "2", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "N", "CP3", "0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "C", "NH1", "CT1", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"O", "C", "NH1", "CT2", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"O", "C", "NH1", "CT3", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"O", "C", "NH1", "H", "2.5000", "2", "180.00", "Gives appropriate NMA cis/trans barrier. (LK)"},
                                          {"O", "CC", "CP1", "CP2", "0.4000", "1", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "CC", "CP1", "CP2", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "CC", "CP1", "HB", "0.4000", "1", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "CC", "CP1", "HB", "0.6000", "2", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "CC", "CP1", "N", "-0.3000", "4", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"O", "CC", "CT2", "HA", "0.0000", "3", "180.00", "adm jr. 4/05/91, for asn,asp,gln,glu and cters"},
                                          {"O", "CC", "NH2", "H", "1.4000", "2", "180.00", "adm jr. 4/10/91, acetamide update"},
                                          {"OB", "CD", "OS", "CT2", "0.9650", "1", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"OB", "CD", "OS", "CT2", "3.8500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"OB", "CD", "OS", "CT3", "0.9650", "1", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"OB", "CD", "OS", "CT3", "3.8500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"OC", "CA", "CA", "CA", "3.1000", "2", "180.00", "adm jr. 8/27/91, phenoxide"},
                                          {"OC", "CA", "CA", "HP", "4.2000", "2", "180.00", "adm jr. 8/27/91, phenoxide"},
                                          {"OC", "CC", "CP1", "CP2", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"OC", "CC", "CP1", "HB", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"OC", "CC", "CP1", "N", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"OC", "CC", "CP1", "NP", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"OC", "CC", "CT1", "NH3", "3.2000", "2", "180.00", "adm jr. 4/17/94, zwitterionic glycine"},
                                          {"OC", "CC", "CT2", "NH3", "3.2000", "2", "180.00", "adm jr. 4/17/94, zwitterionic glycine"},
                                          {"OH1", "CA", "CA", "CA", "3.1000", "2", "180.00", "JES 8/25/89 phenol"},
                                          {"OH1", "CA", "CA", "HP", "4.2000", "2", "180.00", "JES 8/25/89 phenol"},
                                          {"S", "CT2", "CT2", "HA", "0.0100", "3", "0.00", "DTN 8/24/90"},
                                          {"SM", "CT2", "CT2", "HA", "0.0100", "3", "0.00", "DTN 8/24/90"},
                                          {"SM", "SM", "CT2", "CT1", "0.3100", "3", "0.00", "S-S for cys-cys, dummy parameter for now ... DTN 9/04/90"},
                                          {"SM", "SM", "CT2", "CT2", "0.3100", "3", "0.00", "S-S for cys-cys, dummy parameter for now ... DTN 9/04/90"},
                                          {"SM", "SM", "CT2", "HA", "0.1580", "3", "0.00", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                          {"SM", "SM", "CT3", "HA", "0.1580", "3", "0.00", "expt. dimethyldisulfide, 3/26/92 (FL)"},
                                          {"SS", "CS", "CT3", "HA", "0.1500", "3", "0.00", "ethylthiolate 6-31+G* geom/freq, adm jr., 6/1/92"},
                                          {"X", "C", "NC2", "X", "2.2500", "2", "180.00", "9.0->2.25 GUANIDINIUM (KK)"},
                                          {"X", "CD", "OH1", "X", "2.0500", "2", "180.00", "adm jr, 10/17/90, acetic acid C-Oh rotation barrier"},
                                          {"X", "CD", "OS", "X", "2.0500", "2", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CE1", "CE1", "X", "0.1500", "1", "0.00", "2-butene, adm jr., 2/00 update"},
                                          {"X", "CE1", "CE1", "X", "8.5000", "2", "180.00", "2-butene, adm jr., 2/00 update"},
                                          {"X", "CE2", "CE2", "X", "4.9000", "2", "180.00", "for ethene, yin/adm jr., 12/95"},
                                          {"X", "CP1", "C", "X", "0.0000", "6", "180.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"X", "CP1", "CC", "X", "0.0000", "6", "180.00", "changed to 0.0 RLD 5/19/92"},
                                          {"X", "CP1", "CD", "X", "0.0000", "6", "180.00", "Alanine dipeptide; NMA; acetate; etc. backbone param. RLD 3/22/92"},
                                          {"X", "CP1", "CP2", "X", "0.1400", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"X", "CP2", "CP2", "X", "0.1600", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"X", "CP3", "CP2", "X", "0.1400", "3", "0.00", "6-31g* AcProNH2, ProNH2, 6-31g*//3-21g AcProNHCH3 RLD 4/23/93"},
                                          {"X", "CPA", "CPB", "X", "0.0000", "2", "0.00", "Heme (6-liganded): dummy for auto dihe (KK 05/13/91)"},
                                          {"X", "CPA", "CPM", "X", "0.0000", "2", "0.00", "Heme (6-liganded): dummy for auto dihe (KK 05/13/91)"},
                                          {"X", "CPB", "CE1", "X", "3.0000", "2", "180.00", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                          {"X", "CPB", "CPB", "X", "0.0000", "2", "0.00", "Heme (6-liganded): dummy for auto dihe (KK 05/13/91)"},
                                          {"X", "CPB", "CT2", "X", "0.0000", "6", "0.00", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                          {"X", "CPB", "CT3", "X", "0.0000", "6", "0.00", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                          {"X", "CPT", "CPT", "X", "0.0000", "2", "180.00", "JWK indole 05/14/91"},
                                          {"X", "CT1", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                          {"X", "CT1", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CT1", "CT1", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                          {"X", "CT1", "CT2", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                          {"X", "CT1", "CT3", "X", "0.2000", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                          {"X", "CT1", "NH3", "X", "0.1000", "3", "0.00", "0.715->0.10 METHYLAMMONIUM (KK)"},
                                          {"X", "CT1", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                          {"X", "CT1", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CT2", "CA", "X", "0.0000", "6", "0.00", "toluene, adm jr., 3/7/92"},
                                          {"X", "CT2", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                          {"X", "CT2", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CT2", "CT2", "X", "0.1950", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                          {"X", "CT2", "CT3", "X", "0.1600", "3", "0.00", "rotation barrier in Ethane (SF)"},
                                          {"X", "CT2", "NC2", "X", "0.0000", "6", "180.00", "methylguanidinium, adm jr., 3/26/92"},
                                          {"X", "CT2", "NH3", "X", "0.1000", "3", "0.00", "0.715->0.10 METHYLAMMONIUM (KK)"},
                                          {"X", "CT2", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                          {"X", "CT2", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CT3", "CA", "X", "0.0000", "6", "0.00", "toluene, adm jr., 3/7/92"},
                                          {"X", "CT3", "CC", "X", "0.0500", "6", "180.00", "For side chains of asp,asn,glu,gln, (n=6) from KK(LK)"},
                                          {"X", "CT3", "CD", "X", "0.0000", "6", "180.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "CT3", "CT3", "X", "0.1550", "3", "0.00", "alkane update, adm jr., 3/2/92"},
                                          {"X", "CT3", "NC2", "X", "0.0000", "6", "180.00", "methylguanidinium, adm jr., 3/26/92"},
                                          {"X", "CT3", "NH2", "X", "0.1100", "3", "0.00", "methylamine geom/freq, adm jr., 6/2/92"},
                                          {"X", "CT3", "NH3", "X", "0.0900", "3", "0.00", "fine-tuned to ab initio; METHYLAMMONIUM, KK 03/10/92"},
                                          {"X", "CT3", "OH1", "X", "0.1400", "3", "0.00", "EMB 11/21/89 methanol vib fit"},
                                          {"X", "CT3", "OS", "X", "-0.1000", "3", "0.00", "adm jr. 3/19/92, from lipid methyl acetate"},
                                          {"X", "FE", "CM", "X", "0.0500", "4", "0.00", "Heme (6-liganded): ligands (KK 05/13/91)"},
                                          {"X", "FE", "NPH", "X", "0.0000", "2", "0.00", "Heme (6-liganded): for ic para only (KK 05/13/91)"},
                                          {"X", "FE", "NR2", "X", "0.0500", "4", "0.00", "Heme (6-liganded): from param19.inp"},
                                          {"X", "FE", "OM", "X", "0.0000", "4", "0.00", "Heme (6-liganded): ligands (KK 05/13/91)"},
                                          {"X", "NPH", "CPA", "X", "0.0000", "2", "0.00", "Heme (6-liganded): dummy for auto dihe (KK 05/13/91)"}};

/*
 Impropers
  0-3= Keys, 4= Kpsi (kcal mol^-1 rad^-2), 5= psi0 (deg), 6= charmm22_prot_metals info

  V(psi) = Kpsi x (psi - psi0)^2
*/
char * charmm22_prot_metals_impropers[43][8]= {{"CPB", "CPA", "NPH", "CPA", "20.8000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"CPB", "X", "X", "CE1", "90.0000", "0", "0.0000", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                         {"CT2", "X", "X", "CPB", "90.0000", "0", "0.0000", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                         {"CT3", "X", "X", "CPB", "90.0000", "0", "0.0000", "Heme (6-liganded): substituents (KK 05/13/91)"},
                                         {"HA", "CPA", "CPA", "CPM", "29.4000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"HE2", "HE2", "CE2", "CE2", "3.0", "0", "0.00", "for ethene, yin/adm jr., 12/95"},
                                         {"HR1", "NR1", "NR2", "CPH2", "0.5000", "0", "0.0000", "his, adm jr., 7/05/90"},
                                         {"HR1", "NR2", "NR1", "CPH2", "0.5000", "0", "0.0000", "his, adm jr., 7/05/90"},
                                         {"HR3", "CPH1", "NR1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                         {"HR3", "CPH1", "NR2", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                         {"HR3", "CPH1", "NR3", "CPH1", "1.0000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                         {"HR3", "NR1", "CPH1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                         {"HR3", "NR2", "CPH1", "CPH1", "0.5000", "0", "0.0000", "adm jr., 3/24/92, maintain old aliphatic H VDW params"},
                                         {"N", "C", "CP1", "CP3", "0.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                         {"NC2", "X", "X", "C", "40.0000", "0", "0.0000", "5.75->40.0 GUANIDINIUM (KK)"},
                                         {"NH1", "X", "X", "H", "20.0000", "0", "0.0000", "NMA Vibrational Modes (LK)"},
                                         {"NH2", "X", "X", "H", "4.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"NPH", "CPA", "CPA", "FE", "137.4000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"NPH", "CPA", "CPB", "CPB", "40.6000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"NPH", "CPA", "CPM", "CPA", "18.3000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"NPH", "CPM", "CPB", "CPA", "32.7000", "0", "0.0000", "Heme (6-liganded): porphyrin macrocycle (KK 05/13/91)"},
                                         {"NR1", "CPH1", "CPH2", "H", "0.4500", "0", "0.0000", "his, adm jr., 7/05/90"},
                                         {"NR1", "CPH2", "CPH1", "H", "0.4500", "0", "0.0000", "his, adm jr., 7/05/90"},
                                         {"NR3", "CPH1", "CPH2", "H", "1.2000", "0", "0.0000", "his, adm jr., 6/27/90"},
                                         {"NR3", "CPH2", "CPH1", "H", "1.2000", "0", "0.0000", "his, adm jr., 6/27/90"},
                                         {"NY", "CA", "CY", "CPT", "100.0000", "0", "0.0000", "jr., 5/15/91, indole 3-21G HE1 out-of-plane surf."},
                                         {"O", "CP1", "NH2", "CC", "45.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                         {"O", "CT1", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "CT2", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "CT3", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "HA", "NH2", "CC", "45.0000", "0", "0.0000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                         {"O", "N", "CT2", "CC", "120.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                         {"O", "NH2", "CP1", "CC", "45.0000", "0", "0.0000", "6-31g* AcProNH2 and ProNH2 RLD 5/19/92"},
                                         {"O", "NH2", "CT1", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "NH2", "CT2", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "NH2", "CT3", "CC", "45.0000", "0", "0.0000", "adm jr., 8/13/90 acetamide geometry and vibrations"},
                                         {"O", "NH2", "HA", "CC", "45.0000", "0", "0.0000", "adm jr., 5/13/91, formamide geometry and vibrations"},
                                         {"O", "X", "X", "C", "120.0000", "0", "0.0000", "NMA Vibrational Modes (LK)"},
                                         {"OB", "X", "X", "CD", "100.0000", "0", "0.0000", "adm jr., 10/17/90, acetic acid vibrations"},
                                         {"OC", "X", "X", "CC", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                         {"CC", "X", "X", "CT1", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                         {"CC", "X", "X", "CT2", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"},
                                         {"CC", "X", "X", "CT3", "96.0000", "0", "0.0000", "90.0->96.0 acetate, single impr (KK)"}};

/*
 Non-bonded
  0= Key, 1= epsilon (kcal mol^-1), 2= Rmin/2 (A), 3= epsilon[1-4], 4= Rmin[1-4]/2, 5= charmm22_prot_metals info

  V(rij) =  Eps(ij) x [(Rmin(ij)/rij)^12 - 2 x (Rmin(ij)/rij)^6]
  With:
    Esp(ij) = sqrt(epsilon([i) x epsilon[j])
    Rmin(ij)= (Rmin[i] + Rmin[j])/2
*/
char * charmm22_prot_metals_vdw[98][6]= {{"C", "-0.110000", "2.000000", " ", " ", " "},
                                   {"CA", "-0.070000", "1.992400", " ", " ", " "},
                                   {"CC", "-0.070000", "2.000000", " ", " ", " "},
                                   {"CD", "-0.070000", "2.000000", " ", " ", " "},
                                   {"CE1", "-0.068000", "2.090000", " ", " ", " "},
                                   {"CE2", "-0.064000", "2.080000", " ", " ", " "},
                                   {"CM", "-0.110000", "2.100000", " ", " ", " "},
                                   {"CP1", "-0.020000", "2.275000", "-0.010000", "1.900000", " "},
                                   {"CP2", "-0.055000", "2.175000", "-0.010000", "1.900000", " "},
                                   {"CP3", "-0.055000", "2.175000", "-0.010000", "1.900000", " "},
                                   {"CPA", "-0.090000", "1.800000", " ", " ", " "},
                                   {"CPB", "-0.090000", "1.800000", " ", " ", " "},
                                   {"CPH1", "-0.050000", "1.800000", " ", " ", " "},
                                   {"CPH2", "-0.050000", "1.800000", " ", " ", " "},
                                   {"CPM", "-0.090000", "1.800000", " ", " ", " "},
                                   {"CPT", "-0.090000", "1.800000", "-0.090000", "1.900000", " "},
                                   {"CS", "-0.110000", "2.200000", " ", " ", " "},
                                   {"CST", "-0.058000", "1.563000", " ", " ", " "},
                                   {"CT1", "-0.020000", "2.275000", "-0.010000", "1.900000", " "},
                                   {"CT2", "-0.055000", "2.175000", "-0.010000", "1.900000", " "},
                                   {"CT3", "-0.080000", "2.060000", "-0.010000", "1.900000", " "},
                                   {"CY", "-0.070000", "1.992400", " ", " ", " "},
                                   {"CT", "-0.0200", "2.275", "-0.01", "1.9", " "},
                                   {"CT1x", "-0.0200", "2.275", "-0.01", "1.9", " "},
                                   {"CT2x", "-0.0560", "2.010", "-0.01", "1.9", " "},
                                   {"CT3x", "-0.0780", "2.040", "-0.01", "1.9", " "},
                                   {"H", "-0.046000", "0.224500", " ", " ", " "},
                                   {"HA", "-0.022000", "1.320000", " ", " ", " "},
                                   {"HE1", "-0.031000", "1.250000", " ", " ", " "},
                                   {"HE2", "-0.026000", "1.260000", " ", " ", " "},
                                   {"HB", "-0.022000", "1.320000", " ", " ", " "},
                                   {"HC", "-0.046000", "0.224500", " ", " ", " "},
                                   {"HP", "-0.030000", "1.358200", "-0.030000", "1.358200", " "},
                                   {"HR1", "-0.046000", "0.900000", " ", " ", " "},
                                   {"HR2", "-0.046000", "0.700000", " ", " ", " "},
                                   {"HR3", "-0.007800", "1.468000", " ", " ", " "},
                                   {"HS", "-0.100000", "0.450000", " ", " ", " "},
                                   {"HT", "-0.046000", "0.224500", " ", " ", " "},
                                   {"HA1", "-0.022", "1.3200", " ", " ", " "},
                                   {"HA2", "-0.028", "1.3400", " ", " ", " "},
                                   {"HA3", "-0.024", "1.3400", " ", " ", " "},
                                   {"N", "-0.200000", "1.850000", "-0.000100", "1.850000", " "},
                                   {"NC2", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NH1", "-0.200000", "1.850000", "-0.200000", "1.550000", " "},
                                   {"NH2", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NH3", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NP", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NPH", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NR1", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NR2", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NR3", "-0.200000", "1.850000", " ", " ", " "},
                                   {"NY", "-0.200000", "1.850000", " ", " ", " "},
                                   {"O", "-0.120000", "1.700000", "-0.120000", "1.400000", " "},
                                   {"OB", "-0.120000", "1.700000", "-0.120000", "1.400000", " "},
                                   {"OC", "-0.120000", "1.700000", " ", " ", " "},
                                   {"OH1", "-0.152100", "1.770000", " ", " ", " "},
                                   {"OM", "-0.120000", "1.700000", " ", " ", " "},
                                   {"OS", "-0.152100", "1.770000", " ", " ", " "},
                                   {"OST", "-0.165000", "1.692000", " ", " ", " "},
                                   {"OT", "-0.152100", "1.768200", " ", " ", " "},
                                   {"S", "-0.450000", "2.000000", " ", " ", " "},
                                   {"SM", "-0.380000", "1.975000", " ", " ", " "},
                                   {"SS", "-0.470000", "2.200000", " ", " ", " "},
                                   {"SOD", "-0.0469", "1.36375", " ", " ", " "},
                                   {"POT", "-0.0870", "1.76375", " ", " ", " "},
                                   {"CLA", "-0.150", "2.27", " ", " ", " "},
                                   {"CAL", "-0.120", "1.367", " ", " ", " "},
                                   {"MG", "-0.0150", "1.18500", " ", " ", " "},
                                   {"CES", "-0.1900", "2.100", " ", " ", " "},
                                   {"ZN", "-0.250000", "1.090000", " ", " ", " "},
                                   {"FE", "0.000000", "0.650000", " ", " ", " "},
                                   {"HE", "-0.021270", "1.4800", " ", " ", " "},
                                   {"NE", "-0.086000", "1.5300", " ", " ", " "},
                                   {"CLAL", "-0.030000", "1.908200", " ", " ", " "},
                                   {"DUM", "-0.000000", "0.000000", " ", " ", " "},
                                   {"AG", "-4.56", "1.4775", " ", " ", " "},
                                   {"AL", "-4.02", "1.4625", " ", " ", " "},
                                   {"AU", "-5.29", "1.4755", " ", " ", " "},
                                   {"CU", "-4.72", "1.3080", " ", " ", " "},
                                   {"NI", "-5.65", "1.2760", " ", " ", " "},
                                   {"PB", "-2.93", "1.7825", " ", " ", " "},
                                   {"PD", "-6.15", "1.4095", " ", " ", " "},
                                   {"PT", "-7.80", "1.4225", " ", " ", " "},
                                   {"CAP", "-0.070000", "1.992400", " ", " ", " "},
                                   {"FA", "-0.12000", "1.700000", " ", " ", " "},
                                   {"CN", "-0.200000", "1.750000", " ", " ", " "},
                                   {"NC", "-0.600000", "1.850000", " ", " ", " "},
                                   {"OCA", "-0.120000", "1.700000", "-0.120000", "1.400000", " "},
                                   {"COA", "-0.110000", "2.000000", " ", " ", " "},
                                   {"CF1", "-0.060000", "1.900000", " ", " ", " "},
                                   {"CF2", "-0.042000", "2.050000", " ", " ", " "},
                                   {"CF3", "-0.020000", "2.300000", " ", " ", " "},
                                   {"HF1", "-0.028000", "1.3200", " ", " ", " "},
                                   {"HF2", "-0.030000", "1.3000", " ", " ", " "},
                                   {"F1", "-0.135", "1.63", " ", " ", " "},
                                   {"F2", "-0.105", "1.63", " ", " ", " "},
                                   {"F3", "-0.097", "1.60", " ", " ", " "},
                                   {"C3", "-0.020000", "2.275000", " ", " ", " "}};
