/* $Id: vnet.c,v 1.8 2002/12/18 20:37:19 smarkou Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

		Atmel wireless lan drivers is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License as published by
		the Free Software Foundation; either version 2 of the License, or
		(at your option) any later version.

		Atmel wireless lan drivers is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with Atmel wireless lan drivers; if not, write to the Free Software
		Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA

**************************************************************************************/
#include "vnetusba.h"
#include <linux/wireless.h>
#include "command.h"
#include "rx.h"
#include "stdinclude.h"

//static        int             mtu = 1500;
//static        int             eth = 1;
static UCHAR channel = 10;
static UCHAR TxRate = 3;
static USHORT RTSThreshold = 2347;
static USHORT FragThreshold = 2346;
static UCHAR OpMode = INFRASTRUCTURE_MODE;
static char ESSID[ESSID_SIZE + 1] = "";
static UCHAR WepKeyToUse = 0;
static char WepKey1[(WEP_KEY_SIZE * 2) + 1] =
    "00000000000000000000000000\0";
static char WepKey2[(WEP_KEY_SIZE * 2) + 1] =
    "00000000000000000000000000\0";
static char WepKey3[(WEP_KEY_SIZE * 2) + 1] =
    "00000000000000000000000000\0";
static char WepKey4[(WEP_KEY_SIZE * 2) + 1] =
    "00000000000000000000000000\0";
static UCHAR WepMode = WEP_MODE_MANDATORY;
static UCHAR EncryptionLevel = 0;
static UCHAR AuthenticationType = C80211_MGMT_AAN_OPENSYSTEM;
static UCHAR PreambleType = 0;
static UCHAR PwrMgmtMode = ACTIVE_MODE;
static UCHAR InternationalRoaming = 0;
static UCHAR RadioIsOn = 0;

void SetParameters(PVNet_ADAPTER Adapter)
{
	int i, j;
// Channel
	Adapter->Channel = channel;
// TxRate
	Adapter->TxRate = TxRate;
// OperatingMode
	Adapter->OperatingMode = OpMode;
// Preamble Type
	Adapter->PreambleType = PreambleType;
// International Roaming 
	Adapter->InternationalRoaming = InternationalRoaming;
// Radio On - Off
	Adapter->RadioIsOn = RadioIsOn;
// Power Mgmt Mode
	Adapter->PowerMgmtMode = PwrMgmtMode;
// SSID
	Adapter->SSID_size = Adapter->DesiredSSIDsize = strlen(ESSID);

	memcpy((PUCHAR) Adapter->DesiredSSID, (PUCHAR) ESSID,
	       Adapter->SSID_size);
	memset((PUCHAR) Adapter->SelectedSSID, 0, ESSID_SIZE);
	Adapter->SSID_size = 0;
// FragmentationThreshold
	Adapter->FragmentationThreshold = FragThreshold;
// RtsThreshold
	Adapter->RtsThreshold = RTSThreshold;
// Wep Key Information
	Adapter->WepInfo.WepKeyToUse = WepKeyToUse;

	if (!EncryptionLevel) {
		Adapter->WepInfo.EncryptionLevel = 1;
		Adapter->PrivacyInvoked = 0;
	} else {
		Adapter->WepInfo.EncryptionLevel = EncryptionLevel;
		Adapter->PrivacyInvoked = 1;
	}
	Adapter->WepInfo.ExcludeUnencrypted = WepMode;
	Adapter->WepInfo.AuthenticationType = AuthenticationType;
	Adapter->InternationalRoaming = InternationalRoaming;
	// Wep Key 1
	j = 0;
	for (i = 0; i < WEP_KEY_SIZE * 2; i += 2) {
		Adapter->WepInfo.WepKey1[j] =
		    AsciiToByte((UCHAR) WepKey1[i],
				(UCHAR) WepKey1[i + 1]);
		j++;
	}
	// Wep Key 2
	j = 0;
	for (i = 0; i < WEP_KEY_SIZE * 2; i += 2) {
		Adapter->WepInfo.WepKey2[j] =
		    AsciiToByte((UCHAR) WepKey2[i],
				(UCHAR) WepKey2[i + 1]);
		j++;
	}
	// Wep Key 3
	j = 0;
	for (i = 0; i < WEP_KEY_SIZE * 2; i += 2) {
		Adapter->WepInfo.WepKey3[j] =
		    AsciiToByte((UCHAR) WepKey3[i],
				(UCHAR) WepKey3[i + 1]);
		j++;
	}
	// Wep Key 4
	j = 0;
	for (i = 0; i < WEP_KEY_SIZE * 2; i += 2) {
		Adapter->WepInfo.WepKey4[j] =
		    AsciiToByte((UCHAR) WepKey4[i],
				(UCHAR) WepKey4[i + 1]);
		j++;
	}
// TxRate       
	Adapter->TxRate = TxRate;
	Adapter->flags &= ~StationWasAssociated;
	Adapter->flags |= (TX_STOPPED | STOPPED_RX);
}


/*********************************************************/
//              Converts two Characters in One Byte                              //
/*********************************************************/
UCHAR AsciiToByte(UCHAR a1, UCHAR a2)
{
	return (HEX2BIN(a1) << 4) | (HEX2BIN(a2));
}

/************************************************************************
	Values initialization (through InitAdapter).
	Start Device initialization. Urb error handling (since in
	interrupt time (every callback runs in interrupt time)
	we cannot call usb_clear_halt, usb_reset_device etc).
************************************************************************/

int InitDevice(PVNet_ADAPTER Adapter)
{

	if (InitAdapter(Adapter) != 0) {
		err("parameters initialization failed");
		return -1;
	}

	Adapter->cmdhandler = GetOpMode;
	Adapter->flags |= INIT_PENDING;

	dbgcond(DBG_INIT, "flags %08lx\n", Adapter->flags);

	do {
		if (Adapter->flags & NEED_CLEAR_HALT) {
			Adapter->flags &= ~NEED_CLEAR_HALT;
			usb_clear_halt(Adapter->usb,
				       usb_pipeendpoint(Adapter->ctrl_urb->
							pipe));
		}
		if (Adapter->flags & USB_RESET_DEVICE) {
			if (VnetUsbReset(Adapter) < 0) {
				err("Device Reset failed");
				Adapter->flags &= ~INIT_PENDING;
				Adapter->cmdhandler = NULL;
				return -1;
			}
                        
			Adapter->flags &= ~USB_RESET_DEVICE;
		}
		if (Adapter->ctrl_urb->status != -EINPROGRESS) {
			Adapter->cmdhandler(Adapter);
			dbgcond(DBG_INIT, "ctrl_wait %p Adapter %p\n",
				Adapter->ctrl_wait, Adapter);
			VNetSchedule(Adapter, 1);
			if (Adapter->flags & WAKE_UP_WITH_ERROR) {
				return -1;
			}
		}
	} while (Adapter->flags & INIT_PENDING);

	if (Adapter->CmdStatus[5] != CMD_STATUS_COMPLETE) {
		err("StartUp failed");
		return -1;
	}

	memcpy(Adapter->CurrentAddress, Adapter->StationAddress, 6);
	{
		extern struct usb_driver vnet_driver;
		printk(KERN_INFO "%s: driver version " VERSION_STRING
		       ", compiled " __DATE__ " " __TIME__
		       " (dbg_mask x%lx)\n", vnet_driver.name,
		       Adapter->dbg_mask);
	}
	printk(KERN_INFO "MAC addr %02X:%02X:%02X:%02X:%02X:%02X "
	       "firmware %d.%d.%d.%d\n",
	       Adapter->StationAddress[0], Adapter->StationAddress[1],
	       Adapter->StationAddress[2], Adapter->StationAddress[3],
	       Adapter->StationAddress[4], Adapter->StationAddress[5],
	       Adapter->FwVersion[0], Adapter->FwVersion[1],
	       Adapter->FwVersion[2], Adapter->FwVersion[3]);
	return 0;
}				/* InitDevice */

int ChangeConfiguration(PVNet_ADAPTER Adapter,
			DEVICE_CONFIGURATION * pDevConfig)
{
	UCHAR ScanOnChange = 0;

        int i;

	if ((Adapter->Channel != pDevConfig->Channel) ||
	    (Adapter->OperatingMode == AD_HOC_MODE)) {

		Adapter->Channel = pDevConfig->Channel;
            printk(KERN_ALERT __FILE__ ": " "#####################\n");
            printk(KERN_ALERT __FILE__ ": " "Adapter->Channel : %d\n", Adapter->Channel);
            printk(KERN_ALERT __FILE__ ": " "APPLICATION  Channel : %d\n", pDevConfig->Channel);
            printk(KERN_ALERT __FILE__ ": " "#####################\n");
		ScanOnChange = 1;
	}

        if(Adapter->InternationalRoaming != pDevConfig->InternationalRoaming){
           Adapter->InternationalRoaming = pDevConfig->InternationalRoaming;
	   if (Adapter->OperatingMode == AD_HOC_MODE){
		   Adapter->InternationalRoaming = 0;
	   }
	   ScanOnChange = 1;
        }

	/* check for changed SSID */
	if (Adapter->SSID_size != pDevConfig->SSIDlength ||
	    memcmp(Adapter->SelectedSSID, pDevConfig->SSID,
		   Adapter->SSID_size)) {
		char buf[2 * ESSID_SIZE + 1] __attribute__ ((unused));

		assert(pDevConfig->SSIDlength <= ESSID_SIZE);

                if(Adapter->InternationalRoaming == TRUE){
                    Adapter->flags &= ~FIRST_SCAN_DONE;
                                for (i=0; i<14; i++){
                                        Adapter->ChannelVector[i] = 0;
                                }
                }
		Adapter->DesiredSSIDsize = pDevConfig->SSIDlength;
		memcpy(Adapter->DesiredSSID, pDevConfig->SSID,
		       pDevConfig->SSIDlength);

		dbgcond(DBG_CONFIG, "new SSID %s\n",
			ssid2str(buf, Adapter->DesiredSSID,
				 Adapter->DesiredSSIDsize));

		    ScanOnChange = 1;
	}

	/* checked for changed op mode (i.e. infrastructure or adhoc */
        if (Adapter->OperatingMode != (pDevConfig->OperatingMode + 1)) {
            Adapter->OperatingMode = pDevConfig->OperatingMode + 1;
            if(Adapter->OperatingMode == AD_HOC_MODE){
               Adapter->InternationalRoaming = 0;
            }

            ScanOnChange = 1;
        }


	if (Adapter->TxRate != pDevConfig->TxRate) {
		Adapter->TxRate = pDevConfig->TxRate;
		if (Adapter->TxRate == 4)
			Adapter->flags |= AutoRFChanged;
		/*
		   
		else
		        ScanOnChange = 1;

		*/
	}

	if (Adapter->PreambleType != pDevConfig->PreambleType) {
		Adapter->PreambleType = pDevConfig->PreambleType;
		Adapter->flags |= PreambleChanged;
	}

	if (Adapter->RadioIsOn != pDevConfig->RadioIsOn) {
		Adapter->RadioIsOn = pDevConfig->RadioIsOn;
                if ( Adapter->RadioIsOn == TRUE){
		    if (Adapter->InternationalRoaming){
			    Adapter->flags &= ~FIRST_SCAN_DONE;
                                for (i=0; i<14; i++){
                                        Adapter->ChannelVector[i] = 0;
                                }
		    }

                    Adapter->DesiredSSIDsize = pDevConfig->SSIDlength;
                    memcpy(Adapter->DesiredSSID, pDevConfig->SSID, pDevConfig->SSIDlength);

                    ChangeState(Adapter, STATION_STATE_SCANNING);
                    SetRadio(Adapter, TRUE);
                } else {
                    dbgcond(DBG_CONFIG, "RADIO CHANGED!!! \n");
                        ChangeState(Adapter, STATION_STATE_RADIO_OFF);
                        SetRadio(Adapter, FALSE);
                        DropPendingTxPackets(Adapter);
                }
                return 0;
                        
	}

	if (((pDevConfig->FragmentationThreshold <= 2346) ||
	     (pDevConfig->FragmentationThreshold >= 256)) &&
	    (Adapter->FragmentationThreshold !=
	     pDevConfig->FragmentationThreshold)) {
		Adapter->flags |= FragChanged;
                if ((pDevConfig->FragmentationThreshold)%2){
                      pDevConfig->FragmentationThreshold -= 1;
                }
		Adapter->FragmentationThreshold = pDevConfig->FragmentationThreshold;
	}
	if (((pDevConfig->RtsCtsThreshold <= 2347) ||
	     (pDevConfig->RtsCtsThreshold >= 256)) &&
	    (Adapter->RtsThreshold != pDevConfig->RtsCtsThreshold)) {
		Adapter->flags |= RtsCtsChanged;
		Adapter->RtsThreshold = pDevConfig->RtsCtsThreshold;
	}

        if (Adapter->RadioIsOn){
            if (ScanOnChange) {

                    dbgcond(DBG_CONFIG, "rescanning\n");

                    if (Adapter->flags & GetCommandPedding) {
                            VNetSchedule(Adapter, IOCTL_SLEEPING);

                            if (Adapter->flags & WAKE_UP_WITH_ERROR) {
                                    return -1;
                                    Adapter->flags &= ~IOCTL_SLEEPING;
                            }
                    }
                    dbgcond(DBG_CONFIG,
                            "state %02x status tx_urb %d ctrl_urb %d\n",
                            Adapter->StationState, Adapter->tx_urb->status,
                            Adapter->ctrl_urb->status);
                    DropPendingTxPackets(Adapter);
                    Adapter->flags &= ~StationWasAssociated;
                    ChangeState(Adapter, STATION_STATE_SCANNING);
                    dbgcond(DBG_CONFIG,
                            "state %02x status tx_urb %d ctrl_urb %d\n",
                            Adapter->StationState, Adapter->tx_urb->status,
                            Adapter->ctrl_urb->status);
                Adapter->DesiredSSIDsize = pDevConfig->SSIDlength;
		memcpy(Adapter->DesiredSSID, pDevConfig->SSID,
		       pDevConfig->SSIDlength);
		    SetIRoaming(Adapter);
                    return 0;
            }
	/* if (ScanOnChange) */
            if (Adapter->flags & PreambleChanged) {
                    /* jal: this will start a chain of Set*,
                       see callbacks.c::GetCmd_callback()  case CMD_SetMib */
                    SetPreamble(Adapter);
                    Adapter->flags &= ~PreambleChanged;
                    return 0;
            }

            if (Adapter->flags & FragChanged) {
                    SetFragThreshold(Adapter);
                    Adapter->flags &= ~FragChanged;
                    return 0;
            }

            if (Adapter->flags & RtsCtsChanged) {
                    SetRTSThreshold(Adapter);
                    Adapter->flags &= ~RtsCtsChanged;
                    return 0;
            }

            if (Adapter->flags & AutoRFChanged) {
                    SetAutoRateFallback(Adapter);
                    Adapter->flags &= ~AutoRFChanged;
            }

        }
	return 0;
}

BOOLEAN ValidateChannel(PVNet_ADAPTER Adapter, UCHAR Channel)
{
	switch (Adapter->RegDomain) {
	case REG_DOMAIN_FCC:		//1-11
		if ((Channel < 1) || (Channel > 11))
			return FALSE;
		break;
	case REG_DOMAIN_DOC:		//11
		if (Channel != 11)
			return FALSE;
		break;
	case REG_DOMAIN_ETSI:		//1-13
		if ((Channel < 1) || (Channel > 13))
			return FALSE;
		break;
	case REG_DOMAIN_SPAIN:		//10-11
		if ((Channel < 10) || (Channel > 11))
			return FALSE;
		break;
	case REG_DOMAIN_FRANCE:		//10-13
		if ((Channel < 10) || (Channel > 13))
			return FALSE;
		break;
	case REG_DOMAIN_MKK:		//14
		if (Channel != 14)
			return FALSE;
		break;
	case REG_DOMAIN_MKK1:		//1-14
		if ((Channel < 1) || (Channel > 14))
			return FALSE;
		break;
	case REG_DOMAIN_ISRAEL:		//3-7
		if ((Channel < 3) || (Channel > 9))
			return FALSE;
		break;

	}
	return TRUE;
}


void TimerExpired(ULONG a)
{
	PVNet_ADAPTER Adapter = (PVNet_ADAPTER) a;
	ULONG flags;

	if ((!Adapter) || (!(Adapter->flags & VNET_RUNNING)
			   && (Adapter->StationState !=
			       STATION_STATE_FW_DOWNLOAD)))
		return;

	spin_lock_irqsave(Adapter->lock, flags);
	Adapter->flags &= ~TimerReScheduled;

	switch (Adapter->StationState) {

	case STATION_STATE_FW_DOWNLOAD:
		// if usb_reset_device is called here the result will be :
		// Scheduling in interrupt,,,Kernel BUG at .....
		// In this case we wake the sleeping task (InitDevice in vnet.c)
		// and handle the reset there..........
		dbgcond(DBG_FW_DL, "going for reset\n");
		Adapter->flags |= USB_RESET_DEVICE;
		Adapter->cmdhandler = GetOpMode;
		wake_up_interruptible(Adapter->ctrl_wait);
		break;

	case STATION_STATE_AUTHENTICATING:
		dbgcond(DBG_AUTH,
			"auth retry: nr retries %d rx_urb->status %d\n",
			Adapter->AuthenticationRequestRetries,
			Adapter->rx_urb->status);
		Adapter->CurrentAuthentTransactionSeqNum = 0x0001;
		if (++Adapter->AuthenticationRequestRetries >
		    MAX_AUTHENTICATION_RETRIES) {
			dbgcond(DBG_AUTH,
				"max auth retries (%d) reached - giving up\n",
				MAX_AUTHENTICATION_RETRIES);
			DropPendingTxPackets(Adapter);
			ChangeState(Adapter, STATION_STATE_SCANNING);
			UsbScan(Adapter);
		} else {
			SendAuthRequest(Adapter, NULL, 0);
		}
		break;

	case STATION_STATE_ASSOCIATING:
		dbgcond(DBG_ASSOC, "assoc retry: nr retries %d\n",
			Adapter->AssociationRequestRetries);
		if (++Adapter->AssociationRequestRetries >
		    MAX_ASSOCIATION_RETRIES) {
			DropPendingTxPackets(Adapter);
			ChangeState(Adapter, STATION_STATE_SCANNING);
			UsbScan(Adapter);
		} else {
			SendAssocRequest(Adapter);
		}
		break;


	case STATION_STATE_REASSOCIATING:
		dbgcond(DBG_ASSOC, "assoc retry: nr retries %d\n",
			Adapter->ReAssociationRequestRetries);
		if (++Adapter->ReAssociationRequestRetries >
		    MAX_REASSOCIATION_RETRIES) {
			DropPendingTxPackets(Adapter);
			ChangeState(Adapter, STATION_STATE_SCANNING);
			UsbScan(Adapter);
		} else {
			SendReAssocRequest(Adapter);
		}
		break;

	case STATION_STATE_READY:
		// Out of range handler. Check every 2 seconds if HeardBeacons bit is set. If
		// not => OutOfRange
		if (Adapter->flags & HeardBeacons) {
			Adapter->flags &= ~HeardBeacons;
			VnetTimer(Adapter, 25);
			break;
		}
		DropPendingTxPackets(Adapter);
		ChangeState(Adapter, STATION_STATE_SCANNING);
		UsbScan(Adapter);
		break;

	case STATION_STATE_JOINING:
		dbgcond(DBG_JOIN, "ctrl_urb->status %d\n",
			Adapter->ctrl_urb->status);
		break;

	default:
		if (!(Adapter->flags & TimerReScheduled))
			VnetTimer(Adapter, 25);
		break;
	}
	spin_unlock_irqrestore(Adapter->lock, flags);
}

void VnetReleaseResources(PVNet_ADAPTER Adapter)
{

	if (!Adapter)
		return;

	usb_free_urb(Adapter->rx_urb);
	Adapter->rx_urb = NULL;
	usb_free_urb(Adapter->tx_urb);
	Adapter->tx_urb = NULL;
	usb_free_urb(Adapter->ctrl_urb);
	Adapter->ctrl_urb = NULL;
	dbgcond(DBG_INIT, "Urb's freed\n");

	VNetFree(Adapter->CtrlTimer);
	Adapter->CtrlTimer = NULL;
	VNetFree(Adapter->ctrl_wait);
	Adapter->ctrl_wait = NULL;
	VNetFree(Adapter->remove_wait);
	Adapter->remove_wait = NULL;

	dbgcond(DBG_INIT, "Timer's OK freed\n");

	VNetFree(Adapter->netstats);
	Adapter->netstats = NULL;
	VNetFree(Adapter->w_stats);
	Adapter->w_stats = NULL;
	VNetFree(Adapter->devreq);
	Adapter->devreq = NULL;
	VNetFree(Adapter->lock);
	Adapter->lock = NULL;
	VNetFree(Adapter->freeTx);
	Adapter->freeTx = NULL;

	VNetFree(Adapter);
}

void DropPendingTxPackets(PVNet_ADAPTER Adapter)
{
	struct list_head *p;
	PTX_LIST pTxList;

	dbgcond(DBG_TX, "freeing all pending tx packets\n");

	VNetIf_queue(Adapter->net, 0);

	/* free the TxList of pending Tx packets */
	for (p = Adapter->TxList->next; p != Adapter->TxList;) {
		pTxList = list_entry(p, TX_LIST, tx_list);
		list_del(p);
		p = p->next;	/* get the next pointer here, we de-alloc *p below */

		if (pTxList->status & UNDER_SUBMIT) {
			dbgcond(DBG_TX, "tx packet %p dropped\n", pTxList);
			wait_ms(10);
			pTxList->status &= ~UNDER_SUBMIT;	/* jal: shall we inform USB somehow ??? */
		}

		Adapter->netstats->tx_dropped++;
		kfree(pTxList->tx_buff);
		kfree(pTxList);
	}
	Adapter->flags &= ~TX_SLEEP;
}


VOID init_CRCtable(PVNet_ADAPTER Adapter)
{
	ULONG crc;
	int i, j;

	for (i = 0; i < 256; i++) {
		crc = i;
		for (j = 8; j > 0; j--) {
			if (crc & 1)
				crc = (crc >> 1) ^ 0xedb88320;
			else
				crc >>= 1;
		}
		Adapter->CrcTable[i] = crc;
	}
}

ULONG Calculate_CRC32(PUCHAR p, ULONG FrameLength, PULONG crctab)
{
	ULONG crcv, t;
	ULONG nr = 0;

	crcv = 0xffffffff;
	while (nr < FrameLength) {
		t = (crcv ^ p[nr]) & 0xff;
		crcv = ((crcv >> 8) & 0x00ffffff) ^ crctab[t];
		nr++;
	}
	crcv = (crcv ^ 0xffffffff);

	return (ULONG) crcv;
}
