/* $Id: command.c,v 1.9 2002/12/18 20:37:19 smarkou Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "vnetusba.h"
#include "command.h"
#include "rx.h"
#include "mib.h"
#include "stdinclude.h"

#define SendCtrlUrb(A, x) do{\
	int ret = 0;\
	if((A)->flags & CTRL_URB_SLEEP){\
		return -1;\
	}\
	if((ret = usb_submit_urb(x))!=0){\
		dbgcond(DBG_CTRL_URB, "Submit failed %d\n", ret);\
		return ret;\
	}\
	mod_use(1, (A));\
	(A)->flags |= CTRL_URB_SLEEP;\
	}while(0)

/*************************************************************
	Send Get Operating Mode command to the device.
	If this fails there is an eeprom board and we start
	the DFU procedure. In any other case we start normal
	operation
*************************************************************/
int GetOpMode(PVNet_ADAPTER Adapter)
{
	FILL_REQUEST(Adapter, 0x33, INTERFACE_VENDOR_REQUEST_IN, 0x0001, 0,
		     1);
	FILL_CONTROL_URB(Adapter->ctrl_urb, Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq, &Adapter->DevMode,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	dbgcond(DBG_CMDS, "FCU ok %08lx\n", Adapter->flags);
	Adapter->LastCommand[0] = CMD_GetOpMode;
	Adapter->cmdhandler = GetOpMode;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

/*************************************************************
 	GetHWcfg Command gets the Permanent MAC address from
 	the device.
*************************************************************/
int GetHWCfg(PVNet_ADAPTER Adapter)
{
	Adapter->cmdhandler = GetHWCfg;

#if (defined RFMD) || (defined R505)
	FILL_REQUEST(Adapter, 0x33,
		     INTERFACE_VENDOR_REQUEST_IN,
		     ((0x0A << 8) | 0x02), 0, sizeof(HW_CFG));
#else
	FILL_REQUEST(Adapter, 0x33,
		     INTERFACE_VENDOR_REQUEST_IN,
		     ((0x09 << 8) | 0x02), 0, sizeof(HW_CFG));
#endif

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	Adapter->LastCommand[0] = CMD_GetHWCfg;
	dbgcond(DBG_CMDS, " get the hardware configuration\n");
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

/*************************************************************
	GetMIB command is used from the driver to obtain
	the Regulatory Domain from the device.
*************************************************************/
int GetMIBvalue(PVNet_ADAPTER Adapter, USHORT Mib, USHORT bytes)
{
	Adapter->cmdhandler = NULL;

	FILL_REQUEST(Adapter, 0x33, INTERFACE_VENDOR_REQUEST_IN,
		     (Mib << 8), 0, bytes);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	Adapter->LastCommand[0] = CMD_GetMib;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

/*************************************************************
	Get Command Status command. For more details see
	GetCmd_Callback in callbacks.c
*************************************************************/
int GetCmdStatus(PVNet_ADAPTER Adapter, UCHAR CmdID)
{
	FILL_REQUEST(Adapter, 0x22, INTERFACE_VENDOR_REQUEST_IN, CmdID, 0,
		     40);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->CmdStatus,
			 Adapter->devreq->length,
			 GetCmd_callback, Adapter);

	SendCtrlUrb(Adapter, Adapter->ctrl_urb);

	return 0;
}

/*************************************************************
	The StartUp Command starts the device. This sends
	the Card Configuration.
*************************************************************/
int StartUp(PVNet_ADAPTER Adapter)
{
	USB_CARD_CONFIG UsbCardConfig;
	UCHAR SupportedRates[] = { 0x82, 0x84, 0x8B, 0x96 };

	Adapter->cmdhandler = StartUp;
	UsbCardConfig.ExcludeUnencrypted = FALSE;
	UsbCardConfig.PromiscuousMode = 0;
	UsbCardConfig.ShortRetryLimit = 8;
	UsbCardConfig.EncryptionType = 1;
	UsbCardConfig.RtsThreshold = Adapter->RtsThreshold;
	UsbCardConfig.FragmentationThreshold = Adapter->FragmentationThreshold;	// 256..2346
	memcpy((PUCHAR) UsbCardConfig.BasicRateSet,
	       (PUCHAR) SupportedRates, 4);
	if (Adapter->TxRate == 4)
		UsbCardConfig.AutoRateFallBack = 1;
	else
		UsbCardConfig.AutoRateFallBack = 0;
	UsbCardConfig.Channel = Adapter->Channel;

	if (!Adapter->PrivacyInvoked) {
		UsbCardConfig.EncryptionType = 1;
		UsbCardConfig.PrivacyInvoked = 0;
	} else {
		UsbCardConfig.EncryptionType =
		    Adapter->WepInfo.EncryptionLevel;
		UsbCardConfig.PrivacyInvoked = 1;
	}

	memcpy(UsbCardConfig.CurrentSSID, Adapter->DesiredSSID,
	       Adapter->DesiredSSIDsize);
	UsbCardConfig.SSIDLen = Adapter->DesiredSSIDsize;

	UsbCardConfig.WEPDefaultKeyID = Adapter->WepInfo.WepKeyToUse;

	memcpy((PUCHAR) UsbCardConfig.WEPDefaultKeyValue[0],
	       (PUCHAR) Adapter->WepInfo.WepKey1, WEP_KEY_SIZE);
	memcpy((PUCHAR) UsbCardConfig.WEPDefaultKeyValue[1],
	       (PUCHAR) Adapter->WepInfo.WepKey2, WEP_KEY_SIZE);
	memcpy((PUCHAR) UsbCardConfig.WEPDefaultKeyValue[2],
	       (PUCHAR) Adapter->WepInfo.WepKey3, WEP_KEY_SIZE);
	memcpy((PUCHAR) UsbCardConfig.WEPDefaultKeyValue[3],
	       (PUCHAR) Adapter->WepInfo.WepKey4, WEP_KEY_SIZE);
	if (Adapter->PreambleType == PREAMBLE_TYPE_SHORT)
		UsbCardConfig.ShortPreamble = 1;
	else
		UsbCardConfig.ShortPreamble = 0;
	Adapter->BeaconPeriod = UsbCardConfig.BeaconPeriod = 100;

	FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0, 0,
		     (4 + sizeof(USB_CARD_CONFIG)));
	Adapter->ctrl_buff[0] = (UCHAR) CMD_Startup;
	Adapter->ctrl_buff[1] = (UCHAR) 0;
	*(PUSHORT) (Adapter->ctrl_buff + 2) =
	    (USHORT) sizeof(USB_CARD_CONFIG);
	memcpy((PUCHAR) (Adapter->ctrl_buff + 4), (PUCHAR) & UsbCardConfig,
	       sizeof(USB_CARD_CONFIG));

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	Adapter->LastCommand[0] = CMD_Startup;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

/*************************************************************
	UsbScan : Scan command submittion. While Scan is pending
	the driver gets any information for the Access Points or
	the Station's in the area from the beacon frames.
*************************************************************/
int UsbScan(PVNet_ADAPTER Adapter)
{
	UCHAR i;
	SCAN ScanS;
	char buf[ESSID_SIZE + 1] __attribute__ ((unused));

	/*****************************
	 We must clear the IBSS struct
	 before ReScaning;
	*****************************/
	Adapter->SiteS.BSSInList = 0;

	FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0, 0,
		     (4 + sizeof(SCAN)));
	Adapter->cmdhandler = UsbScan;
//      Initialization of ScanStruct
	for (i = 0; i < 6; i++)
		ScanS.BSSID[i] = 0xFF;

	assert(Adapter->DesiredSSIDsize <= sizeof(ScanS.SSID));
	memcpy(ScanS.SSID, Adapter->DesiredSSID, Adapter->DesiredSSIDsize);
	ScanS.SSIDSize = Adapter->DesiredSSIDsize;
	ScanS.Channel = Adapter->Channel;
	ScanS.ProbeDelay = 10000;
	if ((Adapter->InternationalRoaming) &&
	    !(Adapter->flags & FIRST_SCAN_DONE) &&
	    (Adapter->OperatingMode != AD_HOC_MODE)) {
		ScanS.InternationalScan = 1;
                Adapter->IsInternationalScanEnabled = 1;
		Adapter->flags |= FIRST_SCAN_DONE;
                ScanS.ScanType      = 1;
                ScanS.MinChannelTime  = 150;
                ScanS.MaxChannelTime  = 150;

	} else {
		ScanS.InternationalScan = 0;
                Adapter->IsInternationalScanEnabled = 0;
                ScanS.ScanType      = 0;
                ScanS.MinChannelTime  = 10;
                ScanS.MaxChannelTime  = 120;
	}

	dbgcond(DBG_SCAN | DBG_CMDS,
		"ScanReq for ssid %s international %d type %s (ch %d)\n",
		ssid2str(buf, ScanS.SSID, ScanS.SSIDSize),
		ScanS.InternationalScan,
		Adapter->OperatingMode ==
		AD_HOC_MODE ? "ad-hoc" : "infrastructure", ScanS.Channel);

//      Copy struct to buffer
	Adapter->ctrl_buff[0] = (UCHAR) CMD_Scan;
	Adapter->ctrl_buff[1] = (UCHAR) 0;
	*(PUSHORT) (Adapter->ctrl_buff + 2) = (USHORT) (sizeof(SCAN));
	memcpy((PUCHAR) (Adapter->ctrl_buff + 4), (PUCHAR) & ScanS,
	       sizeof(SCAN));

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (PUCHAR) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	Adapter->LastCommand[0] = CMD_Scan;
	Adapter->flags |= GetCommandPedding;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int UsbJoin(PVNet_ADAPTER Adapter)
{
    JOIN JoinS;
    char buf[ESSID_SIZE + 1] __attribute__ ((unused));
    UCHAR i;
    // Check if the selected BSS has Wep or Not
    for (i = 0; i < Adapter->SiteS.BSSInList; i++) {
        if (memcmp (Adapter->SiteS.BssInfo[i].SSID, Adapter->SelectedSSID, Adapter->SSID_size) == 0){
            if (Adapter->SiteS.BssInfo[i].UsingWEP == 1 && Adapter->PrivacyInvoked == 0){ 
                Adapter->ErrorCode=0xa0;
                ChangeState(Adapter, STATION_STATE_MGMT_ERROR);
                continue;
            } else if (Adapter->SiteS.BssInfo[i].UsingWEP == 0 && Adapter->PrivacyInvoked == 1){ 
                Adapter->ErrorCode=0xa1;
                ChangeState(Adapter, STATION_STATE_MGMT_ERROR);
                continue;
            }else {

                    Adapter->ErrorCode=0;
                    Adapter->cmdhandler = UsbJoin;
                    Adapter->StationState = STATION_STATE_JOINING;

            //      JOIN Init       
                    memcpy((PUCHAR) JoinS.BSSID, (PUCHAR) Adapter->CurrentBSSID, 6);
                    memcpy((PUCHAR) JoinS.SSID, (PUCHAR) Adapter->SelectedSSID,
                           Adapter->SSID_size);
                    JoinS.SSIDSize = Adapter->SSID_size;
                    JoinS.BSSType =
                        (Adapter->OperatingMode == INFRASTRUCTURE_MODE) ? 2 : 1;
                    JoinS.Channel = Adapter->Channel;
                    dbgcond(DBG_JOIN | DBG_CMDS, "JoinReq: ssid %s bsstype %d "
                            "bssid %02x:%02x:%02x:%02x:%02x:%02x\n",
                            ssid2str(buf, JoinS.SSID, JoinS.SSIDSize), JoinS.BSSType,
                            JoinS.BSSID[0], JoinS.BSSID[1], JoinS.BSSID[2],
                            JoinS.BSSID[3], JoinS.BSSID[4], JoinS.BSSID[5]);
                    JoinS.JoinFailureTimeout = 2000;

            //      Request struct  
                    FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0, 0,
                                 (4 + sizeof(JOIN)));

            //  Buffer Creation
                    Adapter->ctrl_buff[0] = CMD_Join;
                    Adapter->ctrl_buff[1] = 0;
                    *(PUSHORT) (Adapter->ctrl_buff + 2) =
                        (USHORT) (Adapter->devreq->length - 4);
                    memcpy((PUCHAR) (Adapter->ctrl_buff + 4), (PUCHAR) & JoinS,
                           (Adapter->devreq->length - 4));

                    FILL_CONTROL_URB(Adapter->ctrl_urb,
                                     Adapter->usb,
                                     usb_sndctrlpipe(Adapter->usb, 0),
                                     (PUCHAR) Adapter->devreq,
                                     Adapter->ctrl_buff,
                                     Adapter->devreq->length, ctrl_callback, Adapter);

                    Adapter->LastCommand[0] = CMD_Join;
                    Adapter->flags |= GetCommandPedding;
                    SendCtrlUrb(Adapter, Adapter->ctrl_urb);
                    dbgcond(DBG_CMDS, "Join Out\n");
            }
        }
    }
    return 0;
}

int UsbStartIBSS(PVNet_ADAPTER Adapter)
{
	START_BSS StartBSS;
	char buf[ESSID_SIZE + 1] __attribute__ ((unused));

	Adapter->cmdhandler = UsbStartIBSS;
//  Struct Init
	memset(StartBSS.BSSID, 0xff, sizeof(StartBSS.BSSID));

	memcpy(StartBSS.SSID, Adapter->DesiredSSID,
	       Adapter->DesiredSSIDsize);
	StartBSS.SSIDSize = Adapter->DesiredSSIDsize;
	StartBSS.BSSType = AD_HOC_MODE;
	StartBSS.Channel = Adapter->Channel;
//      request
	FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0, 0,
		     (sizeof(START_BSS) + 4));
//  Buffer
	Adapter->ctrl_buff[0] = CMD_StartIBSS;
	Adapter->ctrl_buff[1] = 0;
	*(PUSHORT) (Adapter->ctrl_buff + 2) = (USHORT) sizeof(START_BSS);
	memcpy(Adapter->ctrl_buff + 4, &StartBSS, sizeof(START_BSS));

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (PUCHAR) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	Adapter->LastCommand[0] = CMD_StartIBSS;
	Adapter->flags |= GetCommandPedding;

	dbgcond(DBG_START_IBSS | DBG_CMDS,
		"starting IBSS, ch %d type %d ssid %s\n",
		StartBSS.Channel, StartBSS.BSSType,
		ssid2str(buf, StartBSS.SSID, StartBSS.SSIDSize));

	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}


int SetRadio(PVNet_ADAPTER Adapter, BOOLEAN EnableRadio)
{
	FILL_REQUEST(Adapter, 0x0E, 0x40, 0, 0, 4);

        if (EnableRadio == TRUE){
            Adapter->RadioIsOn= 1;
	Adapter->ctrl_buff[0] = 6;
        }else {
            Adapter->RadioIsOn = 0;
	Adapter->ctrl_buff[0] = 6;
        }
	Adapter->ctrl_buff[1] = 0;

	*(PUSHORT) (Adapter->ctrl_buff + 2) = 0;

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (PUCHAR) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

        if (EnableRadio == TRUE){
	dbgcond(DBG_CMDS, "setting Radio On\n");
	Adapter->LastCommand[0] = CMD_SetRadioOn;
        }else {
	dbgcond(DBG_CMDS, "setting Radio Off\n");
	Adapter->LastCommand[0] = CMD_SetRadioOff;
        }

	Adapter->flags |= GetCommandPedding;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int SetMibValue(PVNet_ADAPTER Adapter, PSET_MIB pSetMib)
{
	FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0, 0,
		     (8 + pSetMib->Size));

	Adapter->ctrl_buff[0] = CMD_SetMib;
	Adapter->ctrl_buff[1] = 0;

	*(PUSHORT) (Adapter->ctrl_buff + 2) = (USHORT) (4 + pSetMib->Size);
	memcpy((PUCHAR) (Adapter->ctrl_buff + 4), (PUCHAR) pSetMib,
	       (4 + pSetMib->Size));

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (PUCHAR) Adapter->devreq,
			 Adapter->ctrl_buff,
			 Adapter->devreq->length, ctrl_callback, Adapter);

	dbgcond(DBG_CMDS, "setting Mib value\n");
	Adapter->LastCommand[0] = CMD_SetMib;
	Adapter->flags |= GetCommandPedding;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int SetIRoaming(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	Adapter->cmdhandler = SetIRoaming;
	SetMib.Type = SetMibMACMgmt;
	SetMib.Size = 1;
	SetMib.Index = IRoaming_OFFSET;

	dbgcond(DBG_CMDS, "International Roaming : %d\n", Adapter->InternationalRoaming);
	dbgcond(DBG_CMDS, "setting International Roaming \n");
	SetMib.Data[0] =
	    (Adapter->InternationalRoaming == TRUE) ? 1 : 0;
	Adapter->LastCommand[1] = CMD_SetIRoaming;
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;

	return 0;
}


int SetPreamble(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	Adapter->cmdhandler = SetPreamble;
	SetMib.Type = SetMibLocal;
	SetMib.Size = 1;
	SetMib.Index = PreambleType_OFFSET;

	SetMib.Data[0] =
	    (Adapter->PreambleType == PREAMBLE_TYPE_SHORT) ? 1 : 0;
	Adapter->LastCommand[1] = CMD_SetPreamble;
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;

	return 0;
}

int SetFragThreshold(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	Adapter->cmdhandler = SetFragThreshold;
	SetMib.Type = SetMibMAC;
	SetMib.Size = 2;
	SetMib.Index = Fragmentation_OFFSET;
	*(PUSHORT) SetMib.Data = Adapter->FragmentationThreshold;
	Adapter->LastCommand[1] = CMD_SetFrag;
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;

	return 0;
}

int SetRTSThreshold(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	Adapter->cmdhandler = SetRTSThreshold;
	SetMib.Type = SetMibMAC;
	SetMib.Size = 2;
	SetMib.Index = RTS_OFFSET;
	*(PUSHORT) SetMib.Data = Adapter->RtsThreshold;
	Adapter->LastCommand[1] = CMD_SetRTS;
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetAutoRateFallback(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;
	Adapter->cmdhandler = SetAutoRateFallback;
	SetMib.Type = SetMibLocal;
	SetMib.Size = 1;
	SetMib.Index = TxAutoRateFallBack_OFFSET;
	SetMib.Data[0] = (Adapter->TxRate == 4) ? 1 : 0;

	Adapter->LastCommand[1] = CMD_SetARFB;
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;

	return 0;
}

//Wep functions prototypes.........
int SetWEPEncLevel(PVNet_ADAPTER Adapter);
int SetWEPkeyToUse(PVNet_ADAPTER Adapter);
int SetWEPPrivacy(PVNet_ADAPTER Adapter);
int SetWEPexcludeUnencrypted(PVNet_ADAPTER Adapter);
int SetWEPinMgmtMib(PVNet_ADAPTER Adapter);

int SetWEPvalue(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;
	char buf[2 * WEP_KEY_SIZE + 1] __attribute__ ((unused));	/* printbuffer for WEP key */

	SetMib.Type = SetMibMACWEP;

	if (Adapter->WepInfo.EncryptionLevel == WEP_64BIT)
		SetMib.Size = 5;
	else if (Adapter->WepInfo.EncryptionLevel == WEP_128BIT)
		SetMib.Size = WEP_KEY_SIZE;

	switch (Adapter->WepInfo.WepKeyToUse) {
	case 0:
		SetMib.Index = WEP_KEY_ONE_OFFSET;
		memcpy(SetMib.Data, Adapter->WepInfo.WepKey1, SetMib.Size);
		break;
	case 1:
		SetMib.Index = WEP_KEY_TWO_OFFSET;
		memcpy(SetMib.Data, Adapter->WepInfo.WepKey2, SetMib.Size);
		break;
	case 2:
		SetMib.Index = WEP_KEY_THREE_OFFSET;
		memcpy(SetMib.Data, Adapter->WepInfo.WepKey3, SetMib.Size);
		break;
	case 3:
		SetMib.Index = WEP_KEY_FOUR_OFFSET;
		memcpy(SetMib.Data, Adapter->WepInfo.WepKey4, SetMib.Size);
		break;
	}

	Adapter->cmdhandler = SetWEPEncLevel;

	Adapter->LastCommand[1] = CMD_WEP_SET;

	dbgcond(DBG_WEP | DBG_CMDS, "setting WEP key nr %d, size %d: %s\n",
		Adapter->WepInfo.WepKeyToUse, SetMib.Size,
		buf2str(buf, SetMib.Data, SetMib.Size));

	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}				/* end of SetWEPvalue */

int SetWEPEncLevel(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACWEP;
	SetMib.Size = 1;
	SetMib.Index = EncryptionLevel_OFFSET;
	SetMib.Data[0] = Adapter->WepInfo.EncryptionLevel;
	Adapter->cmdhandler = SetWEPkeyToUse;
	dbgcond(DBG_WEP | DBG_CMDS, "setting encryption level %d\n",
		Adapter->WepInfo.EncryptionLevel);
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetWEPkeyToUse(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACWEP;
	SetMib.Size = 1;
	SetMib.Index = WEPDefaultKeyID_OFFSET;
	SetMib.Data[0] = Adapter->WepInfo.WepKeyToUse;

	Adapter->cmdhandler = SetWEPPrivacy;

	dbgcond(DBG_WEP | DBG_CMDS, "setting WEP key nr %d\n",
		Adapter->WepInfo.WepKeyToUse);
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetWEPPrivacy(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACWEP;
	SetMib.Size = 1;
	SetMib.Index = PrivacyInvoked_OFFSET;
	SetMib.Data[0] = Adapter->PrivacyInvoked;
	Adapter->cmdhandler = SetWEPexcludeUnencrypted;
	dbgcond(DBG_WEP | DBG_CMDS, "PrivacyInvoked %d\n",
		Adapter->PrivacyInvoked);
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetWEPexcludeUnencrypted(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACWEP;
	SetMib.Size = 1;
	SetMib.Index = ExcludeUnencrypted_OFFSET;
	SetMib.Data[0] = Adapter->WepInfo.ExcludeUnencrypted;
	Adapter->cmdhandler = SetWEPinMgmtMib;
	dbgcond(DBG_WEP | DBG_CMDS, "ExcludeUnencrypted %d\n",
		Adapter->WepInfo.ExcludeUnencrypted);
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetWEPinMgmtMib(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACMgmt;
	SetMib.Size = 1;
	SetMib.Index = PrivacyOptionImplemented_OFFSET;
	SetMib.Data[0] = Adapter->PrivacyInvoked;

	Adapter->cmdhandler = NULL;
	dbgcond(DBG_WEP | DBG_CMDS, "PrivacyOptionImplemented %d\n",
		Adapter->PrivacyInvoked);

	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

int SetMacAddress(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	SetMib.Type = SetMibMACAdd;
	SetMib.Size = 6;
	SetMib.Index = MACAddress_OFFSET;
	Adapter->LastCommand[1] = CMD_SetMac;
	memcpy(SetMib.Data, Adapter->tmpMAC, 6);

	Adapter->cmdhandler = NULL;
	dbgcond(DBG_CMDS, "SetMacAddr to %02x:%02x:%02x:%02x:%02x:%02x\n",
		Adapter->tmpMAC[0], Adapter->tmpMAC[1], Adapter->tmpMAC[2],
		Adapter->tmpMAC[3], Adapter->tmpMAC[4],
		Adapter->tmpMAC[5]);

	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}

void UsbSelectBSS(PVNet_ADAPTER Adapter)
{
	UCHAR i, SignalStrength = 0, Selected = 0;
	char buf[ESSID_SIZE + 1] __attribute__ ((unused));

	Adapter->flags &= ~BSSIDfound;
	if (Adapter->SiteS.BSSInList == 0)
		return;

	dbgcond(DBG_SCAN | DBG_CMDS,
		"desired ssid %s, opmode %s, %d bss in list\n",
		ssid2str(buf, Adapter->DesiredSSID,
			 Adapter->DesiredSSIDsize),
		Adapter->OperatingMode ==
		INFRASTRUCTURE_MODE ? "infrastructure" : "ad-hoc",
		Adapter->SiteS.BSSInList);

	if (Adapter->DesiredSSIDsize == 0) {
	dbgcond(DBG_SCAN, "International Roaming :%d\n", Adapter->InternationalRoaming);
		// if desired ssid is any....
		for (i = 0; i < Adapter->SiteS.BSSInList; i++) {
			// find the BEST(best rssi, link quality)  and select it

            //Debug Information Start
			dbgcond(DBG_SCAN | DBG_CMDS,
				"%d. BSS: ssid %s, rssi %d, bsstype %d, %s preamble, wep %d\n",
				i, ssid2str(buf,
					    Adapter->SiteS.BssInfo[i].SSID,
					    Adapter->SiteS.BssInfo[i].
					    SSIDsize),
				Adapter->SiteS.BssInfo[i].RSSI,
				Adapter->SiteS.BssInfo[i].BSStype,
				Adapter->SiteS.BssInfo[i].PreambleType ==
				1 ? "short" : "long",
				Adapter->SiteS.BssInfo[i].UsingWEP);
            //Debug Information End

                                if ((Adapter->SiteS.BssInfo[i].RSSI > SignalStrength) && 
                                    (Adapter->SiteS.BssInfo[i].BSStype == Adapter->OperatingMode)){
                                    if(((Adapter->InternationalRoaming==1) && 
				    (Adapter->OperatingMode == INFRASTRUCTURE_MODE) && 
				    (Adapter->ChannelVector[Adapter->SiteS.BssInfo[i].Channel-1]==0))) {
					    continue;
				    } else {
				Adapter->flags |= BSSIDfound;
				Selected = i;
				SignalStrength =
				    Adapter->SiteS.BssInfo[i].RSSI;
				Adapter->Channel =
				    Adapter->SiteS.BssInfo[i].Channel;
				memcpy(Adapter->SelectedSSID,
				       Adapter->SiteS.BssInfo[i].SSID,
				       Adapter->SiteS.BssInfo[i].SSIDsize);
				Adapter->SSID_size =
				    Adapter->SiteS.BssInfo[i].SSIDsize;
				memcpy(Adapter->CurrentBSSID,
				       Adapter->SiteS.BssInfo[i].BSSID, 6);
				if (Adapter->SiteS.BssInfo[i].
				    PreambleType == 1)
					Adapter->PreambleType =
					    PREAMBLE_TYPE_SHORT;
				else
					Adapter->PreambleType =
					    PREAMBLE_TYPE_LONG;
				    }
			}
			continue;
		}
	} else {
            //Debug Information Start
		for (i = 0; i < Adapter->SiteS.BSSInList; i++) {	//check if the desired ssid exists.....
			dbgcond(DBG_SCAN | DBG_CMDS,
				"%d. BSS: ssid %s, rssi %d, bsstype %d, %s preamble, wep %d\n",
				i, ssid2str(buf,
					    Adapter->SiteS.BssInfo[i].SSID,
					    Adapter->SiteS.BssInfo[i].
					    SSIDsize),
				Adapter->SiteS.BssInfo[i].RSSI,
				Adapter->SiteS.BssInfo[i].BSStype,
				Adapter->SiteS.BssInfo[i].PreambleType ==
				1 ? "short" : "long",
				Adapter->SiteS.BssInfo[i].UsingWEP);
            //Debug Information End
            
			if (Adapter->SiteS.BssInfo[i].SSIDsize ==
			    Adapter->DesiredSSIDsize) {
				if (memcmp
				    (Adapter->SiteS.BssInfo[i].SSID,
				     Adapter->DesiredSSID,
				     Adapter->DesiredSSIDsize) == 0) {
					if (Adapter->SiteS.BssInfo[i].  BSStype != Adapter->OperatingMode){
						continue;
                                        }else{
                                           if((Adapter->InternationalRoaming==1) && 
					   (Adapter->OperatingMode == INFRASTRUCTURE_MODE) && 
					   (Adapter->ChannelVector[Adapter->SiteS.BssInfo[i].Channel-1]==0)) {
                                              continue;
                                           }
                                           else{

					// if we are here DesiredSSID found.
					Adapter->Channel =
					    Adapter->SiteS.BssInfo[i].
					    Channel;
					Adapter->SSID_size =
					    Adapter->DesiredSSIDsize;
					memcpy(Adapter->SelectedSSID,
					       Adapter->DesiredSSID,
					       Adapter->SSID_size);
					memcpy(Adapter->CurrentBSSID,
					       Adapter->SiteS.BssInfo[i].
					       BSSID, 6);
					if (Adapter->SiteS.BssInfo[i].
					    PreambleType == 1)
						Adapter->PreambleType =
						    PREAMBLE_TYPE_SHORT;
					else
						Adapter->PreambleType =
						    PREAMBLE_TYPE_LONG;
					Adapter->flags |= BSSIDfound;
					break;
                                           }
                                        }
				}
                }
		}
	}
	dbgcond(DBG_SCAN | DBG_CMDS,
		"SelectedBSSId : BSSID %02x:%02x:%02x:%02x:%02x:%02x,"
		" ssid %s\n",
		Adapter->CurrentBSSID[0], Adapter->CurrentBSSID[1],
		Adapter->CurrentBSSID[2], Adapter->CurrentBSSID[3],
		Adapter->CurrentBSSID[4], Adapter->CurrentBSSID[5],
		ssid2str(buf, Adapter->SelectedSSID, Adapter->SSID_size));
}

void DFUCallbacks(purb_t purb);

int GetDFUState(PVNet_ADAPTER Adapter)
{
	FILL_REQUEST(Adapter, 0x05, CLASS_REQUEST_IN, 0, 0, 1);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 &Adapter->pDfu->State,
			 Adapter->devreq->length, DFUCallbacks, Adapter);

	Adapter->LastCommand[0] = CMD_DFUState;
	Adapter->pDfu->ReSendState = 0;
	Adapter->cmdhandler = GetDFUState;
	dbgcond(DBG_FW_DL, "getting the DFU state\n");
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int GetDFUStatus(PVNet_ADAPTER Adapter)
{
	FILL_REQUEST(Adapter, 0x03, CLASS_REQUEST_IN, 0, 0, 6);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_rcvctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->pDfu->StatusBuf,
			 Adapter->devreq->length, DFUCallbacks, Adapter);

	Adapter->LastCommand[0] = CMD_DFUStatus;
	dbgcond(DBG_FW_DL, "getting the DFU status\n");
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int DownLoadInternal(PVNet_ADAPTER Adapter)
{
	USHORT size = Adapter->pDfu->InternalFWSizeLeft;

	if (size > 1024)
		size = 1024;

	dbgcond(DBG_FW_DL, "dwld. internal fw: size %d "
		"left %d block nr %d\n",
		size, Adapter->pDfu->InternalFWSizeLeft,
		Adapter->pDfu->BlockCnt);

	FILL_REQUEST(Adapter, 0x01, CLASS_REQUEST_OUT,
		     Adapter->pDfu->BlockCnt, 0, size);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->pDfu->InternalRom +
			 (1024 * Adapter->pDfu->BlockCnt),
			 Adapter->devreq->length, DFUCallbacks, Adapter);
        
	Adapter->LastCommand[0] = CMD_FWInternal;
	Adapter->cmdhandler = DownLoadInternal;

	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	if (!size) {
		Adapter->pDfu->BlockCnt = 0;
		return 0;
	}
	Adapter->pDfu->InternalFWSizeLeft -= size;
	Adapter->pDfu->BlockCnt++;
	return 0;
}

int DownLoadExternal(PVNet_ADAPTER Adapter)
{
	USHORT size = Adapter->pDfu->ExternalFWSizeLeft;

	if (size > 1024)
		size = 1024;

	dbgcond(DBG_FW_DL, "dwld. external fw: size %d "
		"left %d block nr %d\n",
		size, Adapter->pDfu->ExternalFWSizeLeft,
		Adapter->pDfu->BlockCnt);

	if (!Adapter->pDfu->ExternalRom) {
		err("no external rom");
		return -1;
	}
	FILL_REQUEST(Adapter, 0x0E, DEVICE_VENDOR_REQUEST_OUT, 0x0802,
		     Adapter->pDfu->BlockCnt, size);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 Adapter->pDfu->ExternalRom +
			 (1024 * Adapter->pDfu->BlockCnt),
			 Adapter->devreq->length, DFUCallbacks, Adapter);

	Adapter->LastCommand[0] = CMD_FWExternal;
	Adapter->cmdhandler = DownLoadExternal;
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);

	if (!size) {
		Adapter->pDfu->BlockCnt = 0;
		return 0;
	}
	Adapter->pDfu->ExternalFWSizeLeft -= size;
	Adapter->pDfu->BlockCnt++;
	return 0;
}

int Remap(PVNet_ADAPTER Adapter)
{
	FILL_REQUEST(Adapter, 0x0A, INTERFACE_VENDOR_REQUEST_OUT, 0, 0, 0);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 NULL, 0, DFUCallbacks, Adapter);

	Adapter->LastCommand[0] = CMD_REMAP;
	dbgcond(DBG_CMDS | DBG_FW_DL, "remap\n");
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

int DFUdetach(PVNet_ADAPTER Adapter)
{
	FILL_REQUEST(Adapter, 0, INTERFACE_VENDOR_REQUEST_OUT, 1000, 0, 0);

	FILL_CONTROL_URB(Adapter->ctrl_urb,
			 Adapter->usb,
			 usb_sndctrlpipe(Adapter->usb, 0),
			 (char *) Adapter->devreq,
			 NULL, 0, DFUCallbacks, Adapter);

	Adapter->LastCommand[0] = CMD_DFUdetach;
	dbgcond(DBG_CMDS | DBG_FW_DL, "DFU detach\n");
	SendCtrlUrb(Adapter, Adapter->ctrl_urb);
	return 0;
}

void GetNewBSS(PVNet_ADAPTER Adapter)
{
	Adapter->LastCommand[1] = CMD_NewBSS;
	dbgcond(DBG_CMDS, "getting new BSS\n");
	GetMIBvalue(Adapter, GetMibMACMgmt, 1);
}

void GetChannelList(PVNet_ADAPTER Adapter)
{
            Adapter->LastCommand[1] = CMD_GetChannelList;
            dbgcond(DBG_CMDS, "getting Channel List \n");
            GetMIBvalue(Adapter, GetMibMDOMAIN, sizeof(MDOMAIN_MIB));
}


void GetOperationalRates(PVNet_ADAPTER Adapter)
{
	Adapter->LastCommand[1] = CMD_GetOpRates;
	dbgcond(DBG_CMDS, "getting operational rates\n");
	GetMIBvalue(Adapter, GetMibPHY, sizeof(PHY_MIB));
}

int SetMIB_NewBSSID_OK(PVNet_ADAPTER Adapter)
{
	SET_MIB SetMib;

	Adapter->LastCommand[1] = CMD_SetNewBSS_OK;

	SetMib.Type = SetMibMACMgmt;
	SetMib.Size = 1;
	SetMib.Index = IBSSChange_OK_OFFSET;
	/*
	 * We have to clear this flag to indicate that we got the IBSS change
	 */
	SetMib.Data[0] = 0;
	Adapter->cmdhandler = NULL;
	dbgcond(DBG_CMDS, "setting new BSSID to OK\n");
	if (SetMibValue(Adapter, &SetMib) != 0)
		return -1;
	return 0;
}
