/* $Id: vnetusba.h,v 1.7 2002/12/18 20:37:18 smarkou Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#ifndef __vnetusba_h_OK__
#define __vnetusba_h_OK__
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/netdevice.h>
#include <linux/wireless.h>
#include <linux/etherdevice.h>
#include <linux/usb.h>
#include <asm/uaccess.h>
#include "general.h"
#include "appint.h"
#include <linux/version.h>

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#endif

/* Kernel 2.4.20 Changes */
#if LINUX_VERSION_CODE > 132115
typedef struct devrequest {
    u8  requesttype;
    u8  request;
    u16  value;
    u16  index;
    u16 length;
} devrequest;

typedef struct urb *purb_t;
#endif

/* the version of this driver */
#define VERSION_STRING "1.0.1"

/* when we got so many pending tx packets in TxList we stop the netdev queue */
#define THRE_STOP_NET_TX 20

/* and restart it below this value */
#define THRE_START_NET_TX 5

#define VNetVID				0x03EB

#define VNetPID_RFMD		0x7605
#define VNetPID_R505    	0x7606

#define	VNET_TX_TIMEOUT		(HZ*10)

// version.....
#define USB_VNET_MAJOR_VERSION  2
#define USB_VNET_MINOR_VERSION  1
#define USB_VNET_SUB_VERSION	2
#define USB_VNET_BUILD	        1


#define RFMD_Board		1
#define R505_Board    	        4

#define VNET_MAX_WIRELESS_PACKET 1536

#define ACTIVE_MODE				0
#define PS_MODE					1
#define	ALIGN(x)				x __attribute__((aligned(L1_CACHE_BYTES)))

// various flags
#define RX_BUSY					0x00000002	// receiver working
#define TX_SLEEP				0x00000004	// bulk out endpoint in use
#define STOPPED_RX				0x00000008	// used to stop Rx path....

//functionallity controls
#define	CTRL_URB_SLEEP			0x00000010	// ctrl endpoint in use
#define VNET_RUNNING			0x00000020	// driver up and running
#define NEED_CLEAR_HALT			0x00000040	// in case of usb_st_stall
#define INIT_PENDING			0x00000080	// flag for initialization
#define TX_STOPPED				0x00000100	// flag for tx queue status(system's queue)
#define INTERNAL_FW_DNLD		0x00000200	// internal f/w downloading (DFU)
#define USB_RESET_DEVICE     	0x00000400	// RESET NEEDED..
#define IOCTL_SLEEPING			0x00000800	// Ioctl Pending....
#define ChangePending			0x00001000
#define GetCommandPedding		0x00002000
// mgmt status
#define HeardBeacons			0x00004000	// check for out of range....
#define StationIsAuthenticated	0x00008000	// check if the station is authenticated                                                                                // (needed in Association Responce)
#define StationWasAssociated	0x00010000	// check if the station was associated
#define BSSIDfound				0x00020000	// in selectBSS flag for BSSID state
#define StationIsAssociated		0x00040000

#define SITE_SURVEY_REQUEST		0x00080000
// wep status
#define WepIsSet				0x00100000
//SetPreamble Status, Fragmentation, Rts/Cts
#define	PreambleChanged			0x00200000
#define FragChanged			0x00400000
#define RtsCtsChanged			0x00800000
#define AutoRFChanged			0x01000000

#define TimerReScheduled		0x02000000
#define WAKE_UP_WITH_ERROR		0x04000000

#define FIRST_SCAN_DONE			0x08000000
#define RadioOnOffChanged		0x10000000


// WEP key values
#define	WEP_DISABLED			0
#define	WEP_64BIT				1
#define	WEP_128BIT				2

#define WEP_MODE_OPTIONAL		0
#define WEP_MODE_MANDATORY		1

// Privacy
#define C80211_MGMT_AAN_OPENSYSTEM		0x0000
#define C80211_MGMT_AAN_SHAREDKEY		0x0001

#define	AD_HOC_MODE						1
#define	INFRASTRUCTURE_MODE				2


#define PREAMBLE_TYPE_SHORT				0
#define	PREAMBLE_TYPE_LONG				1

//Regulatory Domains
#define REG_DOMAIN_FCC          0x10    //Channels      1-11    USA
#define REG_DOMAIN_DOC          0x20    //Channel       1-11    Canada
#define REG_DOMAIN_ETSI         0x30    //Channel       1-13    Europe (ex Spain/France)
#define REG_DOMAIN_SPAIN        0x31    //Channel       10-11   Spain
#define REG_DOMAIN_FRANCE       0x32    //Channel       10-13   France
#define REG_DOMAIN_MKK          0x40    //Channel       14              Japan
#define REG_DOMAIN_MKK1         0x41    //Channel       1-14    Japan(MKK1)
#define REG_DOMAIN_ISRAEL       0x50    //Channel       3-9     ISRAEL

///////////////////////
// StationState defines
///////////////////////
#define STATION_STATE_INITIALIZING              0x00
#define STATION_STATE_SCANNING					0x01
#define STATION_STATE_JOINING 					0x02
#define STATION_STATE_AUTHENTICATING			0x03
#define STATION_STATE_ASSOCIATING				0x04
#define STATION_STATE_READY                     0x05
#define STATION_STATE_OUT_OF_RANGE				0x06
#define STATION_STATE_DISASSOCIATING			0x07
#define STATION_STATE_DEAUTHENTICATING			0x08
#define STATION_STATE_REASSOCIATING				0x09
#define STATION_STATE_RECONFIGURING				0x0A
#define STATION_STATE_FW_DOWNLOAD				0x0B
#define STATION_STATE_IDLE						0x0C

#define STATION_STATE_RESET						0x0F
#define STATION_STATE_EXITING					0x10
#define STATION_STATE_RADIO_OFF						0x13

#define STATION_STATE_MGMT_ERROR				0xf1
#define STATION_STATE_INIT_FAILED				0xf2	// if initialization failed
	// and a function sleeps(vnet_probe) when it wakes up it has to know what happened
/////////////////////////
// Device Operating Modes
/////////////////////////
#define DeviceNetCardMode					1
#define DeviceConfigurationMode				2
#define DeviceDFUMode						3
#define DeviceNOFlashNetCardMode			4

//#define UNDER_CONSTRUCTION    0x01
//#define TX_DATA                               0x02
//#define TX_MGMT                               0x04
#define UNDER_SUBMIT		0x08

//Setup Packet used in Ctrl urb's filler....

#define FILL_REQUEST(a,aa,ab,ac,ad,ae)\
  do {\
      (a)->devreq->request = aa;\
      (a)->devreq->requesttype = ab;\
      (a)->devreq->value = cpu_to_le16(ac);\
      (a)->devreq->index = cpu_to_le16(ad);\
      (a)->devreq->length = cpu_to_le16(ae);\
  }while(0)


typedef struct __DFU {
	PUCHAR ExternalRom;
	PUCHAR InternalRom;
	USHORT BlockCnt;
	UCHAR State;
	UCHAR StatusBuf[6];
	ULONG TimeOut;
	UCHAR ReSendState;
	USHORT ExternalFWSizeLeft;
	USHORT InternalFWSizeLeft;
} DFU, *PDFU;

typedef struct __RX_BUFFER {
	USHORT WLength;
	UCHAR RxRate;
	UCHAR newbss;
	UCHAR Fragmentation;
	UCHAR RSSI;
	UCHAR LinkQuality;
	UCHAR NoiseLevel;
	UCHAR RxTime[4];
	UCHAR WirelessPacket[VNET_MAX_WIRELESS_PACKET];
} RX_BUFFER, *PRX_BUFFER;

typedef struct __VNET_ADAPTER {
	struct usb_device *usb;
	struct usb_config_descriptor *config;

	struct net_device *net;
	struct net_device_stats *netstats;
#ifdef WIRELESS_EXT
	struct iw_statistics *w_stats;
#endif

	struct list_head *TxList;
	struct list_head *freeTx;
	struct timer_list *CtrlTimer;

 
	devrequest *devreq;

	wait_queue_head_t *ctrl_wait;
	wait_queue_head_t *remove_wait;
	UCHAR BulkInAddr;
	purb_t ctrl_urb, rx_urb, tx_urb;

	spinlock_t *lock;

	unsigned long flags;

	RX_BUFFER RxInBuff;
	RX_BUFFER RxBuffUp;

	UCHAR ctrl_buff[200];

	UCHAR BoardType;
	UCHAR TxPacketsPending;
// Device Specific
	// Addresses
	UCHAR StationAddress[6];
	UCHAR tmpMAC[6];
	UCHAR CurrentAddress[6];
	UCHAR CurrentBSSID[6];
	// AP's Info
	UCHAR DesiredSSID[ESSID_SIZE];
	UCHAR SelectedSSID[ESSID_SIZE];
	UCHAR DesiredSSIDsize;
	UCHAR SSID_size;
	UCHAR Channel;
	// CardInfo
	UCHAR DevMode;		//Parallel, ....
	UCHAR PreambleType;
	UCHAR TxRate;
	UCHAR PowerMgmtMode;
	UCHAR InternationalRoaming;
	UCHAR RadioIsOn;
	UCHAR OperatingMode;
	UCHAR FwVersion[4];
	UCHAR Rssi;
	UCHAR LinkQuality;
	UCHAR StationState;
	UCHAR PrivacyInvoked;
        UCHAR IsInternationalScanEnabled;
        UCHAR ChannelVector[14];
	USHORT RtsThreshold;
	USHORT FragmentationThreshold;

	WEP_INFO WepInfo;
	// General Info
	UCHAR RegDomain;
	//driver info
	UCHAR CmdStatus[40];
	UCHAR LastCommand[2];
	UCHAR BeaconPeriod;
	UCHAR CallbacksPending;
	STATISTICS Stats;

	SITE_SURVEY_INFO SiteS;

	UCHAR ErrorCode;
	//Mgmt Info
	UCHAR ExpectedAuthentTransactionSeqNum;
	UCHAR AuthenticationRequestRetries;
	UCHAR CurrentAuthentTransactionSeqNum;
	UCHAR AssociationRequestRetries;
	UCHAR ReAssociationRequestRetries;
	UCHAR OperationalRates[4];

	int (*cmdhandler) (struct __VNET_ADAPTER * Adapter);
	PDFU pDfu;
	ULONG CrcTable[256];
	ULONG dbg_mask;		/* mask to control debug msgs, see DBG_* below */
} VNet_ADAPTER, *PVNet_ADAPTER;

typedef struct __TX_BUFFER {
	USHORT WLength;
	UCHAR TxRate;
	UCHAR PaddingBytes;
	UCHAR Reserved[4];
	UCHAR WirelessPacket[1534];
} TX_BUFFER, *PTX_BUFFER;

typedef struct __TxList {
	struct list_head tx_list;
	struct sk_buff *skb;
	PVNet_ADAPTER Adapter;
	PTX_BUFFER tx_buff;
	USHORT length;
	UCHAR status;
} TX_LIST, *PTX_LIST;


#ifdef USBDBG
//# define dbgusb(format, arg...) printk(KERN_INFO format, ## arg);

/* some flags to control dbgcond */
#define DBG_STATE             0x00000001	/* show state changes */
#define DBG_IOCTL             0x00000002	/* show ioctl calls */
#define DBG_FW_DL             0x00000004	/* firmware download */
#define DBG_INIT              0x00000008	/* initialization */
#define DBG_SCAN              0x00000010	/* scanning (I)BSS */
#define DBG_CTRL_CB           0x00000020	/* ctrl_callback */
#define DBG_CMD_CB            0x00000040	/* GetCmd_callback */
#define DBG_RX_CB             0x00000080	/* RxCallback */
#define DBG_DFU_CB            0x00000100	/* DFU callback */
#define DBG_CRC_CHECK         0x00000200	/* CRC check in RxCallback */
#define DBG_CTRL_URB          0x00000400	/* SendCtrlUrb */
#define DBG_CMDS              0x00000800	/* debug all commands to adapter */
#define DBG_JOIN              0x00001000	/* Join request and answer */
#define DBG_START_IBSS        0x00002000	/* debug only the START_IBSS cmds */
#define DBG_WEP               0x00004000	/* debug WEP keys */
#define DBG_BEACON            0x00008000	/* debug all incoming beacon msgs - many ! */
#define DBG_AUTH              0x00010000	/* debug AUTH msgs */
#define DBG_TXDATA            0x00020000	/* debug first bytes of wireless tx data - for every packet ! */
#define DBG_TX                0x00040000	/* debug other TX stuff, e.g. en/dequeueing */
#define DBG_SCHEDULE          0x00080000	/* debug scheduling */
#define DBG_ASSOC             0x00100000	/* debug association */
#define DBG_DISASS            0x00200000	/* debug disassociation */
#define DBG_CONFIG            0x00400000	/* debug configuration */
#define DBG_RXDATA            0x00800000	/* debug rx data packets - every packet ! */
#define DBG_TX_CB             0x01000000	/* debug the TxOk callback */

# define dbgcond(flag, format, arg...) \
  do {\
    if ((flag) & Adapter->dbg_mask) \
      printk(KERN_INFO format, ## arg);\
  } while (0)

# ifdef INSANEDBG
#define dbgusbnl(format, arg...) {\
	printk(KERN_INFO format "\n" , ## arg);\
	udelay(1000);udelay(1000);udelay(1000);}
# else
#  define dbgusbnl(format, arg...) printk(KERN_INFO format "\n" , ## arg);
# endif

#else
# define dbgcond(flag, format, arg...)
# define dbgusb(format, arg...) {}
# define dbgusbnl(format, arg...) {}
#endif

#include "stdinclude.h"
#endif				//__vnetusba_h_OK__
