/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <netdb.h>		/* gethostbyname, getnetbyname */
#include <linux/if_arp.h>	/* For ARPHRD_ETHER */
#include <linux/socket.h>	/* For AF_INET & struct sockaddr */
#include <linux/wireless.h>
#include <forms.h>
#include "vnetioctl.h"


#define MAX_SSID_LENGTH				32
#define SHORT_WEP_KEY_SIZE			5
#define LONG_WEP_KEY_SIZE			13
#define MAX_BSS_ENTRIES				12

#define BSS_TYPE_AD_HOC				1
#define BSS_TYPE_INFRASTRUCTURE		2

#define WEP_DISABLED				0
#define WEP_64bit					1
#define WEP_128bit					2

#define MAJORAPPVERSION				4
#define MINORAPPVERSION				0
#define APPBUILD				0

#define FALSE					0
#define TRUE					1
#define MAX_VNET_CARDS				8

typedef unsigned char 	UCHAR;
typedef unsigned short 	USHORT;
typedef unsigned long 	ULONG;
typedef unsigned int 	UINT;

typedef unsigned char* 	PUCHAR;
typedef unsigned short*	PUSHORT;
typedef int	 	BOOLEAN;
typedef void	VOID;

typedef struct __BSS_INFO{
	UCHAR		Channel;
	UCHAR		SSID[MAX_SSID_LENGTH];
	UCHAR		SSIDsize;
	UCHAR		BSSID[6];
	UCHAR		RSSI;
	UCHAR		UsingWEP;
	UCHAR		PreambleType;
	USHORT  	BeaconPeriod;
	UCHAR		BSStype;
}BSS_INFO;

typedef struct __WEP_INFO{
	UCHAR		WepKeyToUse;
	UCHAR		WepMode;
	USHORT		AuthenticationType;
	UCHAR		EncryptionLevel;	//0:Disabled,1:64bit,2:128 bit
	UCHAR		WepKey1[LONG_WEP_KEY_SIZE];
	UCHAR		WepKey2[LONG_WEP_KEY_SIZE];
	UCHAR		WepKey3[LONG_WEP_KEY_SIZE];
	UCHAR		WepKey4[LONG_WEP_KEY_SIZE];
} WEP_INFO, *PWEP_INFO;

typedef struct _CON_WEP_INFO{
	UCHAR		WepHex[4][LONG_WEP_KEY_SIZE];
	char		Wep_Ascii[4][28];
	char 		WepKeyLength;
	char 		EncryptionLevel;
	char		WepToUse;
	char		WepMode;
	char		AuthType;
}CON_WEP_INFO;

typedef struct __VERSION_INFO{
	UCHAR		DriverMajorVersion;
	UCHAR		DriverMinorVersion;
	UCHAR		DriverSubVersion;
	USHORT		DriverBuild;

	USHORT		FwMajorVersion;
	USHORT		FwMinorVersion;
	USHORT		FwSubVersion;
	USHORT		FwBuild;
}VERSION_INFO, *PVERSION_INFO;

typedef struct _SUPPORT_INFO{
	char 		essid[32];
	char		newc[32];
	char 		DriverState[200];
	char  		MAC[20];
	char  		SValue[8]; //used for signal strength value %
	char 		LValue[8]; //used for link quality
	char  		DTxSucc[8];
	char  		DRxSucc[8];
	char  		DTxUnS[8];
	char  		DRxUnS[8];	
	int 		Channel;
	int			OpMode;
	int			PowerMgmtMode;
	int			InternationalRoaming;
	int			RadioIsOn;
        char                    RegDomain;
        char                    ChannelVector[14];
        unsigned long   MgmtErrorCode;
}SUPPORT_INFO, *PSUPPORT_INFO;

typedef struct _STATISTICS{
	ULONG	TxDataPacketsOk;
	ULONG	TxDataPacketsError;
	ULONG	TxMgmtPacketsOk;
	ULONG	TxMgmtPacketsError;

	ULONG	RxDataPacketsOk;
	ULONG	RxDataPacketsError;
	ULONG	RxMgmtPacketsOk;
	ULONG	RxMgmtPacketsError;

	ULONG	RxLost;
	ULONG	TxPacketsRejectedNotReady;
	ULONG	TxPacketsRejectedResources;
	ULONG	MatchingBeacons;
}STATISTICS;

typedef struct __STATINFO{
	char	DTxSucc[10];
	char	DRxSucc[10];
	char	DTxUnS[10];
	char	DRxUnS[10];
	
	char	MTxSucc[10];
	char	MRxSucc[10];
	char	MTxUnS[10];
	char	MRxUnS[10];

	char  	RejTx[10];
	char  	RejRx[10];
}STATINFO, *PSTATINFO;

typedef struct __DEVICE_CONFIGURATION{
	UCHAR			OperatingMode;					//AD_HOC_MODE or INFRASTRUCTURE_MODE
	UCHAR			Channel;
	UCHAR			SSID[MAX_SSID_LENGTH];
	UCHAR			SSIDlength;
	UCHAR			TxRate;							//0-4
	
	UCHAR			PowerMgmtMode;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			InternationalRoaming;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			RadioIsOn;					// Radio

	UCHAR			PreambleType;					// LONG_PREAMBLE or SHORT_PREAMBLE	
	USHORT			FragmentationThreshold;	
	USHORT			RtsCtsThreshold;
	UCHAR			BSSID[6];
	UCHAR			StationState;
	UCHAR			Rssi;
	UCHAR			LinkQuality;
        UCHAR                   RegDomain;
        UCHAR                   ChannelVector[14];
	ULONG			MgmtErrorCode;			
}DEVICE_CONFIGURATION, *PDEVICE_CONFIGURATION;

#define CARD_TYPE_PCMCIA		0
#define CARD_TYPE_PCMCIA_RFMD	 	1
#define CARD_TYPE_USB			2
#define CARD_TYPE_USB_RFMD		3
#define CARD_TYPE_PCMCIA_REVD 		4
#define CARD_TYPE_PCMCIA_REVE 		5
#define CARD_TYPE_PCMCIA_504 		6
#define CARD_TYPE_PCMCIA_PCI 		7
#define CARD_TYPE_USB_505               8

typedef struct {
	char 					name[10];
	DEVICE_CONFIGURATION	DevInfo;
	SUPPORT_INFO			SupInfo;
	CON_WEP_INFO			ConWepInfo;
	UCHAR					OpM;
	int						ErrorStatus;
	UCHAR					CardType;//USB(RFMD or NOT), PCMCIA
	UCHAR					MacAddress[6];
}CARD_INFO, *PCARD_INFO;

#include "xvnet_tabs.h"

typedef struct __OPEN_CARDS {
	char				Error[5];
	FD_errorform	 	* fd_errorform;
	FD_alertform	 	* fd_alertform;
	FD_alertform	  	* fd_warningform;
	FD_mainform 	 	* fd_mainform;
	FD_monitorform  	* fd_monitorform;
	FD_statisticsform 	* fd_statisticsform;
	FD_sitesurveyform 	* fd_sitesurveyform;
	FD_encryptionform 	* fd_encryptionform;
	FD_advancedform 	* fd_advancedform;
	FD_versionform	 	* fd_versionform;
	char				Active;
	char				NumOfCards;
	char				fd[8];
	char				Caller;
	PCARD_INFO			pCardInfo[8];
}OPEN_CARDS, *POPEN_CARDS;

typedef struct {
	char		callback_value;
	POPEN_CARDS	pOpenCards;	
}CALLBACK_DATA;
#define SITE_SURVEY_IDLE		0
#define SITE_SURVEY_IN_PROGRESS	1
#define SITE_SURVEY_COMPLETED	2

#include "stdinlude.h"
