/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "xvnet.h"

void DisplayErrorMsg(POPEN_CARDS pOpenCards)
{
	switch(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState)
	{
		case 1: 	//C80211_MGMT_SC_Unspecified:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Unspecified error in Management Frame...");
			break;
		case 10:	//C80211_MGMT_SC_SupportCapabilities:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Support Capabilities error in Association Request...");
			break;
		case 11:	//C80211_MGMT_SC_ReassDenied:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Re-Association Denied");
			break;
	        case 12:	//C80211_MGMT_SC_AssDenied:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Association Denied");
			break;
		case 13:	//C80211_MGMT_SC_AuthAlgNotSupported:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Authentication Algorithm not supported...");
			break;
		case 14:	//C80211_MGMT_SC_AuthTransSeqNumError:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Bad Authentication transaction sequence number...");
			break;
		case 15:	//C80211_MGMT_SC_AuthRejectChallenge:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Authentication challenge text rejection...");
			break;
		case 16:	//C80211_MGMT_SC_AuthRejectTimeout:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Authentication Timeout...");
			break;
		case 17:	//C80211_MGMT_SC_AssDeniedHandleAP:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Access Point can not handle any more stations...");
			break;
		case 18:	//C80211_MGMT_SC_AssDeniedBSSRate:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Association Denied (Supported Rates mismatch)...");
			break;
		default:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Failed to co-operate with the selected Access Point");
	}
}

void DisplayDriverState(POPEN_CARDS pOpenCards)
{
//	if ((pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState==0x05)&&
//		(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode==1))
//	{
//		sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Associated");
//		return;
//	}
		
	switch(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState)
	{
		case 0x00:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Initializing");
			break;
		case 0x01:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Scanning");
			break;
		case 0x02:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Joining");	
			break;
		case 0x03:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Authenticating");
			break;
		case 0x04:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Associating");
			break;
		case 0x05:
			if ( pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode==1)
			{
				sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Associated");
				break;
			}
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Ready");
			break;
		case 0x06:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Station Out of Range");
			break;
		case 0x07:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Disassociating");
			break;
		case 0x08:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Disauthenticating");
			break;
		case 0x09:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Reassociating");
			break;
		case 0x0a:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Forced Joining");
			break;
		case 0x0b:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"ReConfiguring");
			break;
		case 0x0c:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"FW_Upgrade");
			break;
		case 0x0d:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Force Joining Failure");
			break;
		case 0x0e:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Resetting");
			break;
		case 0x0f:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Reset Pending");
			break;
		case 0x13:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Radio OFF");
			break;
		case 0xf0:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"No card Present");
			break;
		case 0xf1:
                        if(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.MgmtErrorCode == 0xa0){
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Enable Encryption to Join this BSS");
                        }else if(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.MgmtErrorCode == 0xa1){
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Disable Encryption to Join this BSS");
                        }else{
			DisplayErrorMsg(pOpenCards);
                        }
			break;
		default:
			sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,"Not Known yet......");
			break;			
	}
}


void Get_Wep(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	WEP_INFO WepInfo;
	int i;
	
	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer=(caddr_t)&WepInfo;
	wrq.u.data.length=0;
	wrq.u.data.flags=GET_WEP_INFO;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepToUse 	= WepInfo.WepKeyToUse;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepMode 	= WepInfo.WepMode;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.AuthType 	= WepInfo.AuthenticationType;
	pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel = WepInfo.EncryptionLevel;

	switch(WepInfo.EncryptionLevel)
	{
		case 0:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 0;
			break;
		case 1:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 5;
			break;
		case 2:
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepKeyLength = 13;	
			break;
	}
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[0],
		WepInfo.WepKey1, LONG_WEP_KEY_SIZE);
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[1],
		WepInfo.WepKey2, LONG_WEP_KEY_SIZE);
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[2],
		WepInfo.WepKey3, LONG_WEP_KEY_SIZE);
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepHex[3],
		WepInfo.WepKey4, LONG_WEP_KEY_SIZE);
	sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[0],
			"%02X%02X%02X%02X%02X", WepInfo.WepKey1[0], WepInfo.WepKey1[1],
				WepInfo.WepKey1[2], WepInfo.WepKey1[3], WepInfo.WepKey1[4]);
	sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[1],
			"%02X%02X%02X%02X%02X", WepInfo.WepKey2[0], WepInfo.WepKey2[1],
				WepInfo.WepKey2[2], WepInfo.WepKey2[3], WepInfo.WepKey2[4]);
	sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[2],
			"%02X%02X%02X%02X%02X", WepInfo.WepKey3[0], WepInfo.WepKey3[1],
				WepInfo.WepKey3[2], WepInfo.WepKey3[3], WepInfo.WepKey3[4]);
	sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[3],
			"%02X%02X%02X%02X%02X", WepInfo.WepKey4[0], WepInfo.WepKey4[1],
				WepInfo.WepKey4[2], WepInfo.WepKey4[3], WepInfo.WepKey4[4]);

}

void Get_Vnet_Stats(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	
	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer = (caddr_t)&pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_SUPPORT_INFO;
	if (ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq)!=0)
	{
		fl_suspend_timer(pOpenCards->fd_mainform->timer);
		fl_deactivate_form(pOpenCards->fd_mainform->mainform);
		fl_set_object_label(pOpenCards->fd_alertform->message, "Possible card removal...");
#if defined(SMARTBRIDGES)||defined(SMARTBRIDGES_T)
		fl_show_form(pOpenCards->fd_alertform->alertform,FL_PLACE_CENTERFREE,FL_FULLBORDER,
				"SmartBridges Wireless LAN Monitor Utility");
#elif defined(ATMEL)
		fl_show_form(pOpenCards->fd_alertform->alertform,FL_PLACE_CENTERFREE,FL_FULLBORDER,
				"ATMEL Wireless LAN Monitor Utility");
#endif	
	}
}
		
void Set_Vnet_Stats(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer = (caddr_t)&pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo;
	wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);
	wrq.u.data.flags = SET_SUPPORT_INFO;
	if ( ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq)<0 )
		exit(0);
}
void Get_Ver(PVERSION_INFO pVerInfo, POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	
	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
	
	wrq.u.data.pointer = (caddr_t)pVerInfo;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_VERSION_INFO;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
}

void ConvertInfo(POPEN_CARDS pOpenCards)
{
        
        int i;
    
	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.MgmtErrorCode = 
	       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.MgmtErrorCode;
	memset(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.essid, 0 , MAX_SSID_LENGTH);
	memcpy(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.essid, pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSID, 
		pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.SSIDlength);
	
        for(i=0; i<14;i++){
	    pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.ChannelVector[i] = 0 ;
        }

	DisplayDriverState(pOpenCards);
	
	if ( pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState == 0x05 ){
		sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState, "%s-BSSID:", 
				pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState);
		sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState, "%s %02X:%02X:%02X:%02X:%02X:%02X", 
				pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState,  
				pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[0],
			       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[1],
			      	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[2], 
				pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[3], 
				pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[4], 
				pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.BSSID[5]);
	}
        
	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.PowerMgmtMode = 
	       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode;
	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.InternationalRoaming = 
	       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.InternationalRoaming;
        if(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.InternationalRoaming){ 
            for(i=0; i<14;i++){
                pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.ChannelVector[i] = pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.ChannelVector[i] ;
            }
        }
	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.RegDomain = 
	       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RegDomain;
	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.Channel = DomainIndex (pOpenCards);

	pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.RadioIsOn = 
	       	pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RadioIsOn;
	
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RadioIsOn){
	if ((pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.StationState == 0x05) && (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode==1)){
            if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Rssi > 40 ){
                    pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Rssi=40;
                    sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.SValue, "100 %%");
            }else{
                    sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.SValue, "%.0f %%", 
                                    pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Rssi*2.5);
            }
            
            if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.LinkQuality > 40 ){
                    pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.LinkQuality = 40;
                    sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.LValue, "100 %%");
            }else{
                    sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.LValue, "%.0f %%", 
                            pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.LinkQuality*2.5);		
            }
        }
	}
}
void Get_MAC(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	int res;
	UCHAR buf[6];
	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
	wrq.u.data.pointer = (caddr_t)buf;
	wrq.u.data.length = 0;
	wrq.u.data.flags = GET_MAC_ADDRESS;
	res = ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	sprintf(pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.MAC, "%02X:%02X:%02X:%02X:%02X:%02X", 
			buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
}

void Get_Stats(PSTATINFO pStatInfo, POPEN_CARDS pOpenCards)
{
 	struct iwreq wrq;
 	STATISTICS Stats;
 	 	
 	strcpy(wrq.ifr_name, pOpenCards->pCardInfo[pOpenCards->Active]->name);
 	wrq.u.data.length = 0;
 	wrq.u.data.flags = GET_STATISTICS;
 	wrq.u.data.pointer = (caddr_t)&Stats;
 	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
 	
 	sprintf(pStatInfo->DTxSucc, "%d", Stats.TxDataPacketsOk);
 	sprintf(pStatInfo->DRxSucc, "%d", Stats.RxDataPacketsOk);
 	sprintf(pStatInfo->DTxUnS, "%d", Stats.TxDataPacketsError);
	sprintf(pStatInfo->DRxUnS, "%d", Stats.RxDataPacketsError);
	
 	sprintf(pStatInfo->MTxSucc, "%d", Stats.TxMgmtPacketsOk);
 	sprintf(pStatInfo->MRxSucc, "%d", Stats.RxMgmtPacketsOk);
 	sprintf(pStatInfo->MTxUnS, "%d", Stats.TxMgmtPacketsError);
	sprintf(pStatInfo->MRxUnS, "%d", Stats.RxMgmtPacketsError);
	
	sprintf(pStatInfo->RejTx, "%d", Stats.TxPacketsRejectedNotReady);
	sprintf(pStatInfo->RejRx, "%d", Stats.RxLost);
}

void SiteSurveyBrowser(POPEN_CARDS pOpenCards)
{
	struct iwreq wrq;
	BSS_INFO Ap[MAX_BSS_ENTRIES];
	UCHAR	State;
	char  tmp[80];
	char *Browser_String = malloc(61);
	int ApSFound, i, j,k;
		
	strcpy(wrq.ifr_name,pOpenCards->pCardInfo[pOpenCards->Active]->name);
 	fl_set_timer(pOpenCards->fd_sitesurveyform->Timer, 1);
    	fl_clear_browser(pOpenCards->fd_sitesurveyform->browser);
    	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t)Ap;
	wrq.u.data.flags = GET_AP_INFO;
	ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
	ApSFound = wrq.u.data.length / sizeof(BSS_INFO);

                    if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RadioIsOn){
                            for (i=0; i<ApSFound; i++)
                            {// Create the browser lines	
                                            memset(Browser_String, ' ', 61);
                                            
                                    if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.InternationalRoaming){

                                if(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.ChannelVector[(Ap[k].Channel)-1] == 1){
                                            //BSSID
                                            sprintf(tmp, "%02X:%02X:%02X:%02X:%02X:%02X", Ap[i].BSSID[0], Ap[i].BSSID[1], Ap[i].BSSID[2], 
                                                                                        Ap[i].BSSID[3], Ap[i].BSSID[4], Ap[i].BSSID[5]);
                                            for (j=0; j<17; j++){
                                                    Browser_String[j] = tmp[j];}
                                            Browser_String[17]=' ';

                                            sprintf(tmp, "%s", Ap[i].SSID);
                                            for (j=18; ((j<(18+Ap[i].SSIDsize))&&(j<36)); j++){
                                                    Browser_String[j] = tmp[j-18];}
                                                    

                                            // SIGNAL STRENGTH
                                            if (Ap[i].RSSI>=40)
                                                    sprintf(tmp, "100%%");
                                            else {
                                                    if (Ap[i].RSSI<4)
                                                            sprintf(tmp, "  %.0f%%",Ap[i].RSSI*2.5);
                                                    else
                                                            sprintf(tmp, " %.0f%%",Ap[i].RSSI*2.5);}
                                            
                                            for (j=30; j<34; j++){
                                                    if (tmp[j-30]!='\0')
                                                            Browser_String[j] = tmp[j-30];}

                                            // CHANNEL INFO
                                            sprintf(tmp,"%2d", Ap[i].Channel);
                                            for (j=35; j<37; j++)
                                                    Browser_String[j] = tmp[j-35];
                                                            
                                            // TO WEP OR NOT TO WEP
                                            if (Ap[i].UsingWEP)
                                                    sprintf(tmp, "Yes");
                                            else
                                                    sprintf(tmp, " No");
                                            for (j=39; j<42; j++)
                                                    Browser_String[j] = tmp[j-39];
                                            
                                            // OPERATING MODE.... (AD_HOC or INFRASTRUCTURE)

                                            if (Ap[i].BSStype==1)
                                                    sprintf(tmp, "Ad-Hoc");
                                            else
                                                    sprintf(tmp, "Infrastructure");
                                            
                                            for (j=43; j<52;j++)
                                                    Browser_String[j] = tmp[j-43];	
                                            
                                            Browser_String[53]='\0';		
                                            fl_add_browser_line(pOpenCards->fd_sitesurveyform->browser, Browser_String);
                                }
                                    }else{
                                            //BSSID
                                            sprintf(tmp, "%02X:%02X:%02X:%02X:%02X:%02X", Ap[i].BSSID[0], Ap[i].BSSID[1], Ap[i].BSSID[2], 
                                                                                        Ap[i].BSSID[3], Ap[i].BSSID[4], Ap[i].BSSID[5]);
                                            for (j=0; j<17; j++){
                                                    Browser_String[j] = tmp[j];}
                                            Browser_String[17]=' ';

                                            sprintf(tmp, "%s", Ap[i].SSID);
                                            for (j=18; ((j<(18+Ap[i].SSIDsize))&&(j<36)); j++){
                                                    Browser_String[j] = tmp[j-18];}
                                                    

                                            // SIGNAL STRENGTH
                                            if (Ap[i].RSSI>=40)
                                                    sprintf(tmp, "100%%");
                                            else {
                                                    if (Ap[i].RSSI<4)
                                                            sprintf(tmp, "  %.0f%%",Ap[i].RSSI*2.5);
                                                    else
                                                            sprintf(tmp, " %.0f%%",Ap[i].RSSI*2.5);}
                                            
                                            for (j=30; j<34; j++){
                                                    if (tmp[j-30]!='\0')
                                                            Browser_String[j] = tmp[j-30];}

                                            // CHANNEL INFO
                                            sprintf(tmp,"%2d", Ap[i].Channel);
                                            for (j=35; j<37; j++)
                                                    Browser_String[j] = tmp[j-35];
                                                            
                                            // TO WEP OR NOT TO WEP
                                            if (Ap[i].UsingWEP)
                                                    sprintf(tmp, "Yes");
                                            else
                                                    sprintf(tmp, " No");
                                            for (j=39; j<42; j++)
                                                    Browser_String[j] = tmp[j-39];
                                            
                                            // OPERATING MODE.... (AD_HOC or INFRASTRUCTURE)

                                            if (Ap[i].BSStype==1)
                                                    sprintf(tmp, "Ad-Hoc");
                                            else
                                                    sprintf(tmp, "Infrastructure");
                                            
                                            for (j=43; j<52;j++)
                                                    Browser_String[j] = tmp[j-43];	
                                            
                                            Browser_String[53]='\0';		
                                            fl_add_browser_line(pOpenCards->fd_sitesurveyform->browser, Browser_String);

                                    }
            }    
                }

		wrq.u.data.pointer = (caddr_t)&State;
		wrq.u.data.flags = SITE_SURVEY_STATE;
		ioctl(pOpenCards->fd[pOpenCards->Active], SIOCDEVPRIVATE, &wrq);
		if (State == SITE_SURVEY_COMPLETED)
		{
			fl_activate_object(pOpenCards->fd_sitesurveyform->browser);
			fl_activate_object(pOpenCards->fd_sitesurveyform->ReScan);
			fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->ReScan, FL_BLACK);
			fl_deactivate_object(pOpenCards->fd_sitesurveyform->Cancel);
			fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->Cancel, FL_INACTIVE);			
			fl_suspend_timer(pOpenCards->fd_sitesurveyform->Timer);
		}
		else
			fl_resume_timer(pOpenCards->fd_sitesurveyform->Timer);
}
