/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "vnet.h"

extern 	int 	mtu;
extern 	UCHAR 	channel;
extern 	UCHAR	TxRate;
extern 	USHORT 	RTSThreshold;
extern 	USHORT 	FragThreshold;
extern 	UCHAR 	OpMode;
extern 	char 	ESSID[MAX_SSID_LENGTH+1];
extern 	UCHAR 	WepKeyToUse;
extern	char	WepKey1[(SHORT_WEP_KEY_SIZE*2)+1];
extern	char	WepKey2[(SHORT_WEP_KEY_SIZE*2)+1];
extern	char	WepKey3[(SHORT_WEP_KEY_SIZE*2)+1];
extern	char	WepKey4[(SHORT_WEP_KEY_SIZE*2)+1];
extern  UCHAR	WepMode;
extern 	UCHAR	EncryptionLevel;
extern  UCHAR	AuthenticationType;
extern 	UCHAR 	PreambleType;
extern 	UCHAR 	PwrMgmtMode;
extern  UCHAR   BeaconPeriod;
extern  UCHAR   RadioOn;


VOID
SetParameters(PVNet_ADAPTER Adapter)
{
	int i,j;
// Channel
	Adapter->Channel=channel;
// TxRate	
	Adapter->DataFramesTxRate					= TxRate;
// OperatingMode	
	Adapter->OperatingMode=OpMode;
// Preamble Type
	Adapter->PreambleType=PreambleType;
// Power Mgmt Mode
	Adapter->PowerMgmtMode=PwrMgmtMode;
	Adapter->IntRoamingEnabled=0;
// SSID
	VNetMoveMemory(Adapter->DesiredSSID, ESSID, MAX_SSID_LENGTH);
	VNetMoveMemory(Adapter->InitialSSID, ESSID, MAX_SSID_LENGTH);
	
	Adapter->InitialSSIDsize = Adapter->SSID_Size = strlen(ESSID);
	if(Adapter->InitialSSIDsize==0)
		Adapter->ConnectToAnyBSS = TRUE;
	else
		Adapter->ConnectToAnyBSS = FALSE;
// FragmentationThreshold
	Adapter->FragmentationThreshold = FragThreshold;
	
// Radio On-off

	if(RadioOn) Adapter->RadioIsOn = TRUE;
// RtsThreshold
	Adapter->RtsThreshold = RTSThreshold;
// Wep Key Information
	Adapter->WepInfo.WepKeyToUse=WepKeyToUse;
	Adapter->WepInfo.EncryptionLevel=EncryptionLevel;
	Adapter->WepInfo.WepMode=WepMode;
	Adapter->WepInfo.AuthenticationType=AuthenticationType;
	// Wep Key 1
	j=0;
	for(i=0; i<SHORT_WEP_KEY_SIZE*2;i+=2){
		Adapter->WepInfo.WepKey1[j] = AsciiToByte((UCHAR)WepKey1[i],(UCHAR)WepKey1[i+1]);
		j++;
	}
	// Wep Key 2
	j=0;
	for(i=0; i<SHORT_WEP_KEY_SIZE*2;i+=2){
		Adapter->WepInfo.WepKey2[j] = AsciiToByte((UCHAR)WepKey2[i],(UCHAR)WepKey2[i+1]);
		j++;
	}	
	// Wep Key 3
	j=0;
	for(i=0; i<SHORT_WEP_KEY_SIZE*2;i+=2){
		Adapter->WepInfo.WepKey3[j] = AsciiToByte((UCHAR)WepKey3[i],(UCHAR)WepKey3[i+1]);
		j++;
	}
	// Wep Key 4
	j=0;
	for(i=0; i<SHORT_WEP_KEY_SIZE*2;i+=2){
		Adapter->WepInfo.WepKey4[j] = AsciiToByte((UCHAR)WepKey4[i],(UCHAR)WepKey4[i+1]);
		j++;
	}		
// TxRate	
	Adapter->DataFramesTxRate=TxRate;	
	Adapter->DefaultBeaconPeriod = Adapter->BeaconPeriod = BeaconPeriod;
}

