#!/bin/bash
# ATMEL Wireless Card Setup for linux
# Copyright 2001 (c) ATMEL Hellas

if [ $# -gt 0 ]; then
	CONFIG_FILE=$1
else
	echo "You must provide the output file as an argument to the script"
	exit
fi

function Checkxforms ()
{
	if [ -r /usr/include/X11/Xlib.h -o -r /usr/X11R6/include/X11/Xlib.h ]; then
		for f in /usr/{X11/,X11R6/,local/,}lib/libforms.{so,a} ; do
			if [ -r $f ]; then break; fi
		done
		for g in /usr/{X11/,X11R6/,local/,}include/{,,X11/}forms.h ; do
			if [ -r $g ]; then break; fi
		done
		if [ -r $f -a -r $g ] ; then
			HAS_FORMS=y
		else
			HAS_FORMS=n
		fi
	else
		echo "X Windows include files missing"
	fi
}

function CheckKernelVersion
{
    if [ -d $1 ]; then
        if [ -f $1/Makefile ]; then
            for TAG in VERSION PATCHLEVEL SUBLEVEL EXTRAVERSION ; do
                eval `sed -ne "/^$TAG/s/[ 	]//gp" $1/Makefile`
            done
            FV="$VERSION.$PATCHLEVEL.$SUBLEVEL$EXTRAVERSION"
            if [ "$LV" = "$FV" ]; then
                if [ "$PATH_FOUND" = "n" ]; then
                    PATH_FOUND=y
                    SRCPATH=$1
                fi
            fi
        fi
    fi
}

PATH_FOUND=n
HAS_FORMS=n
MAN_PATH=$(man -w ls|xargs dirname)
MPA=/usr/src
CONFIGP="/etc/pcmcia"
USB_CONFIG="/etc/hotplug"
LV=$(uname -r)

USBDES="/lib/modules/$LV/kernel/drivers/usb"
if [ ! -d $USBDES ]; then
	mkdir $USBDES
fi
PCMCIADES="/lib/modules/$LV/pcmcia"
PCIDES="/lib/modules/$LV/kernel/drivers/net"
MODPROBE_PATH=$(which modprobe)

Checkxforms

if [ $KERNEL_SRC ]; then 
	echo $KERNEL_SRC "(defined)"
else
	if [ -L /lib/modules/$LV/build ]&&[ -f /lib/modules/$LV/build/Makefile ]; then
		SRCPATH=/lib/modules/$LV/build
	else
		for f in $MPA/*; do CheckKernelVersion $f ; done
	fi

	echo "Kernel Version Running $LV"

	if [ "$SRCPATH" = "null" ]; then
		echo -e "Kernel Source Directory Not Found. Please give path : \c"
		read SRCPATH
		if [ ! -d $SRCPATH ]; then
			echo "Invalid Path"
			rm -f config.mk
		fi
	else
		echo Found Kernel Source Directory "($SRCPATH)"
	fi

	echo KERNEL_SRC = $SRCPATH >> $CONFIG_FILE
fi

if [ $# -gt 10 ]; then
    PCMCIA_IN_KERNEL=$(grep -c CONFIG_PCMCIA= $SRCPATH/.config)

    if [ $PCMCIA_IN_KERNEL -eq 1 ] ; then
	PCMCIA_SRC=$SRCPATH
    else
	for f in $SRCPATH/pcmcia*; do
	    if [ -L $f ]; then
		if [ -d $f/include ]; then
		    PCMCIA_SRC=$f
		    break
	    fi
	    fi

	    if [ -d $f ]; then
	    if [ -d $f/include ]; then
		    PCMCIA_SRC=$f
		    break
	    fi
	    fi
	done
	if [ "$PCMCIA_SRC" = "null" ]; then
	    echo "Pcmcia card services source needed but not found"
	    echo "Please give desired path.If you have the kernel"
	    echo "support for the PCMCIA card services you still"
	    echo "have to install the corresponding version of "
	    echo "the card services"
	    read PCMCIA_SRC
	fi

	if [ ! -d $PCMCIA_SRC/include ] && [ "$PCMCIA_SRC" != "" ]; then
	    echo "Invalid directory. Check pcmcia source path and retry"
	    exit -1;
	fi
    fi
fi

echo HAS_FORMS = $HAS_FORMS >> $CONFIG_FILE
if [ -f $PCMCIA_DES ];then
	echo PCMCIA_CONFIG = $CONFIGP >> $CONFIG_FILE
	echo PCMCIA_SRC = $PCMCIA_SRC >> $CONFIG_FILE
fi

echo PCI_DES = $PCIDES >> $CONFIG_FILE
if [ -f $PCMCIA_DES ];then
	echo PCMCIA_DES = $PCMCIADES >> $CONFIG_FILE
fi
echo USB_DES = $USBDES >> $CONFIG_FILE
echo USB_CONFIG = $USB_CONFIG >> $CONFIG_FILE
echo MAN_PATH = $MAN_PATH >> $CONFIG_FILE
echo >> $CONFIG_FILE
echo >> $CONFIG_FILE
