# ATMEL Wireless Card Setup for linux
# Copyright 2001 (c) ATMEL Hellas

if [ $# -gt 0 ] && [ $1 == 'all' ]; then 
	BUILD_M=y
else
	BUILD_M=n
fi

CFG_FILE=.config

echo -n "Build all (y/n) : "
read Ball

if [ $Ball ] && [ $Ball == 'y' ]; then
	BUILD_M=y
fi

CONFIG_DEBUG=$BUILD_M
CONFIG_USB=$BUILD_M
CONFIG_PCI=$BUILD_M
CONFIG_PCMCIA=$BUILD_M

CONFIG_PCMCIA_502A=$BUILD_M
CONFIG_PCMCIA_3COM=$BUILD_M
CONFIG_PCMCIA_502AD=$BUILD_M
CONFIG_PCMCIA_502AE=$BUILD_M
CONFIG_PCMCIA_504=$BUILD_M
CONFIG_PCI_506=$BUILD_M

CONFIG_USB_503A_RFMD=$BUILD_M
CONFIG_USB_505=$BUILD_M

CONFIG_APPS=$BUILD_M
CONFIG_CMD_LINE=$BUILD_M
CONFIG_XAPP=n

PID=0
VID=0
BoardType=0
BoardDefine=0

bash scripts/setup.sh ${CFG_FILE}tmp

if [ $BUILD_M == 'n' ]; then
#	echo -ne "\033[0;37m"
	echo -n "Build Debug version (y/n) : "
	read CONFIG_DEBUG
        echo -n "Set extra module version information (y/n) : "
        read CONFIG_MODVERSIONS


	echo -n "Build USB Drivers (y/n) : "
	read CONFIG_USB

	if [ $CONFIG_USB ] && [ $CONFIG_USB == 'y' ];then
		echo -n "Build USB 503A RFMD Driver (y/n) : "
		read CONFIG_USB_503A_RFMD

		echo -n "Build USB RFMD 505 Driver (y/n) : "
		read CONFIG_USB_505
	fi

	echo -n "Build PCMCIA Drivers (y/n) : "
	read CONFIG_PCMCIA

	if [ $CONFIG_PCMCIA ] && [ $CONFIG_PCMCIA == 'y' ];then 

		echo -n "Build PCMCIA rfmd Driver (y/n) : "
		read CONFIG_PCMCIA_502A

		echo -n "Build PCMCIA 3COM Driver (y/n) : "
		read CONFIG_PCMCIA_3COM

		echo -n "Build PCMCIA rfmd revision d Driver (y/n) : "
		read CONFIG_PCMCIA_502AD

		echo -n "Build PCMCIA rfmd revision e Driver (y/n) : "
		read CONFIG_PCMCIA_502AE

		echo -n "Build PCMCIA 504 Driver (y/n) : "
		read CONFIG_PCMCIA_504
	fi

	echo -n "Build miniPCI Driver (y/n) : "
	read CONFIG_PCI

	if [ $CONFIG_PCI ] && [ $CONFIG_PCI == 'y' ];then 
		CONFIG_PCI_506=y
	fi

	echo -n "Build applications (y/n) : " 
	read CONFIG_APPS

	if [ $CONFIG_APPS ] && [ $CONFIG_APPS == 'y' ];then
		echo -n "Build command line application (y/n) : "
		read CONFIG_CMD_LINE
	
		XFORMSOK=$(grep HAS_FORM ${CFG_FILE}tmp|grep y -c)
		if [ $XFORMSOK -eq 0 ]; then 
			echo "You have to install the xforms library in order to use the xvnet application"
			CONFIG_XAPP=n
		else
			echo -n "Build X windows application (y/n) : "
			read CONFIG_XAPP
		fi
	fi
	echo -ne "\033[1;39m"
fi

echo -n > $CFG_FILE

echo CONFIG_PCI=$CONFIG_PCI >> $CFG_FILE
echo "" >> $CFG_FILE
echo "#PCMCIA Drivers" >> $CFG_FILE
echo CONFIG_PCMCIA=$CONFIG_PCMCIA >> $CFG_FILE
echo CONFIG_PCMCIA_502A=$CONFIG_PCMCIA_502A >> $CFG_FILE
echo CONFIG_PCMCIA_3COM=$CONFIG_PCMCIA_3COM >> $CFG_FILE
echo CONFIG_PCMCIA_502AD=$CONFIG_PCMCIA_502AD >> $CFG_FILE
echo CONFIG_PCMCIA_502AE=$CONFIG_PCMCIA_502AE >> $CFG_FILE
echo CONFIG_PCMCIA_504=$CONFIG_PCMCIA_504 >> $CFG_FILE
echo CONFIG_PCI_506=$CONFIG_PCI_506 >> $CFG_FILE

echo "" >> $CFG_FILE
echo "#USB Drivers" >> $CFG_FILE
echo CONFIG_USB=$CONFIG_USB >> $CFG_FILE
echo CONFIG_USB_503A_RFMD=$CONFIG_USB_503A_RFMD >> $CFG_FILE
echo CONFIG_USB_505=$CONFIG_USB_505 >> $CFG_FILE
echo "" >> $CFG_FILE
echo "#Applications Configuration" >> $CFG_FILE
echo CONFIG_APPS=$CONFIG_APPS >> $CFG_FILE
echo CONFIG_CMD_LINE=$CONFIG_CMD_LINE >> $CFG_FILE
echo CONFIG_XAPP=$CONFIG_XAPP >> $CFG_FILE
echo "" >> $CFG_FILE
if [ $CONFIG_DEBUG ] && [ $CONFIG_DEBUG == 'y' ]; then
	echo "#DEBUG INFORMATION" >> $CFG_FILE
	echo "DEBUG=D" >> $CFG_FILE
else
	echo "DEBUG=" >> $CFG_FILE
fi

echo CONFIG_MODVERSIONS=$CONFIG_MODVERSIONS >> $CFG_FILE

echo "# runtime variables. Generated by setup.sh" >> $CFG_FILE
cat ${CFG_FILE}tmp >> $CFG_FILE

rm -f ${CFG_FILE}tmp
