# -*- mode:python; coding:utf-8 -*-
import time

import atheist

class ManualRepeatRunner(atheist.Runner, atheist.Plugin):
    def __init__(self, mng):
        atheist.Runner.__init__(self, mng)
        self.tinit = time.time()

    @classmethod
    def add_options(cls, parser):
        parser.add_option('--again', action='store_true',
                          help='Repeat tests when user press ENTER')

    @classmethod
    def config(cls, mng):
        if mng.cfg.again:
            if mng.cfg.until_fail:
                mng.parser.error("-u/--until-fail and --again are incompatible options")

            mng.RunnerClass = cls

    def run(self):
        while 1:
            atheist.Runner.run(self)
            atheist.Runner.summary(self)
            if self.mng.aborted:
                break

            try:
                raw_input("\n-- Press ENTER to run tests again... ")
            except EOFError:
                self.mng.abort()
                break

    def summary(self):
        pass
