/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


WEAPON	weapon[WEAPONS] = {
	{"Small Missile",	// Name
	"Produces a low impact explosion",	// Description
	1500,	10, 10, 0.2, 25, 0, 2, 30,	0, 0,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Medium Missile",	// Name
	"Low yield, small area explosion",	// Description
	2000,	5, 15, 0.2, 40, 0, 2, 40,	0, 1,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Missile",	// Name
	"Medium yield, medium area explosion",	// Description
	4000,	3, 20, 0.2, 60, 1, 3, 60,	0, 2,	1, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Nuke",	// Name
	"High yield, large area explosion",	// Description
	16000,	2, 40, 0.2, 100, 2, 4, 100,	0, 3,	1, 0, FALSE, 2, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Nuke",	// Name
	"Very high yield, huge explosion",	// Description
	22000,	1, 60, 0.2, 150, 2, 5, 150,	0, 4,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Death Head",	// Name
	"Massive, deadly explosion",	// Description
	30000,	1, 80, 0.2, 200, 3, 6, 200,	0, 5,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Spread",	// Name
	"5 Small missiles in a single shot",	// Description
	5000,	3, 10, 0.2, 25, 0, 2, 30,	0, 0,	5, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Medium Spread",	// Name
	"5 Medium missiles in a single shot",	// Description
	11000,	2, 15, 0.2, 40, 0, 2, 40,	0, 1,	5, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Spread",	// Name
	"5 Large missiles in a single shot",	// Description
	17000,	1, 20, 0.2, 60, 1, 3, 60,	0, 2,	5, 0, FALSE, 2, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Super Spread",	// Name
	"4 Small Nukes in a single shot",	// Description
	25000,	1, 40, 0.2, 100, 2, 4, 100,	0, 3,	4, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Death Spread",	// Name
	"3 Nukes in a single shot",	// Description
	50000,	1, 60, 0.2, 150, 2, 5, 150,	0, 4,	3, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Armageddon",	// Name
	"3 Death Heads in a single shot",	// Description
	100000,	1, 80, 0.2, 200, 3, 6, 200,	0, 5,	3, 0, FALSE, 5, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Shaped Charge",	// Name
	"High yield horizontal explosion. All of the energy is focused out to the sides, increasing the damage done but reducing the overall area of the explosion.",	// Description
	10000,	5, 10, 0.2, 100, 2, 3, 100,	0, 17,	1, 0, FALSE, 2, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Wide Boy",	// Name
	"Devastating horizontal explosion. All of the energy is focused out to the sides, increasing the damage done but reducing the overall area of the explosion.",	// Description
	15000,	2, 10, 0.2, 200, 2, 4, 200,	0, 18,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Cutter",	// Name
	"Horizontal explosion that will obliterate anything that gets in the way. All of the energy is focused out to the sides, increasing the damage done but reducing the overall area of the explosion in comparison to a similar sized uncontrolled blast.",	// Description
	20000,	1, 10, 0.2, 300, 3, 5, 300,	0, 19,	1, 0, FALSE, 5, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Roller",	// Name
	"Medium explosive which rolls downhill until it hits something",	// Description
	2000,	3, 20, 0.2, 40, 0, 2, 40,	0, 6,	1, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Roller",	// Name
	"Large explosive which rolls downhill until it hits something",	// Description
	8000,	1, 30, 0.2, 60, 1, 3, 60,	0, 6,	1, 0, FALSE, 2, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Death Roller",	// Name
	"Huge explosive which rolls downhill until it hits something",	// Description
	14000,	1, 40, 0.2, 100, 2, 4, 100,	0, 6,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Cluster Bomb",	// Name
	"Scatters medium yield bomblets on impact",	// Description
	10000,	3, 100,0.2, 150, 0, 2, 200,	0, 7,	1, 0, FALSE, 2, 0, 5, BOMBLET, 0.0, 60, 0, 3.5, 0, -1, 0},

	{"Super Cluster",	// Name
	"Scatters high yield bomblets on impact",	// Description
	20000,	2, 200,0.2, 250, 1, 2, 300,	0, 7,	1, 0, FALSE, 4, 0, 5, SUP_BOMBLET, 0.0, 60, 0, 3.5, 0, -1, 0},

	{"Funky Bomb",	// Name
	"Unpredictable and highly destructive",	// Description
	30000,	3, 50, 0.2, 200, 0, 0, 200,	0, 9,	1, 0, FALSE, 3, 0, 10, FUNKY_BOMBLET, 0.0, 360, 1.0, 0.5, 0.1, -1, 0},

	{"Funky Death",	// Name
	"Unpredictable and extremely destructive",	// Description
	50000,	1, 90, 0.2, 300, 2, 1, 300,	0, 9,	1, 0, FALSE, 4, 0, 10, FUNKY_DEATHLET, 0.0, 360, 1.0, 0.5, 0.1, -1, 0},

	{"Funky Bomblet",
	"Medium yield explosive warhead",
	7000,	3, 5, 0.01, 40, 0, 0, 50,	0, 10,	1, 0, TRUE, 1, 1, 0, -1, 0, 0, 0, 0, 0, 125, 1.0},

	{"Funky Deathlet",
	"High yield explosive warhead",
	9000,	2, 9, 0.01, 100, 2, 1, 90,	0, 10,	1, 0, TRUE, 3, 1, 0, -1, 0, 0, 0, 0, 0, 175, 1.0},

	{"Bomblet",
	"Medium yield explosive warhead",
	3500,	3, 20, 0.2, 40, 0, 2, 40,	0, 8,	1, 0, FALSE, 1, 1, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Super Bomblet",
	"High yield explosive warhead",
	5000,	2, 40, 0.2, 60, 1, 2, 65,	0, 8,	1, 0, FALSE, 3, 1, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Burrower",	// Name
	"Burrows back up to the surface before exploding, good against buried tanks. The Burrower is designed for below-ground use and suffers from high air-resistance.",	// Description
	7500,	3, 100, 0.4, 50, 0, 2, 50,	0, 25,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Penetrator",	// Name
	"Penetrates below ground before rising to the surface. The Penetrator will either explode on exit from the ground or on contact with buried objects. This missile is designed for burrowing and as a result suffers from high air-resistance.",	// Description
	20000,	2, 150, 0.4, 80, 0, 2, 100,	0, 26,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Napalm Bomb",	// Name
	"Scatters small quantities of intensely burning napalm on impact",	// Description
	6000,	3, 80, 0.2, 80, 1, 1, 80,	0, 9,	1, 0, FALSE, 3, 0, 10, NAPALM_JELLY, 0.0, 90, 0.2, 2.5, 1.0, -1, 0},

	{"Medium Napalm Bomb",	// Name
	"Scatters intensely burning napalm on impact",	// Description
	14000,	2, 200, 0.2, 150, 1, 1, 200,	0, 9,	1, 0, FALSE, 4, 0, 25, NAPALM_JELLY, 0.0, 90, 0.2, 3, 1.0, -1, 0},

	{"Large Napalm Bomb",	// Name
	"Covers the surrounding area with intensely burning napalm on impact",	// Description
	22000,	1, 400, 0.2, 200, 1, 2, 500,	0, 9,	1, 0, FALSE, 5, 0, 60, NAPALM_JELLY, 0.0, 90, 0.2, 5, 1.0, -1, 0},

	{"Napalm Jelly",
	"Intensely burning chemical jelly",
	2000,	5, 5, 0.5, 10, 1, 10, 30,	0, 0,	1, 0, FALSE, 2, 1, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Tremor",	// Name
	"Produce a small earthquake on impact",	// Description
	3000,	5, 30, 0.2, 40, 0, 2, 10,	0, 14,	1, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Shock Wave",	// Name
	"Produce a large earthquake on impact",	// Description
	10000,	2, 60, 0.2, 100, 2, 3, 20,	0, 15,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Tectonic Shift",	// Name
	"Produce a huge earthquake on impact",	// Description
	30000,	1, 100,0.2, 150, 2, 4, 30,	0, 16,	1, 0, FALSE, 5, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Riot Bomb",	// Name
	"Destroy a small volume of dirt without damaging anything else",	// Description
	2000,	5, 15, 0.2, 25, 0, 2, 0,	0, 23,	1, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Heavy Riot Bomb",	// Name
	"Destroy a large volume of dirt without damaging anything else",	// Description
	3000,	2, 30, 0.2, 100, 1, 2, 0,	0, 24,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Riot Charge",	// Name
	"Cuts through a cone of dirt directly in front of the gun",	// Description
	1000,	5, 15, 0.2, 50, 0, 2, 0,	0, 11,	1, 0, TRUE, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},

	{"Riot Blast",	// Name
	"Cuts through a large cone of dirt directly in front of the gun",	// Description
	2000,	2, 30, 0.2, 150, 1, 2, 0,	0, 12,	1, 0, TRUE, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},

	{"Dirt Ball",	// Name
	"Produce a small sphere of material to bury your opponents",	// Description
	3000,	5, 15, 0.2, 25, 0, 2, 0,	0, 11,	1, 0, FALSE, 1, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Dirt Ball",	// Name
	"Produce a large sphere of material to bury your opponents",	// Description
	7000,	2, 30, 0.2, 60, 1, 2, 0,	0, 12,	1, 0, FALSE, 3, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Super Dirt Ball",	// Name
	"Produce a huge ball of material to bury your opponents",	// Description
	10000,	1, 60, 0.2, 100, 2, 2, 0,	0, 13,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Laser",	// Name
	"A 50kW laser beam",	// Description
	5000,	5,  1, 0.0,   2, 0, 0, 30,	0, 13,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Medium Laser",	// Name
	"A 100kW laser beam",	// Description
	10000,	3,  1, 0.0,   5, 0, 0, 65,	0, 13,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Laser",	// Name
	"A powerful 200kW laser beam",	// Description
	15000,	2,  1, 0.0,   9, 0, 0, 150,	0, 13,	1, 0, FALSE, 4, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0}
};

WEAPON	naturals[NATURALS] = {
	{"Small Meteor",	// Natural
	"A small chunk of rock from the skies",	// Natural
	0,	1, 15, 0.2, 25, 0, 0, 5,	0, 20,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Medium Meteor",	// Natural
	"A medium chunk of rock from the skies",	// Natural
	0,	1, 20, 0.2, 40, 0, 0, 10,	0, 21,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Meteor",	// Natural
	"A large chunk of rock from the skies",	// Natural
	0,	1, 25, 0.2, 60, 1, 1, 20,	0, 22,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Small Lightning Bolt",	// Natural
	"A weak bolt of lightning",	// Natural
	0,	1,  1, 0.0,  1, 0, 0, 5,	0, 0,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Medium Lightning Bolt",	// Natural
	"A bolt of lightning",	// Natural
	0,	1,  1, 0.0,  4, 0, 0, 15,	0, 0,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0},

	{"Large Lightning Bolt",	// Natural
	"A powerful bolt of lightning",	// Natural
	0,	1,  1, 0.0,  7, 0, 0, 35,	0, 0,	1, 0, FALSE, 0, 0, 0, -1, 0, 0, 0, 0, 0, -1, 0}
};

ITEM item[ITEMS] = {
	{"Teleport",	// Name
	"Teleports the tank to a random location",	// Description
	5000,	2,	TRUE,	3,	11},

        {"Swapper",
        "Swap places with another tank",
        10000,  2,      TRUE,   4,      11},

        {"Fan",
        "Change the wind strength and direction",
        2500, 3,        TRUE,   3,      2},

	{"Vengeance",	// Name
	"A small self-destruct or auto-destruct device, if you've got to go, why not take someone with you?",	// Description
	20000,	1,	TRUE,	2,	0,	{SML_MIS,	20}},

	{"Dying Wrath",	// Name
	"A large self/auto-destruct device. Mutually Assured Destruction.",	// Description
	40000,	1,	TRUE,	3,	0,	{SUP_CLUSTER,	3}},

	{"Fatal Fury",	// Name
	"End it all in style.",	// Description
	60000,	1,	TRUE,	4,	0,	{FUNKY_BOMB,	3}},

	{"Light Shield",	// Name
	"A small amount of protection from damage",	// Description
	10000,	3,	FALSE,	1,	0,	{50,	0,	0,	255,	0,	1}},

	{"Medium Shield",	// Name
	"Protects against  damage",	// Description
	20000,	2,	FALSE,	2,	0,	{100,	0,	64,	255,	0,	3}},

	{"Heavy Shield",	// Name
	"A large amount of protection from damage",	// Description
	30000,	2,	FALSE,	4,	0,	{150,	0,	128,	255,	64,	6}},

	{"Light Repulsor Shield",	// Name
	"Lightly repels enemy missiles",	// Description
	10000,	3,	FALSE,	2,	0,	{10,	250,	128,	0,	255,	1}},

	{"Medium Repulsor Shield",	// Name
	"Repels enemy missiles",	// Description
	20000,	2,	FALSE,	3,	0,	{20,	500,	192,	64,	255,	3}},

	{"Heavy Repulsor Shield",	// Name
	"Strongly repels enemy missiles",	// Description
	40000,	1,	FALSE,	5,	0,	{40,	1000,	255,	128,	255,	6}},

	{"Armour Plating",	// Name
	"Permanently add a small increase to the damage your tanks can take. Each additional purchase adds a slightly smaller amount to your tank's armour.",	// Description
	20000,	1,	FALSE,	2,	0,	{300}},

	{"Plasteel Plating",	// Name
	"Permanently increase the damage your tanks can take. Each additional purchase adds a slightly smaller amount to your tank's armour.",	// Description
	40000,	1,	FALSE,	4,	0,	{2155}},

	{"Intensity Amplifier",	// Name
	"A small permanent increase to the damage done by your weapons. The efficiency decreases and therefore each additional purchase has a reduced affect.",	// Description
	21000,	1,	FALSE,	3,	0,	{0.10}},

	{"Violent Force",	// Name
	"Permanently increase the damage done by your weapons. The efficiency decreases and as a result each additional purchase provides a smaller increase.",	// Description
	50000,	1,	FALSE,	3,	0,	{0.30}},

	{"Slick Projectiles",	// Name
	"A Teflon coating for projectiles to reduce drag and the affect of the wind",	// Description
	1000,	50,	FALSE,	3,	0,	{0.5}},

	{"Dimpled Projectiles",	// Name
	"Small dimples in the skin of projectiles for massive reduction in drag",	// Description
	2000,	50,	FALSE,	4,	0,	{0.1}},

	{"Parachute",	// Name
	"Allows the tank to float gently to the ground",	// Description
	5000,	10,	FALSE,	0,	0,	{0,	0}},

        {"Auto-repair kit",
        "Repairs the tank a little each turn. Each additional kit provides a slightly smaller increase to your armour.",
        25000,   1,     FALSE,  2,      0,      {0, 0}}
};

