/***** Autogenerated from runtime.in; changes will be overwritten *****/

#line 1 "runtime.in"
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate the runtime functions used by the vm::stack machine.
 *
 *****/

/* Autogenerated routines are specified like this (separated by a formfeed):
type asyname:cname(cparams)
{
  C code
}

*/

// Use Void f() instead of void f() to force an explicit Stack argument.


#line 60 "runtime.in"
#include <cfloat>
#include <time.h>
#include <sys/times.h>
#include <locale.h>
  
#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "pen.h"
#include "guide.h"
#include "picture.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawlabel.h"
#include "drawverbatim.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawgroup.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "locate.h"
#include "mathop.h"
#include "callable.h"
#include "stm.h"
#include "lexical.h"
#include "Delaunay.h"
#include "process.h"
#include "arrayop.h"
  
#ifdef HAVE_LIBFFTW3
#include "fftw++.h"
#endif
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
#include <readline/readline.h>
#include <readline/history.h>
#endif

#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
extern "C" {
void *GC_generate_random_valid_address(void);
void GC_debug_print_heap_obj_proc(void *);
}
#endif

using namespace vm;
using namespace camp;
using namespace settings;

namespace run {
using camp::pair;
using vm::array;
using vm::frame;
using vm::stack;
using camp::transform;
using absyntax::runnable;

typedef double real;

typedef array boolarray;
typedef array Intarray;
typedef array Intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array pairarray2;
typedef array triplearray;
typedef array patharray;
typedef array guidearray;
typedef array transformarray;
typedef array penarray;
typedef array penarray2;
typedef array stringarray;
typedef array stringarray2;
  
typedef callable callableBp;
typedef callable callableReal;
typedef callable callableTransform;
}

using vm::array;
using types::function;

#define PRIMITIVE(name,Name,asyName)  using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

using types::boolArray;
using types::IntArray;
using types::IntArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::pairArray2;
using types::tripleArray;
using types::pathArray;
using types::guideArray;
using types::transformArray;
using types::penArray;
using types::penArray2;
using types::stringArray;
using types::stringArray2;
using types::formal;

template<class T>
inline T Min(T a, T b)
{
  return (a < b) ? a : b;
}

template<class T>
inline T Max(T a, T b)
{
  return (a > b) ? a : b;
}

function *voidFunction()
{
  return new function(primVoid());
}

function *breakpointFunction()
{
  return new function(primString(),primString(),primInt(),primInt(),
  primCode());
}

function *realRealFunction()
{
  return new function(primReal(),primReal());
}

function *transformFunction()
{
  return new function(primTransform());
}

const unsigned camp::ColorComponents[]={0,0,1,3,4,0};

namespace vm {
const char *arraymismatch="operation attempted on arrays of different lengths";
}

namespace run {
  
const char *arrayempty="cannot take min or max of empty array";

static inline Int Round(double x) 
{
  return Int(x+((x >= 0) ? 0.5 : -0.5));
}

inline Int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

void outOfBounds(const char *op, size_t len, Int n)
{
  ostringstream buf;
  buf << op << " array of length " << len << " with out-of-bounds index " << n;
  error(buf);
}

inline item& arrayRead(array *a, Int n)  
{
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (Int) len) outOfBounds("reading",len,n);
  return (*a)[(unsigned) n];
}

// Helper function to create deep arrays.
static array* deepArray(Int depth, Int *dims)
{
  assert(depth > 0);
  
  if (depth == 1) {
    return new array(dims[0]);
  } else {
    Int length = dims[0];
    depth--; dims++;

    array *a = new array(length);

    for (Int index = 0; index < length; index++) {
      (*a)[index] = deepArray(depth, dims);
    }
    return a;
  }
}
  
array *nop(array *a) 
{
  return a;
}
  
array *copyArray(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) 
    (*c)[i]=(*a)[i];
  return c;
}

double *copyArrayC(array *a)
{
  size_t size=checkArray(a);
  double *c=new double[size];
  for(size_t i=0; i < size; i++) 
    c[i]=read<double>(a,i);
  return c;
}

array *copyArray2(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) 
      (*ci)[j]=(*ai)[j];
  }
  return c;
}

array *copyArray3(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) {
      array *aij=read<array*>(ai,j);
      size_t aijsize=checkArray(aij);
      array *cij=new array(aijsize);
      (*ci)[j]=cij;
      for(size_t k=0; k < aijsize; k++) 
	(*cij)[k]=(*aij)[k];
    }
  }
  return c;
}

double *copyArray2C(array *a, bool square=true)
{
  size_t n=checkArray(a);
  size_t m=((square || n == 0) ? n : read<array*>(a,0)->size());
  double *c=new double[n*m];
  for(size_t i=0; i < n; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    if(aisize == m) {
      double *ci=c+i*m;
      for(size_t j=0; j < m; j++) 
	ci[j]=read<double>(ai,j);
    } else
      error(square ? "matrix must be square" : "matrix must be rectangular");
  }
  return c;
}

static const char *incommensurate="Incommensurate matrices";
static const char *singular="Singular matrix";
static size_t *pivot,*Row,*Col;
static inline void inverseAllocate(size_t n)
{
  pivot=new size_t[n];
  Row=new size_t[n];
  Col=new size_t[n];
}

static inline void inverseDeallocate()
{
  delete[] pivot;
  delete[] Row;
  delete[] Col;
}

void writestring(stack *s)
{
  callable *suffix=pop<callable *>(s,NULL);
  string S=pop<string>(s);
  vm::item it=pop(s);
  bool defaultfile=isdefault(it);
  camp::file *f=defaultfile ? &camp::Stdout : vm::get<camp::file*>(it);
  if(!f->isOpen()) return;
  if(S != "") f->write(S);
  if(f->text()) {
    if(suffix) {
      s->push(f);
      suffix->call(s);
    } else if(defaultfile) f->writeline();
  }
}

void checkSquare(array *a) 
{
  size_t n=a->size();
  for(size_t i=0; i < n; i++)
    if(read<array*>(a,i)->size() != n)
      error("matrix a must be square");
}

// Crout's algorithm for computing the LU decomposition of a square matrix.
// cf. routine ludcmp (Press et al.,  Numerical Recipes, 1991).
Int LUdecompose(double *a, size_t n, size_t* index, bool warn=true)
{
  double *vv=new double[n];
  Int swap=1;
  for(size_t i=0; i < n; ++i) {
    double big=0.0;
    double *ai=a+i*n;
    for(size_t j=0; j < n; ++j) {
      double temp=fabs(ai[j]);
      if(temp > big) big=temp;
    }
    if(big == 0.0) {
      delete[] vv;
      if(warn) error(singular);
      else return 0;
    }
    vv[i]=1.0/big;
  }
  for(size_t j=0; j < n; ++j) {
    for(size_t i=0; i < j; ++i) {
      double *ai=a+i*n;
      double sum=ai[j];
      for(size_t k=0; k < i; ++k) {
	sum -= ai[k]*a[k*n+j];
      }
      ai[j]=sum;
    }
    double big=0.0;
    size_t imax=j;
    for(size_t i=j; i < n; ++i) {
      double *ai=a+i*n;
      double sum=ai[j];
      for(size_t k=0; k < j; ++k)
	sum -= ai[k]*a[k*n+j];
      ai[j]=sum;
      double temp=vv[i]*fabs(sum);
      if(temp >= big) {
	big=temp;
	imax=i;
      }
    }
    double *aj=a+j*n;
    double *aimax=a+imax*n;
    if(j != imax) {
      for(size_t k=0; k < n; ++k) {
	double temp=aimax[k];
	aimax[k]=aj[k];
	aj[k]=temp;
      }
      swap *= -1;
      vv[imax]=vv[j];
    }
    if(index) 
      index[j]=imax;
    if(j != n) {
      double denom=aj[j];
      if(denom == 0.0) {
	delete[] vv;
	if(warn) error(singular);
	else return 0;
      }
      for(size_t i=j+1; i < n; ++i)
	a[i*n+j] /= denom;
    }
  }
  delete[] vv;
  return swap;
}

void dividebyzero(size_t i)
{
  ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Divide by zero";
  error(buf);
}
  
void integeroverflow(size_t i)
{
  ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Integer overflow";
  error(buf);
}
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
struct historyState {
  bool store;
  HISTORY_STATE state;
};
  
typedef mem::map<CONST string, historyState> historyMap_t;
historyMap_t historyMap;
static HISTORY_STATE history_save;

// Store a deep copy of the current readline history in dest.
void store_history(HISTORY_STATE *dest)
{
  HISTORY_STATE *src=history_get_history_state();
  *dest=*src;
  if(src) {
    for(Int i=0; i < src->length; ++i)
      dest->entries[i]=src->entries[i];
    free(src);
  }
}

stringarray* get_history(Int n) 
{
  int N=intcast(n);
  if(N <= 0) N=history_length;
  else N=Min(N,history_length);
  array *a=new array((size_t) N);
  int offset=history_length-N+1;
  for(int i=0; i < N; ++i) {
    HIST_ENTRY *last=history_get(offset+i);
    string s=last ? last-> line : "";
    (*a)[i]=s;
  }	
  return a;
}

string historyfilename(const string &name) 
{
  return historyname+"_"+name;
}
#endif

#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
int readline_startup_hook()
{
#ifdef __CYGWIN__
  rl_set_key("\\M-[3~",rl_delete,rl_get_keymap());
  rl_set_key("\\M-[2~",rl_overwrite_mode,rl_get_keymap());
#endif    
  return 0;
}

void init_readline(bool tabcompletion=true) 
{
  static bool first=true;
  if(first) {
    first=false;
#ifdef __CYGWIN__
    rl_startup_hook=readline_startup_hook;
#endif    
  }
  rl_bind_key('\t',tabcompletion ? rl_complete : rl_insert);
}
#endif

void cleanup()
{
  processDataStruct &pd=processData();
  pd.atExitFunction=NULL;
  pd.atBreakpointFunction=NULL;
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  store_history(&history_save);
  int nlines=intcast(getSetting<Int>("historylines"));
  for(historyMap_t::iterator h=historyMap.begin(); h != historyMap.end(); 
      ++h) {
    history_set_history_state(&h->second.state);
    stifle_history(nlines);
    if(h->second.store) write_history(historyfilename(h->first).c_str());
  }
  history_set_history_state(&history_save);
#endif
}

void purge()
{
#ifdef USEGC
  GC_gcollect();
#endif
}

void updateFunction(stack *Stack)
{
  callable *atExitFunction=processData().atExitFunction;
  if(atExitFunction && !nullfunc::instance()->compare(atExitFunction))
    atExitFunction->call(Stack);
}

void exitFunction(stack *Stack)
{
  updateFunction(Stack);
  cleanup();
}

default_t def;
string emptystring;
array *emptyarray=new array(0);
string commentchar="#";

void breakpoint(stack *Stack, runnable *r)
{
  callable *atBreakpointFunction=processData().atBreakpointFunction;
  if(atBreakpointFunction &&
     !nullfunc::instance()->compare(atBreakpointFunction)) {
    position curPos=getPos();
    Stack->push<string>(curPos.filename());
    Stack->push<Int>((Int) curPos.Line());
    Stack->push<Int>((Int) curPos.Column());
    Stack->push(r ? r : item(def));
    atBreakpointFunction->call(Stack); // returns a string
  } else Stack->push<string>("");
}

}

namespace types {
extern const char *names[];
}

void checkformat(const char *ptr, bool intformat) 
{
  while(*ptr != '\0') {
    if(*ptr != '%') /* While we have regular characters, print them.  */
      ptr++;
    else { /* We've got a format specifier. */
      ptr++;
      
      while(*ptr && strchr ("-+ #0'I", *ptr)) /* Move past flags.  */
	*ptr++;

      if(*ptr == '*')
	ptr++;
      else while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	ptr++;
	  
      if(*ptr == '.') {
	*ptr++; /* Go past the period.  */
	if(*ptr == '*') {
	  ptr++;
	} else
	  while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	    *ptr++;
      }
      while(*ptr && strchr ("hlL", *ptr))
	*ptr++;
	  
      if(*ptr == '%') ++ptr;
      else if(*ptr != '\0') {
	if(intformat) {
	  switch(*ptr) {
	  case 'd':
	  case 'i':
	  case 'o':
	  case 'u':
	  case 'x':
	  case 'X':
	  case 'c':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type " 
		<< types::names[types::ty_Int];
	    error(buf);
	    break;
	  }
	} else {
	  switch(*ptr) {
	  case 'f':
	  case 'F':
	  case 'e':
	  case 'E':
	  case 'g':
	  case 'G':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type "
		<< types::names[types::ty_real];
	    error(buf);
	    break;
	  }
	}
      }
    } /* End of else statement */
  }
}
  
// Return an angle in the interval [0,360).
inline double principalBranch(double deg)
{
  if(deg < 0) deg += 360; 
  return deg;
}

static string defaulttransparency=string("Compatible");

static const string defaulttimeformat=string("%a %b %d %T %Z %Y");
#ifdef HAVE_STRFTIME
static const size_t nTime=256;
static char Time[nTime];
#endif  

void clear(string file, Int line, bool warn=false) 
{
  bpinfo bp(file,line);
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p) {
    if(*p == bp) {
      cout << "cleared breakpoint at " << file << ": " << line << endl;
      bplist.remove(bp);
      return;
    }
  }
  if(warn)
    cout << "No such breakpoint at "  << file << ": " << line << endl;
}

Int windingnumber(array *p, camp::pair z)
{
  size_t size=p->size();
  Int count=0;
  for(size_t i=0; i < size; i++) 
    count += read<path *>(p,i)->windingnumber(z);
  return count;
}

string convertname(string name, const string& format, bool check=true)
{
  if(name.empty())
    return buildname(outname(),format,"",false);
  else
    if(check) checkLocal(name);
  return format.empty() ? name : format+":"+name;
}

void unused(void *)
{
}

// Ignore unclosed begingroups but not spurious endgroups.
const char *nobegin="endgroup without matching begingroup";
  
// Autogenerated routines:



namespace run {

// Initializers
#line 728 "runtime.in"
void IntZero(stack *Stack)
{
#line 729 "runtime.in"
  {Stack->push<Int>(0); return;}
}

#line 734 "runtime.in"
void realZero(stack *Stack)
{
#line 735 "runtime.in"
  {Stack->push<real>(0.0); return;}
}

#line 739 "runtime.in"
void boolFalse(stack *Stack)
{
#line 740 "runtime.in"
  {Stack->push<bool>(false); return;}
}

#line 744 "runtime.in"
void pushNullArray(stack *Stack)
{
#line 745 "runtime.in"
  {Stack->push<array*>(0); return;}
}

#line 749 "runtime.in"
void pushNullRecord(stack *Stack)
{
#line 750 "runtime.in"
  {Stack->push<frame*>(0); return;}
}

#line 754 "runtime.in"
void pushNullFunction(stack *Stack)
{
#line 755 "runtime.in"
  {Stack->push(nullfunc::instance()); return;}
}


// Default operations

// Put the default value token on the stack (in place of an argument when
// making a function call).
#line 764 "runtime.in"
void pushDefault(stack *Stack)
{
#line 765 "runtime.in"
  {Stack->push(def); return;}
}


// Test if the value on the stack is the default value token.
#line 771 "runtime.in"
void isDefault(stack *Stack)
{
  item i=vm::pop(Stack);
#line 772 "runtime.in"
  {Stack->push<bool>(isdefault(i)); return;}
}


// Logical operations
#line 778 "runtime.in"
// bool !(bool b);
void gen8(stack *Stack)
{
  bool b=vm::pop<bool>(Stack);
#line 779 "runtime.in"
  {Stack->push<bool>(!b); return;}
}

#line 784 "runtime.in"
void boolMemEq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 785 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 789 "runtime.in"
void boolMemNeq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 790 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 794 "runtime.in"
void boolFuncEq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 795 "runtime.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 799 "runtime.in"
void boolFuncNeq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 800 "runtime.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Bit operations
#line 806 "runtime.in"
// Int AND(Int a, Int b);
void gen13(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 807 "runtime.in"
    {Stack->push<Int>(a & b); return;}
}

#line 811 "runtime.in"
// Int OR(Int a, Int b);
void gen14(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 812 "runtime.in"
    {Stack->push<Int>(a | b); return;}
}

#line 816 "runtime.in"
// Int XOR(Int a, Int b);
void gen15(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 817 "runtime.in"
    {Stack->push<Int>(a ^ b); return;}
}

#line 821 "runtime.in"
// Int NOT(Int a);
void gen16(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 822 "runtime.in"
    {Stack->push<Int>(~a); return;}
}


// Casts
#line 828 "runtime.in"
void pairToGuide(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 829 "runtime.in"
  {Stack->push<guide*>(new pairguide(z)); return;}
}

#line 834 "runtime.in"
void pathToGuide(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 835 "runtime.in"
  {Stack->push<guide*>(new pathguide(p)); return;}
}

#line 839 "runtime.in"
void guideToPath(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 840 "runtime.in"
  {Stack->push<path>(g->solve()); return;}
}


// Picture operations
#line 846 "runtime.in"
void newPicture(stack *Stack)
{
#line 847 "runtime.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 852 "runtime.in"
// bool empty(picture *f);
void gen21(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 853 "runtime.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 857 "runtime.in"
// pair max(picture *f);
void gen22(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 858 "runtime.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 862 "runtime.in"
// pair min(picture *f);
void gen23(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 863 "runtime.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 867 "runtime.in"
// void label(picture *f, string *s, string *size, transform t, pair position,	   pair align, pen p);
void gen24(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair align=vm::pop<pair>(Stack);
  pair position=vm::pop<pair>(Stack);
  transform t=vm::pop<transform>(Stack);
  string * size=vm::pop<string *>(Stack);
  string * s=vm::pop<string *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 869 "runtime.in"
  f->append(new drawLabel(*s,*size,t,position,align,p));
}

#line 873 "runtime.in"
// bool labels(picture *f);
void gen25(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 874 "runtime.in"
  {Stack->push<bool>(f->havelabels()); return;}
}

#line 878 "runtime.in"
// void _draw(picture *f, path g, pen p);
void gen26(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  path g=vm::pop<path>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 879 "runtime.in"
  f->append(new drawPath(g,p));
}

#line 883 "runtime.in"
// void fill(picture *f, patharray *g, pen p, bool copy=true);
void gen27(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen p=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 884 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawFill(*copyarray(g),p));
}

#line 889 "runtime.in"
// void latticeshade(picture *f, patharray *g, pen fillrule, penarray2 *p,		  bool copy=true);
void gen28(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 891 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawLatticeShade(*copyarray(g),fillrule,*copyarray(p)));
}

#line 896 "runtime.in"
// void axialshade(picture *f, patharray *g, pen pena, pair a, pen penb, pair b,		bool copy=true);
void gen29(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 898 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawAxialShade(*copyarray(g),pena,a,penb,b));
}

#line 903 "runtime.in"
// void radialshade(picture *f, patharray *g, pen pena, pair a, real ra,		 pen penb, pair b, real rb, bool copy=true);
void gen30(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  real rb=vm::pop<real>(Stack);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  real ra=vm::pop<real>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 905 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawRadialShade(*copyarray(g),pena,a,ra,penb,b,rb));
}

#line 910 "runtime.in"
// void gouraudshade(picture *f, patharray *g, pen fillrule, penarray *p,		  pairarray *z, Intarray *edges, bool copy=true);
void gen31(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  pairarray * z=vm::pop<pairarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 912 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(*copyarray(g),fillrule,*copyarray(p),
				 *copyarray(z),*copyarray(edges)));
}

#line 920 "runtime.in"
// void gouraudshade(picture *f, patharray *g, pen fillrule, penarray *p,		  Intarray *edges, bool copy=true);
void gen32(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 922 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  size_t n=checkArrays(p,edges);
  size_t m=checkArray(g);
  array *z=new array(n);
  Int k=0;
  Int in=(Int) n;
  for(size_t j=0; j < m; ++j) {
    path *P=read<path *>(g,j);
    Int stop=Min(P->size(),in-k);
    mem::vector<solvedKnot>& nodes=P->Nodes();
    for(Int i=0; i < stop; ++i)
      (*z)[k++]=nodes[i].point;
  }
  checkArrays(p,z);
  
 f->append(new drawGouraudShade(*copyarray(g),fillrule,*copyarray(p),
				*z,*copyarray(edges)));
}

#line 942 "runtime.in"
// void tensorshade(picture *f, patharray *g, pen fillrule, penarray2 *p,		 patharray *b=NULL, pairarray2 *z=emptyarray, bool copy=true);
void gen33(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pairarray2 * z=vm::pop<pairarray2 *>(Stack,emptyarray);
  patharray * b=vm::pop<patharray *>(Stack,NULL);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 944 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  if(b == NULL) b=g;
  size_t n=checkArrays(p,b);
  size_t nz=checkArray(z);
  if(nz != 0 && nz != n)
    error(arraymismatch);
  f->append(new drawTensorShade(*copyarray(g),fillrule,*copyarray2(p),
				*copyarray(b),*copyarray2(z)));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 958 "runtime.in"
// void clip(picture *f, patharray *g, pen fillrule, bool copy=true);
void gen34(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 959 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  drawClipBegin *begin=new drawClipBegin(*copyarray(g),fillrule,true);
  f->enclose(begin,new drawClipEnd(true,begin));
}

#line 965 "runtime.in"
// void beginclip(picture *f, patharray *g, pen fillrule);
void gen35(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 966 "runtime.in"
  f->append(new drawClipBegin(*copyArray(g),fillrule,false));
}

#line 970 "runtime.in"
// void endclip(picture *f);
void gen36(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 971 "runtime.in"
  f->append(new drawClipEnd(false));
}

#line 975 "runtime.in"
// void gsave(picture *f);
void gen37(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 976 "runtime.in"
  f->append(new drawGsave());
}

#line 980 "runtime.in"
// void grestore(picture *f);
void gen38(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 981 "runtime.in"
  f->append(new drawGrestore());
}

#line 985 "runtime.in"
// void begingroup(picture *f);
void gen39(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 986 "runtime.in"
  f->append(new drawBegin());
}

#line 990 "runtime.in"
// void endgroup(picture *f);
void gen40(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 991 "runtime.in"
  f->append(new drawEnd());
}

#line 995 "runtime.in"
// void add(picture *dest, picture *src);
void gen41(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 996 "runtime.in"
  dest->add(*src);
}

#line 1000 "runtime.in"
// void prepend(picture *dest, picture *src);
void gen42(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 1001 "runtime.in"
  dest->prepend(*src);
}

#line 1005 "runtime.in"
// void postscript(picture *f, string s);
void gen43(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1006 "runtime.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 1010 "runtime.in"
// void tex(picture *f, string s);
void gen44(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1011 "runtime.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 1015 "runtime.in"
// void postscript(picture *f, string s, pair min, pair max);
void gen45(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1016 "runtime.in"
  f->append(new drawVerbatim(PostScript,s,min,max));
}

#line 1020 "runtime.in"
// void tex(picture *f, string s, pair min, pair max);
void gen46(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1021 "runtime.in"
  f->append(new drawVerbatim(TeX,s,min,max));
}

#line 1025 "runtime.in"
// void texpreamble(string s);
void gen47(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 1026 "runtime.in"
  string t=s+"\n";
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.push_back(t);
  pd.TeXpreamble.push_back(t);
}

#line 1033 "runtime.in"
// void deletepreamble();
void gen48(stack *)
{
#line 1034 "runtime.in"
  if(getSetting<bool>("inlinetex")) {
    unlink(auxname(outname(),"pre").c_str());
  }
}

#line 1040 "runtime.in"
// void _labelpath(picture *f, string s, string size, path g, string justify,		pair offset, pen p);
void gen49(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair offset=vm::pop<pair>(Stack);
  string justify=vm::pop<string>(Stack);
  path g=vm::pop<path>(Stack);
  string size=vm::pop<string>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1042 "runtime.in"
  f->append(new drawLabelPath(s,size,g,justify,offset,p));
}

#line 1046 "runtime.in"
// void texreset();
void gen50(stack *)
{
#line 1047 "runtime.in"
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.clear();
  pd.TeXpreamble.clear();
  pd.tex.pipeclose();
}

#line 1054 "runtime.in"
// void layer(picture *f);
void gen51(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1055 "runtime.in"
  f->append(new drawLayer());
}

#line 1059 "runtime.in"
// void _image(picture *f, realarray2 *data, pair initial, pair final,	    penarray *palette=NULL, transform t=identity, bool copy=true);
void gen52(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray * palette=vm::pop<penarray *>(Stack,NULL);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  realarray2 * data=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1061 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawImage(*copyarray2(data),*copyarray(palette),
			  t*matrix(initial,final)));
}

#line 1068 "runtime.in"
// void _image(picture *f, penarray2 *data, pair initial, pair final,	    transform t=identity, bool copy=true);
void gen53(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  penarray2 * data=vm::pop<penarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1070 "runtime.in"
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawImage(*copyarray2(data),t*matrix(initial,final)));
}

#line 1075 "runtime.in"
// string nativeformat();
void gen54(stack *Stack)
{
#line 1076 "runtime.in"
  {Stack->push<string>(nativeformat()); return;}
}

#line 1080 "runtime.in"
// bool latex();
void gen55(stack *Stack)
{
#line 1081 "runtime.in"
  {Stack->push<bool>(latex(texengine())); return;}
}

#line 1085 "runtime.in"
// bool pdf();
void gen56(stack *Stack)
{
#line 1086 "runtime.in"
  {Stack->push<bool>(pdf(texengine())); return;}
}

#line 1090 "runtime.in"
// void shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,	     string format=emptystring, bool wait=false, bool view=true,	     callableTransform *xform);
void gen57(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  bool view=vm::pop<bool>(Stack,true);
  bool wait=vm::pop<bool>(Stack,false);
  string format=vm::pop<string>(Stack,emptystring);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack,emptystring);
#line 1093 "runtime.in"
  if(prefix.empty()) prefix=outname();

  picture *result=new picture;
  unsigned level=0;
  picture::nodelist::iterator p;
  for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
    xform->call(Stack);
    transform t=pop<transform>(Stack);
    static transform Zero=transform(0.0,0.0,0.0,0.0,0.0,0.0);
    bool Delete=(t == Zero);
    picture *group=new picture;
    assert(*p);
    if((*p)->endgroup()) error(nobegin);
    if((*p)->begingroup()) {
      ++level;
      while(p != f->nodes.end() && level) {
	if(!Delete) {
	  drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
	  group->append(e);
	}
	++p;
	if(p == f->nodes.end()) break;
	assert(*p);
	if((*p)->begingroup()) ++level;
	if((*p)->endgroup()) if(level) --level;
	  else error(nobegin);
      }
    }
    if(p == f->nodes.end()) break;
    assert(*p);
    if(!Delete) {
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      result->add(*group);
    }
  }
    
  result->shipout(preamble,prefix,format,0.0,wait,view);
}

#line 1134 "runtime.in"
// void deconstruct(picture *f, picture *preamble=NULL, real magnification=1, 		 callableTransform *xform);
void gen58(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  real magnification=vm::pop<real>(Stack,1);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
#line 1136 "runtime.in"
  unsigned level=0;
  unsigned n=0;

  string prefix=outname();
  string xformat=getSetting<string>("xformat");

  const unsigned maxargs=::min(ARG_MAX/(prefix.size()+xformat.size()+25ul),
			       256ul);
  
  cout << xformat << newl;
  cout << maxargs << newl;
  
  string preformat=nativeformat();
  const string Done="Done";
  const string Error="Error";
  
  ostringstream cmd;
  
  // Enforce ghostscript limitations.
  magnification=::max(magnification,0.0001);
  double res=::min(::max(magnification*72.0,2.0),8192.0);
  
  const char *converter=NULL, *hint=NULL;
  
  bool png=xformat == "png";
  
  if(magnification > 0.0) {
    string outname;
    unsigned arg=0;
    unsigned batch=0;
    for(picture::nodelist::iterator p=f->nodes.begin();;) {
      if(p == f->nodes.end()) break;
      if(arg == 0) {
	cmd.str("");
	ostringstream buf;
	buf << batch << "_";
	outname=buildname(prefix+buf.str()+"%d",xformat,"",
			  prefix != settings::outname() && !globalwrite());
	if(png) {
	  cmd << "'" << getSetting<string>("gs")
	      << "' -q -dNOPAUSE -dBATCH -sDEVICE=pngalpha -dEPSCrop"
	      << " -r" << res << "x" << res
	      << " -sOutputFile='" << outname << "'";
	  converter="gs";
	  hint="Ghostscript";
	} else {
	  cmd << "'" << getSetting<string>("convert") 
	      << "' -density " << res << "x" << res
	      << " -transparent white";
	  hint=converter="convert";
	}
      }
      
      picture *group=new picture;
      xform->call(Stack);
      transform t=pop<transform>(Stack);
      assert(*p);
      if((*p)->endgroup()) {
	cout << Error << endl;
	error(nobegin);
      }
      if((*p)->begingroup()) {
	++level;
	while(p != f->nodes.end() && level) {
	  drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
	  group->append(e);
	  ++p;
	  if(p == f->nodes.end()) break;
	  assert(*p);
	  if((*p)->begingroup()) ++level;
	  if((*p)->endgroup()) if(level) --level;
	    else {
	      cout << Error << endl;
	      error(nobegin);
	    }
	}
      }
      if(p != f->nodes.end()) {
	assert(*p);
	drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
	group->append(e);
	bbox b;
	ostringstream buf;
	buf << prefix << "_" << n;
	string name=buildname(buf.str(),preformat);
	cmd << " '";
	if(!png) cmd << preformat+":";
	cmd << name << "'";
	group->shipout(preamble,buf.str(),preformat,magnification,false,false);
	b=group->bounds();
	b *= magnification;
      
	cout << b << newl;
	++n;
	++p;
	++arg;
      }
      
      if(p == f->nodes.end() || arg >= maxargs) {
	arg=0;
	++batch;
	cout.flush();
	if(!png) 
	  cmd << " -scene 1 '" << xformat << ":" << outname << "'";
    
	int status=System(cmd,0,true,converter,hint);
	if(status) {
	  cout << Error << endl;
	  error("deconstruct failed");
	}
      }
    }
    
    if(!getSetting<bool>("keep")) {
      for(unsigned i=0; i < n; ++i) {
	ostringstream buf;
	buf << prefix << "_" << i;
	unlink(buildname(buf.str(),preformat).c_str());
      }
    }
    
    cout << Done << endl;
  }
}

#line 1262 "runtime.in"
// void purge();
void gen59(stack *)
{
#line 1263 "runtime.in"
  purge();
}


// Pen operations
#line 1269 "runtime.in"
void newPen(stack *Stack)
{
#line 1270 "runtime.in"
  {Stack->push<pen>(pen()); return;}
}

#line 1275 "runtime.in"
// bool ==(pen a, pen b);
void gen61(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1276 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1280 "runtime.in"
// bool !=(pen a, pen b);
void gen62(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1281 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1285 "runtime.in"
// pen +(pen a, pen b);
void gen63(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1286 "runtime.in"
  {Stack->push<pen>(a+b); return;}
}

#line 1290 "runtime.in"
// pen *(real a, pen b);
void gen64(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  real a=vm::pop<real>(Stack);
#line 1291 "runtime.in"
  {Stack->push<pen>(a*b); return;}
}

#line 1295 "runtime.in"
// pen *(pen a, real b);
void gen65(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1296 "runtime.in"
  {Stack->push<pen>(b*a); return;}
}

#line 1300 "runtime.in"
// pair max(pen p);
void gen66(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1301 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 1305 "runtime.in"
// pair min(pen p);
void gen67(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1306 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

// Reset the meaning of pen default attributes.
#line 1311 "runtime.in"
// void resetdefaultpen();
void gen68(stack *)
{
#line 1312 "runtime.in"
  processData().defaultpen=camp::pen::initialpen();
}

#line 1316 "runtime.in"
// void defaultpen(pen p);
void gen69(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1317 "runtime.in"
  processData().defaultpen=pen(resolvepen,p);
}

#line 1321 "runtime.in"
// pen defaultpen();
void gen70(stack *Stack)
{
#line 1322 "runtime.in"
  {Stack->push<pen>(processData().defaultpen); return;}
}

#line 1326 "runtime.in"
// pen invisible();
void gen71(stack *Stack)
{
#line 1327 "runtime.in"
  {Stack->push<pen>(pen(invisiblepen)); return;}
}

#line 1331 "runtime.in"
// pen gray(pen p);
void gen72(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1332 "runtime.in"
  if(p.rgb()) p.rgbtogrey();
  else if (p.cmyk()) p.cmyktogrey();
  {Stack->push<pen>(p); return;}
}

#line 1338 "runtime.in"
// pen rgb(pen p);
void gen73(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1339 "runtime.in"
  if(p.grayscale()) p.greytorgb();
  else if (p.cmyk()) p.cmyktorgb();
  {Stack->push<pen>(p); return;}
}

#line 1345 "runtime.in"
// pen rgb(real r, real g, real b);
void gen74(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real g=vm::pop<real>(Stack);
  real r=vm::pop<real>(Stack);
#line 1346 "runtime.in"
  {Stack->push<pen>(pen(r,g,b)); return;}
}

#line 1350 "runtime.in"
// pen cmyk(real c, real m, real y, real k);
void gen75(stack *Stack)
{
  real k=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real m=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
#line 1351 "runtime.in"
  {Stack->push<pen>(pen(c,m,y,k)); return;}  
}

#line 1355 "runtime.in"
// pen gray(real gray);
void gen76(stack *Stack)
{
  real gray=vm::pop<real>(Stack);
#line 1356 "runtime.in"
  {Stack->push<pen>(pen(gray)); return;}
}

#line 1360 "runtime.in"
// realarray* colors(pen p);
void gen77(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1361 "runtime.in"  
  Int n=ColorComponents[p.colorspace()];
  array *a=new array(n);
  
  switch(n) {
  case 0:
    break;
  case 1: 
    (*a)[0]=p.gray(); 
    break;
  case 3:
    (*a)[0]=p.red(); 
    (*a)[1]=p.green(); 
    (*a)[2]=p.blue(); 
    break;
  case 4:
    (*a)[0]=p.cyan();
    (*a)[1]=p.magenta(); 
    (*a)[2]=p.yellow(); 
    (*a)[3]=p.black();
    break;
  default:
    break;
  }
  {Stack->push<realarray*>(a); return;}
}

#line 1388 "runtime.in"
// string colorspace(pen p);
void gen78(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1389 "runtime.in"
  string s=ColorDeviceSuffix[p.colorspace()];
  std::transform(s.begin(),s.end(),s.begin(),tolower);
  {Stack->push<string>(s); return;}
}

#line 1395 "runtime.in"
// pen pattern(string *s);
void gen79(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 1396 "runtime.in"
  {Stack->push<pen>(pen(setpattern,*s)); return;}
}

#line 1400 "runtime.in"
// string pattern(pen p);
void gen80(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1401 "runtime.in"
  {Stack->push<string>(p.fillpattern()); return;}  
}

#line 1405 "runtime.in"
// pen fillrule(Int n);
void gen81(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 1406 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nFill ? (FillRule) n : DEFFILL)); return;}
}

#line 1410 "runtime.in"
// Int fillrule(pen p);
void gen82(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1411 "runtime.in"
  {Stack->push<Int>(p.Fillrule()); return;}  
}

#line 1415 "runtime.in"
// pen opacity(real opacity=1.0, string blend=defaulttransparency);
void gen83(stack *Stack)
{
  string blend=vm::pop<string>(Stack,defaulttransparency);
  real opacity=vm::pop<real>(Stack,1.0);
#line 1416 "runtime.in"
  for(Int i=0; i < nBlendMode; ++i)
   if(blend == BlendMode[i]) {Stack->push<pen>(pen(Transparency(blend,opacity))); return;}

  ostringstream buf;
  buf << "Unknown blend mode: " << "'" << blend << "'";
  error(buf);
}

#line 1425 "runtime.in"
// real opacity(pen p);
void gen84(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1426 "runtime.in"
  {Stack->push<real>(p.opacity()); return;}
}

#line 1430 "runtime.in"
// string blend(pen p);
void gen85(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1431 "runtime.in"
  {Stack->push<string>(p.blend()); return;}
}

#line 1435 "runtime.in"
// pen linetype(string *s, real offset=0, bool scale=true, bool adjust=true);
void gen86(stack *Stack)
{
  bool adjust=vm::pop<bool>(Stack,true);
  bool scale=vm::pop<bool>(Stack,true);
  real offset=vm::pop<real>(Stack,0);
  string * s=vm::pop<string *>(Stack);
#line 1436 "runtime.in"
  {Stack->push<pen>(pen(LineType(*s,offset,scale,adjust))); return;} 
}

#line 1440 "runtime.in"
// string linetype(pen p);
void gen87(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1441 "runtime.in"
  {Stack->push<string>(p.stroke()); return;}  
}

#line 1445 "runtime.in"
// real offset(pen p);
void gen88(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1446 "runtime.in"
  {Stack->push<real>(p.linetype().offset); return;}
}

#line 1450 "runtime.in"
// bool scale(pen p);
void gen89(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1451 "runtime.in"
  {Stack->push<bool>(p.linetype().scale); return;}
}

#line 1455 "runtime.in"
// bool adjust(pen p);
void gen90(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1456 "runtime.in"
  {Stack->push<bool>(p.linetype().adjust); return;}
}

#line 1460 "runtime.in"
// pen linecap(Int n);
void gen91(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 1461 "runtime.in"
  {Stack->push<pen>(pen(setlinecap,n >= 0 && n < nCap ? n : DEFCAP)); return;}
}

#line 1465 "runtime.in"
// Int linecap(pen p);
void gen92(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1466 "runtime.in"
  {Stack->push<Int>(p.cap()); return;}  
}

#line 1470 "runtime.in"
// pen linejoin(Int n);
void gen93(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 1471 "runtime.in"
  {Stack->push<pen>(pen(setlinejoin,n >= 0 && n < nJoin ? n : DEFJOIN)); return;}
}

#line 1475 "runtime.in"
// Int linejoin(pen p);
void gen94(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1476 "runtime.in"
  {Stack->push<Int>(p.join()); return;}  
}

#line 1480 "runtime.in"
// pen linewidth(real x);
void gen95(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 1481 "runtime.in"
  {Stack->push<pen>(pen(setlinewidth,x >= 0.0 ? x : DEFWIDTH)); return;}
}

#line 1485 "runtime.in"
// real linewidth(pen p);
void gen96(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1486 "runtime.in"
  {Stack->push<real>(p.width()); return;}  
}

#line 1490 "runtime.in"
// pen fontcommand(string *s);
void gen97(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 1491 "runtime.in"
  {Stack->push<pen>(pen(setfont,*s)); return;}
}

#line 1495 "runtime.in"
// string font(pen p);
void gen98(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1496 "runtime.in"
  {Stack->push<string>(p.Font()); return;}
}

#line 1500 "runtime.in"
// pen fontsize(real size, real lineskip);
void gen99(stack *Stack)
{
  real lineskip=vm::pop<real>(Stack);
  real size=vm::pop<real>(Stack);
#line 1501 "runtime.in"
  {Stack->push<pen>(pen(setfontsize,size > 0.0 ? size : 0.0,
	     lineskip > 0.0 ? lineskip : 0.0)); return;}
}

#line 1506 "runtime.in"
// real fontsize(pen p);
void gen100(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1507 "runtime.in"
  {Stack->push<real>(p.size()); return;}
}

#line 1511 "runtime.in"
// real lineskip(pen p);
void gen101(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1512 "runtime.in"
  {Stack->push<real>(p.Lineskip()); return;}  
}

#line 1516 "runtime.in"
// pen overwrite(Int n);
void gen102(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 1517 "runtime.in"
  {Stack->push<pen>(pen(setoverwrite,n >= 0 && n < nOverwrite ? (overwrite_t) n :
	     DEFWRITE)); return;}
}

#line 1522 "runtime.in"
// Int overwrite(pen p);
void gen103(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1523 "runtime.in"
  {Stack->push<Int>(p.Overwrite()); return;}  
}

#line 1527 "runtime.in"
// pen basealign(Int n);
void gen104(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 1528 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nBaseLine ? (BaseLine) n : DEFBASE)); return;}
}

#line 1532 "runtime.in"
// Int basealign(pen p);
void gen105(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1533 "runtime.in"
  {Stack->push<Int>(p.Baseline()); return;}
}

#line 1537 "runtime.in"
// transform transform(pen p);
void gen106(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1538 "runtime.in"
  {Stack->push<transform>(p.getTransform()); return;}
}

#line 1542 "runtime.in"
// path nib(pen p);
void gen107(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1543 "runtime.in"
  {Stack->push<path>(p.Path()); return;}
}

#line 1547 "runtime.in"
// pen makepen(path p);
void gen108(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1548 "runtime.in"
  {Stack->push<pen>(pen(p)); return;}
}

#line 1552 "runtime.in"
// pen colorless(pen p);
void gen109(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1553 "runtime.in"
  p.colorless();
  {Stack->push<pen>(p); return;}
}

// Interactive mode
#line 1559 "runtime.in"
// bool interactive();
void gen110(stack *Stack)
{
#line 1560 "runtime.in"
  {Stack->push<bool>(interact::interactive); return;}
}

#line 1565 "runtime.in"
// void uptodate(bool b);
void gen111(stack *Stack)
{
  bool b=vm::pop<bool>(Stack);
#line 1566 "runtime.in"
  interact::uptodate=b;
}

#line 1570 "runtime.in"
// bool uptodate();
void gen112(stack *Stack)
{
#line 1571 "runtime.in"
  {Stack->push<bool>(interact::uptodate); return;}
}


// System commands
#line 1577 "runtime.in"
// Int system(string *s);
void gen113(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 1578 "runtime.in"
  if(safe) error("system() call disabled; override with option -unsafe");
  else {Stack->push<Int>(System(s->c_str())); return;}
}

#line 1584 "runtime.in"
// void abort(string s=emptystring);
void gen114(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 1585 "runtime.in"
  if(s == "") throw handled_error();
  error(s.c_str());
}

#line 1590 "runtime.in"
// void exit();
void gen115(stack *)
{
#line 1591 "runtime.in"
  throw quit();
}

#line 1595 "runtime.in"
// void assert(bool b, string s=emptystring);
void gen116(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
  bool b=vm::pop<bool>(Stack);
#line 1596 "runtime.in"
  flush(cout);
  if(!b) {
    ostringstream buf;
    buf << "assert FAILED";
    if(s != "") buf << ": " << s << endl;
    error(buf);
  }
}

#line 1606 "runtime.in"
// void sleep(Int seconds);
void gen117(stack *Stack)
{
  Int seconds=vm::pop<Int>(Stack);
#line 1607 "runtime.in"
  sleep(seconds);
}

#line 1611 "runtime.in"
// void usleep(Int microseconds);
void gen118(stack *Stack)
{
  Int microseconds=vm::pop<Int>(Stack);
#line 1612 "runtime.in"
  usleep((unsigned long) microseconds); 
}

#line 1616 "runtime.in"
// void _eval(string *s, bool embedded, bool interactiveWrite=false);
void gen119(stack *Stack)
{
  bool interactiveWrite=vm::pop<bool>(Stack,false);
  bool embedded=vm::pop<bool>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 1617 "runtime.in"
  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runStringEmbedded(*s, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runString(*s,interactiveWrite);
  }
}

#line 1631 "runtime.in"
// void _eval(runnable *s, bool embedded);
void gen120(stack *Stack)
{
  bool embedded=vm::pop<bool>(Stack);
  runnable * s=vm::pop<runnable *>(Stack);
#line 1632 "runtime.in"
  absyntax::block *ast=new absyntax::block(s->getPos(), false);
  ast->add(s);

  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runCodeEmbedded(ast, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runCode(ast);
  }
}

#line 1649 "runtime.in"
// string location();
void gen121(stack *Stack)
{
#line 1650 "runtime.in"
  ostringstream buf;
  buf << getPos();
  {Stack->push<string>(buf.str()); return;}
}

// Wrapper for the stack::load() method.
#line 1656 "runtime.in"
void loadModule(stack *Stack)
{
  string * index=vm::pop<string *>(Stack);
#line 1657 "runtime.in"
  Stack->load(*index);
}

#line 1661 "runtime.in"
// string cd(string s=emptystring);
void gen123(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 1662 "runtime.in"
  if(!s.empty() && !globalwrite()) writeDisabled();
  {Stack->push<string>(setPath(s.c_str())); return;}
}

#line 1667 "runtime.in"
// void list(string *s, bool imports=false);
void gen124(stack *Stack)
{
  bool imports=vm::pop<bool>(Stack,false);
  string * s=vm::pop<string *>(Stack);
#line 1668 "runtime.in"
  if(*s == "-") return;
  trans::genv ge;
  symbol *name=symbol::trans(*s);
  record *r=ge.getModule(name,*s);
  r->e.list(imports ? 0 : r);
}


// Path operations
#line 1678 "runtime.in"
void nullPath(stack *Stack)
{
#line 1679 "runtime.in"
  {Stack->push<path>(nullpath); return;}
}

#line 1684 "runtime.in"
// bool ==(path a, path b);
void gen126(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 1685 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1689 "runtime.in"
// bool !=(path a, path b);
void gen127(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 1690 "runtime.in"
  {Stack->push<bool>(!(a == b)); return;}
}

#line 1694 "runtime.in"
// pair point(path p, Int t);
void gen128(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1695 "runtime.in"
  {Stack->push<pair>(p.point((Int) t)); return;}
}

#line 1699 "runtime.in"
// pair point(path p, real t);
void gen129(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1700 "runtime.in"
  {Stack->push<pair>(p.point(t)); return;}
}

#line 1704 "runtime.in"
// pair precontrol(path p, Int t);
void gen130(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1705 "runtime.in"
  {Stack->push<pair>(p.precontrol((Int) t)); return;}
}

#line 1709 "runtime.in"
// pair precontrol(path p, real t);
void gen131(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1710 "runtime.in"
  {Stack->push<pair>(p.precontrol(t)); return;}
}

#line 1714 "runtime.in"
// pair postcontrol(path p, Int t);
void gen132(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1715 "runtime.in"
  {Stack->push<pair>(p.postcontrol((Int) t)); return;}
}

#line 1719 "runtime.in"
// pair postcontrol(path p, real t);
void gen133(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1720 "runtime.in"
  {Stack->push<pair>(p.postcontrol(t)); return;}
}

#line 1724 "runtime.in"
// pair dir(path p, Int t, Int sign=0);
void gen134(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1725 "runtime.in"
  {Stack->push<pair>(p.dir((Int) t,sign)); return;}
}

#line 1729 "runtime.in"
// pair dir(path p, real t);
void gen135(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1730 "runtime.in"
  {Stack->push<pair>(p.dir(t)); return;}
}

#line 1734 "runtime.in"
// path reverse(path p);
void gen136(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1735 "runtime.in"
  {Stack->push<path>(p.reverse()); return;}
}

#line 1739 "runtime.in"
// path subpath(path p, Int a, Int b);
void gen137(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1740 "runtime.in"
  {Stack->push<path>(p.subpath((Int) a, (Int) b)); return;}
}

#line 1744 "runtime.in"
// path subpath(path p, real a, real b);
void gen138(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1745 "runtime.in"
  {Stack->push<path>(p.subpath(a,b)); return;}
}

#line 1749 "runtime.in"
// path nurb(pair z0, pair z1, pair z2, pair z3,	  double w0, double w1, double w2, double w3, Int m);
void gen139(stack *Stack)
{
  Int m=vm::pop<Int>(Stack);
  double w3=vm::pop<double>(Stack);
  double w2=vm::pop<double>(Stack);
  double w1=vm::pop<double>(Stack);
  double w0=vm::pop<double>(Stack);
  pair z3=vm::pop<pair>(Stack);
  pair z2=vm::pop<pair>(Stack);
  pair z1=vm::pop<pair>(Stack);
  pair z0=vm::pop<pair>(Stack);
#line 1751 "runtime.in"
  {Stack->push<path>(nurb(z0,z1,z2,z3,w0,w1,w2,w3,m)); return;}
}

#line 1755 "runtime.in"
// Int length(path p);
void gen140(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1756 "runtime.in"
  {Stack->push<Int>(p.length()); return;}
}

#line 1760 "runtime.in"
// bool cyclic(path p);
void gen141(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1761 "runtime.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 1765 "runtime.in"
// bool straight(path p, Int t);
void gen142(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 1766 "runtime.in"
  {Stack->push<bool>(p.straight(t)); return;}
}

#line 1770 "runtime.in"
// bool piecewisestraight(path p);
void gen143(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1771 "runtime.in"
  Int L=p.length();
  for(Int i=0; i < L; ++i)
    if(!p.straight(i)) {Stack->push<bool>(false); return;}
  {Stack->push<bool>(true); return;}
}

#line 1778 "runtime.in"
// real arclength(path p);
void gen144(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1779 "runtime.in"
  {Stack->push<real>(p.arclength()); return;}
}

#line 1783 "runtime.in"
// real arctime(path p, real dval);
void gen145(stack *Stack)
{
  real dval=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 1784 "runtime.in"
  {Stack->push<real>(p.arctime(dval)); return;}
}

#line 1788 "runtime.in"
// real dirtime(path p, pair z);
void gen146(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  path p=vm::pop<path>(Stack);
#line 1789 "runtime.in"
  {Stack->push<real>(p.directiontime(z)); return;}
}

#line 1793 "runtime.in"
// realarray* intersect(path p, path q, real fuzz=0);
void gen147(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,0);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 1794 "runtime.in"
  fuzz=::max(fuzz,Fuzz*::max(::max(length(p.max()),length(p.min())),
			     ::max(length(q.max()),length(q.min()))));
  real s,t;
  if(intersect(s,t,p,q,fuzz)) {
    array *T=new array(2);
    (*T)[0]=s;
    (*T)[1]=t;
    {Stack->push<realarray*>(T); return;}
  } else
    {Stack->push<realarray*>(new array(0)); return;}
}

#line 1807 "runtime.in"
// realarray2* intersections(path p, path q, real fuzz=0);
void gen148(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,0);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 1808 "runtime.in"
  fuzz=::max(fuzz,Fuzz*::max(::max(length(p.max()),length(p.min())),
			     ::max(length(q.max()),length(q.min()))));
  std::vector<real> S,T;
  intersections(S,T,p,q,fuzz);
  unsigned n=S.size();
  array *V=new array(n);
  for(unsigned i=0; i < n; ++i) {
    array *Vi=new array(2);
    (*V)[i]=Vi;
    (*Vi)[0]=S[i];
    (*Vi)[1]=T[i];
  }
  stable_sort(V->begin(),V->end(),compare2<double>());
  {Stack->push<realarray2*>(V); return;}
}

#line 1825 "runtime.in"
// Int size(path p);
void gen149(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1826 "runtime.in"
  {Stack->push<Int>(p.size()); return;}
}

#line 1830 "runtime.in"
// path &(path p, path q);
void gen150(stack *Stack)
{
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 1831 "runtime.in"
  {Stack->push<path>(camp::concat(p,q)); return;}
}

#line 1835 "runtime.in"
// pair min(path p);
void gen151(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1836 "runtime.in"
  {Stack->push<pair>(p.min()); return;}
}

#line 1840 "runtime.in"
// pair max(path p);
void gen152(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1841 "runtime.in"
  {Stack->push<pair>(p.max()); return;}
}

#line 1845 "runtime.in"
// real relativedistance(real theta, real phi, real t, bool atleast);
void gen153(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real t=vm::pop<real>(Stack);
  real phi=vm::pop<real>(Stack);
  real theta=vm::pop<real>(Stack);
#line 1846 "runtime.in"
  {Stack->push<real>(camp::velocity(theta,phi,tension(t,atleast))); return;}
}

#line 1850 "runtime.in"
// Int windingnumber(patharray *p, pair z);
void gen154(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  patharray * p=vm::pop<patharray *>(Stack);
#line 1851 "runtime.in"
  {Stack->push<Int>(windingnumber(p,z)); return;}
}

#line 1855 "runtime.in"
// bool inside(patharray *g, pair z, pen fillrule);
void gen155(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack);
  pair z=vm::pop<pair>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
#line 1856 "runtime.in"
  {Stack->push<bool>(fillrule.inside(windingnumber(g,z))); return;}
}


// Guide operations
#line 1862 "runtime.in"
void nullGuide(stack *Stack)
{
#line 1863 "runtime.in"
  {Stack->push<guide*>(new pathguide(path())); return;}
}

#line 1868 "runtime.in"
void dotsGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 1869 "runtime.in"
  guidevector v;
  size_t size=checkArray(a);
  for (size_t i=0; i < size; ++i)
    v.push_back(a->read<guide*>(i));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1878 "runtime.in"
void dashesGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 1879 "runtime.in"
  static camp::curlSpec curly;
  static specguide curlout(&curly, camp::OUT);
  static specguide curlin(&curly, camp::IN);

  size_t n=checkArray(a);

  // a--b is equivalent to a{curl 1}..{curl 1}b
  guidevector v;
  if (n > 0)
    v.push_back(a->read<guide*>(0));

  if (n==1) {
    v.push_back(&curlout);
    v.push_back(&curlin);
  }
  else
    for (size_t i=1; i<n; ++i) {
      v.push_back(&curlout);
      v.push_back(&curlin);
      v.push_back(a->read<guide*>(i));
    }

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1905 "runtime.in"
void newCycleToken(stack *Stack)
{
#line 1906 "runtime.in"
  {Stack->push<cycleToken>(cycleToken()); return;}
}

#line 1910 "runtime.in"
// guide* operator cast(cycleToken tok);
void gen160(stack *Stack)
{
  cycleToken tok=vm::pop<cycleToken>(Stack);
#line 1911 "runtime.in"
// Avoid unused variable warning messages.
  unused(&tok);
  {Stack->push<guide*>(new cycletokguide()); return;}
}

#line 1917 "runtime.in"
// guide* operator spec(pair z, Int p);
void gen161(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 1918 "runtime.in"
  camp::side d=(camp::side) p;
  camp::dirSpec *sp=new camp::dirSpec(z);

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 1925 "runtime.in"
// curlSpecifier operator curl(real gamma, Int p);
void gen162(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  real gamma=vm::pop<real>(Stack);
#line 1926 "runtime.in"
  camp::side s=(camp::side) p;
  {Stack->push<curlSpecifier>(curlSpecifier(gamma,s)); return;}
}

#line 1931 "runtime.in"
void curlSpecifierValuePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 1932 "runtime.in"
  {Stack->push<real>(spec.getValue()); return;}
}

#line 1936 "runtime.in"
void curlSpecifierSidePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 1937 "runtime.in"
  {Stack->push<Int>(spec.getSide()); return;}
}

#line 1941 "runtime.in"
// guide* operator cast(curlSpecifier spec);
void gen165(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 1942 "runtime.in"
  {Stack->push<guide*>(new specguide(spec)); return;}
}

#line 1946 "runtime.in"
// tensionSpecifier operator tension(real tout, real tin, bool atleast);
void gen166(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real tin=vm::pop<real>(Stack);
  real tout=vm::pop<real>(Stack);
#line 1947 "runtime.in"
  {Stack->push<tensionSpecifier>(tensionSpecifier(tout, tin, atleast)); return;}
}

#line 1951 "runtime.in"
void tensionSpecifierOutPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 1952 "runtime.in"
  {Stack->push<real>(t.getOut()); return;}
}

#line 1956 "runtime.in"
void tensionSpecifierInPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 1957 "runtime.in"
  {Stack->push<real>(t.getIn()); return;}
}

#line 1961 "runtime.in"
void tensionSpecifierAtleastPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 1962 "runtime.in"
  {Stack->push<bool>(t.getAtleast()); return;}
}

#line 1966 "runtime.in"
// guide* operator cast(tensionSpecifier t);
void gen170(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 1967 "runtime.in"
  {Stack->push<guide*>(new tensionguide(t)); return;}
}

#line 1971 "runtime.in"
// guide* operator controls(pair zout, pair zin);
void gen171(stack *Stack)
{
  pair zin=vm::pop<pair>(Stack);
  pair zout=vm::pop<pair>(Stack);
#line 1972 "runtime.in"
  {Stack->push<guide*>(new controlguide(zout, zin)); return;}
}

#line 1976 "runtime.in"
// Int size(guide *g);
void gen172(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 1977 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(f.size()); return;}
}

#line 1983 "runtime.in"
// Int length(guide *g);
void gen173(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 1984 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(g->cyclic() ? f.size() : f.size()-1); return;}
}

#line 1990 "runtime.in"
// bool cyclic(guide *g);
void gen174(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 1991 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<bool>(g->cyclic()); return;}
}

#line 1997 "runtime.in"
// pair point(guide *g, Int t);
void gen175(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 1998 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<pair>(f.Nodes(adjustedIndex(t,f.size(),g->cyclic())).z); return;}
}

#line 2004 "runtime.in"
// pairarray* dirSpecifier(guide *g, Int t);
void gen176(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 2005 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  array *c=new array(2);
  Int n=f.size();
  if(g->cyclic()) t=t % n;
  else if(t < 0 || t >= n-1) {
    static pair zero;
    (*c)[0]=zero;
    (*c)[1]=zero;
    {Stack->push<pairarray*>(c); return;}
  }
  (*c)[0]=f.Nodes(t).out->dir();
  (*c)[1]=f.Nodes(t+1).in->dir();
  {Stack->push<pairarray*>(c); return;}
}

#line 2022 "runtime.in"
// pairarray* controlSpecifier(guide *g, Int t);
void gen177(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 2023 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(g->cyclic()) t=t % n;
  else if(t < 0 || t >= n-1) {Stack->push<pairarray*>(new array(0)); return;}
  knot curr=f.Nodes(t);
  knot next=f.Nodes(t+1);
  if(curr.out->controlled()) {
    array *c;
    assert(next.in->controlled());
    c=new array(2);
    (*c)[0]=curr.out->control();
    (*c)[1]=next.in->control();
    {Stack->push<pairarray*>(c); return;}
  } else {Stack->push<pairarray*>(new array(0)); return;}
}

#line 2041 "runtime.in"
// tensionSpecifier tensionSpecifier(guide *g, Int t);
void gen178(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 2042 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(g->cyclic()) t=t % n;
  else if(t < 0 || t >= n-1) {Stack->push<tensionSpecifier>(tensionSpecifier(1.0,1.0,false)); return;}
  knot curr=f.Nodes(t);
  knot next=f.Nodes(t+1);
  {Stack->push<tensionSpecifier>(tensionSpecifier(curr.tout.val,next.tin.val,curr.tout.atleast)); return;}
}

#line 2053 "runtime.in"
// realarray* curlSpecifier(guide *g);
void gen179(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 2054 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  array *c=new array(2);
  real c0=f.Nodes(0).out->curl();
  real c1=f.Nodes(f.size()-1).in->curl();
  if(c1 < 0.0) c1=f.Nodes(f.size()-1).out->curl();
  (*c)[0]=c0 >= 0.0 ? c0 : 1.0;
  (*c)[1]=c1 >= 0.0 ? c1 : 1.0;
  {Stack->push<realarray*>(c); return;}
}

#line 2066 "runtime.in"
// guide* reverse(guide *g);
void gen180(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 2067 "runtime.in"
  flatguide f;
  bool precycle=g->flatten(f,false);
  if(precycle && g->cyclic()) {
    path p=g->solve();
    {Stack->push<guide*>(new pathguide(p.reverse())); return;}
  }
  Int n=f.size();

  guidevector v;
  if(n >= 0) {
    v.push_back(new pairguide(f.Nodes(n-1).z));
    
    real c0=f.Nodes(0).out->curl();
    real c1=f.Nodes(f.size()-1).in->curl();
    if(c1 < 0.0)
      c1=f.Nodes(f.size()-1).out->curl();
    if(c1 >= 0.0)
      v.push_back(new specguide(new curlSpec(c1),camp::OUT));
  
    for(Int i=n-2; i >= 0; --i) {
      knot curr=f.Nodes(i);
      knot next=f.Nodes(i+1);
      if(curr.out->controlled()) {
	assert(next.in->controlled());
	v.push_back(new controlguide(next.in->control(),curr.out->control()));
      } else {
	pair d=f.Nodes(i+1).in->dir();
	static pair zero;
	if(d != zero) 
	  v.push_back(new specguide(new dirSpec(-d),camp::OUT));
	real tout=next.tin.val;
	real tin=curr.tout.val;
	bool atleast=curr.tout.atleast;
	if(tout != 1.0 || tin != 1.0 || curr.tout.atleast)
	  v.push_back(new tensionguide(tensionSpecifier(tout,tin,atleast)));
	d=f.Nodes(i).out->dir();	
	if(d != zero) 
	  v.push_back(new specguide(new dirSpec(-d),camp::IN));

      }
      if(i == 0 && c0 >= 0.0)
	v.push_back(new specguide(new curlSpec(c0),camp::IN));
      v.push_back(new pairguide(f.Nodes(i).z));
    }
    if(g->cyclic())
      v.push_back(new cycletokguide());
  }
  {Stack->push<guide*>(new multiguide(v)); return;}
}


// String operations
#line 2120 "runtime.in"
void emptyString(stack *Stack)
{
#line 2121 "runtime.in"
  {Stack->push<string>(emptystring); return;}
}

#line 2126 "runtime.in"
// Int length(string *s);
void gen182(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 2127 "runtime.in"
  {Stack->push<Int>((Int) s->length()); return;}
}

#line 2131 "runtime.in"
// Int find(string *s, string t, Int pos=0);
void gen183(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack,0);
  string t=vm::pop<string>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 2132 "runtime.in"
  size_t n=s->find(t,pos);
  {Stack->push<Int>(n == string::npos ? (Int) -1 : (Int) n); return;}
}

#line 2137 "runtime.in"
// Int rfind(string *s, string t, Int pos=-1);
void gen184(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack,-1);
  string t=vm::pop<string>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 2138 "runtime.in"
  size_t n=s->rfind(t,pos);
  {Stack->push<Int>(n == string::npos ? (Int) -1 : (Int) n); return;}
}

#line 2143 "runtime.in"
// string reverse(string s);
void gen185(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 2144 "runtime.in"
  reverse(s.begin(),s.end());
  {Stack->push<string>(s); return;}
}

#line 2149 "runtime.in"
// string insert(string s, Int pos, string t);
void gen186(stack *Stack)
{
  string t=vm::pop<string>(Stack);
  Int pos=vm::pop<Int>(Stack);
  string s=vm::pop<string>(Stack);
#line 2150 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.insert(pos,t)); return;}
  {Stack->push<string>(s); return;}
}

#line 2156 "runtime.in"
// string substr(string* s, Int pos, Int n=-1);
void gen187(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,-1);
  Int pos=vm::pop<Int>(Stack);
  string* s=vm::pop<string*>(Stack);
#line 2157 "runtime.in"
  if ((size_t) pos < s->length())
    {Stack->push<string>(s->substr(pos,n)); return;}
  {Stack->push<string>(emptystring); return;}
}

#line 2163 "runtime.in"
// string erase(string s, Int pos, Int n);
void gen188(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  Int pos=vm::pop<Int>(Stack);
  string s=vm::pop<string>(Stack);
#line 2164 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.erase(pos,n)); return;}
  {Stack->push<string>(s); return;} 
}

#line 2170 "runtime.in"
// string downcase(string s);
void gen189(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 2171 "runtime.in"
  std::transform(s.begin(),s.end(),s.begin(),tolower);
  {Stack->push<string>(s); return;}
}

#line 2176 "runtime.in"
// string upcase(string s);
void gen190(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 2177 "runtime.in"
  std::transform(s.begin(),s.end(),s.begin(),toupper);
  {Stack->push<string>(s); return;}
}

// returns a string constructed by translating all occurrences of the string
// from in an array of string pairs {from,to} to the string to in string s.
#line 2184 "runtime.in"
// string replace(string *S, stringarray2 *translate);
void gen191(stack *Stack)
{
  stringarray2 * translate=vm::pop<stringarray2 *>(Stack);
  string * S=vm::pop<string *>(Stack);
#line 2185 "runtime.in"
  size_t size=checkArray(translate);
  for(size_t i=0; i < size; i++) {
    array *a=read<array*>(translate,i);
    checkArray(a);
  }
  const char *p=S->c_str();
  ostringstream buf;
  while(*p) {
    for(size_t i=0; i < size;) {
      array *a=read<array*>(translate,i);
      string* from=read<string*>(a,0);
      size_t len=from->length();
      if(strncmp(p,from->c_str(),len) != 0) {i++; continue;}
      buf << read<string>(a,1);
      p += len;
      if(*p == 0) {Stack->push<string>(buf.str()); return;}
      i=0;
    }
    buf << *(p++);
  }
  {Stack->push<string>(buf.str()); return;}
}

#line 2209 "runtime.in"
// string format(string *format, Int x);
void gen192(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
  string * format=vm::pop<string *>(Stack);
#line 2210 "runtime.in"
  const char *f=format->c_str();
  
  checkformat(f,true);
  
  Int size=snprintf(NULL,0,f,x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f,x);
  string s=string(buf);
  delete[] buf;
  {Stack->push<string>(s); return;}
}

#line 2224 "runtime.in"
// string format(string *format, real x);
void gen193(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  string * format=vm::pop<string *>(Stack);
#line 2225 "runtime.in"
  ostringstream out;
  
  checkformat(format->c_str(),false);
  
  const char *phantom="\\phantom{+}";
  const char *p0=format->c_str();
  
  const char *p=p0;
  const char *start=NULL;
  while (*p != 0) {
    if(*p == '%') {
      p++;
      if(*p != '%') {start=p-1; break;}
    }
    out << *(p++);
  }
  
  if(!start) {Stack->push<string>(out.str()); return;}
  
  // Allow at most 1 argument  
  while (*p != 0) {
    if(*p == '*' || *p == '$') {Stack->push<string>(out.str()); return;}
    if(isupper(*p) || islower(*p)) {p++; break;}
    p++;
  }
  
  const char *tail=p;
  string f=format->substr(start-p0,tail-start);
  Int size=snprintf(NULL,0,f.c_str(),x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f.c_str(),x);

  bool trailingzero=f.find("#") < string::npos;
  bool plus=f.find("+") < string::npos;
  bool space=f.find(" ") < string::npos;
  
  char *q=buf; // beginning of formatted number

  if(*q == ' ') {
    out << phantom;
    q++;
  }
  
  const char decimal=*(localeconv()->decimal_point);

  // Remove any spurious sign
  if(*q == '-' || *q == '+') {
    p=q+1;
    bool zero=true;
    while(*p != 0) {
      if(!isdigit(*p) && *p != decimal) break;
      if(isdigit(*p) && *p != '0') {zero=false; break;}
      p++;
    }
    if(zero) {
      q++;
      if(plus || space) out << phantom;
    }
  }
  
  const char *r=p=q;
  bool dp=false;
  while(*r != 0 && (isdigit(*r) || *r == decimal || *r == '+' || *r == '-')) {
    if(*r == decimal) dp=true;
    r++;
  }
  if(dp) { // Remove trailing zeros and/or decimal point
    r--;
    unsigned n=0;
    while(r > q && *r == '0') {r--; n++;}
    if(*r == decimal) {r--; n++;}
    while(q <= r) out << *(q++);
    if(!trailingzero) q += n;
  }
  
  bool zero=(r == p && *r == '0') && !trailingzero;
  
  // Translate "E+/E-/e+/e-" exponential notation to TeX
  while(*q != 0) {
    if((*q == 'E' || *q == 'e') && (*(q+1) == '+' || *(q+1) == '-')) {
      if(!zero) out << "\\!\\times\\!10^{";
      bool plus=(*(q+1) == '+');
      q++;
      if(plus) q++;
      if(*q == '-') out << *(q++);
      while(*q == '0' && (zero || isdigit(*(q+1)))) q++;
      while(isdigit(*q)) out << *(q++);
      if(!zero) {
	if(plus) out << phantom;
	out << "}";
      }
      break;
    }
    out << *(q++);
  }
  
  while(*tail != 0) 
    out << *(tail++);
  
  delete[] buf;
  {Stack->push<string>(out.str()); return;}
}

#line 2330 "runtime.in"
// string string(real x, Int digits);
void gen194(stack *Stack)
{
  Int digits=vm::pop<Int>(Stack);
  real x=vm::pop<real>(Stack);
#line 2331 "runtime.in"
  ostringstream buf;
  buf.precision(digits);
  buf << x;
  {Stack->push<string>(buf.str()); return;}
}

#line 2338 "runtime.in"
// string time(string format=defaulttimeformat);
void gen195(stack *Stack)
{
  string format=vm::pop<string>(Stack,defaulttimeformat);
#line 2339 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=time(NULL);
  if(!strftime(Time,nTime,format.c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
  {Stack->push<string>(format); return;}
#endif  
}

#line 2349 "runtime.in"
// string time(Int seconds, string format=defaulttimeformat);
void gen196(stack *Stack)
{
  string format=vm::pop<string>(Stack,defaulttimeformat);
  Int seconds=vm::pop<Int>(Stack);
#line 2350 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=seconds;
  if(!strftime(Time,nTime,format.c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
// Avoid unused variable warning messages
  unused(&seconds);
  {Stack->push<string>(format); return;}
#endif
}

#line 2362 "runtime.in"
// Int seconds(string t=emptystring, string format=emptystring);
void gen197(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string t=vm::pop<string>(Stack,emptystring);
#line 2363 "runtime.in"
#if defined(HAVE_STRPTIME)
  const time_t bintime=time(NULL);
  tm tm=*localtime(&bintime);
  if(t != "" && !strptime(t.c_str(),format.c_str(),&tm)) {Stack->push<Int>(-1); return;}
  {Stack->push<Int>((Int) mktime(&tm)); return;}
#else
  {Stack->push<Int>(-1); return;}
#endif  
}

#line 2374 "runtime.in"
// realarray* _cputime();
void gen198(stack *Stack)
{
#line 2375 "runtime.in"
  static const real ticktime=1.0/sysconf(_SC_CLK_TCK);
  struct tms buf;

  ::times(&buf);
  array *t=new array(4);
  (*t)[0] = ((real) buf.tms_utime)*ticktime;
  (*t)[1] = ((real) buf.tms_stime)*ticktime;
  (*t)[2] = ((real) buf.tms_cutime)*ticktime;
  (*t)[3] = ((real) buf.tms_cstime)*ticktime;
  {Stack->push<realarray*>(t); return;}
}


// Math
#line 2390 "runtime.in"
// real ^(real x, Int y);
void gen199(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  real x=vm::pop<real>(Stack);
#line 2391 "runtime.in"
  {Stack->push<real>(pow(x,y)); return;}
}

#line 2396 "runtime.in"
// pair ^(pair z, Int y);
void gen200(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 2397 "runtime.in"
  {Stack->push<pair>(pow(z,y)); return;}
}

#line 2401 "runtime.in"
// Int quotient(Int x, Int y);
void gen201(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  Int x=vm::pop<Int>(Stack);
#line 2402 "runtime.in" 
  if(y == 0) dividebyzero();
  if(y == -1) {Stack->push<Int>(Negate(x)); return;}
// Implementation-independent definition of integer division: round down
  {Stack->push<Int>((x-portableMod(x,y))/y); return;}
}

#line 2409 "runtime.in"
// Int abs(Int x);
void gen202(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 2410 "runtime.in" 
  {Stack->push<Int>(Abs(x)); return;}
}

#line 2414 "runtime.in"
// Int sgn(real x);
void gen203(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2415 "runtime.in" 
  {Stack->push<Int>(sgn(x)); return;}
}

#line 2419 "runtime.in"
// Int rand();
void gen204(stack *Stack)
{
#line 2420 "runtime.in" 
  {Stack->push<Int>(rand()); return;}
}

#line 2424 "runtime.in"
// void srand(Int seed);
void gen205(stack *Stack)
{
  Int seed=vm::pop<Int>(Stack);
#line 2425 "runtime.in" 
  srand(intcast(seed));
}

#line 2429 "runtime.in"
// Int ceil(real x);
void gen206(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2430 "runtime.in" 
  {Stack->push<Int>(Intcast(ceil(x))); return;}
}

#line 2434 "runtime.in"
// Int floor(real x);
void gen207(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2435 "runtime.in" 
  {Stack->push<Int>(Intcast(floor(x))); return;}
}

#line 2439 "runtime.in"
// Int round(real x);
void gen208(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2440 "runtime.in" 
  if(validInt(x)) {Stack->push<Int>(Round(x)); return;}
  integeroverflow(0);
}

#line 2445 "runtime.in"
// Int Ceil(real x);
void gen209(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2446 "runtime.in" 
  {Stack->push<Int>(Ceil(x)); return;}
}

#line 2450 "runtime.in"
// Int Floor(real x);
void gen210(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2451 "runtime.in" 
  {Stack->push<Int>(Floor(x)); return;}
}

#line 2455 "runtime.in"
// Int Round(real x);
void gen211(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2456 "runtime.in" 
  {Stack->push<Int>(Round(Intcap(x))); return;}
}

#line 2460 "runtime.in"
// real fmod(real x, real y);
void gen212(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2461 "runtime.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<real>(fmod(x,y)); return;}
}

#line 2466 "runtime.in"
// real atan2(real y, real x);
void gen213(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
#line 2467 "runtime.in" 
  {Stack->push<real>(atan2(y,x)); return;}
}

#line 2471 "runtime.in"
// real hypot(real x, real y);
void gen214(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2472 "runtime.in" 
  {Stack->push<real>(hypot(x,y)); return;}
}

#line 2476 "runtime.in"
// real remainder(real x, real y);
void gen215(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2477 "runtime.in" 
  {Stack->push<real>(remainder(x,y)); return;}
}

#line 2481 "runtime.in"
// real J(Int n, real x);
void gen216(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 2482 "runtime.in"
  {Stack->push<real>(jn(n,x)); return;}
}

#line 2486 "runtime.in"
// real Y(Int n, real x);
void gen217(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 2487 "runtime.in"
  {Stack->push<real>(yn(n,x)); return;}
}

#line 2491 "runtime.in"
// real erf(real x);
void gen218(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2492 "runtime.in"
  {Stack->push<real>(erf(x)); return;}
}

#line 2496 "runtime.in"
// real erfc(real x);
void gen219(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2497 "runtime.in"
  {Stack->push<real>(erfc(x)); return;}
}

#line 2501 "runtime.in"
// real gamma(real x);
void gen220(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2502 "runtime.in"
#ifdef HAVE_TGAMMA
  {Stack->push<real>(tgamma(x)); return;}
#else
 real lg = lgamma(x);
 {Stack->push<real>(signgam*exp(lg)); return;}
#endif
}

#line 2511 "runtime.in"
// realarray* quadraticroots(real a, real b, real c);
void gen221(stack *Stack)
{
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 2512 "runtime.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 2520 "runtime.in"
// pairarray* quadraticroots(explicit pair a, explicit pair b, explicit pair c);
void gen222(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 2521 "runtime.in"
  Quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.z1;
  if(q.roots == 2) (*roots)[1]=q.z2;
  {Stack->push<pairarray*>(roots); return;}
}

#line 2529 "runtime.in"
// realarray* cubicroots(real a, real b, real c, real d);
void gen223(stack *Stack)
{
  real d=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 2530 "runtime.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}

  
// Transforms
#line 2541 "runtime.in"
// bool ==(transform a, transform b);
void gen224(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 2542 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 2547 "runtime.in"
// bool !=(transform a, transform b);
void gen225(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 2548 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 2552 "runtime.in"
// transform +(transform a, transform b);
void gen226(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 2553 "runtime.in"
  {Stack->push<transform>(a+b); return;}
}

#line 2557 "runtime.in"
// transform *(transform a, transform b);
void gen227(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 2558 "runtime.in"
  {Stack->push<transform>(a*b); return;}
}

#line 2562 "runtime.in"
// pair *(transform t, pair z);
void gen228(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 2563 "runtime.in"
  {Stack->push<pair>(t*z); return;}
}

#line 2567 "runtime.in"
// path *(transform t, path g);
void gen229(stack *Stack)
{
  path g=vm::pop<path>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 2568 "runtime.in"
  {Stack->push<path>(transformed(t,g)); return;}
}

#line 2572 "runtime.in"
// pen *(transform t, pen p);
void gen230(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 2573 "runtime.in"
  {Stack->push<pen>(transformed(t,p)); return;}
}

#line 2577 "runtime.in"
// picture* *(transform t, picture *f);
void gen231(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 2578 "runtime.in"
  {Stack->push<picture*>(transformed(t,f)); return;}
}

#line 2582 "runtime.in"
// transform ^(transform t, Int n);
void gen232(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 2583 "runtime.in"
  transform T;
  if(n < 0) {
    n=-n;
    t=inverse(t);
  }
  for(Int i=0; i < n; i++) T=T*t;
  {Stack->push<transform>(T); return;}
}

#line 2593 "runtime.in"
void transformXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2594 "runtime.in"
  {Stack->push<real>(t.getx()); return;}
}

#line 2598 "runtime.in"
void transformYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2599 "runtime.in"
  {Stack->push<real>(t.gety()); return;}
}

#line 2603 "runtime.in"
void transformXXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2604 "runtime.in"
  {Stack->push<real>(t.getxx()); return;}
}

#line 2608 "runtime.in"
void transformXYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2609 "runtime.in"
  {Stack->push<real>(t.getxy()); return;}
}

#line 2613 "runtime.in"
void transformYXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2614 "runtime.in"
  {Stack->push<real>(t.getyx()); return;}
}

#line 2618 "runtime.in"
void transformYYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2619 "runtime.in"
  {Stack->push<real>(t.getyy()); return;}
}

#line 2623 "runtime.in"
void real6ToTransform(stack *Stack)
{
  real yy=vm::pop<real>(Stack);
  real yx=vm::pop<real>(Stack);
  real xy=vm::pop<real>(Stack);
  real xx=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2625 "runtime.in"
  {Stack->push<transform>(transform(x,y,xx,xy,yx,yy)); return;}
}

#line 2629 "runtime.in"
// transform shift(transform t);
void gen240(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2630 "runtime.in"
  {Stack->push<transform>(transform(t.getx(),t.gety(),0,0,0,0)); return;}
}

#line 2634 "runtime.in"
// transform shiftless(transform t);
void gen241(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2635 "runtime.in"
  {Stack->push<transform>(transform(0,0,t.getxx(),t.getxy(),t.getyx(),t.getyy())); return;}
}

#line 2639 "runtime.in"
// transform identity();
void transformIdentity(stack *Stack)
{
#line 2640 "runtime.in"
  {Stack->push<transform>(identity); return;}
}

#line 2644 "runtime.in"
// transform inverse(transform t);
void gen243(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 2645 "runtime.in"
  {Stack->push<transform>(inverse(t)); return;}
}

#line 2649 "runtime.in"
// transform shift(pair z);
void gen244(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2650 "runtime.in"
  {Stack->push<transform>(shift(z)); return;}
}

#line 2654 "runtime.in"
// transform shift(real x, real y);
void gen245(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2655 "runtime.in"
  {Stack->push<transform>(shift(pair(x,y))); return;}
}

#line 2659 "runtime.in"
// transform xscale(real x);
void gen246(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2660 "runtime.in"
  {Stack->push<transform>(xscale(x)); return;}
}

#line 2664 "runtime.in"
// transform yscale(real y);
void gen247(stack *Stack)
{
  real y=vm::pop<real>(Stack);
#line 2665 "runtime.in"
  {Stack->push<transform>(yscale(y)); return;}
}

#line 2669 "runtime.in"
// transform scale(real x);
void gen248(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2670 "runtime.in"
  {Stack->push<transform>(scale(x)); return;}
}

#line 2674 "runtime.in"
// transform scale(real x, real y);
void gen249(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2675 "runtime.in"
  {Stack->push<transform>(xscale(x)*yscale(y)); return;}
}

#line 2679 "runtime.in"
// transform slant(real s);
void gen250(stack *Stack)
{
  real s=vm::pop<real>(Stack);
#line 2680 "runtime.in"
  {Stack->push<transform>(slant(s)); return;}
}

#line 2684 "runtime.in"
// transform rotate(real angle, pair z=0);
void gen251(stack *Stack)
{
  pair z=vm::pop<pair>(Stack,0);
  real angle=vm::pop<real>(Stack);
#line 2685 "runtime.in"
  {Stack->push<transform>(rotatearound(z,radians(angle))); return;}
}

#line 2689 "runtime.in"
// transform reflect(pair a, pair b);
void gen252(stack *Stack)
{
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 2690 "runtime.in"
  {Stack->push<transform>(reflectabout(a,b)); return;}
}


// Pair operations
#line 2696 "runtime.in"
void pairZero(stack *Stack)
{
#line 2697 "runtime.in"
  static pair zero;
  {Stack->push<pair>(zero); return;}
}

#line 2703 "runtime.in"
void realRealToPair(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2704 "runtime.in"
  {Stack->push<pair>(pair(x,y)); return;}
}

#line 2708 "runtime.in"
void pairNegate(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2709 "runtime.in"
  {Stack->push<pair>(-z); return;}
}

#line 2713 "runtime.in"
// real xpart(pair z);
void pairXPart(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2714 "runtime.in"
  {Stack->push<real>(z.getx()); return;}
}

#line 2718 "runtime.in"
// real ypart(pair z);
void pairYPart(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2719 "runtime.in"
  {Stack->push<real>(z.gety()); return;}
}

#line 2723 "runtime.in"
// real length(pair z);
void gen258(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2724 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

#line 2728 "runtime.in"
// real abs(pair z);
void gen259(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2729 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

#line 2733 "runtime.in"
// pair sqrt(explicit pair z);
void gen260(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2734 "runtime.in"
  {Stack->push<pair>(Sqrt(z)); return;}
}

// Return the angle of z in radians.
#line 2739 "runtime.in"
// real angle(pair z, bool warn=true);
void gen261(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  pair z=vm::pop<pair>(Stack);
#line 2740 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(z.angle()); return;}
}

// Return the angle of z in degrees in the interval [0,360).
#line 2746 "runtime.in"
// real degrees(pair z, bool warn=true);
void gen262(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  pair z=vm::pop<pair>(Stack);
#line 2747 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(z.angle()))); return;}
}

// Convert degrees to radians.
#line 2753 "runtime.in"
// real radians(real degrees);
void gen263(stack *Stack)
{
  real degrees=vm::pop<real>(Stack);
#line 2754 "runtime.in"
  {Stack->push<real>(radians(degrees)); return;}
}

// Convert radians to degrees.
#line 2759 "runtime.in"
// real degrees(real radians);
void gen264(stack *Stack)
{
  real radians=vm::pop<real>(Stack);
#line 2760 "runtime.in"
  {Stack->push<real>(degrees(radians)); return;}
}

// Convert radians to degrees in [0,360).
#line 2765 "runtime.in"
// real Degrees(real radians);
void gen265(stack *Stack)
{
  real radians=vm::pop<real>(Stack);
#line 2766 "runtime.in"
  {Stack->push<real>(principalBranch(degrees(radians))); return;}
}

#line 2770 "runtime.in"
// real Sin(real deg);
void gen266(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 2771 "runtime.in"
  {Stack->push<real>(sin(radians(deg))); return;}
}

#line 2775 "runtime.in"
// real Cos(real deg);
void gen267(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 2776 "runtime.in"
  {Stack->push<real>(cos(radians(deg))); return;}
}

#line 2780 "runtime.in"
// real Tan(real deg);
void gen268(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 2781 "runtime.in"
  {Stack->push<real>(tan(radians(deg))); return;}
}

#line 2785 "runtime.in"
// real aSin(real x);
void gen269(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2786 "runtime.in"
  {Stack->push<real>(degrees(asin(x))); return;}
}

#line 2790 "runtime.in"
// real aCos(real x);
void gen270(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2791 "runtime.in"
  {Stack->push<real>(degrees(acos(x))); return;}
}

#line 2795 "runtime.in"
// real aTan(real x);
void gen271(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2796 "runtime.in"
  {Stack->push<real>(degrees(atan(x))); return;}
}

#line 2800 "runtime.in"
// pair unit(pair z);
void gen272(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2801 "runtime.in"
  {Stack->push<pair>(unit(z)); return;}
}

#line 2805 "runtime.in"
// pair dir(real theta);
void gen273(stack *Stack)
{
  real theta=vm::pop<real>(Stack);
#line 2806 "runtime.in"
  {Stack->push<pair>(expi(radians(theta))); return;}
}

#line 2810 "runtime.in"
// pair expi(real theta);
void gen274(stack *Stack)
{
  real theta=vm::pop<real>(Stack);
#line 2811 "runtime.in"
  {Stack->push<pair>(expi(theta)); return;}
}

#line 2815 "runtime.in"
// pair conj(pair z);
void gen275(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 2816 "runtime.in"
  {Stack->push<pair>(conj(z)); return;}
}

#line 2820 "runtime.in"
// pair realmult(pair z, pair w);
void gen276(stack *Stack)
{
  pair w=vm::pop<pair>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 2821 "runtime.in"
  {Stack->push<pair>(pair (z.getx()*w.getx(),z.gety()*w.gety())); return;}
}

// To avoid confusion, a dot product requires explicit pair arguments.
#line 2826 "runtime.in"
// real dot(explicit pair z, explicit pair w);
void gen277(stack *Stack)
{
  pair w=vm::pop<pair>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 2827 "runtime.in"
  {Stack->push<real>(z.getx()*w.getx()+z.gety()*w.gety()); return;}
}


// Triple operations
#line 2833 "runtime.in"
void tripleZero(stack *Stack)
{
#line 2834 "runtime.in"
  static triple zero;
  {Stack->push<triple>(zero); return;}
}

#line 2840 "runtime.in"
void realRealRealToTriple(stack *Stack)
{
  real z=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 2841 "runtime.in"
  {Stack->push<triple>(triple(x,y,z)); return;}
}

#line 2845 "runtime.in"
// real xpart(triple v);
void tripleXPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2846 "runtime.in"
  {Stack->push<real>(v.getx()); return;}
}

#line 2850 "runtime.in"
// real ypart(triple v);
void tripleYPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2851 "runtime.in"
  {Stack->push<real>(v.gety()); return;}
}

#line 2855 "runtime.in"
// real zpart(triple v);
void tripleZPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2856 "runtime.in"
  {Stack->push<real>(v.getz()); return;}
}

#line 2860 "runtime.in"
// triple *(real x, triple v);
void gen283(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  real x=vm::pop<real>(Stack);
#line 2861 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 2865 "runtime.in"
// triple *(triple v, real x);
void gen284(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 2866 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 2870 "runtime.in"
// triple /(triple v, real x);
void gen285(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 2871 "runtime.in"
  {Stack->push<triple>(v/x); return;}
}

#line 2875 "runtime.in"
// real length(triple v);
void gen286(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2876 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 2880 "runtime.in"
// real abs(triple v);
void gen287(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2881 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 2885 "runtime.in"
// real polar(triple v);
void gen288(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2886 "runtime.in"
  {Stack->push<real>(v.polar()); return;}
}

#line 2890 "runtime.in"
// real azimuth(triple v);
void gen289(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2891 "runtime.in"
  {Stack->push<real>(v.azimuth()); return;}
}

#line 2895 "runtime.in"
// real colatitude(triple v);
void gen290(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2896 "runtime.in"
  {Stack->push<real>(degrees(v.polar())); return;}
}

#line 2900 "runtime.in"
// real latitude(triple v);
void gen291(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2901 "runtime.in"
  {Stack->push<real>(90.0-degrees(v.polar())); return;}
}

// Return the longitude of v in [0,360).
#line 2906 "runtime.in"
// real longitude(triple v, bool warn=true);
void gen292(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 2907 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(v.azimuth()))); return;}
}

#line 2912 "runtime.in"
// triple unit(triple v);
void gen293(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 2913 "runtime.in"
  {Stack->push<triple>(unit(v)); return;}
}

#line 2917 "runtime.in"
// real dot(triple u, triple v);
void gen294(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  triple u=vm::pop<triple>(Stack);
#line 2918 "runtime.in"
  {Stack->push<real>(u.getx()*v.getx()+u.gety()*v.gety()+u.getz()*v.getz()); return;}
}

#line 2922 "runtime.in"
// triple cross(triple u, triple v);
void gen295(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  triple u=vm::pop<triple>(Stack);
#line 2923 "runtime.in"
  {Stack->push<triple>(triple(u.gety()*v.getz()-u.getz()*v.gety(),
		u.getz()*v.getx()-u.getx()*v.getz(),
		u.getx()*v.gety()-v.getx()*u.gety())); return;}
}

#line 2929 "runtime.in"
// triple expi(real theta, real phi);
void gen296(stack *Stack)
{
  real phi=vm::pop<real>(Stack);
  real theta=vm::pop<real>(Stack);
#line 2930 "runtime.in"
  {Stack->push<triple>(expi(theta,phi)); return;}
  real sintheta=sin(theta);
  {Stack->push<triple>(triple(sintheta*cos(phi),sintheta*sin(phi),cos(theta))); return;}
}

#line 2936 "runtime.in"
// triple dir(real theta, real phi);
void gen297(stack *Stack)
{
  real phi=vm::pop<real>(Stack);
  real theta=vm::pop<real>(Stack);
#line 2937 "runtime.in"
  {Stack->push<triple>(expi(radians(theta),radians(phi))); return;}
}

#line 2941 "runtime.in"
// real cubiclength(triple z0, triple z0p, triple z1m, triple z1, real goal);
void gen298(stack *Stack)
{
  real goal=vm::pop<real>(Stack);
  triple z1=vm::pop<triple>(Stack);
  triple z1m=vm::pop<triple>(Stack);
  triple z0p=vm::pop<triple>(Stack);
  triple z0=vm::pop<triple>(Stack);
#line 2942 "runtime.in"
  {Stack->push<real>(cubiclength(z0,z0p,z1m,z1,goal)); return;}
}


// System routines
#line 2948 "runtime.in"
// string VERSION();
void gen299(stack *Stack)
{
#line 2949 "runtime.in"
  {Stack->push<string>(VERSION); return;}
}

#line 2954 "runtime.in"
// void atexit(callable *f);
void gen300(stack *Stack)
{
  callable * f=vm::pop<callable *>(Stack);
#line 2955 "runtime.in"
  processData().atExitFunction=f;
}

#line 2959 "runtime.in"
// callable* atexit();
void gen301(stack *Stack)
{
#line 2960 "runtime.in"
  {Stack->push<callable*>(processData().atExitFunction); return;}
}

#line 2964 "runtime.in"
// void atbreakpoint(callableBp *f);
void gen302(stack *Stack)
{
  callableBp * f=vm::pop<callableBp *>(Stack);
#line 2965 "runtime.in"
  processData().atBreakpointFunction=f;
}

#line 2969 "runtime.in"
// void breakpoint(runnable *s=NULL);
void gen303(stack *Stack)
{
  runnable * s=vm::pop<runnable *>(Stack,NULL);
#line 2970 "runtime.in"
  breakpoint(Stack,s);
}

#line 2974 "runtime.in"
// string locatefile(string file);
void gen304(stack *Stack)
{
  string file=vm::pop<string>(Stack);
#line 2975 "runtime.in"
  {Stack->push<string>(locateFile(file)); return;}
}

#line 2979 "runtime.in"
// void stop(string file, Int line, runnable *s=NULL);
void gen305(stack *Stack)
{
  runnable * s=vm::pop<runnable *>(Stack,NULL);
  Int line=vm::pop<Int>(Stack);
  string file=vm::pop<string>(Stack);
#line 2980 "runtime.in"
  file=locateFile(file);
  clear(file,line);
  cout << "setting breakpoint at " << file << ": " << line << endl;
  bplist.push_back(bpinfo(file,line,s));
}

#line 2987 "runtime.in"
// void breakpoints();
void gen306(stack *)
{
#line 2988 "runtime.in"
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p)
    cout << p->f.name() << ": " << p->f.line() << endl;
}

#line 2993 "runtime.in"
// void clear(string file, Int line);
void gen307(stack *Stack)
{
  Int line=vm::pop<Int>(Stack);
  string file=vm::pop<string>(Stack);
#line 2994 "runtime.in"
  file=locateFile(file);
  clear(file,line,true);
}

#line 2999 "runtime.in"
// void clear();
void gen308(stack *)
{
#line 3000 "runtime.in"
  bplist.clear();
}

// Strip directory from string
#line 3005 "runtime.in"
// string stripdirectory(string *s);
void gen309(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 3006 "runtime.in"
  {Stack->push<string>(stripDir(*s)); return;}
}

// Strip file extension from string
#line 3011 "runtime.in"
// string stripextension(string *s);
void gen310(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 3012 "runtime.in"
 {Stack->push<string>(stripExt(*s)); return;}
}

// Call ImageMagick convert.
#line 3017 "runtime.in"
// Int convert(string *args, string output=emptystring,	    string format=emptystring);
void gen311(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string output=vm::pop<string>(Stack,emptystring);
  string * args=vm::pop<string *>(Stack);
#line 3019 "runtime.in"
  ostringstream cmd;
  
  string name=convertname(output,format);
  cmd << "'" << getSetting<string>("convert") << "' " << *args
      << " '" << name << "'";
  Int ret=System(cmd,2,true,"convert");
  
  if(ret == 0 && verbose > 0)
    cout << "Wrote " << ((output == "") ? name : output) << endl;
  
  {Stack->push<Int>(ret); return;}
}

// Delete file named s.
#line 3034 "runtime.in"
// Int delete(string *s);
void gen312(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 3035 "runtime.in"
  checkLocal(*s);
  Int rc=unlink(s->c_str());
  if(rc == 0 && verbose > 0) 
    cout << "Deleted " << *s << endl;
  {Stack->push<Int>(rc); return;}
}

// Rename file "from" to file "to".
#line 3044 "runtime.in"
// Int rename(string *from, string *to);
void gen313(stack *Stack)
{
  string * to=vm::pop<string *>(Stack);
  string * from=vm::pop<string *>(Stack);
#line 3045 "runtime.in"
  checkLocal(*from);
  checkLocal(*to);
  Int rc=rename(from->c_str(),to->c_str());
  if(rc == 0 && verbose > 0) 
    cout << "Renamed " << *from << " to " << *to << endl;
  {Stack->push<Int>(rc); return;}
}

// Call ImageMagick animate.
#line 3055 "runtime.in"
// Int animate(string output=emptystring, string format=emptystring);
void gen314(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string output=vm::pop<string>(Stack,emptystring);
#line 3056 "runtime.in"
  string name=convertname(output,format,false);
  if(view()) {
    ostringstream cmd;
    cmd << "'" << getSetting<string>("animate") << "' '" << name << "'";
    {Stack->push<Int>(System(cmd,0,false,"animate","your animated GIF viewer")); return;}
  }
  
  {Stack->push<Int>(0); return;}
}


// Array operations

// Create an empty array.
#line 3071 "runtime.in"
void emptyArray(stack *Stack)
{
#line 3072 "runtime.in"
  {Stack->push<array*>(new array(0)); return;}
}

// Create a new array (technically a vector).
// This array will be multidimensional.  First the number of dimensions
// is popped off the stack, followed by each dimension in reverse order.
// The array itself is technically a one dimensional array of one
// dimension arrays and so on.
#line 3081 "runtime.in"
void newDeepArray(stack *Stack)
{
  Int depth=vm::pop<Int>(Stack);
#line 3082 "runtime.in"
  assert(depth > 0);

  Int *dims = new Int[depth];

  for (Int index = depth-1; index >= 0; index--) {
    Int i=pop<Int>(Stack);
    if(i < 0) error("cannot create a negative length array");
    dims[index]=i;
  }

  array *a=deepArray(depth, dims);
  delete[] dims;
  {Stack->push<array*>(a); return;}
}

// Creates an array with elements already specified.  First, the number
// of elements is popped off the stack, followed by each element in
// reverse order.
#line 3101 "runtime.in"
void newInitializedArray(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 3102 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (Int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);

  {Stack->push<array*>(a); return;}
}

// Similar to newInitializedArray, but after the n elements, append another
// array to it.
#line 3115 "runtime.in"
void newAppendedArray(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array* tail=vm::pop<array*>(Stack);
#line 3116 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (Int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);
  
  copy(tail->begin(), tail->end(), back_inserter(*a));

  {Stack->push<array*>(a); return;}
}

// Read an element from an array. Checks for initialization & bounds.
#line 3130 "runtime.in"
void arrayRead(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3131 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) {
    ostringstream buf;
    buf << "read uninitialized value from array at index " << n;
    error(buf);
  }
  {Stack->push(i); return;}
}

// Read an element from an array of arrays. Check bounds and initialize
// as necessary.
#line 3143 "runtime.in"
void arrayArrayRead(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3144 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) i=new array(0);
  {Stack->push(i); return;}
}

// Write an element to an array.  Increase size if necessary.
#line 3151 "runtime.in"
void arrayWrite(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
  item value=vm::pop(Stack);
#line 3152 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else {
    if(cyclic) outOfBounds("writing cyclic",len,n);
    if(n < 0) outOfBounds("writing",len,n);
    if(len <= (size_t) n)
      a->resize(n+1);
  }
  (*a)[n] = value;
  {Stack->push(value); return;}
}

// Returns the length of an array.
#line 3167 "runtime.in"
void arrayLength(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3168 "runtime.in"
  {Stack->push<Int>((Int) checkArray(a)); return;}
}

// Return the cyclic flag for an array.
#line 3173 "runtime.in"
void arrayCyclicFlag(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3174 "runtime.in"
  checkArray(a);
  {Stack->push<bool>(a->cyclic()); return;}
}

// Check to see if an array element is initialized.
#line 3180 "runtime.in"
void arrayInitializedHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 3181 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (Int) len) {Stack->push<bool>(false); return;}
  item&i=(*a)[(unsigned) n];
  {Stack->push<bool>(!i.empty()); return;}
}

// Returns the initialize method for an array.
#line 3191 "runtime.in"
void arrayInitialized(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3192 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayInitializedHelper),a)); return;}
}

// The helper function for the cyclic method that sets the cyclic flag.
#line 3197 "runtime.in"
void arrayCyclicHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  bool b=vm::pop<bool>(Stack);
#line 3198 "runtime.in"
  checkArray(a);
  a->cyclic(b);
}

// Set the cyclic flag for an array.
#line 3204 "runtime.in"
void arrayCyclic(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3205 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayCyclicHelper),a)); return;}
}

// The helper function for the push method that does the actual operation.
#line 3210 "runtime.in"
void arrayPushHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  item x=vm::pop(Stack);
#line 3211 "runtime.in"
  checkArray(a);
  a->push(x);
  {Stack->push(x); return;}
}

// Returns the push method for an array.
#line 3218 "runtime.in"
void arrayPush(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3219 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPushHelper),a)); return;}
}

// The helper function for the append method that appends b to a.
#line 3224 "runtime.in"
void arrayAppendHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  array * b=vm::pop<array *>(Stack);
#line 3225 "runtime.in"
  checkArray(a);
  size_t size=checkArray(b);
  for(size_t i=0; i < size; i++)
    a->push((*b)[i]);
}

// Returns the append method for an array.
#line 3233 "runtime.in"
void arrayAppend(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3234 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayAppendHelper),a)); return;}
}

// The helper function for the pop method.
#line 3239 "runtime.in"
void arrayPopHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3240 "runtime.in"
  size_t asize=checkArray(a);
  if(asize == 0) 
    error("cannot pop element from empty array");
  {Stack->push(a->pop()); return;}
}

// Returns the pop method for an array.
#line 3248 "runtime.in"
void arrayPop(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3249 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPopHelper),a)); return;}
}

// The helper function for the insert method.
#line 3254 "runtime.in"
void arrayInsertHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  array * x=vm::pop<array *>(Stack);
  Int i=vm::pop<Int>(Stack);
#line 3255 "runtime.in"
  size_t asize=checkArray(a);
  checkArray(x);
  if(a->cyclic() && asize > 0) i=imod(i,asize);
  if(i < 0 || i > (Int) asize) 
    outOfBounds("inserting",asize,i);
  (*a).insert((*a).begin()+i,(*x).begin(),(*x).end());
}

// Returns the insert method for an array.
#line 3265 "runtime.in"
void arrayInsert(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3266 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayInsertHelper),a)); return;}
}

// Returns the delete method for an array.
#line 3271 "runtime.in"
void arrayDelete(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3272 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayDeleteHelper),a)); return;}
}

#line 3276 "runtime.in"
void arrayAlias(stack *Stack)
{
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3277 "runtime.in"
  {Stack->push<bool>(a==b); return;}
}

// Return array formed by indexing array a with elements of integer array b
#line 3282 "runtime.in"
void arrayIntArray(stack *Stack)
{
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3283 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *r=new array(bsize);
  bool cyclic=a->cyclic();
  for(size_t i=0; i < bsize; i++) {
    Int index=read<Int>(b,i);
    if(cyclic && asize > 0) index=imod(index,asize);
    else
      if(index < 0 || index >= (Int) asize)
	outOfBounds("reading",asize,index);
    (*r)[i]=(*a)[index];
  }
  {Stack->push<array*>(r); return;}
}

// returns the complement of the integer array a in {1,2,...,n},
// so that b[complement(a,b.length)] yields the complement of b[a].
#line 3301 "runtime.in"
// Intarray* complement(Intarray *a, Int n);
void gen339(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  Intarray * a=vm::pop<Intarray *>(Stack);
#line 3302 "runtime.in"
  size_t asize=checkArray(a);
  array *r=new array(0);
  bool *keep=new bool[n];
  for(Int i=0; i < n; ++i) keep[i]=true;
  for(size_t i=0; i < asize; ++i) {
    Int j=read<Int>(a,i);
    if(j >= 0 && j < n) keep[j]=false;
  }
  for(Int i=0; i < n; i++)
    if(keep[i]) r->push(i);
  
  delete[] keep;
  {Stack->push<Intarray*>(r); return;}
}

// Generate the sequence {f_i : i=0,1,...n-1} given a function f and integer n
#line 3319 "runtime.in"
void arraySequence(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  callable * f=vm::pop<callable *>(Stack);
#line 3320 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(Int i=0; i < n; ++i) {
    Stack->push(i);
    f->call(Stack);
    (*a)[i]=pop(Stack);
  }
  {Stack->push<Intarray*>(a); return;}
}

// Return the array {0,1,...n-1}
#line 3332 "runtime.in"
// Intarray* sequence(Int n);
void gen341(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 3333 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(Int i=0; i < n; ++i) {
    (*a)[i]=i;
  }
  {Stack->push<Intarray*>(a); return;}
}

// Apply a function to each element of an array
#line 3343 "runtime.in"
void arrayFunction(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  callable * f=vm::pop<callable *>(Stack);
#line 3344 "runtime.in"
  size_t size=checkArray(a);
  array *b=new array(size);
  for(size_t i=0; i < size; ++i) {
    Stack->push((*a)[i]);
    f->call(Stack);
    (*b)[i]=pop(Stack);
  }
  {Stack->push<array*>(b); return;}
}

#line 3355 "runtime.in"
// bool all(boolarray *a);
void gen343(stack *Stack)
{
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 3356 "runtime.in"
  size_t size=checkArray(a);
  bool c=true;
  for(size_t i=0; i < size; i++)
    if(!get<bool>((*a)[i])) {c=false; break;}
  {Stack->push<bool>(c); return;}
}

#line 3364 "runtime.in"
// boolarray* !(boolarray* a);
void gen344(stack *Stack)
{
  boolarray* a=vm::pop<boolarray*>(Stack);
#line 3365 "runtime.in"
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++)
    (*c)[i]=!read<bool>(a,i);
  {Stack->push<boolarray*>(c); return;}
}

#line 3373 "runtime.in"
// Int sum(boolarray *a);
void gen345(stack *Stack)
{
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 3374 "runtime.in"
  size_t size=checkArray(a);
  Int sum=0;
  for(size_t i=0; i < size; i++)
    sum += read<bool>(a,i) ? 1 : 0;
  {Stack->push<Int>(sum); return;}
}

#line 3382 "runtime.in"
void arrayCopy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3383 "runtime.in"
  {Stack->push<array*>(copyArray(a)); return;}
}

#line 3387 "runtime.in"
void arrayConcat(stack *Stack)
{
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3388 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *c=new array(asize+bsize);
  for(size_t i=0; i < asize; i++) 
    (*c)[i]=(*a)[i];
  for(size_t i=0; i < bsize; i++, asize++) 
    (*c)[asize]=(*b)[i];
  {Stack->push<array*>(c); return;}
}

#line 3399 "runtime.in"
void array2Copy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3400 "runtime.in"
  {Stack->push<array*>(copyArray2(a)); return;}
}

#line 3404 "runtime.in"
void array3Copy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3405 "runtime.in"
  {Stack->push<array*>(copyArray3(a)); return;}
}

#line 3409 "runtime.in"
void array2Transpose(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 3410 "runtime.in"
  size_t asize=checkArray(a);
  array *c=new array(0);
  for(size_t i=0; i < asize; i++) {
    size_t ip=i+1;
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    size_t csize=c->size();
    if(csize < aisize) {
      c->resize(aisize);
      for(size_t j=csize; j < aisize; j++) {
	(*c)[j]=new array(ip);
      }
    }
    for(size_t j=0; j < aisize; j++) {
    array *cj=read<array*>(c,j);
    if(cj->size() < ip) cj->resize(ip);
    (*cj)[i]=(*ai)[j];
    }
  }
  {Stack->push<array*>(c); return;}
}

// a is a rectangular 3D array; perm is an Int array indicating the type of
// permutation  (021 or 120, etc; original is 012).
// Transpose by sending respective members to the permutated locations:
// return the array obtained by putting a[i][j][k] into position perm{ijk}. 
#line 3437 "runtime.in"
void array3Transpose(stack *Stack)
{
  array * perm=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3438 "runtime.in"
  const size_t DIM=3;

  if(checkArray(perm) != DIM) {
    ostringstream buf;
    buf << "permutation array must have length " << DIM;
    error(buf);
  }
  
  size_t* size=new size_t[DIM];
  for(size_t i=0; i < DIM; ++i) size[i]=DIM;
  
  for(size_t i=0; i < DIM; ++i) {
    Int p=read<Int>(perm,i);
    size_t P=(size_t) p;
    if(p < 0 || P >= DIM) {
      ostringstream buf;
      buf << "permutation index out of range: " << p;
      error(buf);
    }
    size[P]=P;
  }
  
  for(size_t i=0; i < DIM; ++i)
    if(size[i] == DIM) error("permutation indices must be distinct");
  
  static const char *rectangular=
    "3D transpose implemented for rectangular matrices only";
  
  size_t isize=size[0]=checkArray(a);
  array *a0=read<array*>(a,0);
  size[1]=a0->size();
  array *a00=read<array*>(a0,0);
  size[2]=a00->size();
  for(size_t i=0; i < isize; i++) {
    array *ai=read<array*>(a,i);
    size_t jsize=checkArray(ai);
    if(jsize != size[1]) error(rectangular);
    for(size_t j=0; j < jsize; j++) {
      array *aij=read<array*>(ai,j);
      if(checkArray(aij) != size[2]) error(rectangular);
    }
  }
  
  size_t perm0=(size_t) read<Int>(perm,0);
  size_t perm1=(size_t) read<Int>(perm,1);
  size_t perm2=(size_t) read<Int>(perm,2);
  
  size_t sizep0=size[perm0];
  size_t sizep1=size[perm1];
  size_t sizep2=size[perm2];
  
  array *c=new array(sizep0);
  for(size_t i=0; i < sizep0; ++i) {
    array *ci=new array(sizep1);
    (*c)[i]=ci;
    for(size_t j=0; j < sizep1; ++j) {
      array *cij=new array(sizep2);
      (*ci)[j]=cij;
    }
  }
  
  size_t* i=new size_t[DIM];
  
  for(i[0]=0; i[0] < size[0]; ++i[0]) {
    array *a0=read<array*>(a,i[0]);
    for(i[1]=0; i[1] < size[1]; ++i[1]) {
      array *a1=read<array*>(a0,i[1]);
      for(i[2]=0; i[2] < size[2]; ++i[2]) {
	array *c0=read<array*>(c,i[perm0]);
	array *c1=read<array*>(c0,i[perm1]);
	(*c1)[i[perm2]]=read<real>(a1,i[2]);
      }
    }
  }
  
  delete [] i;  
  delete [] size;  

  {Stack->push<array*>(c); return;}
}

// In a boolean array, find the index of the nth true value or -1 if not found
// If n is negative, search backwards.
#line 3522 "runtime.in"
// Int find(boolarray *a, Int n=1);
void gen352(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 3523 "runtime.in"
  
  size_t size=checkArray(a);
  Int j=-1;
  if(n > 0)
    for(size_t i=0; i < size; i++)
      if(read<bool>(a,i)) {
	n--; if(n == 0) {j=(Int) i; break;}
      }
  if(n < 0)
    for(size_t i=size; i > 0;)
      if(read<bool>(a,--i)) {
	n++; if(n == 0) {j=(Int) i; break;}
      }
  {Stack->push<Int>(j); return;}
}

// construct vector obtained by replacing those elements of b for which the
// corresponding elements of a are false by the corresponding element of c.
#line 3542 "runtime.in"
void arrayConditional(stack *Stack)
{
  array * c=vm::pop<array *>(Stack);
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 3543 "runtime.in"
  size_t size=checkArray(a);
  array *r=new array(size);
  if(b && c) {
    checkArrays(a,b);
    checkArrays(b,c);
    for(size_t i=0; i < size; i++)
      (*r)[i]=read<bool>(a,i) ? (*b)[i] : (*c)[i];
  } else {
    r->clear();
    if(b) {
      checkArrays(a,b);
      for(size_t i=0; i < size; i++)
        if(read<bool>(a,i)) r->push((*b)[i]);
    } else if(c) {
      checkArrays(a,c);
      for(size_t i=0; i < size; i++)
        if(!read<bool>(a,i)) r->push((*c)[i]);
    }
  }
  {Stack->push<array*>(r); return;}
}

// Return an n x n identity matrix.
#line 3567 "runtime.in"
// realarray2* identity(Int n);
void gen354(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 3568 "runtime.in"
  size_t N=(size_t) n;
  array *c=new array(N);
  for(size_t i=0; i < N; ++i) {
    array *ci=new array(N);
    (*c)[i]=ci;
    for(size_t j=0; j < N; ++j)
      (*ci)[j]=0.0;
   (*ci)[i]=1.0;
  }
  {Stack->push<realarray2*>(c); return;}
}

// Return the inverse of an n x n matrix a using Gauss-Jordan elimination.
#line 3582 "runtime.in"
// realarray2* inverse(realarray2 *a);
void gen355(stack *Stack)
{
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3583 "runtime.in"
  a=copyArray2(a);
  size_t n=a->size();
  checkSquare(a);
  
  inverseAllocate(n);
  
  for(size_t i=0; i < n; i++)
    pivot[i]=0;
 
  size_t col=0, row=0;
  // This is the main loop over the columns to be reduced.
  for(size_t i=0; i < n; i++) {
    real big=0.0;
    // This is the outer loop of the search for a pivot element.
    for(size_t j=0; j < n; j++) {
      array *aj=read<array*>(a,j);
      if(pivot[j] != 1) {
	for(size_t k=0; k < n; k++) {
	  if(pivot[k] == 0) {
	    real temp=fabs(read<real>(aj,k));
	    if(temp >= big) {
	      big=temp;
	      row=j;
	      col=k;
	    }
	  } else if(pivot[k] > 1) {
	    inverseDeallocate();
	    error(singular);
	  }
	}
      }
    }
    ++(pivot[col]);
    
    // Interchange rows, if needed, to put the pivot element on the diagonal.
    array *acol=read<array*>(a,col);
    if(row != col) {
      array *arow=read<array*>(a,row);
      for(size_t l=0; l < n; l++) {
	real temp=read<real>(arow,l);
	(*arow)[l]=read<real>(acol,l);
	(*acol)[l]=temp;
      }
    }
    
    Row[i]=row; 
    Col[i]=col;

    // Divide the pivot row by the pivot element.
    real denom=read<real>(acol,col);
    if(denom == 0.0) {
      inverseDeallocate();
      error(singular);
    }
    real pivinv=1.0/denom;
    (*acol)[col]=1.0;
    for(size_t l=0; l < n; l++) 
      (*acol)[l]=read<real>(acol,l)*pivinv;
    
    // Reduce all rows except for the pivoted one.
    for(size_t k=0; k < n; k++) {
      if(k != col) { 
	array *ak=read<array*>(a,k);
	real akcol=read<real>(ak,col);
	(*ak)[col]=0.0;
	for(size_t l=0; l < n; l++)
	  (*ak)[l]=read<real>(ak,l)-read<real>(acol,l)*akcol;
      }
    }
  }
  
  // Unscramble the inverse matrix in view of the column interchanges.
  for(size_t l=n; l > 0;) {
    l--;
    size_t r=Row[l];
    size_t c=Col[l];
    if(r != c) {
      for(size_t k=0; k < n; k++) {
	array *ak=read<array*>(a,k);
	real temp=read<real>(ak,r);
	(*ak)[r]=read<real>(ak,c);
	(*ak)[c]=temp;
      }
    }
  }
  inverseDeallocate();
  {Stack->push<realarray2*>(a); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an array of length n.
#line 3675 "runtime.in"
// realarray* solve(realarray2 *a, realarray *b);
void gen356(stack *Stack)
{
  realarray * b=vm::pop<realarray *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3676 "runtime.in"
  size_t n=a->size();
  
  array *x=new array(n);
  if(n == 0) {Stack->push<realarray*>(x); return;}
  
  real *A=copyArray2C(a);
  real *B=copyArrayC(b);
  size_t m=b->size();
  if(m != n) error(incommensurate);  
  
  size_t *index=new size_t[n];
  LUdecompose(A,n,index);

  for(size_t i=0; i < n; ++i) {
    size_t ip=index[i];
    real sum=B[ip];
    B[ip]=B[i];
    real *Ai=A+i*n;
    for(size_t j=0; j < i; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum;
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real sum=B[i];
    real *Ai=A+i*n;
    for(size_t j=i+1; j < n; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum/Ai[i];
  }
  
  for(size_t i=0; i < n; ++i)
    (*x)[i]=B[i];

  delete[] index;
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray*>(x); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an n x m matrix.
#line 3721 "runtime.in"
// realarray2* solve(realarray2 *a, realarray2 *b);
void gen357(stack *Stack)
{
  realarray2 * b=vm::pop<realarray2 *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3722 "runtime.in"
  size_t n=a->size();
  
  array *x=new array(n);
  if(n == 0) {Stack->push<realarray2*>(x); return;}
  
  if(b->size() != n) error(incommensurate);  
  size_t m=read<array*>(b,0)->size();
  
  real *A=copyArray2C(a);
  real *B=copyArray2C(b,false);
  
  size_t *index=new size_t[n];
  LUdecompose(A,n,index);

  for(size_t i=0; i < n; ++i) {
    real *Ai=A+i*n;
    real *Bi=B+i*m;
    real *Bip=B+index[i]*m;
    for(size_t k=0; k < m; ++k) {
      real sum=Bip[k];
      Bip[k]=Bi[k];
      size_t jk=k;
      for(size_t j=0; j < i; ++j, jk += m)
	sum -= Ai[j]*B[jk];
      Bi[k]=sum;
    }
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real *Ai=A+i*n;
    real *Bi=B+i*m;
    for(size_t k=0; k < m; ++k) {
      real sum=Bi[k];
      size_t jk=(i+1)*m+k;
      for(size_t j=i+1; j < n; ++j, jk += m)
	sum -= Ai[j]*B[jk];
      Bi[k]=sum/Ai[i];
    }
  }
  
  for(size_t i=0; i < n; ++i) {
    real *Bi=B+i*m;
    array *xi=new array(m);
    (*x)[i]=xi;
    for(size_t j=0; j < m; ++j)
      (*xi)[j]=Bi[j];
  }
    
  delete[] index;
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray2*>(x); return;}
}

// Compute the determinant of an n x n matrix.
#line 3780 "runtime.in"
// real determinant(realarray2 *a);
void gen358(stack *Stack)
{
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3781 "runtime.in"
  real *A=copyArray2C(a);
  size_t n=a->size();
  
  real det=LUdecompose(A,n,NULL,false);
  size_t n1=n+1;
  for(size_t i=0; i < n; ++i)
    det *= A[i*n1];
  
  delete[] A;
  
  {Stack->push<real>(det); return;}
}

#line 3795 "runtime.in"
// realarray* *(realarray2 *a, realarray *b);
void gen359(stack *Stack)
{
  realarray * b=vm::pop<realarray *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3796 "runtime.in"
  size_t n=checkArray(a);
  if(b->size() != n) error(incommensurate);
  array *c=new array(n);
  real *B=copyArrayC(b);
  for(size_t i=0; i < n; ++i) {
    array *ai=read<array*>(a,i);
    real sum=0.0;
    for(size_t j=0; j < n; ++j)
      sum += read<real>(ai,j)*B[j];
    (*c)[i]=sum;
  }
  delete[] B;
  {Stack->push<realarray*>(c); return;}
}

// Multiply a by diagonal(b).
#line 3813 "runtime.in"
// realarray2* multdiagonal(realarray2 *a, realarray *b);
void gen360(stack *Stack)
{
  realarray * b=vm::pop<realarray *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3814 "runtime.in"
  size_t n=checkArray(a);
  if(b->size() != n) error(incommensurate);
  array *c=new array(n);
  real *B=copyArrayC(b);
  for(size_t i=0; i < n; ++i) {
    array *ai=read<array*>(a,i);
    array *ci=new array(n);
    (*c)[i]=ci;
    for(size_t j=0; j < n; ++j)
      (*ci)[j]=read<real>(ai,j)*B[j];
  }
  delete[] B;
  {Stack->push<realarray2*>(c); return;}
}

#line 3830 "runtime.in"
// realarray2* *(realarray2 *a, realarray2 *b);
void gen361(stack *Stack)
{
  realarray2 * b=vm::pop<realarray2 *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 3831 "runtime.in"
  size_t n=a->size();
  
  size_t nb=b->size();
  size_t na0=n == 0 ? 0 : read<array*>(a,0)->size();
  if(na0 != nb) 
    error(incommensurate);
  
  size_t nb0=nb == 0 ? 0 : read<array*>(b,0)->size();
    
  array *c=new array(n);

  real *A=copyArray2C(a,false);
  real *B=copyArray2C(b,false);

  for(size_t i=0; i < n; ++i) {
    real *Ai=A+i*nb;
    array *ci=new array(nb0);
    (*c)[i]=ci;
    for(size_t j=0; j < nb0; ++j) {
      real sum=0.0;
      size_t kj=j;
      for(size_t k=0; k < nb; ++k, kj += nb0)
        sum += Ai[k]*B[kj];
      (*ci)[j]=sum;
    }
  }
  
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray2*>(c); return;}
}

// Solve the problem L\inv f, where f is an n vector and L is the n x n matrix
//
// [ b[0] c[0]           a[0]   ]
// [ a[1] b[1] c[1]             ]
// [      a[2] b[2] c[2]        ]
// [                ...         ]
// [ c[n-1]       a[n-1] b[n-1] ]
#line 3872 "runtime.in"
// realarray* tridiagonal(realarray *a, realarray *b, realarray *c, realarray *f);
void gen362(stack *Stack)
{
  realarray * f=vm::pop<realarray *>(Stack);
  realarray * c=vm::pop<realarray *>(Stack);
  realarray * b=vm::pop<realarray *>(Stack);
  realarray * a=vm::pop<realarray *>(Stack);
#line 3873 "runtime.in"
  size_t n=checkArrays(a,b);
  if(n != checkArray(c) || n != checkArray(f))
    error(arraymismatch);
  
  array *up=new array(n);
  array& u=*up;

  if(n == 0) {Stack->push<realarray*>(up); return;}
  
  // Special case: zero Dirichlet boundary conditions
  if(read<real>(a,0) == 0.0 && read<real>(c,n-1) == 0.0) {
    real temp=read<real>(b,0);
    if(temp == 0.0) dividebyzero();
    temp=1.0/temp;
    
    real *work=new real[n];
    u[0]=read<real>(f,0)*temp;
    work[0]=-read<real>(c,0)*temp;
	
    for(size_t i=1; i < n; i++) {
      real temp=(read<real>(b,i)+read<real>(a,i)*work[i-1]);
      if(temp == 0.0) {delete[] work; dividebyzero();}
      temp=1.0/temp;
      u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*temp;
      work[i]=-read<real>(c,i)*temp;
    }

    for(size_t i=n-1; i >= 1; i--)
      u[i-1]=read<real>(u,i-1)+work[i-1]*read<real>(u,i);
    
    delete[] work;
    {Stack->push<realarray*>(up); return;}
  }
  
  real binv=read<real>(b,0);
  if(binv == 0.0) dividebyzero();
  binv=1.0/binv;
  
  if(n == 1) {u[0]=read<real>(f,0)*binv; {Stack->push<realarray*>(up); return;}}
  if(n == 2) {
    real factor=(read<real>(b,0)*read<real>(b,1)-
		   read<real>(a,0)*read<real>(c,1));
    if(factor== 0.0) dividebyzero();
    factor=1.0/factor;
    real temp=(read<real>(b,0)*read<real>(f,1)-
	  read<real>(c,1)*read<real>(f,0))*factor;
    u[0]=(read<real>(b,1)*read<real>(f,0)-
	  read<real>(a,0)*read<real>(f,1))*factor;
    u[1]=temp;
    {Stack->push<realarray*>(up); return;}
  }
	
  real *gamma=new real[n-2];
  real *delta=new real[n-2];
  
  gamma[0]=read<real>(c,0)*binv;
  delta[0]=read<real>(a,0)*binv;
  u[0]=read<real>(f,0)*binv;
  real beta=read<real>(c,n-1);
  real fn=read<real>(f,n-1)-beta*read<real>(u,0);
  real alpha=read<real>(b,n-1)-beta*delta[0];

  for(size_t i=1; i <= n-3; i++) {
    real alphainv=read<real>(b,i)-read<real>(a,i)*gamma[i-1];
    if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
    alphainv=1.0/alphainv;
    beta *= -gamma[i-1];
    gamma[i]=read<real>(c,i)*alphainv;
    u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*alphainv;
    fn -= beta*read<real>(u,i);
    delta[i]=-read<real>(a,i)*delta[i-1]*alphainv;
    alpha -= beta*delta[i];
  }
	
  real alphainv=read<real>(b,n-2)-read<real>(a,n-2)*gamma[n-3];
  if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  alphainv=1.0/alphainv;
  u[n-2]=(read<real>(f,n-2)-read<real>(a,n-2)*read<real>(u,n-3))
    *alphainv;
  beta=read<real>(a,n-1)-beta*gamma[n-3];
  real dnm1=(read<real>(c,n-2)-read<real>(a,n-2)*delta[n-3])*alphainv;
  real temp=alpha-beta*dnm1;
  if(temp == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  u[n-1]=temp=(fn-beta*read<real>(u,n-2))/temp;
  u[n-2]=read<real>(u,n-2)-dnm1*temp;
	
  for(size_t i=n-2; i >= 1; i--)
    u[i-1]=read<real>(u,i-1)-gamma[i-1]*read<real>(u,i)-delta[i-1]*temp;
  
  delete[] delta;
  delete[] gamma;
  
  {Stack->push<realarray*>(up); return;}
}

// Root solve by Newton-Raphson
#line 3970 "runtime.in"
// real newton(Int iterations=100, callableReal *f, callableReal *fprime, real x,	    bool verbose=false);
void gen363(stack *Stack)
{
  bool verbose=vm::pop<bool>(Stack,false);
  real x=vm::pop<real>(Stack);
  callableReal * fprime=vm::pop<callableReal *>(Stack);
  callableReal * f=vm::pop<callableReal *>(Stack);
  Int iterations=vm::pop<Int>(Stack,100);
#line 3972 "runtime.in"
  static const real fuzz=1000.0*DBL_EPSILON;
  Int i=0;
  size_t oldPrec=cout.precision(DBL_DIG);

  real diff=DBL_MAX;
  real lastdiff;
  do {
    real x0=x;
    
    Stack->push(x);
    f->call(Stack);
    real fx=pop<real>(Stack);
    
    Stack->push(x);
    fprime->call(Stack);
    real dfdx=pop<real>(Stack);
    
    if(dfdx == 0.0) {
      x=DBL_MAX;
      break;
    }
    x -= fx/dfdx;

    lastdiff=diff;
    
    if(verbose)
      cout << "Newton-Raphson: " << x << endl;
    
    diff=fabs(x-x0);
    if(++i == iterations) {
      x=DBL_MAX;
      break;
    }
  } while (diff != 0.0 && (diff < lastdiff || diff > fuzz*fabs(x)));

  cout.precision(oldPrec);
  {Stack->push<real>(x); return;}
}

// Root solve by Newton-Raphson bisection
// cf. routine rtsafe (Press et al.,  Numerical Recipes, 1991).
#line 4014 "runtime.in"
// real newton(Int iterations=100, callableReal *f, callableReal *fprime, real x1,	    real x2, bool verbose=false);
void gen364(stack *Stack)
{
  bool verbose=vm::pop<bool>(Stack,false);
  real x2=vm::pop<real>(Stack);
  real x1=vm::pop<real>(Stack);
  callableReal * fprime=vm::pop<callableReal *>(Stack);
  callableReal * f=vm::pop<callableReal *>(Stack);
  Int iterations=vm::pop<Int>(Stack,100);
#line 4016 "runtime.in"
  static const real fuzz=1000.0*DBL_EPSILON;
  size_t oldPrec=cout.precision(DBL_DIG);

  Stack->push(x1);
  f->call(Stack);
  real f1=pop<real>(Stack);
  if(f1 == 0.0) {Stack->push<real>(x1); return;}
  
  Stack->push(x2);
  f->call(Stack);
  real f2=pop<real>(Stack);
  if(f2 == 0.0) {Stack->push<real>(x2); return;}
	
  if((f1 > 0.0 && f2 > 0.0) || (f1 < 0.0 && f2 < 0.0)) {
    ostringstream buf;
    buf << "root not bracketed, f(x1)=" << f1 << ", f(x2)=" << f2 << endl;
    error(buf);
  }

  real x=0.5*(x1+x2);
  real dxold=fabs(x2-x1);
  if(f1 > 0.0) {
    real temp=x1;
    x1=x2;
    x2=temp;
  }
	
  if(verbose)
    cout << "midpoint: " << x << endl;

  real dx=dxold;
  Stack->push(x);
  f->call(Stack);
  real y=pop<real>(Stack);
  
  Stack->push(x);
  fprime->call(Stack);
  real dy=pop<real>(Stack);

  Int j;
  for(j=0; j < iterations; j++) {
    if(((x-x2)*dy-y)*((x-x1)*dy-y) >= 0.0 || fabs(2.0*y) > fabs(dxold*dy)) {
      dxold=dx;
      dx=0.5*(x2-x1);
      x=x1+dx;
      if(verbose)
	cout << "bisection: " << x << endl;
      if(x1 == x) {Stack->push<real>(x); return;}
    } else {
      dxold=dx;
      dx=y/dy;
      real temp=x;
      x -= dx;
      if(verbose)
	cout << "Newton-Raphson: " << x << endl;
      if(temp == x) {Stack->push<real>(x); return;}
    }
    if(fabs(dx) < fuzz*fabs(x)) {Stack->push<real>(x); return;}
    
    Stack->push(x);
    f->call(Stack);
    y=pop<real>(Stack);
    
    Stack->push(x);
    fprime->call(Stack);
    dy=pop<real>(Stack);

    if(y < 0.0) x1=x;
    else x2=x;
  }
  cout.precision(oldPrec);
  {Stack->push<real>((j == iterations) ? DBL_MAX : x); return;}
}

// Compute the fast Fourier transform of a pair array
#line 4092 "runtime.in"
void pairArrayFFT(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,1);
  pairarray * a=vm::pop<pairarray *>(Stack);
#line 4093 "runtime.in"
  unsigned n=(unsigned) checkArray(a);
#ifdef HAVE_LIBFFTW3
  array *c=new array(n);
  if(n) {
    Complex *f=FFTWComplex(n);
    fft1d Forward(n,intcast(sign),f);
  
    for(size_t i=0; i < n; i++) {
      pair z=read<pair>(a,i);
      f[i]=Complex(z.getx(),z.gety());
    }
    Forward.fft(f);
  
    for(size_t i=0; i < n; i++) {
      Complex z=f[i];
      (*c)[i]=pair(z.real(),z.imag());
    }
    FFTWdelete(f);
  }
#else
  unused(&n);
  unused(&sign);
  array *c=new array(0);
#endif //  HAVE_LIBFFTW3
  {Stack->push<pairarray*>(c); return;}
}

// Call Gilles Dumoulin's port of Paul Bourke's triangulation code.
#line 4122 "runtime.in"
// Intarray2* triangulate(pairarray *z);
void gen366(stack *Stack)
{
  pairarray * z=vm::pop<pairarray *>(Stack);
#line 4123 "runtime.in"
  size_t nv=checkArray(z);

  XYZ *pxyz=new XYZ[nv+3];
  ITRIANGLE *V=new ITRIANGLE[3*nv];
  
  for(size_t i=0; i < nv; ++i) {
    pair w=read<pair>(z,i);
    pxyz[i].x=w.getx();
    pxyz[i].y=w.gety();
    pxyz[i].i=(Int) i;
  }
  
  Int ntri;
  Triangulate((Int) nv,pxyz,V,ntri,true,false);

  size_t nt=(size_t) ntri;
  array *t=new array(nt);
  for(size_t i=0; i < nt; ++i) {
    array *ti=new array(3);
    (*t)[i]=ti;
    ITRIANGLE *Vi=V+i;
    (*ti)[0]=pxyz[Vi->p1].i;
    (*ti)[1]=pxyz[Vi->p2].i;
    (*ti)[2]=pxyz[Vi->p3].i;
  }
   
  delete[] V;
  delete[] pxyz;
  
  {Stack->push<Intarray2*>(t); return;}      
}


// File operations
#line 4158 "runtime.in"
// bool ==(file *a, file *b);
void gen367(stack *Stack)
{
  file * b=vm::pop<file *>(Stack);
  file * a=vm::pop<file *>(Stack);
#line 4159 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 4164 "runtime.in"
// bool !=(file *a, file *b);
void gen368(stack *Stack)
{
  file * b=vm::pop<file *>(Stack);
  file * a=vm::pop<file *>(Stack);
#line 4165 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 4169 "runtime.in"
void nullFile(stack *Stack)
{
#line 4170 "runtime.in"
 {Stack->push<file*>(&camp::nullfile); return;}
}

#line 4174 "runtime.in"
// file* input(string name, bool check=true, string comment=commentchar);
void gen370(stack *Stack)
{
  string comment=vm::pop<string>(Stack,commentchar);
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 4175 "runtime.in"
  char c=comment == "" ? (char) 0 : comment[0];
  file *f=new ifile(name,c,check);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 4182 "runtime.in"
// file* output(string name, bool update=false, string comment=commentchar);
void gen371(stack *Stack)
{
  string comment=vm::pop<string>(Stack,commentchar);
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 4183 "runtime.in"
  file *f;
  if(update) {
    char c=comment == "" ? (char) 0 : comment[0];
    f=new iofile(name,c);
  } else f=new ofile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
}

#line 4194 "runtime.in"
// file* xinput(string name, bool check=true);
void gen372(stack *Stack)
{
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 4195 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new ixfile(name,check);
  f->open();
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR read support not enabled";
  error(buf);
  unused(&check); // Suppress unused variable warning
#endif
}

#line 4208 "runtime.in"
// file* xoutput(string name, bool update=false);
void gen373(stack *Stack)
{
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 4209 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f;
  if(update)
    f=new ioxfile(name);
  else f=new oxfile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR write support not enabled";
  error(buf);
  unused(&update); // Suppress unused variable warning
#endif
}

#line 4226 "runtime.in"
// file* binput(string name, bool check=true);
void gen374(stack *Stack)
{
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 4227 "runtime.in"
  file *f=new ibfile(name,check);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 4233 "runtime.in"
// file* boutput(string name, bool update=false);
void gen375(stack *Stack)
{
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 4234 "runtime.in"
  file *f;
  if(update) f=new iobfile(name);
  else f=new obfile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
}

#line 4243 "runtime.in"
// bool eof(file *File);
void gen376(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4244 "runtime.in"
  {Stack->push<bool>(File->eof()); return;}
}

#line 4248 "runtime.in"
// bool eol(file *File);
void gen377(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4249 "runtime.in"
  {Stack->push<bool>(File->eol()); return;}
}

#line 4253 "runtime.in"
// bool error(file *File);
void gen378(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4254 "runtime.in"
  {Stack->push<bool>(File->error()); return;}
}

#line 4258 "runtime.in"
// void clear(file *File);
void gen379(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4259 "runtime.in"
  File->clear();
}

#line 4263 "runtime.in"
// void close(file *File);
void gen380(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4264 "runtime.in"
  File->close();
}

#line 4268 "runtime.in"
// void precision(file *File, Int digits);
void gen381(stack *Stack)
{
  Int digits=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4269 "runtime.in"
  File->precision(digits);
}

#line 4273 "runtime.in"
// void flush(file *File);
void gen382(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4274 "runtime.in"
   File->flush();
}

#line 4278 "runtime.in"
// string getc(file *File);
void gen383(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4279 "runtime.in"
  char c=0;
  if(File->isOpen()) File->read(c);
  static char str[1];
  str[0]=c;
  {Stack->push<string>(string(str)); return;}
}

#line 4287 "runtime.in"
// Int tell(file *File);
void gen384(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4288 "runtime.in"
  {Stack->push<Int>(File->tell()); return;}
}

#line 4292 "runtime.in"
// void seek(file *File, Int pos);
void gen385(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4293 "runtime.in"
  File->seek(pos,pos >= 0);
}

#line 4297 "runtime.in"
// void seekeof(file *File);
void gen386(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4298 "runtime.in"
  File->seek(0,false);
}

// Set file dimensions
#line 4303 "runtime.in"
// file* dimension(file *File, Int nx);
void gen387(stack *Stack)
{
  Int nx=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4304 "runtime.in"
  File->dimension(nx);
  {Stack->push<file*>(File); return;}
}

#line 4309 "runtime.in"
// file* dimension(file *File, Int nx, Int ny);
void gen388(stack *Stack)
{
  Int ny=vm::pop<Int>(Stack);
  Int nx=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4310 "runtime.in"
  File->dimension(nx,ny);
  {Stack->push<file*>(File); return;}
}

#line 4315 "runtime.in"
// file* dimension(file *File, Int nx, Int ny, Int nz);
void gen389(stack *Stack)
{
  Int nz=vm::pop<Int>(Stack);
  Int ny=vm::pop<Int>(Stack);
  Int nx=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4316 "runtime.in"
  File->dimension(nx,ny,nz);
  {Stack->push<file*>(File); return;}
}

// Set file to read comma-separated values
#line 4322 "runtime.in"
// file* csv(file *File, bool b=true);
void gen390(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * File=vm::pop<file *>(Stack);
#line 4323 "runtime.in"
  File->CSVMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read whitespace-separated values
#line 4329 "runtime.in"
// file* word(file *File, bool b=true);
void gen391(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * File=vm::pop<file *>(Stack);
#line 4330 "runtime.in"
  File->WordMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read arrays in line-at-a-time mode
#line 4336 "runtime.in"
// file* line(file *File, bool b=true);
void gen392(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * File=vm::pop<file *>(Stack);
#line 4337 "runtime.in"
  File->LineMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read/write single-precision XDR values.
#line 4343 "runtime.in"
// file* single(file *File, bool b=true);
void gen393(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * File=vm::pop<file *>(Stack);
#line 4344 "runtime.in"
  File->SingleReal(b);
  File->SingleInt(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read/write single-precision real XDR values.
#line 4351 "runtime.in"
// file* single(file *File, real x, bool b=true);
void gen394(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  real x=vm::pop<real>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4352 "runtime.in"
  File->SingleReal(b);
  unused(&x);
  {Stack->push<file*>(File); return;}
}

// Set file to read/write single-precision int XDR values.
#line 4359 "runtime.in"
// file* single(file *File, Int x, bool b=true);
void gen395(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  Int x=vm::pop<Int>(Stack);
  file * File=vm::pop<file *>(Stack);
#line 4360 "runtime.in"
  File->SingleInt(b);
  unused(&x);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array1 (1 Int size followed by a 1d array)
#line 4367 "runtime.in"
// file* read1(file *File);
void gen396(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4368 "runtime.in"
  File->dimension(-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array2 (2 Int sizes followed by a 2d array)
#line 4374 "runtime.in"
// file* read2(file *File);
void gen397(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4375 "runtime.in"
  File->dimension(-2,-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array3 (3 Int sizes followed by a 3d array)
#line 4381 "runtime.in"
// file* read3(file *File);
void gen398(stack *Stack)
{
  file * File=vm::pop<file *>(Stack);
#line 4382 "runtime.in"
  File->dimension(-2,-2,-2);
  {Stack->push<file*>(File); return;}
}

// Return the last n lines of the history named name.
#line 4388 "runtime.in"
// stringarray* history(string name, Int n=1);
void gen399(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
  string name=vm::pop<string>(Stack);
#line 4389 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  bool newhistory=historyMap.find(name) == historyMap.end();
  
  string filename;
  
  if(newhistory) {
    filename=historyfilename(name);
    std::ifstream exists(filename.c_str());
    if(!exists) {Stack->push<stringarray*>(new array(0)); return;}
  }

  store_history(&history_save);
  HISTORY_STATE& history=historyMap[name].state;
  history_set_history_state(&history);
  
  if(newhistory)
    read_history(filename.c_str());

  array *a=get_history(n);
  
  store_history(&history);
  history_set_history_state(&history_save);
  
  {Stack->push<stringarray*>(a); return;}
#else
  unused(&n);
  {Stack->push<stringarray*>(new array(0)); return;}
#endif
}

// Return the last n lines of the interactive history.
#line 4421 "runtime.in"
// stringarray* history(Int n=0);
void gen400(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,0);
#line 4422 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  {Stack->push<stringarray*>(get_history(n)); return;}
#else
  unused(&n);
  {Stack->push<stringarray*>(new array(0)); return;}
#endif
}

// Prompt for a string using prompt, the GNU readline library, and a
// local history named name.
#line 4433 "runtime.in"
// string readline(string prompt=emptystring, string name=emptystring,		bool tabcompletion=false);
void gen401(stack *Stack)
{
  bool tabcompletion=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack,emptystring);
  string prompt=vm::pop<string>(Stack,emptystring);
#line 4435 "runtime.in"
 if(!isatty(STDIN_FILENO)) 
   {Stack->push<string>(emptystring); return;}
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  init_readline(tabcompletion);
  
  store_history(&history_save);
  bool newhistory=historyMap.find(name) == historyMap.end();
  historyState& h=historyMap[name];
  HISTORY_STATE& history=h.state;
  history_set_history_state(&history);

  if(newhistory)
    read_history(historyfilename(name).c_str());
  
  static char *line=NULL;
  /* Return the memory to the free pool
     if the buffer has already been allocated. */
  if(line) {
    free(line);
    line=NULL;
  }
     
  /* Get a line from the user. */
  line=readline(prompt.c_str());
     
  if(!line) cout << endl;
  
  history_set_history_state(&history_save);

  {Stack->push<string>(line ? string(line) : emptystring); return;}
#else
  cout << prompt;
  string s;
  getline(cin,s);
  unused(&tabcompletion); // Avoid unused variable warning message.
  {Stack->push<string>(s); return;}
#endif
}

// Save a string in a local history named name.
// If store=true, store the local history in the file historyfilename(name).
#line 4477 "runtime.in"
// void saveline(string name, string value, bool store=true);
void gen402(stack *Stack)
{
  bool store=vm::pop<bool>(Stack,true);
  string value=vm::pop<string>(Stack);
  string name=vm::pop<string>(Stack);
#line 4478 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  store_history(&history_save);
  bool newhistory=historyMap.find(name) == historyMap.end();
  historyState& h=historyMap[name];
  h.store=store;
  HISTORY_STATE& history=h.state;
  history_set_history_state(&history);

  if(newhistory)
    read_history(historyfilename(name).c_str());
  
  if(value != "")
    add_history(value.c_str());
  
  store_history(&history);
  history_set_history_state(&history_save);
#else
  unused(&store);
#endif	 
}

#line 4500 "runtime.in"
// void generate_random_backtrace();
void gen403(stack *)
{
#line 4501 "runtime.in"
#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  GC_generate_random_backtrace();
#else
  error("generate_random_backtrace() requires ./configure --enable-gc-debug");
#endif
}

#line 4509 "runtime.in"
// void print_random_addresses(Int n=1);
void gen404(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
#line 4510 "runtime.in"
#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  GC_gcollect();
  for (Int i=0; i < n; ++i)
    GC_debug_print_heap_obj_proc(GC_base(GC_generate_random_valid_address()));
#else
  error("print_random_addresses() requires ./configure --enable-gc-debug");
  unused(&n); // Avoid unused variable warning message.
#endif
}

} // namespace run

namespace trans {

void gen_base_venv(venv &ve)
{
#line 776 "runtime.in"
  addFunc(ve, run::gen8, primBoolean(), "!", formal(primBoolean(), "b", false, false));
#line 804 "runtime.in"
  addFunc(ve, run::gen13, primInt(), "AND", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 811 "runtime.in"
  addFunc(ve, run::gen14, primInt(), "OR", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 816 "runtime.in"
  addFunc(ve, run::gen15, primInt(), "XOR", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 821 "runtime.in"
  addFunc(ve, run::gen16, primInt(), "NOT", formal(primInt(), "a", false, false));
#line 852 "runtime.in"
  addFunc(ve, run::gen21, primBoolean(), "empty", formal(primPicture(), "f", false, false));
#line 857 "runtime.in"
  addFunc(ve, run::gen22, primPair(), "max", formal(primPicture(), "f", false, false));
#line 862 "runtime.in"
  addFunc(ve, run::gen23, primPair(), "min", formal(primPicture(), "f", false, false));
#line 867 "runtime.in"
  addFunc(ve, run::gen24, primVoid(), "label", formal(primPicture(), "f", false, false), formal(primString(), "s", false, false), formal(primString(), "size", false, false), formal(primTransform(), "t", false, false), formal(primPair(), "position", false, false), formal(primPair(), "align", false, false), formal(primPen(), "p", false, false));
#line 873 "runtime.in"
  addFunc(ve, run::gen25, primBoolean(), "labels", formal(primPicture(), "f", false, false));
#line 878 "runtime.in"
  addFunc(ve, run::gen26, primVoid(), "_draw", formal(primPicture(), "f", false, false), formal(primPath(), "g", false, false), formal(primPen(), "p", false, false));
#line 883 "runtime.in"
  addFunc(ve, run::gen27, primVoid(), "fill", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false), formal(primBoolean(), "copy", true, false));
#line 889 "runtime.in"
  addFunc(ve, run::gen28, primVoid(), "latticeshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray2()  , "p", false, false), formal(primBoolean(), "copy", true, false));
#line 896 "runtime.in"
  addFunc(ve, run::gen29, primVoid(), "axialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primBoolean(), "copy", true, false));
#line 903 "runtime.in"
  addFunc(ve, run::gen30, primVoid(), "radialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primReal(), "ra", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primReal(), "rb", false, false), formal(primBoolean(), "copy", true, false));
#line 910 "runtime.in"
  addFunc(ve, run::gen31, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray()  , "p", false, false), formal(pairArray(), "z", false, false), formal(IntArray(), "edges", false, false), formal(primBoolean(), "copy", true, false));
#line 920 "runtime.in"
  addFunc(ve, run::gen32, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray()  , "p", false, false), formal(IntArray(), "edges", false, false), formal(primBoolean(), "copy", true, false));
#line 942 "runtime.in"
  addFunc(ve, run::gen33, primVoid(), "tensorshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray2()  , "p", false, false), formal(pathArray()  , "b", true, false), formal(pairArray2(), "z", true, false), formal(primBoolean(), "copy", true, false));
#line 956 "runtime.in"
  addFunc(ve, run::gen34, primVoid(), "clip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(primBoolean(), "copy", true, false));
#line 965 "runtime.in"
  addFunc(ve, run::gen35, primVoid(), "beginclip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false));
#line 970 "runtime.in"
  addFunc(ve, run::gen36, primVoid(), "endclip", formal(primPicture(), "f", false, false));
#line 975 "runtime.in"
  addFunc(ve, run::gen37, primVoid(), "gsave", formal(primPicture(), "f", false, false));
#line 980 "runtime.in"
  addFunc(ve, run::gen38, primVoid(), "grestore", formal(primPicture(), "f", false, false));
#line 985 "runtime.in"
  addFunc(ve, run::gen39, primVoid(), "begingroup", formal(primPicture(), "f", false, false));
#line 990 "runtime.in"
  addFunc(ve, run::gen40, primVoid(), "endgroup", formal(primPicture(), "f", false, false));
#line 995 "runtime.in"
  addFunc(ve, run::gen41, primVoid(), "add", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1000 "runtime.in"
  addFunc(ve, run::gen42, primVoid(), "prepend", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1005 "runtime.in"
  addFunc(ve, run::gen43, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 1010 "runtime.in"
  addFunc(ve, run::gen44, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 1015 "runtime.in"
  addFunc(ve, run::gen45, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primPair(), "min", false, false), formal(primPair(), "max", false, false));
#line 1020 "runtime.in"
  addFunc(ve, run::gen46, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primPair(), "min", false, false), formal(primPair(), "max", false, false));
#line 1025 "runtime.in"
  addFunc(ve, run::gen47, primVoid(), "texpreamble", formal(primString() , "s", false, false));
#line 1033 "runtime.in"
  addFunc(ve, run::gen48, primVoid(), "deletepreamble");
#line 1040 "runtime.in"
  addFunc(ve, run::gen49, primVoid(), "_labelpath", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primString() , "size", false, false), formal(primPath(), "g", false, false), formal(primString() , "justify", false, false), formal(primPair(), "offset", false, false), formal(primPen(), "p", false, false));
#line 1046 "runtime.in"
  addFunc(ve, run::gen50, primVoid(), "texreset");
#line 1054 "runtime.in"
  addFunc(ve, run::gen51, primVoid(), "layer", formal(primPicture(), "f", false, false));
#line 1059 "runtime.in"
  addFunc(ve, run::gen52, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(realArray2(), "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(penArray()  , "palette", true, false), formal(primTransform(), "t", true, false), formal(primBoolean(), "copy", true, false));
#line 1068 "runtime.in"
  addFunc(ve, run::gen53, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(penArray2()  , "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(primTransform(), "t", true, false), formal(primBoolean(), "copy", true, false));
#line 1075 "runtime.in"
  addFunc(ve, run::gen54, primString() , "nativeformat");
#line 1080 "runtime.in"
  addFunc(ve, run::gen55, primBoolean(), "latex");
#line 1085 "runtime.in"
  addFunc(ve, run::gen56, primBoolean(), "pdf");
#line 1090 "runtime.in"
  addFunc(ve, run::gen57, primVoid(), "shipout", formal(primString() , "prefix", true, false), formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primString() , "format", true, false), formal(primBoolean(), "wait", true, false), formal(primBoolean(), "view", true, false), formal(transformFunction(), "xform", false, false));
#line 1134 "runtime.in"
  addFunc(ve, run::gen58, primVoid(), "deconstruct", formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primReal(), "magnification", true, false), formal(transformFunction(), "xform", false, false));
#line 1262 "runtime.in"
  addFunc(ve, run::gen59, primVoid(), "purge");
#line 1275 "runtime.in"
  addFunc(ve, run::gen61, primBoolean(), "==", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1280 "runtime.in"
  addFunc(ve, run::gen62, primBoolean(), "!=", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1285 "runtime.in"
  addFunc(ve, run::gen63, primPen(), "+", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1290 "runtime.in"
  addFunc(ve, run::gen64, primPen(), "*", formal(primReal(), "a", false, false), formal(primPen(), "b", false, false));
#line 1295 "runtime.in"
  addFunc(ve, run::gen65, primPen(), "*", formal(primPen(), "a", false, false), formal(primReal(), "b", false, false));
#line 1300 "runtime.in"
  addFunc(ve, run::gen66, primPair(), "max", formal(primPen(), "p", false, false));
#line 1305 "runtime.in"
  addFunc(ve, run::gen67, primPair(), "min", formal(primPen(), "p", false, false));
#line 1310 "runtime.in"
  addFunc(ve, run::gen68, primVoid(), "resetdefaultpen");
#line 1316 "runtime.in"
  addFunc(ve, run::gen69, primVoid(), "defaultpen", formal(primPen(), "p", false, false));
#line 1321 "runtime.in"
  addFunc(ve, run::gen70, primPen(), "defaultpen");
#line 1326 "runtime.in"
  addFunc(ve, run::gen71, primPen(), "invisible");
#line 1331 "runtime.in"
  addFunc(ve, run::gen72, primPen(), "gray", formal(primPen(), "p", false, false));
#line 1338 "runtime.in"
  addFunc(ve, run::gen73, primPen(), "rgb", formal(primPen(), "p", false, false));
#line 1345 "runtime.in"
  addFunc(ve, run::gen74, primPen(), "rgb", formal(primReal(), "r", false, false), formal(primReal(), "g", false, false), formal(primReal(), "b", false, false));
#line 1350 "runtime.in"
  addFunc(ve, run::gen75, primPen(), "cmyk", formal(primReal(), "c", false, false), formal(primReal(), "m", false, false), formal(primReal(), "y", false, false), formal(primReal(), "k", false, false));
#line 1355 "runtime.in"
  addFunc(ve, run::gen76, primPen(), "gray", formal(primReal(), "gray", false, false));
#line 1360 "runtime.in"
  addFunc(ve, run::gen77, realArray(), "colors", formal(primPen(), "p", false, false));
#line 1388 "runtime.in"
  addFunc(ve, run::gen78, primString() , "colorspace", formal(primPen(), "p", false, false));
#line 1395 "runtime.in"
  addFunc(ve, run::gen79, primPen(), "pattern", formal(primString(), "s", false, false));
#line 1400 "runtime.in"
  addFunc(ve, run::gen80, primString() , "pattern", formal(primPen(), "p", false, false));
#line 1405 "runtime.in"
  addFunc(ve, run::gen81, primPen(), "fillrule", formal(primInt(), "n", false, false));
#line 1410 "runtime.in"
  addFunc(ve, run::gen82, primInt(), "fillrule", formal(primPen(), "p", false, false));
#line 1415 "runtime.in"
  addFunc(ve, run::gen83, primPen(), "opacity", formal(primReal(), "opacity", true, false), formal(primString() , "blend", true, false));
#line 1425 "runtime.in"
  addFunc(ve, run::gen84, primReal(), "opacity", formal(primPen(), "p", false, false));
#line 1430 "runtime.in"
  addFunc(ve, run::gen85, primString() , "blend", formal(primPen(), "p", false, false));
#line 1435 "runtime.in"
  addFunc(ve, run::gen86, primPen(), "linetype", formal(primString(), "s", false, false), formal(primReal(), "offset", true, false), formal(primBoolean(), "scale", true, false), formal(primBoolean(), "adjust", true, false));
#line 1440 "runtime.in"
  addFunc(ve, run::gen87, primString() , "linetype", formal(primPen(), "p", false, false));
#line 1445 "runtime.in"
  addFunc(ve, run::gen88, primReal(), "offset", formal(primPen(), "p", false, false));
#line 1450 "runtime.in"
  addFunc(ve, run::gen89, primBoolean(), "scale", formal(primPen(), "p", false, false));
#line 1455 "runtime.in"
  addFunc(ve, run::gen90, primBoolean(), "adjust", formal(primPen(), "p", false, false));
#line 1460 "runtime.in"
  addFunc(ve, run::gen91, primPen(), "linecap", formal(primInt(), "n", false, false));
#line 1465 "runtime.in"
  addFunc(ve, run::gen92, primInt(), "linecap", formal(primPen(), "p", false, false));
#line 1470 "runtime.in"
  addFunc(ve, run::gen93, primPen(), "linejoin", formal(primInt(), "n", false, false));
#line 1475 "runtime.in"
  addFunc(ve, run::gen94, primInt(), "linejoin", formal(primPen(), "p", false, false));
#line 1480 "runtime.in"
  addFunc(ve, run::gen95, primPen(), "linewidth", formal(primReal(), "x", false, false));
#line 1485 "runtime.in"
  addFunc(ve, run::gen96, primReal(), "linewidth", formal(primPen(), "p", false, false));
#line 1490 "runtime.in"
  addFunc(ve, run::gen97, primPen(), "fontcommand", formal(primString(), "s", false, false));
#line 1495 "runtime.in"
  addFunc(ve, run::gen98, primString() , "font", formal(primPen(), "p", false, false));
#line 1500 "runtime.in"
  addFunc(ve, run::gen99, primPen(), "fontsize", formal(primReal(), "size", false, false), formal(primReal(), "lineskip", false, false));
#line 1506 "runtime.in"
  addFunc(ve, run::gen100, primReal(), "fontsize", formal(primPen(), "p", false, false));
#line 1511 "runtime.in"
  addFunc(ve, run::gen101, primReal(), "lineskip", formal(primPen(), "p", false, false));
#line 1516 "runtime.in"
  addFunc(ve, run::gen102, primPen(), "overwrite", formal(primInt(), "n", false, false));
#line 1522 "runtime.in"
  addFunc(ve, run::gen103, primInt(), "overwrite", formal(primPen(), "p", false, false));
#line 1527 "runtime.in"
  addFunc(ve, run::gen104, primPen(), "basealign", formal(primInt(), "n", false, false));
#line 1532 "runtime.in"
  addFunc(ve, run::gen105, primInt(), "basealign", formal(primPen(), "p", false, false));
#line 1537 "runtime.in"
  addFunc(ve, run::gen106, primTransform(), "transform", formal(primPen(), "p", false, false));
#line 1542 "runtime.in"
  addFunc(ve, run::gen107, primPath(), "nib", formal(primPen(), "p", false, false));
#line 1547 "runtime.in"
  addFunc(ve, run::gen108, primPen(), "makepen", formal(primPath(), "p", false, false));
#line 1552 "runtime.in"
  addFunc(ve, run::gen109, primPen(), "colorless", formal(primPen(), "p", false, false));
#line 1558 "runtime.in"
  addFunc(ve, run::gen110, primBoolean(), "interactive");
#line 1565 "runtime.in"
  addFunc(ve, run::gen111, primVoid(), "uptodate", formal(primBoolean(), "b", false, false));
#line 1570 "runtime.in"
  addFunc(ve, run::gen112, primBoolean(), "uptodate");
#line 1575 "runtime.in"
  addFunc(ve, run::gen113, primInt(), "system", formal(primString(), "s", false, false));
#line 1584 "runtime.in"
  addFunc(ve, run::gen114, primVoid(), "abort", formal(primString() , "s", true, false));
#line 1590 "runtime.in"
  addFunc(ve, run::gen115, primVoid(), "exit");
#line 1595 "runtime.in"
  addFunc(ve, run::gen116, primVoid(), "assert", formal(primBoolean(), "b", false, false), formal(primString() , "s", true, false));
#line 1606 "runtime.in"
  addFunc(ve, run::gen117, primVoid(), "sleep", formal(primInt(), "seconds", false, false));
#line 1611 "runtime.in"
  addFunc(ve, run::gen118, primVoid(), "usleep", formal(primInt(), "microseconds", false, false));
#line 1616 "runtime.in"
  addFunc(ve, run::gen119, primVoid(), "_eval", formal(primString(), "s", false, false), formal(primBoolean(), "embedded", false, false), formal(primBoolean(), "interactivewrite", true, false));
#line 1631 "runtime.in"
  addFunc(ve, run::gen120, primVoid(), "_eval", formal(primCode(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 1649 "runtime.in"
  addFunc(ve, run::gen121, primString() , "location");
#line 1661 "runtime.in"
  addFunc(ve, run::gen123, primString() , "cd", formal(primString() , "s", true, false));
#line 1667 "runtime.in"
  addFunc(ve, run::gen124, primVoid(), "list", formal(primString(), "s", false, false), formal(primBoolean(), "imports", true, false));
#line 1684 "runtime.in"
  addFunc(ve, run::gen126, primBoolean(), "==", formal(primPath(), "a", false, false), formal(primPath(), "b", false, false));
#line 1689 "runtime.in"
  addFunc(ve, run::gen127, primBoolean(), "!=", formal(primPath(), "a", false, false), formal(primPath(), "b", false, false));
#line 1694 "runtime.in"
  addFunc(ve, run::gen128, primPair(), "point", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 1699 "runtime.in"
  addFunc(ve, run::gen129, primPair(), "point", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1704 "runtime.in"
  addFunc(ve, run::gen130, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 1709 "runtime.in"
  addFunc(ve, run::gen131, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1714 "runtime.in"
  addFunc(ve, run::gen132, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 1719 "runtime.in"
  addFunc(ve, run::gen133, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1724 "runtime.in"
  addFunc(ve, run::gen134, primPair(), "dir", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false), formal(primInt(), "sign", true, false));
#line 1729 "runtime.in"
  addFunc(ve, run::gen135, primPair(), "dir", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1734 "runtime.in"
  addFunc(ve, run::gen136, primPath(), "reverse", formal(primPath(), "p", false, false));
#line 1739 "runtime.in"
  addFunc(ve, run::gen137, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 1744 "runtime.in"
  addFunc(ve, run::gen138, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primReal(), "a", false, false), formal(primReal(), "b", false, false));
#line 1749 "runtime.in"
  addFunc(ve, run::gen139, primPath(), "nurb", formal(primPair(), "z0", false, false), formal(primPair(), "z1", false, false), formal(primPair(), "z2", false, false), formal(primPair(), "z3", false, false), formal(primReal(), "w0", false, false), formal(primReal(), "w1", false, false), formal(primReal(), "w2", false, false), formal(primReal(), "w3", false, false), formal(primInt(), "m", false, false));
#line 1755 "runtime.in"
  addFunc(ve, run::gen140, primInt(), "length", formal(primPath(), "p", false, false));
#line 1760 "runtime.in"
  addFunc(ve, run::gen141, primBoolean(), "cyclic", formal(primPath(), "p", false, false));
#line 1765 "runtime.in"
  addFunc(ve, run::gen142, primBoolean(), "straight", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 1770 "runtime.in"
  addFunc(ve, run::gen143, primBoolean(), "piecewisestraight", formal(primPath(), "p", false, false));
#line 1778 "runtime.in"
  addFunc(ve, run::gen144, primReal(), "arclength", formal(primPath(), "p", false, false));
#line 1783 "runtime.in"
  addFunc(ve, run::gen145, primReal(), "arctime", formal(primPath(), "p", false, false), formal(primReal(), "dval", false, false));
#line 1788 "runtime.in"
  addFunc(ve, run::gen146, primReal(), "dirtime", formal(primPath(), "p", false, false), formal(primPair(), "z", false, false));
#line 1793 "runtime.in"
  addFunc(ve, run::gen147, realArray(), "intersect", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 1807 "runtime.in"
  addFunc(ve, run::gen148, realArray2(), "intersections", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 1825 "runtime.in"
  addFunc(ve, run::gen149, primInt(), "size", formal(primPath(), "p", false, false));
#line 1830 "runtime.in"
  addFunc(ve, run::gen150, primPath(), "&", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false));
#line 1835 "runtime.in"
  addFunc(ve, run::gen151, primPair(), "min", formal(primPath(), "p", false, false));
#line 1840 "runtime.in"
  addFunc(ve, run::gen152, primPair(), "max", formal(primPath(), "p", false, false));
#line 1845 "runtime.in"
  addFunc(ve, run::gen153, primReal(), "relativedistance", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "atleast", false, false));
#line 1850 "runtime.in"
  addFunc(ve, run::gen154, primInt(), "windingnumber", formal(pathArray()  , "p", false, false), formal(primPair(), "z", false, false));
#line 1855 "runtime.in"
  addFunc(ve, run::gen155, primBoolean(), "inside", formal(pathArray()  , "g", false, false), formal(primPair(), "z", false, false), formal(primPen(), "fillrule", false, false));
#line 1910 "runtime.in"
  addFunc(ve, run::gen160, primGuide(), "operator cast", formal(primCycleToken(), "tok", false, false));
#line 1917 "runtime.in"
  addFunc(ve, run::gen161, primGuide(), "operator spec", formal(primPair(), "z", false, false), formal(primInt(), "p", false, false));
#line 1925 "runtime.in"
  addFunc(ve, run::gen162, primCurlSpecifier(), "operator curl", formal(primReal(), "gamma", false, false), formal(primInt(), "p", false, false));
#line 1941 "runtime.in"
  addFunc(ve, run::gen165, primGuide(), "operator cast", formal(primCurlSpecifier(), "spec", false, false));
#line 1946 "runtime.in"
  addFunc(ve, run::gen166, primTensionSpecifier(), "operator tension", formal(primReal(), "tout", false, false), formal(primReal(), "tin", false, false), formal(primBoolean(), "atleast", false, false));
#line 1966 "runtime.in"
  addFunc(ve, run::gen170, primGuide(), "operator cast", formal(primTensionSpecifier(), "t", false, false));
#line 1971 "runtime.in"
  addFunc(ve, run::gen171, primGuide(), "operator controls", formal(primPair(), "zout", false, false), formal(primPair(), "zin", false, false));
#line 1976 "runtime.in"
  addFunc(ve, run::gen172, primInt(), "size", formal(primGuide(), "g", false, false));
#line 1983 "runtime.in"
  addFunc(ve, run::gen173, primInt(), "length", formal(primGuide(), "g", false, false));
#line 1990 "runtime.in"
  addFunc(ve, run::gen174, primBoolean(), "cyclic", formal(primGuide(), "g", false, false));
#line 1997 "runtime.in"
  addFunc(ve, run::gen175, primPair(), "point", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 2004 "runtime.in"
  addFunc(ve, run::gen176, pairArray(), "dirSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 2022 "runtime.in"
  addFunc(ve, run::gen177, pairArray(), "controlSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 2041 "runtime.in"
  addFunc(ve, run::gen178, primTensionSpecifier(), "tensionSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 2053 "runtime.in"
  addFunc(ve, run::gen179, realArray(), "curlSpecifier", formal(primGuide(), "g", false, false));
#line 2066 "runtime.in"
  addFunc(ve, run::gen180, primGuide(), "reverse", formal(primGuide(), "g", false, false));
#line 2126 "runtime.in"
  addFunc(ve, run::gen182, primInt(), "length", formal(primString(), "s", false, false));
#line 2131 "runtime.in"
  addFunc(ve, run::gen183, primInt(), "find", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 2137 "runtime.in"
  addFunc(ve, run::gen184, primInt(), "rfind", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 2143 "runtime.in"
  addFunc(ve, run::gen185, primString() , "reverse", formal(primString() , "s", false, false));
#line 2149 "runtime.in"
  addFunc(ve, run::gen186, primString() , "insert", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primString() , "t", false, false));
#line 2156 "runtime.in"
  addFunc(ve, run::gen187, primString() , "substr", formal(primString(), "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", true, false));
#line 2163 "runtime.in"
  addFunc(ve, run::gen188, primString() , "erase", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", false, false));
#line 2170 "runtime.in"
  addFunc(ve, run::gen189, primString() , "downcase", formal(primString() , "s", false, false));
#line 2176 "runtime.in"
  addFunc(ve, run::gen190, primString() , "upcase", formal(primString() , "s", false, false));
#line 2182 "runtime.in"
  addFunc(ve, run::gen191, primString() , "replace", formal(primString(), "s", false, false), formal(stringArray2(), "translate", false, false));
#line 2209 "runtime.in"
  addFunc(ve, run::gen192, primString() , "format", formal(primString(), "format", false, false), formal(primInt(), "x", false, false));
#line 2224 "runtime.in"
  addFunc(ve, run::gen193, primString() , "format", formal(primString(), "format", false, false), formal(primReal(), "x", false, false));
#line 2330 "runtime.in"
  addFunc(ve, run::gen194, primString() , "string", formal(primReal(), "x", false, false), formal(primInt(), "digits", false, false));
#line 2338 "runtime.in"
  addFunc(ve, run::gen195, primString() , "time", formal(primString() , "format", true, false));
#line 2349 "runtime.in"
  addFunc(ve, run::gen196, primString() , "time", formal(primInt(), "seconds", false, false), formal(primString() , "format", true, false));
#line 2362 "runtime.in"
  addFunc(ve, run::gen197, primInt(), "seconds", formal(primString() , "t", true, false), formal(primString() , "format", true, false));
#line 2374 "runtime.in"
  addFunc(ve, run::gen198, realArray(), "_cputime");
#line 2388 "runtime.in"
  addFunc(ve, run::gen199, primReal(), "^", formal(primReal(), "x", false, false), formal(primInt(), "y", false, false));
#line 2396 "runtime.in"
  addFunc(ve, run::gen200, primPair(), "^", formal(primPair(), "z", false, false), formal(primInt(), "y", false, false));
#line 2401 "runtime.in"
  addFunc(ve, run::gen201, primInt(), "quotient", formal(primInt(), "x", false, false), formal(primInt(), "y", false, false));
#line 2409 "runtime.in"
  addFunc(ve, run::gen202, primInt(), "abs", formal(primInt(), "x", false, false));
#line 2414 "runtime.in"
  addFunc(ve, run::gen203, primInt(), "sgn", formal(primReal(), "x", false, false));
#line 2419 "runtime.in"
  addFunc(ve, run::gen204, primInt(), "rand");
#line 2424 "runtime.in"
  addFunc(ve, run::gen205, primVoid(), "srand", formal(primInt(), "seed", false, false));
#line 2429 "runtime.in"
  addFunc(ve, run::gen206, primInt(), "ceil", formal(primReal(), "x", false, false));
#line 2434 "runtime.in"
  addFunc(ve, run::gen207, primInt(), "floor", formal(primReal(), "x", false, false));
#line 2439 "runtime.in"
  addFunc(ve, run::gen208, primInt(), "round", formal(primReal(), "x", false, false));
#line 2445 "runtime.in"
  addFunc(ve, run::gen209, primInt(), "Ceil", formal(primReal(), "x", false, false));
#line 2450 "runtime.in"
  addFunc(ve, run::gen210, primInt(), "Floor", formal(primReal(), "x", false, false));
#line 2455 "runtime.in"
  addFunc(ve, run::gen211, primInt(), "Round", formal(primReal(), "x", false, false));
#line 2460 "runtime.in"
  addFunc(ve, run::gen212, primReal(), "fmod", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2466 "runtime.in"
  addFunc(ve, run::gen213, primReal(), "atan2", formal(primReal(), "y", false, false), formal(primReal(), "x", false, false));
#line 2471 "runtime.in"
  addFunc(ve, run::gen214, primReal(), "hypot", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2476 "runtime.in"
  addFunc(ve, run::gen215, primReal(), "remainder", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2481 "runtime.in"
  addFunc(ve, run::gen216, primReal(), "J", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 2486 "runtime.in"
  addFunc(ve, run::gen217, primReal(), "Y", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 2491 "runtime.in"
  addFunc(ve, run::gen218, primReal(), "erf", formal(primReal(), "x", false, false));
#line 2496 "runtime.in"
  addFunc(ve, run::gen219, primReal(), "erfc", formal(primReal(), "x", false, false));
#line 2501 "runtime.in"
  addFunc(ve, run::gen220, primReal(), "gamma", formal(primReal(), "x", false, false));
#line 2511 "runtime.in"
  addFunc(ve, run::gen221, realArray(), "quadraticroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false));
#line 2520 "runtime.in"
  addFunc(ve, run::gen222, pairArray(), "quadraticroots", formal(primPair(), "a", false, true), formal(primPair(), "b", false, true), formal(primPair(), "c", false, true));
#line 2529 "runtime.in"
  addFunc(ve, run::gen223, realArray(), "cubicroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false), formal(primReal(), "d", false, false));
#line 2539 "runtime.in"
  addFunc(ve, run::gen224, primBoolean(), "==", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2547 "runtime.in"
  addFunc(ve, run::gen225, primBoolean(), "!=", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2552 "runtime.in"
  addFunc(ve, run::gen226, primTransform(), "+", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2557 "runtime.in"
  addFunc(ve, run::gen227, primTransform(), "*", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2562 "runtime.in"
  addFunc(ve, run::gen228, primPair(), "*", formal(primTransform(), "t", false, false), formal(primPair(), "z", false, false));
#line 2567 "runtime.in"
  addFunc(ve, run::gen229, primPath(), "*", formal(primTransform(), "t", false, false), formal(primPath(), "g", false, false));
#line 2572 "runtime.in"
  addFunc(ve, run::gen230, primPen(), "*", formal(primTransform(), "t", false, false), formal(primPen(), "p", false, false));
#line 2577 "runtime.in"
  addFunc(ve, run::gen231, primPicture(), "*", formal(primTransform(), "t", false, false), formal(primPicture(), "f", false, false));
#line 2582 "runtime.in"
  addFunc(ve, run::gen232, primTransform(), "^", formal(primTransform(), "t", false, false), formal(primInt(), "n", false, false));
#line 2629 "runtime.in"
  addFunc(ve, run::gen240, primTransform(), "shift", formal(primTransform(), "t", false, false));
#line 2634 "runtime.in"
  addFunc(ve, run::gen241, primTransform(), "shiftless", formal(primTransform(), "t", false, false));
#line 2639 "runtime.in"
  addFunc(ve, run::transformIdentity, primTransform(), "identity");
#line 2644 "runtime.in"
  addFunc(ve, run::gen243, primTransform(), "inverse", formal(primTransform(), "t", false, false));
#line 2649 "runtime.in"
  addFunc(ve, run::gen244, primTransform(), "shift", formal(primPair(), "z", false, false));
#line 2654 "runtime.in"
  addFunc(ve, run::gen245, primTransform(), "shift", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2659 "runtime.in"
  addFunc(ve, run::gen246, primTransform(), "xscale", formal(primReal(), "x", false, false));
#line 2664 "runtime.in"
  addFunc(ve, run::gen247, primTransform(), "yscale", formal(primReal(), "y", false, false));
#line 2669 "runtime.in"
  addFunc(ve, run::gen248, primTransform(), "scale", formal(primReal(), "x", false, false));
#line 2674 "runtime.in"
  addFunc(ve, run::gen249, primTransform(), "scale", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2679 "runtime.in"
  addFunc(ve, run::gen250, primTransform(), "slant", formal(primReal(), "s", false, false));
#line 2684 "runtime.in"
  addFunc(ve, run::gen251, primTransform(), "rotate", formal(primReal(), "angle", false, false), formal(primPair(), "z", true, false));
#line 2689 "runtime.in"
  addFunc(ve, run::gen252, primTransform(), "reflect", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false));
#line 2713 "runtime.in"
  addFunc(ve, run::pairXPart, primReal(), "xpart", formal(primPair(), "z", false, false));
#line 2718 "runtime.in"
  addFunc(ve, run::pairYPart, primReal(), "ypart", formal(primPair(), "z", false, false));
#line 2723 "runtime.in"
  addFunc(ve, run::gen258, primReal(), "length", formal(primPair(), "z", false, false));
#line 2728 "runtime.in"
  addFunc(ve, run::gen259, primReal(), "abs", formal(primPair(), "z", false, false));
#line 2733 "runtime.in"
  addFunc(ve, run::gen260, primPair(), "sqrt", formal(primPair(), "z", false, true));
#line 2738 "runtime.in"
  addFunc(ve, run::gen261, primReal(), "angle", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 2745 "runtime.in"
  addFunc(ve, run::gen262, primReal(), "degrees", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 2752 "runtime.in"
  addFunc(ve, run::gen263, primReal(), "radians", formal(primReal(), "degrees", false, false));
#line 2758 "runtime.in"
  addFunc(ve, run::gen264, primReal(), "degrees", formal(primReal(), "radians", false, false));
#line 2764 "runtime.in"
  addFunc(ve, run::gen265, primReal(), "Degrees", formal(primReal(), "radians", false, false));
#line 2770 "runtime.in"
  addFunc(ve, run::gen266, primReal(), "Sin", formal(primReal(), "deg", false, false));
#line 2775 "runtime.in"
  addFunc(ve, run::gen267, primReal(), "Cos", formal(primReal(), "deg", false, false));
#line 2780 "runtime.in"
  addFunc(ve, run::gen268, primReal(), "Tan", formal(primReal(), "deg", false, false));
#line 2785 "runtime.in"
  addFunc(ve, run::gen269, primReal(), "aSin", formal(primReal(), "x", false, false));
#line 2790 "runtime.in"
  addFunc(ve, run::gen270, primReal(), "aCos", formal(primReal(), "x", false, false));
#line 2795 "runtime.in"
  addFunc(ve, run::gen271, primReal(), "aTan", formal(primReal(), "x", false, false));
#line 2800 "runtime.in"
  addFunc(ve, run::gen272, primPair(), "unit", formal(primPair(), "z", false, false));
#line 2805 "runtime.in"
  addFunc(ve, run::gen273, primPair(), "dir", formal(primReal(), "theta", false, false));
#line 2810 "runtime.in"
  addFunc(ve, run::gen274, primPair(), "expi", formal(primReal(), "theta", false, false));
#line 2815 "runtime.in"
  addFunc(ve, run::gen275, primPair(), "conj", formal(primPair(), "z", false, false));
#line 2820 "runtime.in"
  addFunc(ve, run::gen276, primPair(), "realmult", formal(primPair(), "z", false, false), formal(primPair(), "w", false, false));
#line 2825 "runtime.in"
  addFunc(ve, run::gen277, primReal(), "dot", formal(primPair(), "z", false, true), formal(primPair(), "w", false, true));
#line 2845 "runtime.in"
  addFunc(ve, run::tripleXPart, primReal(), "xpart", formal(primTriple(), "v", false, false));
#line 2850 "runtime.in"
  addFunc(ve, run::tripleYPart, primReal(), "ypart", formal(primTriple(), "v", false, false));
#line 2855 "runtime.in"
  addFunc(ve, run::tripleZPart, primReal(), "zpart", formal(primTriple(), "v", false, false));
#line 2860 "runtime.in"
  addFunc(ve, run::gen283, primTriple(), "*", formal(primReal(), "x", false, false), formal(primTriple(), "v", false, false));
#line 2865 "runtime.in"
  addFunc(ve, run::gen284, primTriple(), "*", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 2870 "runtime.in"
  addFunc(ve, run::gen285, primTriple(), "/", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 2875 "runtime.in"
  addFunc(ve, run::gen286, primReal(), "length", formal(primTriple(), "v", false, false));
#line 2880 "runtime.in"
  addFunc(ve, run::gen287, primReal(), "abs", formal(primTriple(), "v", false, false));
#line 2885 "runtime.in"
  addFunc(ve, run::gen288, primReal(), "polar", formal(primTriple(), "v", false, false));
#line 2890 "runtime.in"
  addFunc(ve, run::gen289, primReal(), "azimuth", formal(primTriple(), "v", false, false));
#line 2895 "runtime.in"
  addFunc(ve, run::gen290, primReal(), "colatitude", formal(primTriple(), "v", false, false));
#line 2900 "runtime.in"
  addFunc(ve, run::gen291, primReal(), "latitude", formal(primTriple(), "v", false, false));
#line 2905 "runtime.in"
  addFunc(ve, run::gen292, primReal(), "longitude", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 2912 "runtime.in"
  addFunc(ve, run::gen293, primTriple(), "unit", formal(primTriple(), "v", false, false));
#line 2917 "runtime.in"
  addFunc(ve, run::gen294, primReal(), "dot", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2922 "runtime.in"
  addFunc(ve, run::gen295, primTriple(), "cross", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2929 "runtime.in"
  addFunc(ve, run::gen296, primTriple(), "expi", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2936 "runtime.in"
  addFunc(ve, run::gen297, primTriple(), "dir", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2941 "runtime.in"
  addFunc(ve, run::gen298, primReal(), "cubiclength", formal(primTriple(), "z0", false, false), formal(primTriple(), "z0p", false, false), formal(primTriple(), "z1m", false, false), formal(primTriple(), "z1", false, false), formal(primReal(), "goal", false, false));
#line 2946 "runtime.in"
  addFunc(ve, run::gen299, primString() , "VERSION");
#line 2954 "runtime.in"
  addFunc(ve, run::gen300, primVoid(), "atexit", formal(voidFunction(), "f", false, false));
#line 2959 "runtime.in"
  addFunc(ve, run::gen301, voidFunction(), "atexit");
#line 2964 "runtime.in"
  addFunc(ve, run::gen302, primVoid(), "atbreakpoint", formal(breakpointFunction(), "f", false, false));
#line 2969 "runtime.in"
  addFunc(ve, run::gen303, primVoid(), "breakpoint", formal(primCode(), "s", true, false));
#line 2974 "runtime.in"
  addFunc(ve, run::gen304, primString() , "locatefile", formal(primString() , "file", false, false));
#line 2979 "runtime.in"
  addFunc(ve, run::gen305, primVoid(), "stop", formal(primString() , "file", false, false), formal(primInt(), "line", false, false), formal(primCode(), "s", true, false));
#line 2987 "runtime.in"
  addFunc(ve, run::gen306, primVoid(), "breakpoints");
#line 2993 "runtime.in"
  addFunc(ve, run::gen307, primVoid(), "clear", formal(primString() , "file", false, false), formal(primInt(), "line", false, false));
#line 2999 "runtime.in"
  addFunc(ve, run::gen308, primVoid(), "clear");
#line 3004 "runtime.in"
  addFunc(ve, run::gen309, primString() , "stripdirectory", formal(primString(), "s", false, false));
#line 3010 "runtime.in"
  addFunc(ve, run::gen310, primString() , "stripextension", formal(primString(), "s", false, false));
#line 3016 "runtime.in"
  addFunc(ve, run::gen311, primInt(), "convert", formal(primString(), "args", false, false), formal(primString() , "output", true, false), formal(primString() , "format", true, false));
#line 3033 "runtime.in"
  addFunc(ve, run::gen312, primInt(), "delete", formal(primString(), "s", false, false));
#line 3043 "runtime.in"
  addFunc(ve, run::gen313, primInt(), "rename", formal(primString(), "from", false, false), formal(primString(), "to", false, false));
#line 3054 "runtime.in"
  addFunc(ve, run::gen314, primInt(), "animate", formal(primString() , "output", true, false), formal(primString() , "format", true, false));
#line 3299 "runtime.in"
  addFunc(ve, run::gen339, IntArray(), "complement", formal(IntArray(), "a", false, false), formal(primInt(), "n", false, false));
#line 3331 "runtime.in"
  addFunc(ve, run::gen341, IntArray(), "sequence", formal(primInt(), "n", false, false));
#line 3355 "runtime.in"
  addFunc(ve, run::gen343, primBoolean(), "all", formal(boolArray(), "a", false, false));
#line 3364 "runtime.in"
  addFunc(ve, run::gen344, boolArray(), "!", formal(boolArray(), "a", false, false));
#line 3373 "runtime.in"
  addFunc(ve, run::gen345, primInt(), "sum", formal(boolArray(), "a", false, false));
#line 3520 "runtime.in"
  addFunc(ve, run::gen352, primInt(), "find", formal(boolArray(), "a", false, false), formal(primInt(), "n", true, false));
#line 3566 "runtime.in"
  addFunc(ve, run::gen354, realArray2(), "identity", formal(primInt(), "n", false, false));
#line 3581 "runtime.in"
  addFunc(ve, run::gen355, realArray2(), "inverse", formal(realArray2(), "a", false, false));
#line 3673 "runtime.in"
  addFunc(ve, run::gen356, realArray(), "solve", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 3719 "runtime.in"
  addFunc(ve, run::gen357, realArray2(), "solve", formal(realArray2(), "a", false, false), formal(realArray2(), "b", false, false));
#line 3779 "runtime.in"
  addFunc(ve, run::gen358, primReal(), "determinant", formal(realArray2(), "a", false, false));
#line 3795 "runtime.in"
  addFunc(ve, run::gen359, realArray(), "*", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 3812 "runtime.in"
  addFunc(ve, run::gen360, realArray2(), "multdiagonal", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 3830 "runtime.in"
  addFunc(ve, run::gen361, realArray2(), "*", formal(realArray2(), "a", false, false), formal(realArray2(), "b", false, false));
#line 3865 "runtime.in"
  addFunc(ve, run::gen362, realArray(), "tridiagonal", formal(realArray(), "a", false, false), formal(realArray(), "b", false, false), formal(realArray(), "c", false, false), formal(realArray(), "f", false, false));
#line 3969 "runtime.in"
  addFunc(ve, run::gen363, primReal(), "newton", formal(primInt(), "iterations", true, false), formal(realRealFunction(), "f", false, false), formal(realRealFunction(), "fprime", false, false), formal(primReal(), "x", false, false), formal(primBoolean(), "verbose", true, false));
#line 4012 "runtime.in"
  addFunc(ve, run::gen364, primReal(), "newton", formal(primInt(), "iterations", true, false), formal(realRealFunction(), "f", false, false), formal(realRealFunction(), "fprime", false, false), formal(primReal(), "x1", false, false), formal(primReal(), "x2", false, false), formal(primBoolean(), "verbose", true, false));
#line 4121 "runtime.in"
  addFunc(ve, run::gen366, IntArray2(), "triangulate", formal(pairArray(), "z", false, false));
#line 4156 "runtime.in"
  addFunc(ve, run::gen367, primBoolean(), "==", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 4164 "runtime.in"
  addFunc(ve, run::gen368, primBoolean(), "!=", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 4174 "runtime.in"
  addFunc(ve, run::gen370, primFile(), "input", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false), formal(primString() , "comment", true, false));
#line 4182 "runtime.in"
  addFunc(ve, run::gen371, primFile(), "output", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false), formal(primString() , "comment", true, false));
#line 4194 "runtime.in"
  addFunc(ve, run::gen372, primFile(), "xinput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 4208 "runtime.in"
  addFunc(ve, run::gen373, primFile(), "xoutput", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false));
#line 4226 "runtime.in"
  addFunc(ve, run::gen374, primFile(), "binput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 4233 "runtime.in"
  addFunc(ve, run::gen375, primFile(), "boutput", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false));
#line 4243 "runtime.in"
  addFunc(ve, run::gen376, primBoolean(), "eof", formal(primFile(), "file", false, false));
#line 4248 "runtime.in"
  addFunc(ve, run::gen377, primBoolean(), "eol", formal(primFile(), "file", false, false));
#line 4253 "runtime.in"
  addFunc(ve, run::gen378, primBoolean(), "error", formal(primFile(), "file", false, false));
#line 4258 "runtime.in"
  addFunc(ve, run::gen379, primVoid(), "clear", formal(primFile(), "file", false, false));
#line 4263 "runtime.in"
  addFunc(ve, run::gen380, primVoid(), "close", formal(primFile(), "file", false, false));
#line 4268 "runtime.in"
  addFunc(ve, run::gen381, primVoid(), "precision", formal(primFile(), "file", false, false), formal(primInt(), "digits", false, false));
#line 4273 "runtime.in"
  addFunc(ve, run::gen382, primVoid(), "flush", formal(primFile(), "file", false, false));
#line 4278 "runtime.in"
  addFunc(ve, run::gen383, primString() , "getc", formal(primFile(), "file", false, false));
#line 4287 "runtime.in"
  addFunc(ve, run::gen384, primInt(), "tell", formal(primFile(), "file", false, false));
#line 4292 "runtime.in"
  addFunc(ve, run::gen385, primVoid(), "seek", formal(primFile(), "file", false, false), formal(primInt(), "pos", false, false));
#line 4297 "runtime.in"
  addFunc(ve, run::gen386, primVoid(), "seekeof", formal(primFile(), "file", false, false));
#line 4302 "runtime.in"
  addFunc(ve, run::gen387, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false));
#line 4309 "runtime.in"
  addFunc(ve, run::gen388, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false));
#line 4315 "runtime.in"
  addFunc(ve, run::gen389, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false), formal(primInt(), "nz", false, false));
#line 4321 "runtime.in"
  addFunc(ve, run::gen390, primFile(), "csv", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 4328 "runtime.in"
  addFunc(ve, run::gen391, primFile(), "word", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 4335 "runtime.in"
  addFunc(ve, run::gen392, primFile(), "line", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 4342 "runtime.in"
  addFunc(ve, run::gen393, primFile(), "single", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 4350 "runtime.in"
  addFunc(ve, run::gen394, primFile(), "single", formal(primFile(), "file", false, false), formal(primReal(), "x", false, false), formal(primBoolean(), "b", true, false));
#line 4358 "runtime.in"
  addFunc(ve, run::gen395, primFile(), "single", formal(primFile(), "file", false, false), formal(primInt(), "x", false, false), formal(primBoolean(), "b", true, false));
#line 4366 "runtime.in"
  addFunc(ve, run::gen396, primFile(), "read1", formal(primFile(), "file", false, false));
#line 4373 "runtime.in"
  addFunc(ve, run::gen397, primFile(), "read2", formal(primFile(), "file", false, false));
#line 4380 "runtime.in"
  addFunc(ve, run::gen398, primFile(), "read3", formal(primFile(), "file", false, false));
#line 4387 "runtime.in"
  addFunc(ve, run::gen399, stringArray(), "history", formal(primString() , "name", false, false), formal(primInt(), "n", true, false));
#line 4420 "runtime.in"
  addFunc(ve, run::gen400, stringArray(), "history", formal(primInt(), "n", true, false));
#line 4431 "runtime.in"
  addFunc(ve, run::gen401, primString() , "readline", formal(primString() , "prompt", true, false), formal(primString() , "name", true, false), formal(primBoolean(), "tabcompletion", true, false));
#line 4475 "runtime.in"
  addFunc(ve, run::gen402, primVoid(), "saveline", formal(primString() , "name", false, false), formal(primString() , "value", false, false), formal(primBoolean(), "store", true, false));
#line 4500 "runtime.in"
  addFunc(ve, run::gen403, primVoid(), "generate_random_backtrace");
#line 4509 "runtime.in"
  addFunc(ve, run::gen404, primVoid(), "print_random_addresses", formal(primInt(), "n", true, false));
}

} // namespace trans
