/***** Autogenerated from runtime.in; changes will be overwritten *****/

#line 1 "runtime.in"
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate the runtime functions used by the vm::stack machine.
 *
 *****/

/* Autogenerated routines are specified like this (separated by a formfeed):
type asyname:cname(cparams)
{
  C code
}
*/


#line 48 "runtime.in"
#include <cfloat>
#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "pen.h"
#include "guide.h"
#include "picture.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawlabel.h"
#include "drawverbatim.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawgroup.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "mathop.h"
#include "callable.h"
#include "stm.h"
  
#ifdef HAVE_LIBFFTW3
#include "fftw++.h"
#endif
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
#include <readline/readline.h>
#include <readline/history.h>
#endif

using namespace vm;
using namespace camp;
using namespace settings;

namespace settings {
extern pen *initialdefaultpen;
}

namespace run {
using camp::pair;
using mem::string;
using vm::array;
using vm::frame;
using vm::stack;
using camp::transform;
using absyntax::runnable;

callable *atExitFunction=NULL;
callable *atDrawFunction=NULL;
  
typedef array boolarray;
typedef array intarray;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array triplearray;
typedef array patharray;
typedef array guidearray;
typedef array transformarray;
typedef array penarray;
typedef array penarray2;
typedef array stringarray;
typedef array stringarray2;
}

using vm::array;
using types::function;
using types::primVoid;
using types::primBoolean;
using types::primInt;
using types::primReal;
using types::primPair;
using types::primTriple;
using types::primPen;
using types::primPath;
using types::primGuide;
using types::primPicture;
using types::primString;
using types::primCode;
using types::primArray;
using types::primFile;
using types::primTransform;
using types::boolArray;
using types::intArray;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::tripleArray;
using types::pathArray;
using types::guideArray;
using types::transformArray;
using types::penArray;
using types::penArray2;
using types::stringArray;
using types::stringArray2;
using types::formal;

namespace loop {
  void doIRunnable(absyntax::runnable *r, bool embedded=false);
  void doITree(absyntax::block *tree, bool embedded=false);
}
  
function *voidFunction()
{
  return new function(primVoid());
}

const int camp::ColorComponents[]={0,0,1,3,4,0};

namespace vm {
const char *arraymismatch="operation attempted on arrays of different lengths";
}

namespace run {
  
const char *arraymin="cannot take min of empty array";
const char *arraymax="cannot take max of empty array";

static inline int Round(double x) 
{
  return int(x+((x >= 0) ? 0.5 : -0.5));
}

inline int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

void outOfBounds(const char *op, size_t len, int n)
{
  ostringstream buf;
  buf << op << " array of length " << len << " with out-of-bounds index "
      << n;
  error(buf);
}

inline item& arrayRead(array *a, int n)  
{
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (int) len) outOfBounds("reading",len,n);
  return (*a)[(unsigned) n];
}

// Helper function to create deep arrays.
static array* deepArray(int depth, int *dims)
{
  assert(depth > 0);
  
  if (depth == 1) {
    return new array(dims[0]);
  } else {
    int length = dims[0];
    depth--; dims++;

    array *a = new array(length);

    for (int index = 0; index < length; index++) {
      (*a)[index] = deepArray(depth, dims);
    }
    return a;
  }
}
  
array *copyArray(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) 
    (*c)[i]=(*a)[i];
  return c;
}

array *copyArray2(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) 
      (*ci)[j]=(*ai)[j];
  }
  return c;
}

void writestring(stack *s)
{
  callable *suffix=pop<callable *>(s,NULL);
  string S=pop<string>(s);
  vm::item it=pop(s);
  bool defaultfile=isdefault(it);
  camp::file *f=defaultfile ? &camp::Stdout : vm::get<camp::file*>(it);
  if(!f->isOpen()) return;
  if(S != "") f->write(S);
  if(f->text()) {
    if(suffix) {
      s->push(f);
      suffix->call(s);
    } else if(defaultfile) f->writeline();
  }
}

void dividebyzero(size_t i)
{
  std::ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Divide by zero";
  error(buf);
}
  
void integeroverflow(size_t i)
{
  std::ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Integer overflow";
  error(buf);
}
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_HISTORY_STATE) && \
    defined(HAVE_LIBCURSES)
typedef mem::map<CONST string, HISTORY_STATE> historyMap_t;
historyMap_t historyMap;
static HISTORY_STATE history_save;

// Store a deep copy of the current readline history in dest.
void store_history(HISTORY_STATE *dest)
{
  HISTORY_STATE *src=history_get_history_state();
  *dest=*src;
  if(src) {
    for(int i=0; i < src->length; ++i)
      dest->entries[i]=src->entries[i];
    free(src);
  }
}

const char nosave='\n';

string historyfilename(const string &name) 
{
  return historyname+"_"+name;
}
#endif

#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
int readline_startup_hook()
{
#ifdef __CYGWIN__
  rl_set_key("\\M-[3~",rl_delete,rl_get_keymap());
  rl_set_key("\\M-[2~",rl_overwrite_mode,rl_get_keymap());
#endif    
  return 0;
}

void init_readline(bool tabcompletion=true) 
{
  static bool first=true;
  if(first) {
    first=false;
#ifdef __CYGWIN__
    rl_startup_hook=readline_startup_hook;
#endif    
  }
  rl_bind_key('\t',tabcompletion ? rl_complete : rl_insert);
}
#endif

static size_t *pivot,*Row,*Col;
static inline void solveAllocate(size_t n, size_t m)
{
  pivot=new size_t[n];
  if(m == 0) {
    Row=new size_t[n];
    Col=new size_t[n];
  } else {
    Row=NULL;
    Col=NULL;
  }
}

static inline void solveDeallocate()
{
  delete[] pivot;
  if(Row) delete[] Row;
  if(Col) delete[] Col;
}

void cleanup()
{
  if(initialdefaultpen) defaultpen=*initialdefaultpen;
  if(!interact::interactive) scrollLines=0;
  
  if(TeXinitialized) {
    camp::TeXpipepreamble.clear();
    camp::TeXpreamble.clear();
    camp::tex.pipeclose();
    TeXinitialized=false;
  }

#if defined(HAVE_LIBREADLINE) && defined(HAVE_HISTORY_STATE) && \
    defined(HAVE_LIBCURSES)
  store_history(&history_save);
  int nlines=getSetting<int>("historylines");
  for(historyMap_t::iterator h=historyMap.begin(); h != historyMap.end(); 
      ++h) {
    history_set_history_state(&h->second);
    stifle_history(nlines);
    if(h->first[0] != nosave) write_history(historyfilename(h->first).c_str());
  }
  history_set_history_state(&history_save);
#endif
}

void exitFunction(stack *Stack)
{
  if(atExitFunction && !nullfunc::instance()->compare(atExitFunction)) {
    atExitFunction->call(Stack);
    atExitFunction=NULL;
  }
  cleanup();
}

void updateFunction(stack *Stack)
{
  if(atExitFunction && !nullfunc::instance()->compare(atExitFunction))
    atExitFunction->call(Stack);
}

default_t def;
string emptystring;
transform Identity;
string commentchar="#";

}

namespace types {
extern const char *names[];
}

void checkformat(const char *ptr, bool intformat) 
{
  while(*ptr != '\0') {
    if(*ptr != '%') /* While we have regular characters, print them.  */
      ptr++;
    else { /* We've got a format specifier. */
      ptr++;
      
      while(*ptr && strchr ("-+ #0", *ptr)) /* Move past flags.  */
	*ptr++;

      if(*ptr == '*')
	ptr++;
      else while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	ptr++;
	  
      if(*ptr == '.') {
	*ptr++; /* Go past the period.  */
	if(*ptr == '*') {
	  ptr++;
	} else
	  while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	    *ptr++;
      }
      while(*ptr && strchr ("hlL", *ptr))
	*ptr++;
	  
      if(*ptr == '%') ++ptr;
      else if(*ptr != '\0') {
	if(intformat) {
	  switch(*ptr) {
	  case 'd':
	  case 'i':
	  case 'o':
	  case 'u':
	  case 'x':
	  case 'X':
	  case 'c':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type " 
		<< types::names[types::ty_int];
	    error(buf);
	    break;
	  }
	} else {
	  switch(*ptr) {
	  case 'f':
	  case 'e':
	  case 'E':
	  case 'g':
	  case 'G':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type "
		<< types::names[types::ty_real];
	    error(buf);
	    break;
	  }
	}
      }
    } /* End of else statement */
  }
}
  
// Return an angle in the interval [0,360).
inline double principalBranch(double deg)
{
  if(deg < 0) deg += 360; 
  return deg;
}

inline double Min(double a, double b)
{
  return (a < b) ? a : b;
}

inline double Max(double a, double b)
{
  return (a > b) ? a : b;
}

// Auto-generated routines:



namespace run {

// Initializers
#line 491 "runtime.in"
void intZero(stack *Stack)
{
#line 492 "runtime.in"
  {Stack->push<int>(0); return;}
}

#line 497 "runtime.in"
void realZero(stack *Stack)
{
#line 498 "runtime.in"
  {Stack->push<double>(0.0); return;}
}

#line 502 "runtime.in"
void boolFalse(stack *Stack)
{
#line 503 "runtime.in"
  {Stack->push<bool>(false); return;}
}

#line 507 "runtime.in"
void pushNullArray(stack *Stack)
{
#line 508 "runtime.in"
  {Stack->push<array*>(0); return;}
}

#line 512 "runtime.in"
void pushNullRecord(stack *Stack)
{
#line 513 "runtime.in"
  {Stack->push<frame*>(0); return;}
}

#line 517 "runtime.in"
void pushNullFunction(stack *Stack)
{
#line 518 "runtime.in"
  {Stack->push(nullfunc::instance()); return;}
}


// Default operations

// Put the default value token on the stack (in place of an argument when
// making a function call).
#line 527 "runtime.in"
void pushDefault(stack *Stack)
{
#line 528 "runtime.in"
  {Stack->push(def); return;}
}


// Test if the value on the stack is the default value token.
#line 534 "runtime.in"
void isDefault(stack *Stack)
{
  item i = vm::pop(Stack);
#line 535 "runtime.in"
  {Stack->push<bool>(isdefault(i)); return;}
}


// Logical operations
#line 541 "runtime.in"
// bool !(bool b);
void gen8(stack *Stack)
{
  bool b = vm::pop<bool>(Stack);
#line 542 "runtime.in"
  {Stack->push<bool>(!b); return;}
}

#line 547 "runtime.in"
void boolMemEq(stack *Stack)
{
  frame * b = vm::pop<frame *>(Stack);
  frame * a = vm::pop<frame *>(Stack);
#line 548 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 552 "runtime.in"
void boolMemNeq(stack *Stack)
{
  frame * b = vm::pop<frame *>(Stack);
  frame * a = vm::pop<frame *>(Stack);
#line 553 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 557 "runtime.in"
void boolFuncEq(stack *Stack)
{
  callable * b = vm::pop<callable *>(Stack);
  callable * a = vm::pop<callable *>(Stack);
#line 558 "runtime.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 562 "runtime.in"
void boolFuncNeq(stack *Stack)
{
  callable * b = vm::pop<callable *>(Stack);
  callable * a = vm::pop<callable *>(Stack);
#line 563 "runtime.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Casts
#line 569 "runtime.in"
void pairToGuide(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 570 "runtime.in"
  {Stack->push<guide*>(new pairguide(z)); return;}
}

#line 575 "runtime.in"
void pathToGuide(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 576 "runtime.in"
  {Stack->push<guide*>(new pathguide(p)); return;}
}

#line 581 "runtime.in"
void guideToPath(stack *Stack)
{
  guide * g = vm::pop<guide *>(Stack);
#line 582 "runtime.in"
  {Stack->push<path>(g->solve()); return;}
}


// Picture operations
#line 589 "runtime.in"
void newPicture(stack *Stack)
{
#line 590 "runtime.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 595 "runtime.in"
// bool empty(picture *f);
void gen17(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 596 "runtime.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 600 "runtime.in"
// pair max(picture *f);
void gen18(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 601 "runtime.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 605 "runtime.in"
// pair min(picture *f);
void gen19(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 606 "runtime.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 610 "runtime.in"
// void label(picture *f, string *s, string *size, double angle, pair position,	   pair align, pair scale, pen p);
void gen20(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  pair scale = vm::pop<pair>(Stack);
  pair align = vm::pop<pair>(Stack);
  pair position = vm::pop<pair>(Stack);
  double angle = vm::pop<double>(Stack);
  string * size = vm::pop<string *>(Stack);
  string * s = vm::pop<string *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 612 "runtime.in"
  f->append(new drawLabel(*s,*size,angle,position,align,scale,p));
}

#line 616 "runtime.in"
// bool labels(picture *f);
void gen21(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 617 "runtime.in"
  {Stack->push<bool>(f->havelabels()); return;}
}

#line 621 "runtime.in"
// void fill(picture *f, patharray *g, pen p);
void gen22(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 622 "runtime.in"
  f->append(new drawFill(copyArray(g),p));
}

#line 626 "runtime.in"
// void latticeshade(picture *f, patharray *g, pen fillrule, penarray2 *p);
void gen23(stack *Stack)
{
  penarray2 * p = vm::pop<penarray2 *>(Stack);
  pen fillrule = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 627 "runtime.in"
  f->append(new drawLatticeShade(copyArray(g),fillrule,copyArray(p)));
}

#line 631 "runtime.in"
// void axialshade(picture *f, patharray *g, pen pena, pair a, pen penb, pair b);
void gen24(stack *Stack)
{
  pair b = vm::pop<pair>(Stack);
  pen penb = vm::pop<pen>(Stack);
  pair a = vm::pop<pair>(Stack);
  pen pena = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 632 "runtime.in"
  f->append(new drawAxialShade(copyArray(g),pena,a,penb,b));
}

#line 636 "runtime.in"
// void radialshade(picture *f, patharray *g, pen pena, pair a, double ra,		 pen penb, pair b, double rb);
void gen25(stack *Stack)
{
  double rb = vm::pop<double>(Stack);
  pair b = vm::pop<pair>(Stack);
  pen penb = vm::pop<pen>(Stack);
  double ra = vm::pop<double>(Stack);
  pair a = vm::pop<pair>(Stack);
  pen pena = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 638 "runtime.in"
  f->append(new drawRadialShade(copyArray(g),pena,a,ra,penb,b,rb));
}

#line 642 "runtime.in"
// void gouraudshade(picture *f, patharray *g, pen fillrule, penarray *p,		  pairarray *z, intarray *edges);
void gen26(stack *Stack)
{
  intarray * edges = vm::pop<intarray *>(Stack);
  pairarray * z = vm::pop<pairarray *>(Stack);
  penarray * p = vm::pop<penarray *>(Stack);
  pen fillrule = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 644 "runtime.in"
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(copyArray(g),fillrule,copyArray(p),
				 copyArray(z),copyArray(edges)));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 653 "runtime.in"
// void clip(picture *f, patharray *g, pen p);
void gen27(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 654 "runtime.in"
  f->enclose(new drawClipBegin(copyArray(g),p),new drawClipEnd());
}

#line 658 "runtime.in"
// void beginclip(picture *f, patharray *g, pen p);
void gen28(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 659 "runtime.in"
  f->append(new drawClipBegin(copyArray(g),p,false));
}

#line 663 "runtime.in"
// void postscript(picture *f, string s);
void gen29(stack *Stack)
{
  string s = vm::pop<string>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 664 "runtime.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 668 "runtime.in"
// void tex(picture *f, string s);
void gen30(stack *Stack)
{
  string s = vm::pop<string>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 669 "runtime.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 673 "runtime.in"
// void texpreamble(string s);
void gen31(stack *Stack)
{
  string s = vm::pop<string>(Stack);
#line 674 "runtime.in"
  string t=s+"\n";
  camp::TeXpipepreamble.push_back(t);
  camp::TeXpreamble.push_back(t);
}

#line 680 "runtime.in"
// void layer(picture *f);
void gen32(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 681 "runtime.in"
  f->append(new drawLayer());
}

#line 685 "runtime.in"
// void image(picture *f, realarray2 *data, penarray *palette, 	   pair initial, pair final, transform t=Identity);
void gen33(stack *Stack)
{
  transform t = vm::pop<transform>(Stack,Identity);
  pair final = vm::pop<pair>(Stack);
  pair initial = vm::pop<pair>(Stack);
  penarray * palette = vm::pop<penarray *>(Stack);
  realarray2 * data = vm::pop<realarray2 *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 687 "runtime.in"
  f->append(new drawImage(copyArray2(data),copyArray(palette),
			  t*matrix(initial,final)));
}

#line 692 "runtime.in"
// void shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,	     string format=emptystring, bool wait=0, bool quiet=0,	     transformarray *GUItransform, boolarray *GUIdelete);
void gen34(stack *Stack)
{
  boolarray * GUIdelete = vm::pop<boolarray *>(Stack);
  transformarray * GUItransform = vm::pop<transformarray *>(Stack);
  bool quiet = vm::pop<bool>(Stack,0);
  bool wait = vm::pop<bool>(Stack,0);
  string format = vm::pop<string>(Stack,emptystring);
  picture * preamble = vm::pop<picture *>(Stack,NULL);
  picture * f = vm::pop<picture *>(Stack);
  string prefix = vm::pop<string>(Stack,emptystring);
#line 695 "runtime.in"
  if(prefix.empty()) prefix=getSetting<string>("outname");
  
  size_t size=GUItransform && GUIdelete ?
    checkArrays(GUItransform,GUIdelete) : 0;
 
  if(getSetting<double>("deconstruct") || size) {
    picture *result=new picture;
    unsigned level=0;
    unsigned i=0;
    nodelist::iterator p;
    for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
      bool Delete;
      transform t;
      if(i < size) {
	t=*(read<transform*>(GUItransform,i));
	Delete=read<bool>(GUIdelete,i);
      } else {
	t=identity();
	Delete=false;
      }
      picture *group=new picture;
// Ignore unclosed begingroups but not spurious endgroups.
      const char *nobegin="endgroup without matching begingroup";
      assert(*p);
      if((*p)->endgroup()) error(nobegin);
      if((*p)->begingroup()) {
	++level;
	while(p != f->nodes.end() && level) {
	  drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
	  group->append(e);
	  ++p;
	  if(p == f->nodes.end()) break;
	  assert(*p);
	  if((*p)->begingroup()) ++level;
	  if((*p)->endgroup()) if(level) --level;
	  else error(nobegin);
	}
      }
      if(p == f->nodes.end()) break;
      assert(*p);
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      if(!group->empty()) {
	if(getSetting<double>("deconstruct")) {
	  ostringstream buf;
	  buf << prefix << "_" << i;
	  group->shipout(preamble,buf.str(),"tgif",false,true,Delete);
	}
	++i;
      }
      if(size && !Delete) result->add(*group);
    }
    if(size) f=result;
  }

  f->shipout(preamble,prefix,format,wait,quiet);
}


// Pen operations
#line 756 "runtime.in"
void newPen(stack *Stack)
{
#line 757 "runtime.in"
  {Stack->push<pen>(pen()); return;}
}

#line 762 "runtime.in"
// bool ==(pen a, pen b);
void gen36(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 763 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 767 "runtime.in"
// bool !=(pen a, pen b);
void gen37(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 768 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 772 "runtime.in"
// pen +(pen a, pen b);
void gen38(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 773 "runtime.in"
  {Stack->push<pen>(a+b); return;}
}

#line 777 "runtime.in"
// pen *(double a, pen b);
void gen39(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  double a = vm::pop<double>(Stack);
#line 778 "runtime.in"
  {Stack->push<pen>(a*b); return;}
}

#line 782 "runtime.in"
// pen *(pen a, double b);
void gen40(stack *Stack)
{
  double b = vm::pop<double>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 783 "runtime.in"
  {Stack->push<pen>(b*a); return;}
}

#line 787 "runtime.in"
// pair max(pen p);
void gen41(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 788 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 792 "runtime.in"
// pair min(pen p);
void gen42(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 793 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

// Reset the meaning of pen default attributes.
#line 798 "runtime.in"
// void resetdefaultpen();
void gen43(stack *)
{
#line 799 "runtime.in"
  if(initialdefaultpen) defaultpen=*initialdefaultpen;
}

#line 803 "runtime.in"
// void defaultpen(pen p);
void gen44(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 804 "runtime.in"
  defaultpen=pen(resolvepen,p);
}

#line 808 "runtime.in"
// pen defaultpen();
void gen45(stack *Stack)
{
#line 809 "runtime.in"
  {Stack->push<pen>(defaultpen); return;}
}

#line 813 "runtime.in"
// pen invisible();
void gen46(stack *Stack)
{
#line 814 "runtime.in"
  {Stack->push<pen>(pen(invisiblepen)); return;}
}

#line 818 "runtime.in"
// pen gray(pen p);
void gen47(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 819 "runtime.in"
  if(p.rgb()) p.rgbtogrey();
  else if (p.cmyk()) p.cmyktogrey();
  {Stack->push<pen>(p); return;}
}

#line 825 "runtime.in"
// pen rgb(pen p);
void gen48(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 826 "runtime.in"
  if(p.grayscale()) p.greytorgb();
  else if (p.cmyk()) p.cmyktorgb();
  {Stack->push<pen>(p); return;}
}

#line 832 "runtime.in"
// pen rgb(double r, double g, double b);
void gen49(stack *Stack)
{
  double b = vm::pop<double>(Stack);
  double g = vm::pop<double>(Stack);
  double r = vm::pop<double>(Stack);
#line 833 "runtime.in"
  {Stack->push<pen>(pen(r,g,b)); return;}
}

#line 837 "runtime.in"
// pen cmyk(double c, double m, double y, double k);
void gen50(stack *Stack)
{
  double k = vm::pop<double>(Stack);
  double y = vm::pop<double>(Stack);
  double m = vm::pop<double>(Stack);
  double c = vm::pop<double>(Stack);
#line 838 "runtime.in"
  {Stack->push<pen>(pen(c,m,y,k)); return;}  
}

#line 842 "runtime.in"
// pen gray(double gray);
void gen51(stack *Stack)
{
  double gray = vm::pop<double>(Stack);
#line 843 "runtime.in"
  {Stack->push<pen>(pen(gray)); return;}
}

#line 847 "runtime.in"
// realarray* colors(pen p);
void gen52(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 848 "runtime.in"  
  int n=ColorComponents[p.colorspace()];
  array *a=new array(n);
  
  switch(n) {
  case 0:
    break;
  case 1: 
    (*a)[0]=p.gray(); 
    break;
  case 3:
    (*a)[0]=p.red(); 
    (*a)[1]=p.green(); 
    (*a)[2]=p.blue(); 
    break;
  case 4:
    (*a)[0]=p.cyan();
    (*a)[1]=p.magenta(); 
    (*a)[2]=p.yellow(); 
    (*a)[3]=p.black();
    break;
  default:
    break;
  }
  {Stack->push<realarray*>(a); return;}
}

#line 875 "runtime.in"
// pen pattern(string *s);
void gen53(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 876 "runtime.in"
  {Stack->push<pen>(pen(setpattern,*s)); return;}
}

#line 880 "runtime.in"
// string pattern(pen p);
void gen54(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 881 "runtime.in"
  {Stack->push<string>(p.fillpattern()); return;}  
}

#line 885 "runtime.in"
// pen fillrule(int n);
void gen55(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 886 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nFill ? (FillRule) n : DEFFILL)); return;}
}

#line 890 "runtime.in"
// int fillrule(pen p);
void gen56(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 891 "runtime.in"
  {Stack->push<int>(p.Fillrule()); return;}  
}

#line 895 "runtime.in"
// pen linetype(string *s, bool scale);
void gen57(stack *Stack)
{
  bool scale = vm::pop<bool>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 896 "runtime.in"
  {Stack->push<pen>(pen(LineType(*s,scale))); return;} 
}

#line 900 "runtime.in"
// string linetype(pen p);
void gen58(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 901 "runtime.in"
  {Stack->push<string>(p.stroke()); return;}  
}

#line 905 "runtime.in"
// pen linecap(int n);
void gen59(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 906 "runtime.in"
  {Stack->push<pen>(pen(setlinecap,n >= 0 && n < nCap ? n : DEFCAP)); return;}
}

#line 910 "runtime.in"
// int linecap(pen p);
void gen60(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 911 "runtime.in"
  {Stack->push<int>(p.cap()); return;}  
}

#line 915 "runtime.in"
// pen linejoin(int n);
void gen61(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 916 "runtime.in"
  {Stack->push<pen>(pen(setlinejoin,n >= 0 && n < nJoin ? n : DEFJOIN)); return;}
}

#line 920 "runtime.in"
// int linejoin(pen p);
void gen62(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 921 "runtime.in"
  {Stack->push<int>(p.join()); return;}  
}

#line 925 "runtime.in"
// pen linewidth(double x);
void gen63(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 926 "runtime.in"
  {Stack->push<pen>(pen(setlinewidth,x >= 0.0 ? x : DEFWIDTH)); return;}
}

#line 930 "runtime.in"
// double linewidth(pen p);
void gen64(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 931 "runtime.in"
  {Stack->push<double>(p.width()); return;}  
}

#line 935 "runtime.in"
// pen fontcommand(string *s);
void gen65(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 936 "runtime.in"
  {Stack->push<pen>(pen(setfont,*s)); return;}
}

#line 940 "runtime.in"
// string font(pen p);
void gen66(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 941 "runtime.in"
  {Stack->push<string>(p.Font()); return;}
}

#line 945 "runtime.in"
// pen fontsize(double size, double skip);
void gen67(stack *Stack)
{
  double skip = vm::pop<double>(Stack);
  double size = vm::pop<double>(Stack);
#line 946 "runtime.in"
  {Stack->push<pen>(pen(setfontsize,size > 0.0 ? size : 0.0,
	     skip > 0.0 ? skip : 0.0)); return;}
}

#line 951 "runtime.in"
// double fontsize(pen p);
void gen68(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 952 "runtime.in"
  {Stack->push<double>(p.size()); return;}
}

#line 956 "runtime.in"
// double lineskip(pen p);
void gen69(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 957 "runtime.in"
  {Stack->push<double>(p.Lineskip()); return;}  
}

#line 961 "runtime.in"
// pen overwrite(int n);
void gen70(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 962 "runtime.in"
  {Stack->push<pen>(pen(setoverwrite,n >= 0 && n < nOverwrite ? (overwrite_t) n :
	     DEFWRITE)); return;}
}

#line 967 "runtime.in"
// int overwrite(pen p);
void gen71(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 968 "runtime.in"
  {Stack->push<int>(p.Overwrite()); return;}  
}

#line 972 "runtime.in"
// pen basealign(int n);
void gen72(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 973 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nBaseLine ? (BaseLine) n : DEFBASE)); return;}
}

#line 977 "runtime.in"
// int basealign(pen p);
void gen73(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 978 "runtime.in"
  {Stack->push<int>(p.Baseline()); return;}
}

#line 982 "runtime.in"
// path nib(pen p);
void gen74(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 983 "runtime.in"
  static path nullpath;
  path *g=p.Path();
  {Stack->push<path>(g ? *g : nullpath); return;}
}

#line 989 "runtime.in"
// pen makepen(path p);
void gen75(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 990 "runtime.in"
  {Stack->push<pen>(p.size() == 0 ? pen() : pen(new path(p))); return;}
}

#line 994 "runtime.in"
// void _draw(picture *f, path g, pen p);
void gen76(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  path g = vm::pop<path>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 995 "runtime.in"
  f->append(new drawPath(g,p));
}

#line 999 "runtime.in"
// void endclip(picture *f);
void gen77(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 1000 "runtime.in"
  f->append(new drawClipEnd(false));
}

#line 1004 "runtime.in"
// void gsave(picture *f);
void gen78(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 1005 "runtime.in"
  f->append(new drawGsave());
}

#line 1009 "runtime.in"
// void grestore(picture *f);
void gen79(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 1010 "runtime.in"
  f->append(new drawGrestore());
}

#line 1014 "runtime.in"
// void begingroup(picture *f);
void gen80(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 1015 "runtime.in"
  f->append(new drawBegin());
}

#line 1019 "runtime.in"
// void endgroup(picture *f);
void gen81(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 1020 "runtime.in"
  f->append(new drawEnd());
}

#line 1024 "runtime.in"
// void add(picture *dest, picture *src);
void gen82(stack *Stack)
{
  picture * src = vm::pop<picture *>(Stack);
  picture * dest = vm::pop<picture *>(Stack);
#line 1025 "runtime.in"
  dest->add(*src);
}

#line 1029 "runtime.in"
// void prepend(picture *dest, picture *src);
void gen83(stack *Stack)
{
  picture * src = vm::pop<picture *>(Stack);
  picture * dest = vm::pop<picture *>(Stack);
#line 1030 "runtime.in"
  dest->prepend(*src);
}


// Interactive mode
#line 1036 "runtime.in"
// bool interact();
void gen84(stack *Stack)
{
#line 1037 "runtime.in"
  {Stack->push<bool>(interact::interactive); return;}
}

#line 1042 "runtime.in"
// void uptodate(bool b);
void gen85(stack *Stack)
{
  bool b = vm::pop<bool>(Stack);
#line 1043 "runtime.in"
  interact::uptodate=b;
}

#line 1047 "runtime.in"
// bool uptodate();
void gen86(stack *Stack)
{
#line 1048 "runtime.in"
  {Stack->push<bool>(interact::uptodate); return;}
}


// System commands
#line 1054 "runtime.in"
// int system(string *str);
void gen87(stack *Stack)
{
  string * str = vm::pop<string *>(Stack);
#line 1055 "runtime.in"
  if(safe) error("system() call disabled; override with option -unsafe");
  else {Stack->push<int>(System(str->c_str())); return;}
}

#line 1061 "runtime.in"
// void abort(string *msg);
void gen88(stack *Stack)
{
  string * msg = vm::pop<string *>(Stack);
#line 1062 "runtime.in"
  error(msg->c_str());
}

#line 1066 "runtime.in"
// void _eval(string *s, bool embedded);
void gen89(stack *Stack)
{
  bool embedded = vm::pop<bool>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1067 "runtime.in"
  loop::doITree(parser::parseString(*s),embedded);
}

#line 1071 "runtime.in"
// void _eval(runnable *s, bool embedded);
void gen90(stack *Stack)
{
  bool embedded = vm::pop<bool>(Stack);
  runnable * s = vm::pop<runnable *>(Stack);
#line 1072 "runtime.in"
  loop::doIRunnable(s,embedded);
}

#line 1076 "runtime.in"
// void gui(double x=1);
void gen91(stack *Stack)
{
  double x = vm::pop<double>(Stack,1);
#line 1077 "runtime.in" 
  Setting("deconstruct")=(x > 0.0 ? x : 0.0);
}

#line 1081 "runtime.in"
// bool deconstruct();
void gen92(stack *Stack)
{
#line 1082 "runtime.in" 
  {Stack->push<bool>(getSetting<double>("deconstruct")); return;}
}

#line 1086 "runtime.in"
// void readGUI();
void gen93(stack *)
{
#line 1087 "runtime.in"
  static bool first=true;
  string name=buildname(getSetting<string>("outname"),"gui");
  std::ifstream exists(name.c_str());
  if(exists) {
    if((getSetting<bool>("clearGUI") && !interact::interactive) ||
       (first && interact::interactive)) unlink(name.c_str());
    else {
      if (!getSetting<bool>("ignoreGUI")) {
	string cmd=string("include \"")+name+string("\";");
	absyntax::block *ast = parser::parseString(cmd);
	loop::doITree(ast,true);
      }
    }
  }
  first=false;
}

// Wrapper for the stack::load() method.
#line 1106 "runtime.in"
void loadModule(stack *Stack)
{
  string * index = vm::pop<string *>(Stack);
#line 1107 "runtime.in"
  Stack->load(*index);
}

#line 1111 "runtime.in"
// string cd(string *d);
void gen95(stack *Stack)
{
  string * d = vm::pop<string *>(Stack);
#line 1112 "runtime.in"
  int rc=setPath(d->c_str());
  if(rc != 0) {
    ostringstream buf;
    buf << "Cannot change to directory '" << *d << "'";
    error(buf);
  }
  char *p=getPath();
  if(p && interact::interactive) 
    cout << p << endl;
  {Stack->push<string>(p); return;}
}

#line 1125 "runtime.in"
// void scroll(int n);
void gen96(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1126 "runtime.in"
  scrollLines=n;
}


// Path operations
#line 1132 "runtime.in"
void nullPath(stack *Stack)
{
#line 1133 "runtime.in"
  static path nullpath;
  {Stack->push<path>(nullpath); return;}
}

#line 1139 "runtime.in"
// pair point(path p, int n);
void gen98(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1140 "runtime.in"
  {Stack->push<pair>(p.point(n)); return;}
}

#line 1144 "runtime.in"
// pair point(path p, double t);
void gen99(stack *Stack)
{
  double t = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1145 "runtime.in"
  {Stack->push<pair>(p.point(t)); return;}
}

#line 1149 "runtime.in"
// pair precontrol(path p, int n);
void gen100(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1150 "runtime.in"
  {Stack->push<pair>(p.precontrol(n)); return;}
}

#line 1154 "runtime.in"
// pair precontrol(path p, double t);
void gen101(stack *Stack)
{
  double t = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1155 "runtime.in"
  {Stack->push<pair>(p.precontrol(t)); return;}
}

#line 1159 "runtime.in"
// pair postcontrol(path p, int n);
void gen102(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1160 "runtime.in"
  {Stack->push<pair>(p.postcontrol(n)); return;}
}

#line 1164 "runtime.in"
// pair postcontrol(path p, double t);
void gen103(stack *Stack)
{
  double t = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1165 "runtime.in"
  {Stack->push<pair>(p.postcontrol(t)); return;}
}

#line 1169 "runtime.in"
// pair dir(path p, int n);
void gen104(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1170 "runtime.in"
  {Stack->push<pair>(unit(p.direction(n))); return;}
}

#line 1174 "runtime.in"
// pair dir(path p, double t);
void gen105(stack *Stack)
{
  double t = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1175 "runtime.in"
  {Stack->push<pair>(unit(p.direction(t))); return;}
}

#line 1179 "runtime.in"
// path reverse(path p);
void gen106(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1180 "runtime.in"
  {Stack->push<path>(p.reverse()); return;}
}

#line 1184 "runtime.in"
// path subpath(path p, int b, int e);
void gen107(stack *Stack)
{
  int e = vm::pop<int>(Stack);
  int b = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1185 "runtime.in"
  {Stack->push<path>(p.subpath(b,e)); return;}
}

#line 1189 "runtime.in"
// path subpath(path p, double b, double e);
void gen108(stack *Stack)
{
  double e = vm::pop<double>(Stack);
  double b = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1190 "runtime.in"
  {Stack->push<path>(p.subpath(b,e)); return;}
}

#line 1194 "runtime.in"
// int length(path p);
void gen109(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1195 "runtime.in"
  {Stack->push<int>(p.length()); return;}
}

#line 1199 "runtime.in"
// bool cyclic(path p);
void gen110(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1200 "runtime.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 1204 "runtime.in"
// bool straight(path p, int i);
void gen111(stack *Stack)
{
  int i = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1205 "runtime.in"
  {Stack->push<bool>(p.straight(i)); return;}
}

#line 1209 "runtime.in"
// double arclength(path p);
void gen112(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1210 "runtime.in"
  {Stack->push<double>(p.arclength()); return;}
}

#line 1214 "runtime.in"
// double arctime(path p, double dval);
void gen113(stack *Stack)
{
  double dval = vm::pop<double>(Stack);
  path p = vm::pop<path>(Stack);
#line 1215 "runtime.in"
  {Stack->push<double>(p.arctime(dval)); return;}
}

#line 1219 "runtime.in"
// double dirtime(path p, pair z);
void gen114(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
  path p = vm::pop<path>(Stack);
#line 1220 "runtime.in"
  {Stack->push<double>(p.directiontime(z)); return;}
}

#line 1224 "runtime.in"
// pair intersect(path x, path y, double fuzz=0);
void gen115(stack *Stack)
{
  double fuzz = vm::pop<double>(Stack,0);
  path y = vm::pop<path>(Stack);
  path x = vm::pop<path>(Stack);
#line 1225 "runtime.in"
  {Stack->push<pair>(intersectiontime(x,y,fuzz)); return;}
}

#line 1229 "runtime.in"
// int size(path p);
void gen116(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1230 "runtime.in"
  {Stack->push<int>(p.size()); return;}
}

#line 1234 "runtime.in"
// path &(path p, path q);
void gen117(stack *Stack)
{
  path q = vm::pop<path>(Stack);
  path p = vm::pop<path>(Stack);
#line 1235 "runtime.in"
  {Stack->push<path>(camp::concat(p,q)); return;}
}

#line 1239 "runtime.in"
// pair min(path p);
void gen118(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1240 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

#line 1244 "runtime.in"
// pair max(path p);
void gen119(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1245 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 1249 "runtime.in"
// double relativedistance(double theta, double phi, double t, bool atleast);
void gen120(stack *Stack)
{
  bool atleast = vm::pop<bool>(Stack);
  double t = vm::pop<double>(Stack);
  double phi = vm::pop<double>(Stack);
  double theta = vm::pop<double>(Stack);
#line 1250 "runtime.in"
  {Stack->push<double>(camp::velocity(theta,phi,tension(t,atleast))); return;}
}

#line 1254 "runtime.in"
// bool inside(patharray *g, pair z, pen p);
void gen121(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  pair z = vm::pop<pair>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
#line 1255 "runtime.in"
  array *G=copyArray(g);
  size_t size=G->size();
  int count=0;
  for(size_t i=0; i < size; i++) 
    count += read<path *>(G,i)->inside(z);
  {Stack->push<bool>(p.inside(count)); return;}
}


// Guide operations
#line 1266 "runtime.in"
void nullGuide(stack *Stack)
{
#line 1267 "runtime.in"
  {Stack->push<guide*>(new pathguide(path())); return;}
}

#line 1272 "runtime.in"
void dotsGuide(stack *Stack)
{
  guidearray * a = vm::pop<guidearray *>(Stack);
#line 1273 "runtime.in"
  guidevector v;
  size_t size=checkArray(a);
  for (size_t i=0; i < size; ++i)
    v.push_back(a->read<guide*>(i));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1282 "runtime.in"
void dashesGuide(stack *Stack)
{
  guidearray * a = vm::pop<guidearray *>(Stack);
#line 1283 "runtime.in"
  static camp::curlSpec curly;
  static specguide curlout(&curly, camp::OUT);
  static specguide curlin(&curly, camp::IN);

  size_t n=checkArray(a);

  // a--b is equivalent to a{curl 1}..{curl 1}b
  guidevector v;
  if (n > 0)
    v.push_back(a->read<guide*>(0));

  if (n==1) {
    v.push_back(&curlout);
    v.push_back(&curlin);
  }
  else
    for (size_t i=1; i<n; ++i) {
      v.push_back(&curlout);
      v.push_back(&curlin);
      v.push_back(a->read<guide*>(i));
    }

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1309 "runtime.in"
// guide* operator cycle();
void gen125(stack *Stack)
{
#line 1310 "runtime.in"
  {Stack->push<guide*>(new cycletokguide()); return;}
}

#line 1314 "runtime.in"
// guide* operator spec(pair z, int p);
void gen126(stack *Stack)
{
  int p = vm::pop<int>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 1315 "runtime.in"
  camp::side d=(camp::side) p;
  camp::dirSpec *sp=new camp::dirSpec(angle(z));

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 1322 "runtime.in"
// guide* operator curl(double gamma, int p);
void gen127(stack *Stack)
{
  int p = vm::pop<int>(Stack);
  double gamma = vm::pop<double>(Stack);
#line 1323 "runtime.in"
  camp::side d=(camp::side) p;
  camp::curlSpec *sp=new camp::curlSpec(gamma);

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 1330 "runtime.in"
// guide* operator tension(double tout, double tin, bool atleast);
void gen128(stack *Stack)
{
  bool atleast = vm::pop<bool>(Stack);
  double tin = vm::pop<double>(Stack);
  double tout = vm::pop<double>(Stack);
#line 1331 "runtime.in"
  tension Tin(tin, atleast),
         Tout(tout, atleast);

  {Stack->push<guide*>(new tensionguide(tout, tin)); return;}
}

#line 1338 "runtime.in"
// guide* operator controls(pair zout, pair zin);
void gen129(stack *Stack)
{
  pair zin = vm::pop<pair>(Stack);
  pair zout = vm::pop<pair>(Stack);
#line 1339 "runtime.in"
  {Stack->push<guide*>(new controlguide(zout, zin)); return;}
}


// String operations
#line 1345 "runtime.in"
void emptyString(stack *Stack)
{
#line 1346 "runtime.in"
  {Stack->push<string>(emptystring); return;}
}

#line 1351 "runtime.in"
// int length(string *s);
void gen131(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 1352 "runtime.in"
  {Stack->push<int>((int) s->length()); return;}
}

#line 1356 "runtime.in"
// int find(string *s, string t, int pos=0);
void gen132(stack *Stack)
{
  int pos = vm::pop<int>(Stack,0);
  string t = vm::pop<string>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1357 "runtime.in"
  {Stack->push<int>((int) s->find(t,pos)); return;}
}

#line 1361 "runtime.in"
// int rfind(string *s, string t, int pos=-1);
void gen133(stack *Stack)
{
  int pos = vm::pop<int>(Stack,-1);
  string t = vm::pop<string>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1362 "runtime.in"
  {Stack->push<int>((int) s->rfind(t,pos)); return;}
}

#line 1366 "runtime.in"
// string reverse(string s);
void gen134(stack *Stack)
{
  string s = vm::pop<string>(Stack);
#line 1367 "runtime.in"
  reverse(s.begin(),s.end());
  {Stack->push<string>(s); return;}
}

#line 1372 "runtime.in"
// string insert(string s, int pos, string t);
void gen135(stack *Stack)
{
  string t = vm::pop<string>(Stack);
  int pos = vm::pop<int>(Stack);
  string s = vm::pop<string>(Stack);
#line 1373 "runtime.in"
  if ((size_t)pos < s.length())
    {Stack->push<string>(s.insert(pos,t)); return;}
  {Stack->push<string>(s); return;}
}

#line 1379 "runtime.in"
// string substr(string* s, int pos, int n=-1);
void gen136(stack *Stack)
{
  int n = vm::pop<int>(Stack,-1);
  int pos = vm::pop<int>(Stack);
  string* s = vm::pop<string*>(Stack);
#line 1380 "runtime.in"
  if ((size_t)pos < s->length())
    {Stack->push<string>(s->substr(pos,n)); return;}
  {Stack->push<string>(emptystring); return;}
}

#line 1386 "runtime.in"
// string erase(string s, int pos, int n);
void gen137(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  int pos = vm::pop<int>(Stack);
  string s = vm::pop<string>(Stack);
#line 1387 "runtime.in"
  if ((size_t)pos < s.length())
    {Stack->push<string>(s.erase(pos,n)); return;}
  {Stack->push<string>(s); return;} 
}

// returns a string constructed by translating all occurrences of the string
// from in an array of string pairs {from,to} to the string to in string s.
#line 1395 "runtime.in"
// string replace(string *S, stringarray2 *translate);
void gen138(stack *Stack)
{
  stringarray2 * translate = vm::pop<stringarray2 *>(Stack);
  string * S = vm::pop<string *>(Stack);
#line 1396 "runtime.in"
  size_t size=checkArray(translate);
  for(size_t i=0; i < size; i++) {
    array *a=read<array*>(translate,i);
    checkArray(a);
  }
  const char *p=S->c_str();
  ostringstream buf;
  while(*p) {
    for(size_t i=0; i < size;) {
      array *a=read<array*>(translate,i);
      string* from=read<string*>(a,0);
      size_t len=from->length();
      if(strncmp(p,from->c_str(),len) != 0) {i++; continue;}
      buf << read<string>(a,1);
      p += len;
      if(*p == 0) {Stack->push<string>(buf.str()); return;}
      i=0;
    }
    buf << *(p++);
  }
  {Stack->push<string>(buf.str()); return;}
}

#line 1420 "runtime.in"
// string format(string *format, int x);
void gen139(stack *Stack)
{
  int x = vm::pop<int>(Stack);
  string * format = vm::pop<string *>(Stack);
#line 1421 "runtime.in"
  const char *f=format->c_str();
  
  checkformat(f,true);
  
  int size=snprintf(NULL,0,f,x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f,x);
  string s=string(buf);
  delete[] buf;
  {Stack->push<string>(s); return;}
}

#line 1435 "runtime.in"
// string format(string *format, double x);
void gen140(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  string * format = vm::pop<string *>(Stack);
#line 1436 "runtime.in"
  ostringstream out;
  
  checkformat(format->c_str(),false);
  
  const char *phantom="\\phantom{+}";
  const char *p0=format->c_str();
  
  const char *p=p0;
  const char *start=NULL;
  while (*p != 0) {
    if(*p == '%') {
      p++;
      if(*p != '%') {start=p-1; break;}
    }
    out << *(p++);
  }
  
  if(!start) {Stack->push<string>(out.str()); return;}
  
  // Allow at most 1 argument  
  while (*p != 0) {
    if(*p == '*' || *p == '$') {Stack->push<string>(out.str()); return;}
    if(isupper(*p) || islower(*p)) {p++; break;}
    p++;
  }
  
  const char *tail=p;
  string f=format->substr(start-p0,tail-start);
  int size=snprintf(NULL,0,f.c_str(),x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f.c_str(),x);

  bool trailingzero=f.find("#") < string::npos;
  bool plus=f.find("+") < string::npos;
  bool space=f.find(" ") < string::npos;
  
  char *q=buf; // beginning of formatted number

  if(*q == ' ') {
    out << phantom;
    q++;
  }
  
  // Remove any spurious sign
  if(*q == '-' || *q == '+') {
    p=q+1;
    bool zero=true;
    while(*p != 0) {
      if(!isdigit(*p) && *p != '.') break;
      if(isdigit(*p) && *p != '0') {zero=false; break;}
      p++;
    }
    if(zero) {
      q++;
      if(plus || space) out << phantom;
    }
  }
  
  const char *r=p=q;
  bool dp=false;
  while(*r != 0 && (isdigit(*r) || *r == '.' || *r == '+' || *r == '-')) {
    if(*r == '.') dp=true;
    r++;
  }
  if(dp) { // Remove trailing zeros and/or decimal point
    r--;
    unsigned int n=0;
    while(r > q && *r == '0') {r--; n++;}
    if(*r == '.') {r--; n++;}
    while(q <= r) out << *(q++);
    if(!trailingzero) q += n;
  }
  
  bool zero=(r == p && *r == '0') && !trailingzero;
  
  // Translate "E+/E-/e+/e-" exponential notation to TeX
  while(*q != 0) {
    if((*q == 'E' || *q == 'e') && (*(q+1) == '+' || *(q+1) == '-')) {
      if(!zero) out << "\\!\\times\\!10^{";
      bool plus=(*(q+1) == '+');
      q++;
      if(plus) q++;
      if(*q == '-') out << *(q++);
      while(*q == '0' && (zero || isdigit(*(q+1)))) q++;
      while(isdigit(*q)) out << *(q++);
      if(!zero) {
	if(plus) out << phantom;
	out << "}";
      }
      break;
    }
    out << *(q++);
  }
  
  while(*tail != 0) 
    out << *(tail++);
  
  delete[] buf;
  {Stack->push<string>(out.str()); return;}
}

#line 1539 "runtime.in"
// string time(string *format);
void gen141(stack *Stack)
{
  string * format = vm::pop<string *>(Stack);
#line 1540 "runtime.in"
#ifdef HAVE_STRFTIME
  static const size_t n=256;
  static char Time[n];
  const time_t bintime=time(NULL);
  strftime(Time,n,format->c_str(),localtime(&bintime));
  {Stack->push<string>(Time); return;}
#else  
  {Stack->push<string>(*format); return;}
#endif  
}


// Math
#line 1554 "runtime.in"
// double ^(double x, int y);
void gen142(stack *Stack)
{
  int y = vm::pop<int>(Stack);
  double x = vm::pop<double>(Stack);
#line 1555 "runtime.in"
  {Stack->push<double>(pow(x,y)); return;}
}

#line 1560 "runtime.in"
// int quotient(int x, int y);
void gen143(stack *Stack)
{
  int y = vm::pop<int>(Stack);
  int x = vm::pop<int>(Stack);
#line 1561 "runtime.in" 
  if (y == 0) dividebyzero();
// Implementation-independent definition of integer division: round down
  {Stack->push<int>((x-portableMod(x,y))/y); return;}
}

#line 1567 "runtime.in"
// int abs(int x);
void gen144(stack *Stack)
{
  int x = vm::pop<int>(Stack);
#line 1568 "runtime.in" 
  {Stack->push<int>(abs(x)); return;}
}

#line 1572 "runtime.in"
// int sgn(double x);
void gen145(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1573 "runtime.in" 
  {Stack->push<int>(sgn(x)); return;}
}

#line 1577 "runtime.in"
// int rand();
void gen146(stack *Stack)
{
#line 1578 "runtime.in" 
  {Stack->push<int>(rand()); return;}
}

#line 1582 "runtime.in"
// void srand(int seed);
void gen147(stack *Stack)
{
  int seed = vm::pop<int>(Stack);
#line 1583 "runtime.in" 
  srand(seed);
}

#line 1587 "runtime.in"
// int ceil(double x);
void gen148(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1588 "runtime.in" 
  double y=ceil(x);
  checkint(y,0);
  {Stack->push<int>((int) y); return;}
}

#line 1594 "runtime.in"
// int floor(double x);
void gen149(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1595 "runtime.in" 
  double y=floor(x);
  checkint(y,0);
  {Stack->push<int>((int) y); return;}
}

#line 1601 "runtime.in"
// int round(double x);
void gen150(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1602 "runtime.in" 
  if(fabs(x) >= INT_MAX+0.5) integeroverflow(0);
  {Stack->push<int>(Round(x)); return;}
}

#line 1607 "runtime.in"
// int Ceil(double x);
void gen151(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1608 "runtime.in" 
  {Stack->push<int>(Ceil(x)); return;}
}

#line 1612 "runtime.in"
// int Floor(double x);
void gen152(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1613 "runtime.in" 
  {Stack->push<int>(Floor(x)); return;}
}

#line 1617 "runtime.in"
// int Round(double x);
void gen153(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1618 "runtime.in" 
  {Stack->push<int>(Round(intcap(x))); return;}
}

#line 1622 "runtime.in"
// double fmod(double x, double y);
void gen154(stack *Stack)
{
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1623 "runtime.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<double>(fmod(x,y)); return;}
}

#line 1628 "runtime.in"
// double atan2(double y, double x);
void gen155(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  double y = vm::pop<double>(Stack);
#line 1629 "runtime.in" 
  {Stack->push<double>(atan2(y,x)); return;}
}

#line 1633 "runtime.in"
// double hypot(double x, double y);
void gen156(stack *Stack)
{
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1634 "runtime.in" 
  {Stack->push<double>(hypot(x,y)); return;}
}

#line 1638 "runtime.in"
// double remainder(double x, double y);
void gen157(stack *Stack)
{
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1639 "runtime.in" 
  {Stack->push<double>(remainder(x,y)); return;}
}

#line 1643 "runtime.in"
// double J(int n, double x);
void gen158(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  int n = vm::pop<int>(Stack);
#line 1644 "runtime.in"
  {Stack->push<double>(jn(n,x)); return;}
}

#line 1648 "runtime.in"
// double Y(int n, double x);
void gen159(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  int n = vm::pop<int>(Stack);
#line 1649 "runtime.in"
  {Stack->push<double>(yn(n,x)); return;}
}

#line 1653 "runtime.in"
// double erf(double x);
void gen160(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1654 "runtime.in"
  {Stack->push<double>(erf(x)); return;}
}

#line 1658 "runtime.in"
// double erfc(double x);
void gen161(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1659 "runtime.in"
  {Stack->push<double>(erfc(x)); return;}
}

#line 1663 "runtime.in"
// double gamma(double x);
void gen162(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1664 "runtime.in"
#ifdef HAVE_TGAMMA
  {Stack->push<double>(tgamma(x)); return;}
#else
 double lg = lgamma(x);
 {Stack->push<double>(signgam*exp(lg)); return;}
#endif
}

#line 1673 "runtime.in"
// realarray* quadraticroots(double a, double b, double c);
void gen163(stack *Stack)
{
  double c = vm::pop<double>(Stack);
  double b = vm::pop<double>(Stack);
  double a = vm::pop<double>(Stack);
#line 1674 "runtime.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 1682 "runtime.in"
// realarray* cubicroots(double a, double b, double c, double d);
void gen164(stack *Stack)
{
  double d = vm::pop<double>(Stack);
  double c = vm::pop<double>(Stack);
  double b = vm::pop<double>(Stack);
  double a = vm::pop<double>(Stack);
#line 1683 "runtime.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}

  
// Transforms
#line 1694 "runtime.in"
// bool ==(transform a, transform b);
void gen165(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 1695 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1700 "runtime.in"
// bool !=(transform a, transform b);
void gen166(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 1701 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1705 "runtime.in"
// transform *(transform a, transform b);
void gen167(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 1706 "runtime.in"
  {Stack->push<transform>(a*b); return;}
}

#line 1710 "runtime.in"
// pair *(transform t, pair z);
void gen168(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 1711 "runtime.in"
  {Stack->push<pair>(t*z); return;}
}

#line 1715 "runtime.in"
// path *(transform t, path g);
void gen169(stack *Stack)
{
  path g = vm::pop<path>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 1716 "runtime.in"
  {Stack->push<path>(transformed(t,g)); return;}
}

#line 1720 "runtime.in"
// pen *(transform t, pen p);
void gen170(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 1721 "runtime.in"
  {Stack->push<pen>(transformed(t,p)); return;}
}

#line 1725 "runtime.in"
// picture* *(transform t, picture *f);
void gen171(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 1726 "runtime.in"
  {Stack->push<picture*>(transformed(t,f)); return;}
}

#line 1730 "runtime.in"
// transform ^(transform t, int n);
void gen172(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 1731 "runtime.in"
  transform T;
  if(n < 0) {
    n=-n;
    t=inverse(t);
  }
  for(int i=0; i < n; i++) T=T*t;
  {Stack->push<transform>(T); return;}
}

#line 1741 "runtime.in"
void transformXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1742 "runtime.in"
  {Stack->push<double>(t.getx()); return;}
}

#line 1746 "runtime.in"
void transformYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1747 "runtime.in"
  {Stack->push<double>(t.gety()); return;}
}

#line 1751 "runtime.in"
void transformXXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1752 "runtime.in"
  {Stack->push<double>(t.getxx()); return;}
}

#line 1756 "runtime.in"
void transformXYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1757 "runtime.in"
  {Stack->push<double>(t.getxy()); return;}
}

#line 1761 "runtime.in"
void transformYXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1762 "runtime.in"
  {Stack->push<double>(t.getyx()); return;}
}

#line 1766 "runtime.in"
void transformYYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1767 "runtime.in"
  {Stack->push<double>(t.getyy()); return;}
}

#line 1771 "runtime.in"
void real6ToTransform(stack *Stack)
{
  double yy = vm::pop<double>(Stack);
  double yx = vm::pop<double>(Stack);
  double xy = vm::pop<double>(Stack);
  double xx = vm::pop<double>(Stack);
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1773 "runtime.in"
  {Stack->push<transform>(transform(x,y,xx,xy,yx,yy)); return;}
}

#line 1777 "runtime.in"
// transform identity();
void transformIdentity(stack *Stack)
{
#line 1778 "runtime.in"
  {Stack->push<transform>(identity()); return;}
}

#line 1782 "runtime.in"
// transform inverse(transform t);
void gen181(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 1783 "runtime.in"
  {Stack->push<transform>(inverse(t)); return;}
}

#line 1787 "runtime.in"
// transform shift(pair z);
void gen182(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1788 "runtime.in"
  {Stack->push<transform>(shift(z)); return;}
}

#line 1792 "runtime.in"
// transform xscale(double x);
void gen183(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1793 "runtime.in"
  {Stack->push<transform>(xscale(x)); return;}
}

#line 1797 "runtime.in"
// transform yscale(double y);
void gen184(stack *Stack)
{
  double y = vm::pop<double>(Stack);
#line 1798 "runtime.in"
  {Stack->push<transform>(yscale(y)); return;}
}

#line 1802 "runtime.in"
// transform scale(double x);
void gen185(stack *Stack)
{
  double x = vm::pop<double>(Stack);
#line 1803 "runtime.in"
  {Stack->push<transform>(scale(x)); return;}
}

#line 1807 "runtime.in"
// transform slant(double s);
void gen186(stack *Stack)
{
  double s = vm::pop<double>(Stack);
#line 1808 "runtime.in"
  {Stack->push<transform>(slant(s)); return;}
}

#line 1812 "runtime.in"
// transform rotate(double angle, pair z=0);
void gen187(stack *Stack)
{
  pair z = vm::pop<pair>(Stack,0);
  double angle = vm::pop<double>(Stack);
#line 1813 "runtime.in"
  {Stack->push<transform>(rotatearound(z,radians(angle))); return;}
}

#line 1817 "runtime.in"
// transform reflect(pair a, pair b);
void gen188(stack *Stack)
{
  pair b = vm::pop<pair>(Stack);
  pair a = vm::pop<pair>(Stack);
#line 1818 "runtime.in"
  {Stack->push<transform>(reflectabout(a,b)); return;}
}


// Pair operations
#line 1824 "runtime.in"
void pairZero(stack *Stack)
{
#line 1825 "runtime.in"
  static pair zero;
  {Stack->push<pair>(zero); return;}
}

#line 1831 "runtime.in"
void realRealToPair(stack *Stack)
{
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1832 "runtime.in"
  {Stack->push<pair>(pair(x,y)); return;}
}

#line 1836 "runtime.in"
void pairNegate(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1837 "runtime.in"
  {Stack->push<pair>(-z); return;}
}

#line 1841 "runtime.in"
// double xpart(pair z);
void pairXPart(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1842 "runtime.in"
  {Stack->push<double>(z.getx()); return;}
}

#line 1846 "runtime.in"
// double ypart(pair z);
void pairYPart(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1847 "runtime.in"
  {Stack->push<double>(z.gety()); return;}
}

#line 1851 "runtime.in"
// double length(pair z);
void gen194(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1852 "runtime.in"
  {Stack->push<double>(z.length()); return;}
}

#line 1856 "runtime.in"
// double abs(pair z);
void gen195(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1857 "runtime.in"
  {Stack->push<double>(z.length()); return;}
}

#line 1861 "runtime.in"
// double angle(pair z);
void gen196(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1862 "runtime.in"
  {Stack->push<double>(z.angle()); return;}
}

// Return the angle of z in degrees in the interval [0,360).
#line 1867 "runtime.in"
// double degrees(pair z);
void gen197(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1868 "runtime.in"
  {Stack->push<double>(principalBranch(degrees(z.angle()))); return;}
}

// Return the angle of z in degrees in the interval [0,360), ignoring errors.
#line 1873 "runtime.in"
// double Degrees(pair z);
void gen198(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1874 "runtime.in"
  if(z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<double>(0.0); return;}
  {Stack->push<double>(principalBranch(degrees(z.angle()))); return;}
}

#line 1879 "runtime.in"
// pair unit(pair z);
void gen199(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1880 "runtime.in"
  {Stack->push<pair>(unit(z)); return;}
}

#line 1884 "runtime.in"
// pair dir(double theta);
void gen200(stack *Stack)
{
  double theta = vm::pop<double>(Stack);
#line 1885 "runtime.in"
  {Stack->push<pair>(expi(radians(theta))); return;}
}

#line 1889 "runtime.in"
// pair expi(double theta);
void gen201(stack *Stack)
{
  double theta = vm::pop<double>(Stack);
#line 1890 "runtime.in"
  {Stack->push<pair>(expi(theta)); return;}
}

#line 1894 "runtime.in"
// pair conj(pair z);
void gen202(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 1895 "runtime.in"
  {Stack->push<pair>(conj(z)); return;}
}

// To avoid confusion, a dot product requires explicit pair arguments.
#line 1900 "runtime.in"
// double dot(explicit pair u, explicit pair v);
void gen203(stack *Stack)
{
  pair v = vm::pop<pair>(Stack);
  pair u = vm::pop<pair>(Stack);
#line 1901 "runtime.in"
  {Stack->push<double>(u.getx()*v.getx()+u.gety()*v.gety()); return;}
}

#line 1905 "runtime.in"
// pair minbound(pair z, pair w);
void gen204(stack *Stack)
{
  pair w = vm::pop<pair>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 1906 "runtime.in"
  {Stack->push<pair>(pair(Min(z.getx(),w.getx()),Min(z.gety(),w.gety()))); return;}
}

#line 1910 "runtime.in"
// pair maxbound(pair z, pair w);
void gen205(stack *Stack)
{
  pair w = vm::pop<pair>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 1911 "runtime.in"
  {Stack->push<pair>(pair(Max(z.getx(),w.getx()),Max(z.gety(),w.gety()))); return;}
}



// Triple operations
#line 1918 "runtime.in"
void tripleZero(stack *Stack)
{
#line 1919 "runtime.in"
  static triple zero;
  {Stack->push<triple>(zero); return;}
}

#line 1925 "runtime.in"
void realRealRealToTriple(stack *Stack)
{
  double z = vm::pop<double>(Stack);
  double y = vm::pop<double>(Stack);
  double x = vm::pop<double>(Stack);
#line 1926 "runtime.in"
  {Stack->push<triple>(triple(x,y,z)); return;}
}

#line 1930 "runtime.in"
// double xpart(triple v);
void tripleXPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1931 "runtime.in"
  {Stack->push<double>(v.getx()); return;}
}

#line 1935 "runtime.in"
// double ypart(triple v);
void tripleYPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1936 "runtime.in"
  {Stack->push<double>(v.gety()); return;}
}

#line 1940 "runtime.in"
// double zpart(triple v);
void tripleZPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1941 "runtime.in"
  {Stack->push<double>(v.getz()); return;}
}

#line 1945 "runtime.in"
// triple *(double x, triple v);
void gen211(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  double x = vm::pop<double>(Stack);
#line 1946 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 1950 "runtime.in"
// triple *(triple v, double x);
void gen212(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  triple v = vm::pop<triple>(Stack);
#line 1951 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 1955 "runtime.in"
// triple /(triple v, double x);
void gen213(stack *Stack)
{
  double x = vm::pop<double>(Stack);
  triple v = vm::pop<triple>(Stack);
#line 1956 "runtime.in"
  {Stack->push<triple>(v/x); return;}
}

#line 1960 "runtime.in"
// double length(triple v);
void gen214(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1961 "runtime.in"
  {Stack->push<double>(v.length()); return;}
}

#line 1965 "runtime.in"
// double abs(triple v);
void gen215(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1966 "runtime.in"
  {Stack->push<double>(v.length()); return;}
}

#line 1970 "runtime.in"
// double polar(triple v);
void gen216(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1971 "runtime.in"
  {Stack->push<double>(v.polar()); return;}
}

#line 1975 "runtime.in"
// double azimuth(triple v);
void gen217(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1976 "runtime.in"
  {Stack->push<double>(v.azimuth()); return;}
}

#line 1980 "runtime.in"
// double colatitude(triple v);
void gen218(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1981 "runtime.in"
  {Stack->push<double>(degrees(v.polar())); return;}
}

#line 1985 "runtime.in"
// double latitude(triple v);
void gen219(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1986 "runtime.in"
  {Stack->push<double>(90.0-degrees(v.polar())); return;}
}

// Return the longitude of v in [0,360).
#line 1991 "runtime.in"
// double longitude(triple v);
void gen220(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1992 "runtime.in"
  {Stack->push<double>(principalBranch(degrees(v.azimuth()))); return;}
}

// Return the longitude of v in [0,360), ignoring errors.
#line 1997 "runtime.in"
// double Longitude(triple v);
void gen221(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 1998 "runtime.in"
  if(v.getx() == 0.0 && v.gety() == 0.0) {Stack->push<double>(0.0); return;}
  {Stack->push<double>(principalBranch(degrees(v.azimuth()))); return;}
}

#line 2003 "runtime.in"
// triple unit(triple v);
void gen222(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2004 "runtime.in"
  {Stack->push<triple>(unit(v)); return;}
}

#line 2008 "runtime.in"
// double dot(triple u, triple v);
void gen223(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2009 "runtime.in"
  {Stack->push<double>(u.getx()*v.getx()+u.gety()*v.gety()+u.getz()*v.getz()); return;}
}

#line 2013 "runtime.in"
// triple cross(triple u, triple v);
void gen224(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2014 "runtime.in"
  {Stack->push<triple>(triple(u.gety()*v.getz()-u.getz()*v.gety(),
		u.getz()*v.getx()-u.getx()*v.getz(),
		u.getx()*v.gety()-v.getx()*u.gety())); return;}
}

#line 2020 "runtime.in"
// triple expi(double theta, double phi);
void gen225(stack *Stack)
{
  double phi = vm::pop<double>(Stack);
  double theta = vm::pop<double>(Stack);
#line 2021 "runtime.in"
  {Stack->push<triple>(expi(theta,phi)); return;}
  double sintheta=sin(theta);
  {Stack->push<triple>(triple(sintheta*cos(phi),sintheta*sin(phi),cos(theta))); return;}
}

#line 2027 "runtime.in"
// triple dir(double theta, double phi);
void gen226(stack *Stack)
{
  double phi = vm::pop<double>(Stack);
  double theta = vm::pop<double>(Stack);
#line 2028 "runtime.in"
  {Stack->push<triple>(expi(radians(theta),radians(phi))); return;}
}

#line 2032 "runtime.in"
// triple minbound(triple u, triple v);
void gen227(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2033 "runtime.in"
  {Stack->push<triple>(triple(Min(u.getx(),v.getx()),Min(u.gety(),v.gety()),
		Min(u.getz(),v.getz()))); return;}
}

#line 2038 "runtime.in"
// triple maxbound(triple u, triple v);
void gen228(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2039 "runtime.in"
  {Stack->push<triple>(triple(Max(u.getx(),v.getx()),Max(u.gety(),v.gety()),
		Max(u.getz(),v.getz()))); return;}
}

#line 2044 "runtime.in"
// double cubiclength(triple z0, triple z0p, triple z1m, triple z1, double goal);
void gen229(stack *Stack)
{
  double goal = vm::pop<double>(Stack);
  triple z1 = vm::pop<triple>(Stack);
  triple z1m = vm::pop<triple>(Stack);
  triple z0p = vm::pop<triple>(Stack);
  triple z0 = vm::pop<triple>(Stack);
#line 2045 "runtime.in"
  {Stack->push<double>(cubiclength(z0,z0p,z1m,z1,goal)); return;}
}

#line 2049 "runtime.in"
// pair intersect(triplearray* pre1, triplearray* point1, triplearray* post1,               triplearray* pre2, triplearray* point2, triplearray* post2,	       double fuzz);
void gen230(stack *Stack)
{
  double fuzz = vm::pop<double>(Stack);
  triplearray* post2 = vm::pop<triplearray*>(Stack);
  triplearray* point2 = vm::pop<triplearray*>(Stack);
  triplearray* pre2 = vm::pop<triplearray*>(Stack);
  triplearray* post1 = vm::pop<triplearray*>(Stack);
  triplearray* point1 = vm::pop<triplearray*>(Stack);
  triplearray* pre1 = vm::pop<triplearray*>(Stack);
#line 2052 "runtime.in"
  size_t size1=checkArrays(pre1,point1);
  size_t size2=checkArrays(pre2,point2);
      
  if(checkArray(post1) != size1 || checkArray(post2) != size2)
    vm::error(arraymismatch);
  
  int single1=(size1 == 1);
  int single2=(size2 == 1);
  
  size_t Size1=size1+single1;
  size_t Size2=size2+single2;
  
  node *n1=new node[Size1];
  node *n2=new node[Size2];
      
  for(size_t i=0; i < size1; ++i)
    n1[i]=node(read<triple>(pre1,i),read<triple>(point1,i),
	       read<triple>(post1,i));

  for(size_t i=0; i < size2; ++i)
    n2[i]=node(read<triple>(pre2,i),read<triple>(point2,i),
	       read<triple>(post2,i));

  if(single1) n1[1]=n1[0];
  if(single2) n2[1]=n2[0];
  
  {Stack->push<pair>(intersect((int) Size1-1,(int) Size2-1,n1,n2,fuzz)); return;}
}


// System routines
#line 2084 "runtime.in"
// string VERSION();
void gen231(stack *Stack)
{
#line 2085 "runtime.in"
  {Stack->push<string>(VERSION); return;}
}

#line 2090 "runtime.in"
// void quiet(bool v);
void gen232(stack *Stack)
{
  bool v = vm::pop<bool>(Stack);
#line 2091 "runtime.in"
  Setting("interactiveView")=
    Setting("batchView")=
    Setting("oneFileView")=!v;
}

#line 2097 "runtime.in"
// void atexit(callable *f);
void gen233(stack *Stack)
{
  callable * f = vm::pop<callable *>(Stack);
#line 2098 "runtime.in"
  atExitFunction=f;
}

#line 2102 "runtime.in"
// callable* atexit();
void gen234(stack *Stack)
{
#line 2103 "runtime.in"
  {Stack->push<callable*>(atExitFunction); return;}
}


// Merge output files  
#line 2109 "runtime.in"
// int merge(stringarray *files, string *args, string *format);
void gen235(stack *Stack)
{
  string * format = vm::pop<string *>(Stack);
  string * args = vm::pop<string *>(Stack);
  stringarray * files = vm::pop<stringarray *>(Stack);
#line 2110 "runtime.in"
  int ret;
  
  size_t size=checkArray(files);
  
  if(!checkFormatString(*format)) return;
  
  ostringstream cmd,remove;
  cmd << "'" << getSetting<string>("convert") << "' "+*args;
  
  for(size_t i=0; i < size; i++) 
    cmd << " " << read<string>(files,i);
  
  string name=buildname(getSetting<string>("outname"),format->c_str());
  cmd << " " << name;
  ret=System(cmd,false,true,"convert");
  
  if(ret == 0)
    if(verbose > 0) cout << "Wrote " << name << endl;
  
  if(!getSetting<bool>("keep"))
    for(size_t i=0; i < size; i++) 
      unlink(read<string>(files,i).c_str());
    
  if(ret == 0 && view()) {
    ostringstream cmd;
    cmd << "'" << getSetting<string>("animate") << "' " << name;
    System(cmd,false,false,"animate","your animated GIF viewer");
  }
  
  {Stack->push<int>(ret); return;}
}


// Array operations

// Create an empty array.
#line 2147 "runtime.in"
void emptyArray(stack *Stack)
{
#line 2148 "runtime.in"
  {Stack->push<array*>(new array(0)); return;}
}

// Create a new array (technically a vector).
// This array will be multidimensional.  First the number of dimensions
// is popped off the stack, followed by each dimension in reverse order.
// The array itself is technically a one dimensional array of one
// dimension arrays and so on.
#line 2157 "runtime.in"
void newDeepArray(stack *Stack)
{
  int depth = vm::pop<int>(Stack);
#line 2158 "runtime.in"
  assert(depth > 0);

  int *dims = new int[depth];

  for (int index = depth-1; index >= 0; index--)
    dims[index] = pop<int>(Stack);

  array *a=deepArray(depth, dims);
  delete[] dims;
  {Stack->push<array*>(a); return;}
}

// Creates an array with elements already specified.  First, the number
// of elements is popped off the stack, followed by each element in
// reverse order.
#line 2174 "runtime.in"
void newInitializedArray(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 2175 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);

  {Stack->push<array*>(a); return;}
}

// Similar to newInitializedArray, but after the n elements, append another
// array to it.
#line 2188 "runtime.in"
void newAppendedArray(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array* tail = vm::pop<array*>(Stack);
#line 2189 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);
  
  copy(tail->begin(), tail->end(), back_inserter(*a));

  {Stack->push<array*>(a); return;}
}

// Read an element from an array. Checks for initialization & bounds.
#line 2203 "runtime.in"
void arrayRead(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2204 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) {
    ostringstream buf;
    buf << "read uninitialized value from array at index " << n;
    error(buf);
  }
  {Stack->push(i); return;}
}

// Read an element from an array of arrays. Check bounds and initialize
// as necessary.
#line 2216 "runtime.in"
void arrayArrayRead(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2217 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) i=new array(0);
  {Stack->push(i); return;}
}

// Write an element to an array.  Increase size if necessary.
#line 2224 "runtime.in"
void arrayWrite(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
  item value = vm::pop(Stack);
#line 2225 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else {
    if(cyclic) outOfBounds("writing cyclic",len,n);
    if(n < 0) outOfBounds("writing",len,n);
    if(len <= (size_t) n)
      a->resize(n+1);
  }
  (*a)[n] = value;
  {Stack->push(value); return;}
}

// Returns the length of an array.
#line 2240 "runtime.in"
void arrayLength(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2241 "runtime.in"
  {Stack->push<int>((int) checkArray(a)); return;}
}

// Return the cyclic flag for an array.
#line 2246 "runtime.in"
void arrayCyclicFlag(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2247 "runtime.in"
  checkArray(a);
  {Stack->push<bool>(a->cyclic()); return;}
}

// The helper function for the cyclic method that sets the cyclic flag.
#line 2253 "runtime.in"
void arrayCyclicHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  bool b = vm::pop<bool>(Stack);
#line 2254 "runtime.in"
  checkArray(a);
  a->cyclic(b);
}

// Set the cyclic flag for an array.
#line 2260 "runtime.in"
void arrayCyclic(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2261 "runtime.in"
  checkArray(a);
  {Stack->push<callable*>(new thunk(new bfunc(arrayCyclicHelper),a)); return;}
}

// The helper function for the push method that does the actual operation.
#line 2267 "runtime.in"
void arrayPushHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  item i = vm::pop(Stack);
#line 2268 "runtime.in"
  checkArray(a);
  a->push(i);
  {Stack->push(i); return;}
}

// Returns the push method for an array.
#line 2275 "runtime.in"
void arrayPush(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2276 "runtime.in"
  checkArray(a);
  {Stack->push<callable*>(new thunk(new bfunc(arrayPushHelper),a)); return;}
}

// The helper function for the append method that appends b to a.
#line 2282 "runtime.in"
void arrayAppendHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  array * b = vm::pop<array *>(Stack);
#line 2283 "runtime.in"
  checkArray(a);
  size_t size=checkArray(b);
  for(size_t i=0; i < size; i++)
    a->push((*b)[i]);
}

// Returns the append method for an array.
#line 2291 "runtime.in"
void arrayAppend(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2292 "runtime.in"
  checkArray(a);
  {Stack->push<callable*>(new thunk(new bfunc(arrayAppendHelper),a)); return;}
}

// The helper function for the pop method.
#line 2298 "runtime.in"
void arrayPopHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2299 "runtime.in"
  size_t asize=checkArray(a);
  if(asize == 0) 
    error("cannot pop element from empty array");
  {Stack->push(a->pop()); return;}
}

// Returns the pop method for an array.
#line 2307 "runtime.in"
void arrayPop(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2308 "runtime.in"
  checkArray(a);
  {Stack->push<callable*>(new thunk(new bfunc(arrayPopHelper),a)); return;}
}

#line 2313 "runtime.in"
void arrayAlias(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2314 "runtime.in"
  {Stack->push<bool>(a==b); return;}
}

// Return array formed by indexing array a with elements of integer array b
#line 2319 "runtime.in"
void arrayIntArray(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2320 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *r=new array(bsize);
  bool cyclic=a->cyclic();
  for(size_t i=0; i < bsize; i++) {
    int index=read<int>(b,i);
    if(cyclic && asize > 0) index=imod(index,asize);
    else
      if(index < 0 || index >= (int) asize)
	outOfBounds("reading",asize,index);
    (*r)[i]=(*a)[index];
  }
  {Stack->push<array*>(r); return;}
}

// returns the complement of the integer array a in {1,2,...,n},
// so that b[complement(a,b.length)] yields the complement of b[a].
#line 2338 "runtime.in"
// intarray* complement(intarray *a, int n);
void gen255(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  intarray * a = vm::pop<intarray *>(Stack);
#line 2339 "runtime.in"
  size_t asize=checkArray(a);
  array *r=new array(0);
  bool *keep=new bool(n);
  for(int i=0; i < n; ++i) keep[i]=true;
  for(size_t i=0; i < asize; ++i) {
    int j=read<int>(a,i);
    if(j >= 0 && j < n) keep[j]=false;
  }
  for(int i=0; i < n; i++)
    if(keep[i]) r->push(i);
  
  delete[] keep;
  {Stack->push<intarray*>(r); return;}
}

// Generate the sequence {f_i : i=0,1,...n-1} given a function f and integer n
#line 2356 "runtime.in"
void arraySequence(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  callable * f = vm::pop<callable *>(Stack);
#line 2357 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(int i=0; i < n; ++i) {
    Stack->push(i);
    f->call(Stack);
    (*a)[i]=pop(Stack);
  }
  {Stack->push<intarray*>(a); return;}
}

// Return the array {0,1,...n-1}
#line 2369 "runtime.in"
// intarray* sequence(int n);
void gen257(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 2370 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(int i=0; i < n; ++i) {
    (*a)[i]=i;
  }
  {Stack->push<intarray*>(a); return;}
}

// Apply a function to each element of an array
#line 2380 "runtime.in"
void arrayFunction(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  callable * f = vm::pop<callable *>(Stack);
#line 2381 "runtime.in"
  size_t size=checkArray(a);
  array *b=new array(size);
  for(size_t i=0; i < size; ++i) {
    Stack->push((*a)[i]);
    f->call(Stack);
    (*b)[i]=pop(Stack);
  }
  {Stack->push<array*>(b); return;}
}

#line 2392 "runtime.in"
// bool all(boolarray *a);
void gen259(stack *Stack)
{
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 2393 "runtime.in"
  size_t size=checkArray(a);
  bool c=true;
  for(size_t i=0; i < size; i++)
    if(!get<bool>((*a)[i])) {c=false; break;}
  {Stack->push<bool>(c); return;}
}

#line 2401 "runtime.in"
// boolarray* !(boolarray* a);
void gen260(stack *Stack)
{
  boolarray* a = vm::pop<boolarray*>(Stack);
#line 2402 "runtime.in"
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++)
    (*c)[i]=!read<bool>(a,i);
  {Stack->push<boolarray*>(c); return;}
}

#line 2410 "runtime.in"
// int sum(boolarray *a);
void gen261(stack *Stack)
{
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 2411 "runtime.in"
  size_t size=checkArray(a);
  int sum=0;
  for(size_t i=0; i < size; i++)
    sum += read<bool>(a,i) ? 1 : 0;
  {Stack->push<int>(sum); return;}
}

#line 2419 "runtime.in"
void arrayCopy(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2420 "runtime.in"
  {Stack->push<array*>(copyArray(a)); return;}
}

#line 2424 "runtime.in"
void arrayConcat(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2425 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *c=new array(asize+bsize);
  for(size_t i=0; i < asize; i++) 
    (*c)[i]=(*a)[i];
  for(size_t i=0; i < bsize; i++, asize++) 
    (*c)[asize]=(*b)[i];
  {Stack->push<array*>(c); return;}
}

#line 2436 "runtime.in"
void array2Copy(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2437 "runtime.in"
  {Stack->push<array*>(copyArray2(a)); return;}
}

#line 2441 "runtime.in"
void array2Transpose(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2442 "runtime.in"
  size_t asize=checkArray(a);
  array *c=new array(0);
  for(size_t i=0; i < asize; i++) {
    size_t ip=i+1;
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    size_t csize=c->size();
    if(csize < aisize) {
      c->resize(aisize);
      for(size_t j=csize; j < aisize; j++) {
	(*c)[j]=new array(ip);
      }
    }
    for(size_t j=0; j < aisize; j++) {
    array *cj=read<array*>(c,j);
    if(cj->size() < ip) cj->resize(ip);
    (*cj)[i]=(*ai)[j];
    }
  }
  {Stack->push<array*>(c); return;}
}

// In a boolean array, find the index of the nth true value or -1 if not found
// If n is negative, search backwards.
#line 2467 "runtime.in"
// int find(boolarray *a, int n=1);
void gen266(stack *Stack)
{
  int n = vm::pop<int>(Stack,1);
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 2468 "runtime.in"
  
  size_t size=checkArray(a);
  int j=-1;
  if(n > 0)
    for(size_t i=0; i < size; i++)
      if(read<bool>(a,i)) {
	n--; if(n == 0) {j=(int) i; break;}
      }
  if(n < 0)
    for(size_t i=size; i > 0;)
      if(read<bool>(a,--i)) {
	n++; if(n == 0) {j=(int) i; break;}
      }
  {Stack->push<int>(j); return;}
}

// construct vector obtained by replacing those elements of b for which the
// corresponding elements of a are false by the corresponding element of c.
#line 2487 "runtime.in"
void arrayConditional(stack *Stack)
{
  array * c = vm::pop<array *>(Stack);
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2488 "runtime.in"
  size_t size=checkArray(a);
  array *r=new array(size);
  if(b && c) {
    checkArrays(a,b);
    checkArrays(b,c);
    for(size_t i=0; i < size; i++)
      (*r)[i]=read<bool>(a,i) ? (*b)[i] : (*c)[i];
  } else {
    r->clear();
    if(b) {
      checkArrays(a,b);
      for(size_t i=0; i < size; i++)
        if(read<bool>(a,i)) r->push((*b)[i]);
    } else if(c) {
      checkArrays(a,c);
      for(size_t i=0; i < size; i++)
        if(!read<bool>(a,i)) r->push((*c)[i]);
    }
  }
  {Stack->push<array*>(r); return;}
}

// Solve the linear equation ax=b by Gauss-Jordan elimination, returning
// the solution x, where a is an n x n matrix and b is an n x m matrix.
// If b is omitted or nm=0, return the inverse of a.
// TODO: Use LU decomposition for linear solve and specialize this routine
// for computing matrix inverses only.
#line 2516 "runtime.in"
// realarray2* solve(realarray2 *a, realarray2 *b=NULL);
void gen268(stack *Stack)
{
  realarray2 * b = vm::pop<realarray2 *>(Stack,NULL);
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 2517 "runtime.in"
  a=copyArray2(a);
  size_t n=a->size();
  size_t bsize=b ? b->size() : 0;
  
  for(size_t i=0; i < n; i++)
    if(read<array*>(a,i)->size() != n)
      error("matrix a must be square");
    
  size_t m;
  if(bsize) {
    b=copyArray2(b);
    if(bsize != n) error("Incommensurate matrices");
    m=read<array*>(b,0)->size();
    for(size_t i=0; i < n; i++)
      if(read<array*>(b,i)->size() != m)
	error("matrix b must be rectangular");
  } else m=0;
  
  solveAllocate(n,m);
  
  for(size_t i=0; i < n; i++)
    pivot[i]=0;

  const char *singular="Singular matrix";
  
  size_t col=0, row=0;
  // This is the main loop over the columns to be reduced.
  for(size_t i=0; i < n; i++) {
    double big=0.0;
    // This is the outer loop of the search for a pivot element.
    for(size_t j=0; j < n; j++) {
      array *aj=read<array*>(a,j);
      if(pivot[j] != 1) {
	for(size_t k=0; k < n; k++) {
	  if(pivot[k] == 0) {
	    double temp=fabs(read<double>(aj,k));
	    if(temp >= big) {
	      big=temp;
	      row=j;
	      col=k;
	    }
	  } else if(pivot[k] > 1) {
	    solveDeallocate();
	    error(singular);
	  }
	}
      }
    }
    ++(pivot[col]);
    
    // Interchange rows, if needed, to put the pivot element on the diagonal.
    array *acol=read<array*>(a,col);
    array *bcol=m ? read<array*>(b,col) : 0;
    if(row != col) {
      array *arow=read<array*>(a,row);
      for(size_t l=0; l < n; l++) {
	double temp=read<double>(arow,l);
	(*arow)[l]=read<double>(acol,l);
	(*acol)[l]=temp;
      }
      if(m) {
	array *brow=read<array*>(b,row);
	for(size_t l=0; l < m; l++) {
	  double temp=read<double>(brow,l);
	  (*brow)[l]=read<double>(bcol,l);
	  (*bcol)[l]=temp;
	}
      }
    }
    
    if(m == 0) {
      Row[i]=row; 
      Col[i]=col;
    }
    // Divide the pivot row by the pivot element.
    double denom=read<double>(acol,col);
    if(denom == 0.0) {
      solveDeallocate();
      error(singular);
    }
    double pivinv=1.0/denom;
    (*acol)[col]=1.0;
    for(size_t l=0; l < n; l++) 
      (*acol)[l]=read<double>(acol,l)*pivinv;
    for(size_t l=0; l < m; l++)
      (*bcol)[l]=read<double>(bcol,l)*pivinv;
    
    // Reduce all rows except for the pivoted one.
    for(size_t k=0; k < n; k++) {
      if(k != col) { 
	array *ak=read<array*>(a,k);
	double dum=read<double>(ak,col);
	(*ak)[col]=0.0;
	for(size_t l=0; l < n; l++)
	  (*ak)[l]=read<double>(ak,l)-read<double>(acol,l)*dum;
	array *bk=m ? read<array*>(b,k) : 0;
	for(size_t l=0; l < m; l++)
	  (*bk)[l]=read<double>(bk,l)-read<double>(bcol,l)*dum;
      }
    }
  }
  
  if(m == 0) {
    // Unscramble the inverse matrix in view of the column interchanges.
    for(size_t l=n; l > 0;) {
      l--;
      size_t r=Row[l];
      size_t c=Col[l];
      if(r != c) {
	for(size_t k=0; k < n; k++) {
	  array *ak=read<array*>(a,k);
	  double temp=read<double>(ak,r);
	  (*ak)[r]=read<double>(ak,c);
	  (*ak)[c]=temp;
	}
      }
    }
    b=a;
  }
  solveDeallocate();
  {Stack->push<realarray2*>(b); return;}
}

// Solve the problem L\inv f, where f is an n vector and L is the n x n matrix
//
// [ b[0] c[0]           a[0]   ]
// [ a[1] b[1] c[1]             ]
// [      a[2] b[2] c[2]        ]
// [                ...         ]
// [       c[n-1] a[n-1] b[n-1] ]
#line 2648 "runtime.in"
// realarray* tridiagonal(realarray *a, realarray *b, realarray *c, realarray *f);
void gen269(stack *Stack)
{
  realarray * f = vm::pop<realarray *>(Stack);
  realarray * c = vm::pop<realarray *>(Stack);
  realarray * b = vm::pop<realarray *>(Stack);
  realarray * a = vm::pop<realarray *>(Stack);
#line 2649 "runtime.in"
  size_t n=checkArrays(a,b);
  if(n != checkArray(c) || n != checkArray(f))
    vm::error(arraymismatch);
  
  array *up=new array(n);
  array& u=*up;

  if(n == 0) {Stack->push<realarray*>(up); return;}
  
  // Special case: zero Dirichlet boundary conditions
  if(read<double>(a,0) == 0.0 && read<double>(c,n-1) == 0.0) {
    double temp=read<double>(b,0);
    if(temp == 0.0) dividebyzero();
    temp=1.0/temp;
    
    double *work=new double[n];
    u[0]=read<double>(f,0)*temp;
    work[0]=-read<double>(c,0)*temp;
	
    for(size_t i=1; i < n; i++) {
      double temp=(read<double>(b,i)+read<double>(a,i)*work[i-1]);
      if(temp == 0.0) {delete[] work; dividebyzero();}
      temp=1.0/temp;
      u[i]=(read<double>(f,i)-read<double>(a,i)*read<double>(u,i-1))*temp;
      work[i]=-read<double>(c,i)*temp;
    }

    for(size_t i=n-1; i >= 1; i--)
      u[i-1]=read<double>(u,i-1)+work[i-1]*read<double>(u,i);
    
    delete[] work;
    {Stack->push<realarray*>(up); return;}
  }
  
  double binv=read<double>(b,0);
  if(binv == 0.0) dividebyzero();
  binv=1.0/binv;
  
  if(n == 1) {u[0]=read<double>(f,0)*binv; {Stack->push<realarray*>(up); return;}}
  if(n == 2) {
    double factor=(read<double>(b,0)*read<double>(b,1)-
		   read<double>(a,0)*read<double>(c,1));
    if(factor== 0.0) dividebyzero();
    factor=1.0/factor;
    double temp=(read<double>(b,0)*read<double>(f,1)-
	  read<double>(c,1)*read<double>(f,0))*factor;
    u[0]=(read<double>(b,1)*read<double>(f,0)-
	  read<double>(a,0)*read<double>(f,1))*factor;
    u[1]=temp;
    {Stack->push<realarray*>(up); return;}
  }
	
  double *gamma=new double[n-2];
  double *delta=new double[n-2];
  
  gamma[0]=read<double>(c,0)*binv;
  delta[0]=read<double>(a,0)*binv;
  u[0]=read<double>(f,0)*binv;
  double beta=read<double>(c,n-1);
  double fn=read<double>(f,n-1)-beta*read<double>(u,0);
  double alpha=read<double>(b,n-1)-beta*delta[0];

  for(size_t i=1; i <= n-3; i++) {
    double alphainv=read<double>(b,i)-read<double>(a,i)*gamma[i-1];
    if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
    alphainv=1.0/alphainv;
    beta *= -gamma[i-1];
    gamma[i]=read<double>(c,i)*alphainv;
    u[i]=(read<double>(f,i)-read<double>(a,i)*read<double>(u,i-1))*alphainv;
    fn -= beta*read<double>(u,i);
    delta[i]=-read<double>(a,i)*delta[i-1]*alphainv;
    alpha -= beta*delta[i];
  }
	
  double alphainv=read<double>(b,n-2)-read<double>(a,n-2)*gamma[n-3];
  if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  alphainv=1.0/alphainv;
  u[n-2]=(read<double>(f,n-2)-read<double>(a,n-2)*read<double>(u,n-3))
    *alphainv;
  beta=read<double>(a,n-1)-beta*gamma[n-3];
  double dnm1=(read<double>(c,n-2)-read<double>(a,n-2)*delta[n-3])*alphainv;
  double temp=alpha-beta*dnm1;
  if(temp == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  u[n-1]=temp=(fn-beta*read<double>(u,n-2))/temp;
  u[n-2]=read<double>(u,n-2)-dnm1*temp;
	
  for(size_t i=n-2; i >= 1; i--)
    u[i-1]=read<double>(u,i-1)-gamma[i-1]*read<double>(u,i)-delta[i-1]*temp;
  
  delete[] gamma;
  delete[] delta;
  
  {Stack->push<realarray*>(up); return;}
}

// Compute the fast Fourier transform of a pair array
#line 2746 "runtime.in"
void pairArrayFFT(stack *Stack)
{
  int sign = vm::pop<int>(Stack,1);
  pairarray * a = vm::pop<pairarray *>(Stack);
#line 2747 "runtime.in"
  unsigned n=(unsigned) checkArray(a);
  array *c=new array(n);
#ifdef HAVE_LIBFFTW3
  Complex *f=FFTWComplex(n);
  fft1d Forward(n,sign,f);
  
  for(size_t i=0; i < n; i++) {
    pair z=read<pair>(a,i);
    f[i]=Complex(z.getx(),z.gety());
  }
  Forward.fft(f);
  
  for(size_t i=0; i < n; i++) {
    Complex z=f[i];
    (*c)[i]=pair(z.real(),z.imag());
  }
  FFTWdelete(f);
#else
  assert(sign); // Avoid unused variable warning message
#endif //  HAVE_LIBFFTW3
  {Stack->push<pairarray*>(c); return;}
}


// File operations
#line 2773 "runtime.in"
// bool ==(file *a, file *b);
void gen271(stack *Stack)
{
  file * b = vm::pop<file *>(Stack);
  file * a = vm::pop<file *>(Stack);
#line 2774 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 2779 "runtime.in"
// bool !=(file *a, file *b);
void gen272(stack *Stack)
{
  file * b = vm::pop<file *>(Stack);
  file * a = vm::pop<file *>(Stack);
#line 2780 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 2784 "runtime.in"
void standardOut(stack *Stack)
{
#line 2785 "runtime.in"
  {Stack->push<file*>(&camp::Stdout); return;}
}

#line 2789 "runtime.in"
void nullFile(stack *Stack)
{
#line 2790 "runtime.in"
  {Stack->push<file*>(&camp::nullfile); return;}
}

#line 2794 "runtime.in"
// file* input(string name, bool check=true, string comment=commentchar);
void gen275(stack *Stack)
{
  string comment = vm::pop<string>(Stack,commentchar);
  bool check = vm::pop<bool>(Stack,true);
  string name = vm::pop<string>(Stack);
#line 2795 "runtime.in"
  char c=comment == "" ? (char) 0 : comment[0];
  file *f=new ifile(name,check,c);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 2802 "runtime.in"
// file* output(string name, bool append=false);
void gen276(stack *Stack)
{
  bool append = vm::pop<bool>(Stack,false);
  string name = vm::pop<string>(Stack);
#line 2803 "runtime.in"
  file *f=new ofile(name,append);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 2809 "runtime.in"
// file* xinput(string name, bool check=true);
void gen277(stack *Stack)
{
  bool check = vm::pop<bool>(Stack,true);
  string name = vm::pop<string>(Stack);
#line 2810 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new ixfile(name,check);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR read support not enabled";
  error(buf);
  if(check) return; // Never reached; suppress unused variable warning
#endif
}

#line 2822 "runtime.in"
// file* xoutput(string name, bool append=false);
void gen278(stack *Stack)
{
  bool append = vm::pop<bool>(Stack,false);
  string name = vm::pop<string>(Stack);
#line 2823 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new oxfile(name,append);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR write support not enabled";
  error(buf);
  if(append) return; // Never reached; suppress unused variable warning
#endif
}

#line 2835 "runtime.in"
// bool eof(file *File);
void gen279(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2836 "runtime.in"
  {Stack->push<bool>(File->eof()); return;}
}

#line 2840 "runtime.in"
// bool eol(file *File);
void gen280(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2841 "runtime.in"
  {Stack->push<bool>(File->eol()); return;}
}

#line 2845 "runtime.in"
// bool error(file *File);
void gen281(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2846 "runtime.in"
  {Stack->push<bool>(File->error()); return;}
}

#line 2850 "runtime.in"
// void clear(file *File);
void gen282(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2851 "runtime.in"
  File->clear();
}

#line 2855 "runtime.in"
// void close(file *File);
void gen283(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2856 "runtime.in"
  File->close();
}

#line 2860 "runtime.in"
// void precision(file *File, int digits);
void gen284(stack *Stack)
{
  int digits = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 2861 "runtime.in"
  File->precision(digits);
}

#line 2865 "runtime.in"
// void flush(file *File);
void gen285(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2866 "runtime.in"
   File->flush();
}

#line 2870 "runtime.in"
// string getc(file *File);
void gen286(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2871 "runtime.in"
  char c;
  if(File->isOpen()) File->read(c);
  static char str[1];
  str[0]=c;
  {Stack->push<string>(string(str)); return;}
}

#line 2879 "runtime.in"
// int tell(file *File);
void gen287(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2880 "runtime.in"
  {Stack->push<int>((int) File->tell()); return;}
}

#line 2884 "runtime.in"
// void seek(file *File, int pos);
void gen288(stack *Stack)
{
  int pos = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 2885 "runtime.in"
  File->seek(pos);
}

// Set file dimensions
#line 2890 "runtime.in"
// file* dimension(file *File, int nx);
void gen289(stack *Stack)
{
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 2891 "runtime.in"
  File->dimension(nx);
  {Stack->push<file*>(File); return;}
}

#line 2896 "runtime.in"
// file* dimension(file *File, int nx, int ny);
void gen290(stack *Stack)
{
  int ny = vm::pop<int>(Stack);
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 2897 "runtime.in"
  File->dimension(nx,ny);
  {Stack->push<file*>(File); return;}
}

#line 2902 "runtime.in"
// file* dimension(file *File, int nx, int ny, int nz);
void gen291(stack *Stack)
{
  int nz = vm::pop<int>(Stack);
  int ny = vm::pop<int>(Stack);
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 2903 "runtime.in"
  File->dimension(nx,ny,nz);
  {Stack->push<file*>(File); return;}
}

// Set file to read comma-separated values
#line 2909 "runtime.in"
// file* csv(file *File, bool b=true);
void gen292(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 2910 "runtime.in"
  File->CSVMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read arrays in line-at-a-time mode
#line 2916 "runtime.in"
// file* line(file *File, bool b=true);
void gen293(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 2917 "runtime.in"
  File->LineMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read/write single-precision XDR values.
#line 2923 "runtime.in"
// file* single(file *File, bool b=true);
void gen294(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 2924 "runtime.in"
  File->SingleMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array1 (1 int size followed by a 1d array)
#line 2930 "runtime.in"
// file* read1(file *File);
void gen295(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2931 "runtime.in"
  File->dimension(-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array2 (2 int sizes followed by a 2d array)
#line 2937 "runtime.in"
// file* read2(file *File);
void gen296(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2938 "runtime.in"
  File->dimension(-2,-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array3 (3 int sizes followed by a 3d array)
#line 2944 "runtime.in"
// file* read3(file *File);
void gen297(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 2945 "runtime.in"
  File->dimension(-2,-2,-2);
  {Stack->push<file*>(File); return;}
}

// Prompt for a string using the GNU readline library and a local history.
// On exit, save this local history under the name historyfilename(history),
// unless history begins with an underscore character.
#line 2953 "runtime.in"
// string readline(string prompt=emptystring, string history=emptystring,		string initial=emptystring, bool tabcompletion=false);
void gen298(stack *Stack)
{
  bool tabcompletion = vm::pop<bool>(Stack,false);
  string initial = vm::pop<string>(Stack,emptystring);
  string history = vm::pop<string>(Stack,emptystring);
  string prompt = vm::pop<string>(Stack,emptystring);
#line 2955 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_HISTORY_STATE) && \
    defined(HAVE_LIBCURSES)
  init_readline(tabcompletion);
  
  store_history(&history_save);
  bool newhistory=historyMap.find(history) == historyMap.end();
  HISTORY_STATE& History=historyMap[history];
  history_set_history_state(&History);
  if(history[0] != nosave && newhistory)
    read_history(historyfilename(history).c_str());
  
  static char *line_read=NULL;
  /* Return the memory to the free pool
     if the buffer has already been allocated. */
  if(line_read) {
    free(line_read);
    line_read=NULL;
  }
     
  HIST_ENTRY *last=history_get(history_length);
  const char *Default=last ? last->line : initial.c_str();
  int size=snprintf(NULL,0,prompt.c_str(),Default)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,prompt.c_str(),Default);
  
  /* Get a line from the user. */
  line_read=readline(buf);
  delete[] buf;
     
  if(line_read) {
  /* If the line has any text in it, save it on the history. */
    if(*line_read) add_history(line_read);
  } else cout << endl;
  
  store_history(&History);
  history_set_history_state(&history_save);
  
  {Stack->push<string>(line_read ? string(*line_read ? line_read : Default) : emptystring); return;}
#else
  Stdout.write(prompt);
  static ifile Stdin("");
  string s;
  Stdin.read(s);
  if(tabcompletion) {Stack->push<string>(s); return;} // Avoid unused variable warning message.
  {Stack->push<string>(s); return;}
#endif
}

} // namespace run

namespace trans {

void gen_base_venv(venv &ve)
{
#line 539 "runtime.in"
  addFunc(ve, run::gen8, primBoolean(), "!", formal(primBoolean(), "b", false, false));
#line 595 "runtime.in"
  addFunc(ve, run::gen17, primBoolean(), "empty", formal(primPicture(), "f", false, false));
#line 600 "runtime.in"
  addFunc(ve, run::gen18, primPair(), "max", formal(primPicture(), "f", false, false));
#line 605 "runtime.in"
  addFunc(ve, run::gen19, primPair(), "min", formal(primPicture(), "f", false, false));
#line 610 "runtime.in"
  addFunc(ve, run::gen20, primVoid(), "label", formal(primPicture(), "f", false, false), formal(primString(), "s", false, false), formal(primString(), "size", false, false), formal(primReal(), "angle", false, false), formal(primPair(), "position", false, false), formal(primPair(), "align", false, false), formal(primPair(), "scale", false, false), formal(primPen(), "p", false, false));
#line 616 "runtime.in"
  addFunc(ve, run::gen21, primBoolean(), "labels", formal(primPicture(), "f", false, false));
#line 621 "runtime.in"
  addFunc(ve, run::gen22, primVoid(), "fill", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 626 "runtime.in"
  addFunc(ve, run::gen23, primVoid(), "latticeshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray2()  , "p", false, false));
#line 631 "runtime.in"
  addFunc(ve, run::gen24, primVoid(), "axialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false));
#line 636 "runtime.in"
  addFunc(ve, run::gen25, primVoid(), "radialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primReal(), "ra", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primReal(), "rb", false, false));
#line 642 "runtime.in"
  addFunc(ve, run::gen26, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray()  , "p", false, false), formal(pairArray(), "z", false, false), formal(intArray(), "edges", false, false));
#line 651 "runtime.in"
  addFunc(ve, run::gen27, primVoid(), "clip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 658 "runtime.in"
  addFunc(ve, run::gen28, primVoid(), "beginclip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 663 "runtime.in"
  addFunc(ve, run::gen29, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 668 "runtime.in"
  addFunc(ve, run::gen30, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 673 "runtime.in"
  addFunc(ve, run::gen31, primVoid(), "texpreamble", formal(primString() , "s", false, false));
#line 680 "runtime.in"
  addFunc(ve, run::gen32, primVoid(), "layer", formal(primPicture(), "f", false, false));
#line 685 "runtime.in"
  addFunc(ve, run::gen33, primVoid(), "image", formal(primPicture(), "f", false, false), formal(realArray2(), "data", false, false), formal(penArray()  , "palette", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(primTransform(), "t", true, false));
#line 692 "runtime.in"
  addFunc(ve, run::gen34, primVoid(), "shipout", formal(primString() , "prefix", true, false), formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primString() , "format", true, false), formal(primBoolean(), "wait", true, false), formal(primBoolean(), "quiet", true, false), formal(transformArray(), "guitransform", false, false), formal(boolArray(), "guidelete", false, false));
#line 762 "runtime.in"
  addFunc(ve, run::gen36, primBoolean(), "==", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 767 "runtime.in"
  addFunc(ve, run::gen37, primBoolean(), "!=", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 772 "runtime.in"
  addFunc(ve, run::gen38, primPen(), "+", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 777 "runtime.in"
  addFunc(ve, run::gen39, primPen(), "*", formal(primReal(), "a", false, false), formal(primPen(), "b", false, false));
#line 782 "runtime.in"
  addFunc(ve, run::gen40, primPen(), "*", formal(primPen(), "a", false, false), formal(primReal(), "b", false, false));
#line 787 "runtime.in"
  addFunc(ve, run::gen41, primPair(), "max", formal(primPen(), "p", false, false));
#line 792 "runtime.in"
  addFunc(ve, run::gen42, primPair(), "min", formal(primPen(), "p", false, false));
#line 797 "runtime.in"
  addFunc(ve, run::gen43, primVoid(), "resetdefaultpen");
#line 803 "runtime.in"
  addFunc(ve, run::gen44, primVoid(), "defaultpen", formal(primPen(), "p", false, false));
#line 808 "runtime.in"
  addFunc(ve, run::gen45, primPen(), "defaultpen");
#line 813 "runtime.in"
  addFunc(ve, run::gen46, primPen(), "invisible");
#line 818 "runtime.in"
  addFunc(ve, run::gen47, primPen(), "gray", formal(primPen(), "p", false, false));
#line 825 "runtime.in"
  addFunc(ve, run::gen48, primPen(), "rgb", formal(primPen(), "p", false, false));
#line 832 "runtime.in"
  addFunc(ve, run::gen49, primPen(), "rgb", formal(primReal(), "r", false, false), formal(primReal(), "g", false, false), formal(primReal(), "b", false, false));
#line 837 "runtime.in"
  addFunc(ve, run::gen50, primPen(), "cmyk", formal(primReal(), "c", false, false), formal(primReal(), "m", false, false), formal(primReal(), "y", false, false), formal(primReal(), "k", false, false));
#line 842 "runtime.in"
  addFunc(ve, run::gen51, primPen(), "gray", formal(primReal(), "gray", false, false));
#line 847 "runtime.in"
  addFunc(ve, run::gen52, realArray(), "colors", formal(primPen(), "p", false, false));
#line 875 "runtime.in"
  addFunc(ve, run::gen53, primPen(), "pattern", formal(primString(), "s", false, false));
#line 880 "runtime.in"
  addFunc(ve, run::gen54, primString() , "pattern", formal(primPen(), "p", false, false));
#line 885 "runtime.in"
  addFunc(ve, run::gen55, primPen(), "fillrule", formal(primInt(), "n", false, false));
#line 890 "runtime.in"
  addFunc(ve, run::gen56, primInt(), "fillrule", formal(primPen(), "p", false, false));
#line 895 "runtime.in"
  addFunc(ve, run::gen57, primPen(), "linetype", formal(primString(), "s", false, false), formal(primBoolean(), "scale", false, false));
#line 900 "runtime.in"
  addFunc(ve, run::gen58, primString() , "linetype", formal(primPen(), "p", false, false));
#line 905 "runtime.in"
  addFunc(ve, run::gen59, primPen(), "linecap", formal(primInt(), "n", false, false));
#line 910 "runtime.in"
  addFunc(ve, run::gen60, primInt(), "linecap", formal(primPen(), "p", false, false));
#line 915 "runtime.in"
  addFunc(ve, run::gen61, primPen(), "linejoin", formal(primInt(), "n", false, false));
#line 920 "runtime.in"
  addFunc(ve, run::gen62, primInt(), "linejoin", formal(primPen(), "p", false, false));
#line 925 "runtime.in"
  addFunc(ve, run::gen63, primPen(), "linewidth", formal(primReal(), "x", false, false));
#line 930 "runtime.in"
  addFunc(ve, run::gen64, primReal(), "linewidth", formal(primPen(), "p", false, false));
#line 935 "runtime.in"
  addFunc(ve, run::gen65, primPen(), "fontcommand", formal(primString(), "s", false, false));
#line 940 "runtime.in"
  addFunc(ve, run::gen66, primString() , "font", formal(primPen(), "p", false, false));
#line 945 "runtime.in"
  addFunc(ve, run::gen67, primPen(), "fontsize", formal(primReal(), "size", false, false), formal(primReal(), "skip", false, false));
#line 951 "runtime.in"
  addFunc(ve, run::gen68, primReal(), "fontsize", formal(primPen(), "p", false, false));
#line 956 "runtime.in"
  addFunc(ve, run::gen69, primReal(), "lineskip", formal(primPen(), "p", false, false));
#line 961 "runtime.in"
  addFunc(ve, run::gen70, primPen(), "overwrite", formal(primInt(), "n", false, false));
#line 967 "runtime.in"
  addFunc(ve, run::gen71, primInt(), "overwrite", formal(primPen(), "p", false, false));
#line 972 "runtime.in"
  addFunc(ve, run::gen72, primPen(), "basealign", formal(primInt(), "n", false, false));
#line 977 "runtime.in"
  addFunc(ve, run::gen73, primInt(), "basealign", formal(primPen(), "p", false, false));
#line 982 "runtime.in"
  addFunc(ve, run::gen74, primPath(), "nib", formal(primPen(), "p", false, false));
#line 989 "runtime.in"
  addFunc(ve, run::gen75, primPen(), "makepen", formal(primPath(), "p", false, false));
#line 994 "runtime.in"
  addFunc(ve, run::gen76, primVoid(), "_draw", formal(primPicture(), "f", false, false), formal(primPath(), "g", false, false), formal(primPen(), "p", false, false));
#line 999 "runtime.in"
  addFunc(ve, run::gen77, primVoid(), "endclip", formal(primPicture(), "f", false, false));
#line 1004 "runtime.in"
  addFunc(ve, run::gen78, primVoid(), "gsave", formal(primPicture(), "f", false, false));
#line 1009 "runtime.in"
  addFunc(ve, run::gen79, primVoid(), "grestore", formal(primPicture(), "f", false, false));
#line 1014 "runtime.in"
  addFunc(ve, run::gen80, primVoid(), "begingroup", formal(primPicture(), "f", false, false));
#line 1019 "runtime.in"
  addFunc(ve, run::gen81, primVoid(), "endgroup", formal(primPicture(), "f", false, false));
#line 1024 "runtime.in"
  addFunc(ve, run::gen82, primVoid(), "add", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1029 "runtime.in"
  addFunc(ve, run::gen83, primVoid(), "prepend", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1034 "runtime.in"
  addFunc(ve, run::gen84, primBoolean(), "interact");
#line 1042 "runtime.in"
  addFunc(ve, run::gen85, primVoid(), "uptodate", formal(primBoolean(), "b", false, false));
#line 1047 "runtime.in"
  addFunc(ve, run::gen86, primBoolean(), "uptodate");
#line 1052 "runtime.in"
  addFunc(ve, run::gen87, primInt(), "system", formal(primString(), "str", false, false));
#line 1061 "runtime.in"
  addFunc(ve, run::gen88, primVoid(), "abort", formal(primString(), "msg", false, false));
#line 1066 "runtime.in"
  addFunc(ve, run::gen89, primVoid(), "_eval", formal(primString(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 1071 "runtime.in"
  addFunc(ve, run::gen90, primVoid(), "_eval", formal(primCode(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 1076 "runtime.in"
  addFunc(ve, run::gen91, primVoid(), "gui", formal(primReal(), "x", true, false));
#line 1081 "runtime.in"
  addFunc(ve, run::gen92, primBoolean(), "deconstruct");
#line 1086 "runtime.in"
  addFunc(ve, run::gen93, primVoid(), "readGUI");
#line 1111 "runtime.in"
  addFunc(ve, run::gen95, primString() , "cd", formal(primString(), "d", false, false));
#line 1125 "runtime.in"
  addFunc(ve, run::gen96, primVoid(), "scroll", formal(primInt(), "n", false, false));
#line 1139 "runtime.in"
  addFunc(ve, run::gen98, primPair(), "point", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1144 "runtime.in"
  addFunc(ve, run::gen99, primPair(), "point", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1149 "runtime.in"
  addFunc(ve, run::gen100, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1154 "runtime.in"
  addFunc(ve, run::gen101, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1159 "runtime.in"
  addFunc(ve, run::gen102, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1164 "runtime.in"
  addFunc(ve, run::gen103, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1169 "runtime.in"
  addFunc(ve, run::gen104, primPair(), "dir", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1174 "runtime.in"
  addFunc(ve, run::gen105, primPair(), "dir", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1179 "runtime.in"
  addFunc(ve, run::gen106, primPath(), "reverse", formal(primPath(), "p", false, false));
#line 1184 "runtime.in"
  addFunc(ve, run::gen107, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primInt(), "b", false, false), formal(primInt(), "e", false, false));
#line 1189 "runtime.in"
  addFunc(ve, run::gen108, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primReal(), "b", false, false), formal(primReal(), "e", false, false));
#line 1194 "runtime.in"
  addFunc(ve, run::gen109, primInt(), "length", formal(primPath(), "p", false, false));
#line 1199 "runtime.in"
  addFunc(ve, run::gen110, primBoolean(), "cyclic", formal(primPath(), "p", false, false));
#line 1204 "runtime.in"
  addFunc(ve, run::gen111, primBoolean(), "straight", formal(primPath(), "p", false, false), formal(primInt(), "i", false, false));
#line 1209 "runtime.in"
  addFunc(ve, run::gen112, primReal(), "arclength", formal(primPath(), "p", false, false));
#line 1214 "runtime.in"
  addFunc(ve, run::gen113, primReal(), "arctime", formal(primPath(), "p", false, false), formal(primReal(), "dval", false, false));
#line 1219 "runtime.in"
  addFunc(ve, run::gen114, primReal(), "dirtime", formal(primPath(), "p", false, false), formal(primPair(), "z", false, false));
#line 1224 "runtime.in"
  addFunc(ve, run::gen115, primPair(), "intersect", formal(primPath(), "x", false, false), formal(primPath(), "y", false, false), formal(primReal(), "fuzz", true, false));
#line 1229 "runtime.in"
  addFunc(ve, run::gen116, primInt(), "size", formal(primPath(), "p", false, false));
#line 1234 "runtime.in"
  addFunc(ve, run::gen117, primPath(), "&", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false));
#line 1239 "runtime.in"
  addFunc(ve, run::gen118, primPair(), "min", formal(primPath(), "p", false, false));
#line 1244 "runtime.in"
  addFunc(ve, run::gen119, primPair(), "max", formal(primPath(), "p", false, false));
#line 1249 "runtime.in"
  addFunc(ve, run::gen120, primReal(), "relativedistance", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "atleast", false, false));
#line 1254 "runtime.in"
  addFunc(ve, run::gen121, primBoolean(), "inside", formal(pathArray()  , "g", false, false), formal(primPair(), "z", false, false), formal(primPen(), "p", false, false));
#line 1309 "runtime.in"
  addFunc(ve, run::gen125, primGuide(), "operator cycle");
#line 1314 "runtime.in"
  addFunc(ve, run::gen126, primGuide(), "operator spec", formal(primPair(), "z", false, false), formal(primInt(), "p", false, false));
#line 1322 "runtime.in"
  addFunc(ve, run::gen127, primGuide(), "operator curl", formal(primReal(), "gamma", false, false), formal(primInt(), "p", false, false));
#line 1330 "runtime.in"
  addFunc(ve, run::gen128, primGuide(), "operator tension", formal(primReal(), "tout", false, false), formal(primReal(), "tin", false, false), formal(primBoolean(), "atleast", false, false));
#line 1338 "runtime.in"
  addFunc(ve, run::gen129, primGuide(), "operator controls", formal(primPair(), "zout", false, false), formal(primPair(), "zin", false, false));
#line 1351 "runtime.in"
  addFunc(ve, run::gen131, primInt(), "length", formal(primString(), "s", false, false));
#line 1356 "runtime.in"
  addFunc(ve, run::gen132, primInt(), "find", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 1361 "runtime.in"
  addFunc(ve, run::gen133, primInt(), "rfind", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 1366 "runtime.in"
  addFunc(ve, run::gen134, primString() , "reverse", formal(primString() , "s", false, false));
#line 1372 "runtime.in"
  addFunc(ve, run::gen135, primString() , "insert", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primString() , "t", false, false));
#line 1379 "runtime.in"
  addFunc(ve, run::gen136, primString() , "substr", formal(primString(), "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", true, false));
#line 1386 "runtime.in"
  addFunc(ve, run::gen137, primString() , "erase", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", false, false));
#line 1393 "runtime.in"
  addFunc(ve, run::gen138, primString() , "replace", formal(primString(), "s", false, false), formal(stringArray2(), "translate", false, false));
#line 1420 "runtime.in"
  addFunc(ve, run::gen139, primString() , "format", formal(primString(), "format", false, false), formal(primInt(), "x", false, false));
#line 1435 "runtime.in"
  addFunc(ve, run::gen140, primString() , "format", formal(primString(), "format", false, false), formal(primReal(), "x", false, false));
#line 1539 "runtime.in"
  addFunc(ve, run::gen141, primString() , "time", formal(primString(), "format", false, false));
#line 1552 "runtime.in"
  addFunc(ve, run::gen142, primReal(), "^", formal(primReal(), "x", false, false), formal(primInt(), "y", false, false));
#line 1560 "runtime.in"
  addFunc(ve, run::gen143, primInt(), "quotient", formal(primInt(), "x", false, false), formal(primInt(), "y", false, false));
#line 1567 "runtime.in"
  addFunc(ve, run::gen144, primInt(), "abs", formal(primInt(), "x", false, false));
#line 1572 "runtime.in"
  addFunc(ve, run::gen145, primInt(), "sgn", formal(primReal(), "x", false, false));
#line 1577 "runtime.in"
  addFunc(ve, run::gen146, primInt(), "rand");
#line 1582 "runtime.in"
  addFunc(ve, run::gen147, primVoid(), "srand", formal(primInt(), "seed", false, false));
#line 1587 "runtime.in"
  addFunc(ve, run::gen148, primInt(), "ceil", formal(primReal(), "x", false, false));
#line 1594 "runtime.in"
  addFunc(ve, run::gen149, primInt(), "floor", formal(primReal(), "x", false, false));
#line 1601 "runtime.in"
  addFunc(ve, run::gen150, primInt(), "round", formal(primReal(), "x", false, false));
#line 1607 "runtime.in"
  addFunc(ve, run::gen151, primInt(), "Ceil", formal(primReal(), "x", false, false));
#line 1612 "runtime.in"
  addFunc(ve, run::gen152, primInt(), "Floor", formal(primReal(), "x", false, false));
#line 1617 "runtime.in"
  addFunc(ve, run::gen153, primInt(), "Round", formal(primReal(), "x", false, false));
#line 1622 "runtime.in"
  addFunc(ve, run::gen154, primReal(), "fmod", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1628 "runtime.in"
  addFunc(ve, run::gen155, primReal(), "atan2", formal(primReal(), "y", false, false), formal(primReal(), "x", false, false));
#line 1633 "runtime.in"
  addFunc(ve, run::gen156, primReal(), "hypot", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1638 "runtime.in"
  addFunc(ve, run::gen157, primReal(), "remainder", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1643 "runtime.in"
  addFunc(ve, run::gen158, primReal(), "J", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 1648 "runtime.in"
  addFunc(ve, run::gen159, primReal(), "Y", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 1653 "runtime.in"
  addFunc(ve, run::gen160, primReal(), "erf", formal(primReal(), "x", false, false));
#line 1658 "runtime.in"
  addFunc(ve, run::gen161, primReal(), "erfc", formal(primReal(), "x", false, false));
#line 1663 "runtime.in"
  addFunc(ve, run::gen162, primReal(), "gamma", formal(primReal(), "x", false, false));
#line 1673 "runtime.in"
  addFunc(ve, run::gen163, realArray(), "quadraticroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false));
#line 1682 "runtime.in"
  addFunc(ve, run::gen164, realArray(), "cubicroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false), formal(primReal(), "d", false, false));
#line 1692 "runtime.in"
  addFunc(ve, run::gen165, primBoolean(), "==", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 1700 "runtime.in"
  addFunc(ve, run::gen166, primBoolean(), "!=", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 1705 "runtime.in"
  addFunc(ve, run::gen167, primTransform(), "*", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 1710 "runtime.in"
  addFunc(ve, run::gen168, primPair(), "*", formal(primTransform(), "t", false, false), formal(primPair(), "z", false, false));
#line 1715 "runtime.in"
  addFunc(ve, run::gen169, primPath(), "*", formal(primTransform(), "t", false, false), formal(primPath(), "g", false, false));
#line 1720 "runtime.in"
  addFunc(ve, run::gen170, primPen(), "*", formal(primTransform(), "t", false, false), formal(primPen(), "p", false, false));
#line 1725 "runtime.in"
  addFunc(ve, run::gen171, primPicture(), "*", formal(primTransform(), "t", false, false), formal(primPicture(), "f", false, false));
#line 1730 "runtime.in"
  addFunc(ve, run::gen172, primTransform(), "^", formal(primTransform(), "t", false, false), formal(primInt(), "n", false, false));
#line 1777 "runtime.in"
  addFunc(ve, run::transformIdentity, primTransform(), "identity");
#line 1782 "runtime.in"
  addFunc(ve, run::gen181, primTransform(), "inverse", formal(primTransform(), "t", false, false));
#line 1787 "runtime.in"
  addFunc(ve, run::gen182, primTransform(), "shift", formal(primPair(), "z", false, false));
#line 1792 "runtime.in"
  addFunc(ve, run::gen183, primTransform(), "xscale", formal(primReal(), "x", false, false));
#line 1797 "runtime.in"
  addFunc(ve, run::gen184, primTransform(), "yscale", formal(primReal(), "y", false, false));
#line 1802 "runtime.in"
  addFunc(ve, run::gen185, primTransform(), "scale", formal(primReal(), "x", false, false));
#line 1807 "runtime.in"
  addFunc(ve, run::gen186, primTransform(), "slant", formal(primReal(), "s", false, false));
#line 1812 "runtime.in"
  addFunc(ve, run::gen187, primTransform(), "rotate", formal(primReal(), "angle", false, false), formal(primPair(), "z", true, false));
#line 1817 "runtime.in"
  addFunc(ve, run::gen188, primTransform(), "reflect", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false));
#line 1841 "runtime.in"
  addFunc(ve, run::pairXPart, primReal(), "xpart", formal(primPair(), "z", false, false));
#line 1846 "runtime.in"
  addFunc(ve, run::pairYPart, primReal(), "ypart", formal(primPair(), "z", false, false));
#line 1851 "runtime.in"
  addFunc(ve, run::gen194, primReal(), "length", formal(primPair(), "z", false, false));
#line 1856 "runtime.in"
  addFunc(ve, run::gen195, primReal(), "abs", formal(primPair(), "z", false, false));
#line 1861 "runtime.in"
  addFunc(ve, run::gen196, primReal(), "angle", formal(primPair(), "z", false, false));
#line 1866 "runtime.in"
  addFunc(ve, run::gen197, primReal(), "degrees", formal(primPair(), "z", false, false));
#line 1872 "runtime.in"
  addFunc(ve, run::gen198, primReal(), "Degrees", formal(primPair(), "z", false, false));
#line 1879 "runtime.in"
  addFunc(ve, run::gen199, primPair(), "unit", formal(primPair(), "z", false, false));
#line 1884 "runtime.in"
  addFunc(ve, run::gen200, primPair(), "dir", formal(primReal(), "theta", false, false));
#line 1889 "runtime.in"
  addFunc(ve, run::gen201, primPair(), "expi", formal(primReal(), "theta", false, false));
#line 1894 "runtime.in"
  addFunc(ve, run::gen202, primPair(), "conj", formal(primPair(), "z", false, false));
#line 1899 "runtime.in"
  addFunc(ve, run::gen203, primReal(), "dot", formal(primPair(), "u", false, true), formal(primPair(), "v", false, true));
#line 1905 "runtime.in"
  addFunc(ve, run::gen204, primPair(), "minbound", formal(primPair(), "z", false, false), formal(primPair(), "w", false, false));
#line 1910 "runtime.in"
  addFunc(ve, run::gen205, primPair(), "maxbound", formal(primPair(), "z", false, false), formal(primPair(), "w", false, false));
#line 1930 "runtime.in"
  addFunc(ve, run::tripleXPart, primReal(), "xpart", formal(primTriple(), "v", false, false));
#line 1935 "runtime.in"
  addFunc(ve, run::tripleYPart, primReal(), "ypart", formal(primTriple(), "v", false, false));
#line 1940 "runtime.in"
  addFunc(ve, run::tripleZPart, primReal(), "zpart", formal(primTriple(), "v", false, false));
#line 1945 "runtime.in"
  addFunc(ve, run::gen211, primTriple(), "*", formal(primReal(), "x", false, false), formal(primTriple(), "v", false, false));
#line 1950 "runtime.in"
  addFunc(ve, run::gen212, primTriple(), "*", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 1955 "runtime.in"
  addFunc(ve, run::gen213, primTriple(), "/", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 1960 "runtime.in"
  addFunc(ve, run::gen214, primReal(), "length", formal(primTriple(), "v", false, false));
#line 1965 "runtime.in"
  addFunc(ve, run::gen215, primReal(), "abs", formal(primTriple(), "v", false, false));
#line 1970 "runtime.in"
  addFunc(ve, run::gen216, primReal(), "polar", formal(primTriple(), "v", false, false));
#line 1975 "runtime.in"
  addFunc(ve, run::gen217, primReal(), "azimuth", formal(primTriple(), "v", false, false));
#line 1980 "runtime.in"
  addFunc(ve, run::gen218, primReal(), "colatitude", formal(primTriple(), "v", false, false));
#line 1985 "runtime.in"
  addFunc(ve, run::gen219, primReal(), "latitude", formal(primTriple(), "v", false, false));
#line 1990 "runtime.in"
  addFunc(ve, run::gen220, primReal(), "longitude", formal(primTriple(), "v", false, false));
#line 1996 "runtime.in"
  addFunc(ve, run::gen221, primReal(), "Longitude", formal(primTriple(), "v", false, false));
#line 2003 "runtime.in"
  addFunc(ve, run::gen222, primTriple(), "unit", formal(primTriple(), "v", false, false));
#line 2008 "runtime.in"
  addFunc(ve, run::gen223, primReal(), "dot", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2013 "runtime.in"
  addFunc(ve, run::gen224, primTriple(), "cross", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2020 "runtime.in"
  addFunc(ve, run::gen225, primTriple(), "expi", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2027 "runtime.in"
  addFunc(ve, run::gen226, primTriple(), "dir", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2032 "runtime.in"
  addFunc(ve, run::gen227, primTriple(), "minbound", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2038 "runtime.in"
  addFunc(ve, run::gen228, primTriple(), "maxbound", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2044 "runtime.in"
  addFunc(ve, run::gen229, primReal(), "cubiclength", formal(primTriple(), "z0", false, false), formal(primTriple(), "z0p", false, false), formal(primTriple(), "z1m", false, false), formal(primTriple(), "z1", false, false), formal(primReal(), "goal", false, false));
#line 2049 "runtime.in"
  addFunc(ve, run::gen230, primPair(), "intersect", formal(tripleArray(), "pre1", false, false), formal(tripleArray(), "point1", false, false), formal(tripleArray(), "post1", false, false), formal(tripleArray(), "pre2", false, false), formal(tripleArray(), "point2", false, false), formal(tripleArray(), "post2", false, false), formal(primReal(), "fuzz", false, false));
#line 2082 "runtime.in"
  addFunc(ve, run::gen231, primString() , "VERSION");
#line 2090 "runtime.in"
  addFunc(ve, run::gen232, primVoid(), "quiet", formal(primBoolean(), "v", false, false));
#line 2097 "runtime.in"
  addFunc(ve, run::gen233, primVoid(), "atexit", formal(voidFunction(), "f", false, false));
#line 2102 "runtime.in"
  addFunc(ve, run::gen234, voidFunction(), "atexit");
#line 2107 "runtime.in"
  addFunc(ve, run::gen235, primInt(), "merge", formal(stringArray(), "files", false, false), formal(primString(), "args", false, false), formal(primString(), "format", false, false));
#line 2336 "runtime.in"
  addFunc(ve, run::gen255, intArray(), "complement", formal(intArray(), "a", false, false), formal(primInt(), "n", false, false));
#line 2368 "runtime.in"
  addFunc(ve, run::gen257, intArray(), "sequence", formal(primInt(), "n", false, false));
#line 2392 "runtime.in"
  addFunc(ve, run::gen259, primBoolean(), "all", formal(boolArray(), "a", false, false));
#line 2401 "runtime.in"
  addFunc(ve, run::gen260, boolArray(), "!", formal(boolArray(), "a", false, false));
#line 2410 "runtime.in"
  addFunc(ve, run::gen261, primInt(), "sum", formal(boolArray(), "a", false, false));
#line 2465 "runtime.in"
  addFunc(ve, run::gen266, primInt(), "find", formal(boolArray(), "a", false, false), formal(primInt(), "n", true, false));
#line 2511 "runtime.in"
  addFunc(ve, run::gen268, realArray2(), "solve", formal(realArray2(), "a", false, false), formal(realArray2(), "b", true, false));
#line 2641 "runtime.in"
  addFunc(ve, run::gen269, realArray(), "tridiagonal", formal(realArray(), "a", false, false), formal(realArray(), "b", false, false), formal(realArray(), "c", false, false), formal(realArray(), "f", false, false));
#line 2771 "runtime.in"
  addFunc(ve, run::gen271, primBoolean(), "==", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 2779 "runtime.in"
  addFunc(ve, run::gen272, primBoolean(), "!=", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 2794 "runtime.in"
  addFunc(ve, run::gen275, primFile(), "input", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false), formal(primString() , "comment", true, false));
#line 2802 "runtime.in"
  addFunc(ve, run::gen276, primFile(), "output", formal(primString() , "name", false, false), formal(primBoolean(), "append", true, false));
#line 2809 "runtime.in"
  addFunc(ve, run::gen277, primFile(), "xinput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 2822 "runtime.in"
  addFunc(ve, run::gen278, primFile(), "xoutput", formal(primString() , "name", false, false), formal(primBoolean(), "append", true, false));
#line 2835 "runtime.in"
  addFunc(ve, run::gen279, primBoolean(), "eof", formal(primFile(), "file", false, false));
#line 2840 "runtime.in"
  addFunc(ve, run::gen280, primBoolean(), "eol", formal(primFile(), "file", false, false));
#line 2845 "runtime.in"
  addFunc(ve, run::gen281, primBoolean(), "error", formal(primFile(), "file", false, false));
#line 2850 "runtime.in"
  addFunc(ve, run::gen282, primVoid(), "clear", formal(primFile(), "file", false, false));
#line 2855 "runtime.in"
  addFunc(ve, run::gen283, primVoid(), "close", formal(primFile(), "file", false, false));
#line 2860 "runtime.in"
  addFunc(ve, run::gen284, primVoid(), "precision", formal(primFile(), "file", false, false), formal(primInt(), "digits", false, false));
#line 2865 "runtime.in"
  addFunc(ve, run::gen285, primVoid(), "flush", formal(primFile(), "file", false, false));
#line 2870 "runtime.in"
  addFunc(ve, run::gen286, primString() , "getc", formal(primFile(), "file", false, false));
#line 2879 "runtime.in"
  addFunc(ve, run::gen287, primInt(), "tell", formal(primFile(), "file", false, false));
#line 2884 "runtime.in"
  addFunc(ve, run::gen288, primVoid(), "seek", formal(primFile(), "file", false, false), formal(primInt(), "pos", false, false));
#line 2889 "runtime.in"
  addFunc(ve, run::gen289, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false));
#line 2896 "runtime.in"
  addFunc(ve, run::gen290, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false));
#line 2902 "runtime.in"
  addFunc(ve, run::gen291, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false), formal(primInt(), "nz", false, false));
#line 2908 "runtime.in"
  addFunc(ve, run::gen292, primFile(), "csv", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 2915 "runtime.in"
  addFunc(ve, run::gen293, primFile(), "line", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 2922 "runtime.in"
  addFunc(ve, run::gen294, primFile(), "single", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 2929 "runtime.in"
  addFunc(ve, run::gen295, primFile(), "read1", formal(primFile(), "file", false, false));
#line 2936 "runtime.in"
  addFunc(ve, run::gen296, primFile(), "read2", formal(primFile(), "file", false, false));
#line 2943 "runtime.in"
  addFunc(ve, run::gen297, primFile(), "read3", formal(primFile(), "file", false, false));
#line 2950 "runtime.in"
  addFunc(ve, run::gen298, primString() , "readline", formal(primString() , "prompt", true, false), formal(primString() , "history", true, false), formal(primString() , "initial", true, false), formal(primBoolean(), "tabcompletion", true, false));
}

} // namespace trans
