#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import unittest

from common import dict_conf, execcmd, tmpdir
from data   import astout_export

import asrun

srcfiles = os.path.join(dict_conf['ASTER_ROOT'], dict_conf['ASTER_VERSION'], "astest", "efica02a.*")

class TestAstout(unittest.TestCase):

    def test01_cmdline(self):
        export = os.path.join(tmpdir, "astout.export")
        #dict_conf['ASTER_VERSION'] = 'NEW10_intel'
        open(export, "w").write(astout_export % dict_conf)
        dest = os.path.join(tmpdir, "astout.rep_test")
        try:
            os.makedirs(dest)
        except OSError:
            pass
        iret = os.system("cp %s %s" % (srcfiles, dest))
        cmd = dict_conf["as_run"] + ["--only_nook", export]
        iret = execcmd(cmd, "astout.1")
        assert iret == 0


if __name__ == "__main__":
    unittest.main()

