#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
import time
import random

from asrun.run    import AsRunFactory
from asrun.thread import Task, Dispatcher


# "native"
from threading import Thread
class SleepThread(Thread):
   def __init__(self, item, maxi):
      Thread.__init__(self)
      self.item  = item
      self.maxi  = maxi
      self.delay = 0.

   def run(self):
      delay = random.uniform(0., 1.) * self.maxi
      print 'thread #%d waits for %.2f s' % (self.item, delay)
      time.sleep(delay)
      self.delay = delay


class SleepTask(Task):
   def execute(self, item, **kwargs):
      delay = random.uniform(0., 1.) * self.maxi
      print 'thread waits for %.2f s' % delay
      time.sleep(delay)
      return (delay,)

   def result(self, delay, **kwargs):
      self.wait   += delay
      self.niter += 1


def test_task(maxi):
   t0 = time.time()
   task = SleepTask(maxi=maxi,                             # IN
                    niter=0, wait=0.)                      # OUT
   sleep = Dispatcher(range(numthread * mult), task, numthread)
   dt = time.time() - t0
   print sleep.report()
   print 'wallclock time = %.2f s' % dt
   print 'total wait time = %.2f s (%d iter)' % (task.wait, task.niter)
   return dt < task.wait and numthread * mult == task.niter


def test_thread(maxi):
   t0 = time.time()
   l_thread = []
   for i in range(numthread * mult):
      th = SleepThread(i, maxi)
      l_thread.append(th)
      th.start()
   wait = 0.
   niter = 0
   for th in l_thread:
      th.join()
      wait += th.delay
      niter += 1
   dt = time.time() - t0
   print 'wallclock time = %.2f s' % dt
   print 'total wait time = %.2f s (%d iter)' % (wait, niter)
   return dt < wait and numthread * mult == niter


if __name__ == '__main__':
   run = AsRunFactory()
   numthread = run.GetCpuInfo('numthread')
   if not numthread or numthread <= 1:
      print 'numthread=%s : test skipped' % numthread
      run.Sortie(0)
   mult = 2
   maxi = 0.5

   iret = 0
   ok1 = test_task(maxi)
   print
   ok2 = test_thread(maxi)
   if not ok1 or not ok2:
      iret = 4
   run.Sortie(iret)


