#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Test du suivi interactif.
"""
# ne devrait plus y avoir de problème après simplication de system.local_shell

import os
import sys

from asrun.run   import AsRunFactory
run = AsRunFactory()
run.print_timer = True

cmd = 'ls -lR /usr/lib'
run.timer.Start('mise en "cache"')
iret, output = run.Shell(cmd, follow_output=False)
run.timer.Stop('mise en "cache"')

run.timer.Start('follow_output=False')
iret, output = run.Shell(cmd, follow_output=False)
run.timer.Stop('follow_output=False')

run.timer.Start('follow_output=True')
iret, output = run.Shell(cmd, follow_output=True)
run.timer.Stop('follow_output=True')

cpu1, sys1, elap1 = run.timer.StopAndGet('follow_output=False')
cpu2, sys2, elap2 = run.timer.StopAndGet('follow_output=True')

ok1 = elap1 < 1.
ok2 = elap2 < 1.
print 'Taille output = %d bytes' % len(output)
print 'Temps 1 = %.2f s // ok ? %s' % (elap1, ok1)
print 'Temps 2 = %.2f s // ok ? %s' % (elap2, ok2)

ecart = (elap2 - elap1) / elap1 * 100.
print 'Ecart elapsed 1/2 = %.2f %%' % ecart

iret = 0
if not (ok1 and ok2):
   iret = 4
run.Sortie(iret)


