#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""Test pour l'agla'
"""

import os
import sys

from asrun.run    import AsRunFactory
from asrun.profil import ASTER_PROFIL

run = AsRunFactory()
run.print_timer = True

content_export = """
P profastk courtois@cli70cx.der.edf.fr:/home/courtois/CAS_TEST/mecanonline/ssnp110a.astk
P serveur aster.cla.edfgdf.fr
P noeud AGLA
P username courtois
P mclient cli70cx.der.edf.fr
P uclient courtois
P version NEW9
P lang fr
P debug nodebug
P mode batch
P ncpus 1
P mpi_nbcpu 1
P mpi_nbnoeud 1
P classe 
P depart 
P distrib 
P timeout 
P exectool 
P nomjob asdeno_NEW9
P origine ASTK VDEV
P display cli70cx.der.edf.fr:0.0
A args 
A memjeveux 16.0
P mem_aster 100.0
A tpmax 300
P memjob 131072
P tpsjob 5
P nbmaxnook 5
P cpresok RESNOOK
P facmtps 1
P corefilesize unlimited
N py macr_lign_coupe D 0
N py fichier_inexistant D 0
N py test_temps_ops D 0
P actions asdeno
P consbtc oui
P soumbtc oui
"""

prof = ASTER_PROFIL()
prof.parse(content_export)
prof.WriteExportTo('agla.export')

ok = prof.content.find('N py fichier_inexistant D 0') > -1 and os.path.exists('agla.export')

iret = 0
if not ok:
   iret = 4
run.Sortie(iret)


