#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import re

from asrun.installation import aster_root, confdir


# ----- get default version
fconfig = os.path.join(confdir, 'aster')
txt = open(fconfig, 'r').read()
mat = re.search('default_vers *: *([A-Z0-9\.]+)', txt)
assert mat != None, 'default_vers not found in %s' % fconfig
aster_version = mat.group(1)


# ----- write file
content = r"""# Generated by config.py
ASTER_ROOT       = %s
ASTER_VERSION   ?= %s
TOOLS_DIR        = $(ASTER_ROOT)/outils
PYTHONEXECUTABLE = %s

as_run          ?= $(ASTER_ROOT)/bin/as_run

# config file
CONFIG          ?=
ifneq ($(CONFIG),)
CONFIG_FILE_LINE = F conf $(CONFIG) D 0
endif

# common parts
PWD := $(shell pwd)


.PHONY: diag clean
diag: unittest
	@echo "   >>> Unittest ended with `cat unittest` for $(TEST)"

%%.export: %%.export.in
	@sed -e 's@ASTER_ROOT@$(ASTER_ROOT)@g' \
	     -e 's@ASTER_VERSION@$(ASTER_VERSION)@g' \
	     -e 's@PWD@$(PWD)@g' \
	     -e 's@CONFIG_FILE_LINE@$(CONFIG_FILE_LINE)@g' \
	   $< > $@

%%.py: %%.py.in
	@sed -e 's@ASTER_ROOT@$(ASTER_ROOT)@g' \
	     -e 's@ASTER_VERSION@$(ASTER_VERSION)@g' \
	     -e 's@PWD@$(PWD)@g' \
	     -e 's@CONFIG_FILE_LINE@$(CONFIG_FILE_LINE)@g' \
	   $< > $@
	@chmod 755 $@

%%.pyoutput: %%.py
	$(PYTHONEXECUTABLE) $< > $@ 2> $(patsubst %%.pyoutput,%%.pyerror,$@)


clean:
ifneq ($jobclean,)
	@if [ -f jobid ]; then \
	   rm -f $(HOME)/flasheur/*.?`cat jobid`; \
	fi
endif
	@rm -rf output.* error.* exit_code unittest $(TODELETE)

"""
open('Makefile.inc', 'w').write(content % (aster_root, aster_version, sys.executable))



