# -*- coding: utf-8 -*-

import os
from shutil import rmtree

from asrun.run    import AsRunFactory
from asrun.client import CLIENT, SERVER_CONF

run = AsRunFactory()

# local astkrc directory for test
rcdir = os.path.join(os.getcwd(), 'astkrc')

client = CLIENT(rcdir, run=run)

prefs = client.get_user_preferences()
print prefs
assert len(prefs) == 11     # number of fields in default prefs file
assert prefs.has_key('nom_domaine')

client.init_server_config() #force=True, refresh=True)

assert client.get_server_rcinfo() == '1.1'

servers = client.get_server_list()
assert len(servers) == 7
for serv in servers:
   cfg = client.get_server_config(serv)
   print serv, cfg

# fails outside EDF network
client.init_server_config(refresh=True)

client.save_server_config()

print 'EXIT_CODE=0'

