# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""
Helper to read/write resources files :
   - config files : etc/codeaster/{asrun,aster,agla,config_nodename}
   - user files   : ~/.astkrc/{config_serveurs,prefs}
"""
# should only use standard python modules

import os
import re
from ConfigParser import SafeConfigParser


def read_rcfile(ficrc, destdict, mcfact_key=None, mcsimp=None):
   """
   Read a ressource file and store variables into 'destdict'.
   """
   f = open(ficrc, 'r')
   dcur = destdict
   iocc = -1
   for line in f:
      if not re.search('^[ ]*#', line):
         try:
            key, value = decode_config_line(line)
            # mot-cle "facteur"
            if mcfact_key and key == mcfact_key:
               iocc += 1
               destdict[value] = { '__id__' : iocc }
               dcur = destdict[value]
               continue
            # mot-cle simp repetable ?
            if mcsimp and key in mcsimp and dcur.has_key(key):
               value = str(dcur[key])+' '+str(value)
            dcur[key] = value
         except:
            pass
   f.close()


def decode_config_line(line):
   """
   Read a line
   """
   mc, val = re.search('([-a-z_A-Z0-9]+) *: *(.*)', line.strip()).groups()
#   print line, ">>>", mc, val
   val = try_conversion(val)
   return mc, val


def time_to_seconds(val):
   """
   Convert 'hh:mm:ss' in seconds
   """
   mattps = re.search('([0-9]*):([0-9]*):([0-9]+)', val)
   if mattps is None:
      mattps = re.search('([0-9]*):([0-9]+)', val)
      if mattps is not None:
         mm, ss = [int(v) for v in mattps.groups()]
         val = mm*60 + ss
   else:
      hh, mm, ss = [int(v) for v in mattps.groups()]
      val = hh*3600 + mm*60 + ss
   return val


def try_conversion(value):
   """
   Try to convert numbers and boolean values from string
   """
   if type(value) in (str, unicode) and value == '_VIDE':
      value = ''
   try:
      if value.isdigit():
         value = int(value)
      else:
         value = float(value)
   except ValueError:
      if value in ('True', 'False'):
         value = eval(value)
   return value


def parse_config(filename, dict_default={}):
   """
   Return a dict of the content of 'filename'.
   """
   content = {}
   config = SafeConfigParser()
   try:
      config.readfp(open(filename))
   except:
      return content
   # add defaults
   for option, value in dict_default.items():
      config.set('DEFAULT', option, value)
   
   l_sect = config.sections()
   for title in l_sect:
      d = { }
      for opt in config.options(title):
         try:
            v = config.getint(title, opt)
         except ValueError:
            try:
               v = config.getfloat(title, opt)
            except ValueError:
               v = config.get(title, opt)
         d[opt] = v
      content[title] = d
   return content


