# -*- coding: utf-8 -*-

import os.path

from utils import default_install_value


# Code_Aster installation prefix
aster_root  = default_install_value("""value = '?ASTER_ROOT?'""", '/opt/aster')

# directory for configuration files (profile.sh, config)
# alternative to /etc/code_aster for non-root install
prefix = aster_root
if aster_root == '/usr':
   prefix = '/'
confdir = os.path.join(prefix, 'etc', 'codeaster')

# directory containing data files
datadir = os.path.join(aster_root, 'share', 'codeaster', 'asrun', 'data')

# directory for internationalization
localedir = os.path.join(aster_root, 'share', 'locale')

