#ifndef TE_LIB
#define TE_LIB

#include <mISDNlib.h>
#include <isdn_net.h>
#include <l3dss1.h>
#include <net_l3.h>

#include <pthread.h>


//#include "ies.h"

#define MAX_BCHANS 30


#ifndef ASTERISK_STABLE
//#define pthread_create ast_pthread_create
#endif



typedef struct bcte_s bchannel_te_t;
typedef struct te_stack_s stack_te_t;
typedef struct te_manager_s manager_te_t ;



#if USE_ZT_EC
//#include "sec.h"
//#include "sec-2.h"
//#include "mec.h"
#include "mec2.h"
//#include "mec3.h"


struct echo_can_s {
  int echostate;
  int echotimer;
  int echolastupdate;
  echo_can_state_t  *ec;
}; 
#endif



/** For initialization usage **/
typedef int ie_nothing_t ;
/** end of init usage **/


enum bc_te_state_e {
  STATE_NOTHING=0,
  STATE_NULL,
  STATE_CALL_INIT,
  STATE_CONNECTED,
  STATE_HOLD_ACKNOWLEDGE
};


enum tone_e {
  TONE_NONE=0,
  TONE_DIAL,
  TONE_ALERTING,
  TONE_BUSY,
  TONE_FILE
};

enum misdn_err_e {
  ENOCHAN=1
};



enum mISDN_NUMBER_PLAN {
  NUMPLAN_INTERNATIONAL=0x1,
  NUMPLAN_NATIONAL=0x2,
  NUMPLAN_SUBSCRIBER=0x4,
  NUMPLAN_UNKNOWN=0x0
}; 


struct bcte_s {
  /** init stuff **/
  int b_stid;
  //int b_addr;
  int layer_id;
  
  /** var stuff**/
  int l3_id;
  int pid;
  int ces;
  
  int channel;
  int in_use;
  int addr;

  unsigned char * bframe;
  int bframe_len;
  
  sem_t astsem;
  sem_t misdnsem;
  ibuffer_t *astbuf;
  ibuffer_t *misdnbuf;
  
  //dtmf digit
  int dtmf;
  
  //wether we should detect dtmf or not
  int nodtmf;

  enum mISDN_NUMBER_PLAN numplan;
  
  /*** CRYPTING STUFF ***/
  
  int crypt;
  int curprx;
  int curptx; 
  char crypt_key[255];
  
  int crypt_state;
    
  /*char ast_dtmf_buf[255];
    char misdn_dtmf_buf[255]; */
  
  /*** CRYPTING STUFF END***/
  
  int active;
  int upset;

  enum tone_e tone;
  int tone_cnt;
  int tone_cnt2;
  
  enum bc_te_state_e state;

  int holded;
  int holded_l3id;
  
  int pres;
  
  int digital;
  int capability;
  int law;
  
  unsigned char display[84];
  unsigned char msn[32];
  unsigned char oad[32];
  unsigned char dad[32];
  unsigned char keypad[32];
  
  unsigned char info_dad[64];
  unsigned char infos_pending[64];
  unsigned char info_keypad[32];
  unsigned char clisub[24];
  unsigned char cldsub[24];
  unsigned char fac[132];
  unsigned char uu[256];
  
  int cause;
  
  //bchannel_te_t hold_bc;
  
  /** list stuf **/
#if USE_ZT_EC
  struct echo_can_s ec;
#endif
  int ec_enable;
  int ec_tics;
  int orig;

  int volume;
  
  bchannel_te_t *next;
  stack_te_t *stack;
};



struct te_stack_s {
  /** is first element because &nst equals &mISDNlist **/
  net_stack_t nst;
  manager_t mgr;
  
  int d_stid;
  
  int b_num;
  
  int b_stids[MAX_BCHANS + 1];
  
  int ptp;
  int lower_id;
  int upper_id;
  
  int l2link;
  
  time_t l2establish;
  
  int l1link;
  int midev;
  
  enum mode_e {NT_MODE, TE_MODE} mode;
  int pri;
  

  int procids[0x100+1];

  msg_queue_t downqueue;
  int busy;
  
  int port;
  bchannel_te_t bc_te[MAX_BCHANS + 1];
  
  bchannel_te_t* bc_list; 
  
  int channels[MAX_BCHANS + 1];

  
  
  int te_choose_channel;
  

  bchannel_te_t *holding; //Queue which holds holded channels :)
  
  stack_te_t *next;
  manager_te_t *mgr_te;
}; 


enum te_event_response_e {
  RESPONSE_IGNORE_SETUP_WITHOUT_CLOSE,
  RESPONSE_IGNORE_SETUP,
  RESPONSE_ERR,
  RESPONSE_OK
};



enum te_event_e {
  EVENT_NOTHING,
  EVENT_BCHAN_DATA,
  EVENT_CLEANUP,
  EVENT_PROCEEDING,
  EVENT_PROGRESS,
  EVENT_SETUP,
  EVENT_ALERTING,
  EVENT_CONNECT,
  EVENT_SETUP_ACKNOWLEDGE,
  EVENT_CONNECT_ACKNOWLEDGE ,
  EVENT_USER_INFORMATION,
  EVENT_SUSPEND_REJECT,
  EVENT_RESUME_REJECT,
  EVENT_HOLD,
  EVENT_SUSPEND,
  EVENT_RESUME,
  EVENT_HOLD_ACKNOWLEDGE,
  EVENT_SUSPEND_ACKNOWLEDGE,
  EVENT_RESUME_ACKNOWLEDGE,
  EVENT_HOLD_REJECT,
  EVENT_RETRIEVE,
  EVENT_RETRIEVE_ACKNOWLEDGE,
  EVENT_RETRIEVE_REJECT,
  EVENT_DISCONNECT,
  EVENT_RESTART,
  EVENT_RELEASE,
  EVENT_RELEASE_COMPLETE,
  EVENT_FACILITY,
  EVENT_NOTIFY,
  EVENT_STATUS_ENQUIRY,
  EVENT_INFORMATION,
  EVENT_STATUS,
  EVENT_TIMEOUT,
  EVENT_DTMF_TONE,
  EVENT_NEW_L3ID,
  EVENT_UNKNOWN
}; 


enum ie_name_e {
  IE_DUMMY,
  IE_LAST
};

enum { /* bearer capability */
  INFO_CAPABILITY_SPEECH=0,
  INFO_CAPABILITY_AUDIO,
  INFO_CAPABILITY_VIDEO,
  INFO_CAPABILITY_DIGITAL_UNRESTRICTED,
  INFO_CAPABILITY_DIGITAL_RESTRICTED,
  INFO_CAPABILITY_DIGITAL_UNRESTRICTED_TONES,
};

enum { /*CODECS*/
  INFO_CODEC_ALAW=0,
  INFO_CODEC_ULAW
}; 


enum layer_e {
  L3,
  L2,
  L1,
  UNKNOWN
}; 




struct te_manager_s {
  int midev;
  int midev_nt;
  
  enum te_event_response_e
  (*cbEvent)(manager_te_t *mgr, enum te_event_e event, bchannel_te_t *bc, void *user_data);
  
  pthread_t event_thread;
  pthread_t event_handler_thread;
  
  void *user_data;

  msg_queue_t upqueue;
  msg_queue_t activatequeue; 
  
  sem_t new_msg;
  
  manager_te_t *next;
  stack_te_t *stack_list;
  
} ;

int init_bc_te(stack_te_t * stack,  bchannel_te_t *bc_te, int midev, int port, int bidx, char *msn, int firsttime);

stack_te_t* stack_te_init(int midev,  int port, int ptp);
void stack_te_destroy(stack_te_t* stack);




/***** USER IFACE **********/

int te_lib_init() ; //returns midev
void te_lib_destroy(int midev) ;


manager_te_t*
manager_te_init(char *portlist, void *cbEvent, void *user_data);
int manager_te_send_event(manager_te_t *mgr, bchannel_te_t *bc, enum te_event_e event );
void manager_te_destroy(manager_te_t * mgr_te);

char *manager_isdn_get_info(enum te_event_e event);

void manager_te_transfer(manager_te_t *mgr ,bchannel_te_t* holded_bc);

bchannel_te_t *manager_find_bc_by_pid(manager_te_t *mgr, int pid);
bchannel_te_t* manager_te_get_free_bc(manager_te_t *mgr, int port);
bchannel_te_t *manager_find_bc_holded(manager_te_t *mgr, bchannel_te_t* bc);


void manager_bchannel_activate(bchannel_te_t *bc);
void manager_bchannel_deactivate(bchannel_te_t * bc);
int manager_send_frame(bchannel_te_t *bc, void *data, int len);
void manager_send_tone ( manager_te_t *mgr, bchannel_te_t *bc, enum tone_e tone);
unsigned char * manager_flip_buf_bits ( unsigned char * buf , int len);

void manager_ph_control(bchannel_te_t *bc, int c1, int c2);
void manager_ph_control_block(bchannel_te_t *bc, int c1, void *c2, int c2_len);
void manager_clean_bc(manager_te_t *mgr, bchannel_te_t *bc );

void manager_bchannel_setup (bchannel_te_t *bc);
void manager_bchannel_cleanup (bchannel_te_t *bc);

int manager_te_port_restart(manager_te_t *mgr_te,int port);
int manager_te_get_port_info(manager_te_t* mgr,  int port);

int manager_te_free_bc_avail(manager_te_t *mgr_te, int port );
     
bchannel_te_t * find_new_bc_in_stack(manager_te_t * mgr, int port);
void free_bc ( manager_te_t *mgr, bchannel_te_t *bc);

/** internal stuff **/

typedef struct isdn_ies_s isdn_ies_t ;

struct isdn_ies_s {
  enum ie_name_e ie_name;
  char iedescr; // wether 'd' - digit or 's' for string
  
  // Value
  int ied;
  char iestr[256];
  
  isdn_ies_t *ies;
}; 

typedef struct isdn_msg_s isdn_msg_t;

struct isdn_msg_s {
  unsigned long misdn_msg;
  
  enum layer_e layer;
  enum te_event_e event;
  
  void (*msg_parser)(isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt);
  msg_t *(*msg_builder)(isdn_msg_t msgs[], bchannel_te_t *bc, int nt);
  void (*msg_printer)(isdn_msg_t msgs[]);
  
  char *info;
  
} ; 



int isdn_msg_get_index(isdn_msg_t msgs[], msg_t *frm, int nt);
enum te_event_e isdn_msg_get_event(isdn_msg_t msgs[], msg_t *frm, int nt);
int isdn_msg_parse_event(isdn_msg_t msgs[], msg_t *frm, bchannel_te_t *bc, int nt);


void ec_chunk( bchannel_te_t *bc, unsigned char *rxchunk, unsigned char *txchunk, int chunk_size);

void ec_init(void); 

#endif
