/*
 * Chan_Misdn -- Channel Driver for Asterisk
 *
 * Interface to mISDN
 *
 * Copyright (C) 2004, Christian Richter
 *
 * Christian Richter <crich@beronet.com>
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */


void parse_proceeding (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  CALL_PROCEEDING_t *proceeding=(CALL_PROCEEDING_t*)((unsigned long)msg->data+ HEADER_LEN);
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

  {
    int  exclusive, channel;
    dec_ie_channel_id(proceeding->CHANNEL_ID, (Q931_info_t *)proceeding, &exclusive, &channel, nt,bc);

    if (channel==0xff) //any channel
      channel=-1;
    
    // ALERT: is that everytime true ? 
    if (channel > 0 && bc->stack->mode == NT_MODE) 
      bc->channel = channel;
  }
#if DEBUG 
  printf("Parsing PROCEEDING Msg\n"); 
#endif

 
}
msg_t *build_proceeding (isdn_msg_t msgs[], bchannel_te_t *bc, int nt)
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  CALL_PROCEEDING_t *proceeding;
  msg_t *msg =(msg_t*)create_l3msg(CC_PROCEEDING | REQUEST, MT_CALL_PROCEEDING,  bc?bc->l3_id:-1, sizeof(CALL_PROCEEDING_t) ,nt); 
  
  proceeding=(CALL_PROCEEDING_t*)((msg->data+HEADER_LEN));

  enc_ie_channel_id(&proceeding->CHANNEL_ID, msg, 1,bc->channel, nt,bc);
  
  if (nt) 
    enc_ie_progress(&proceeding->PROGRESS, msg, 0, nt?1:5, 8, nt,bc);
  

#if DEBUG 
 printf("Building PROCEEDING Msg\n"); 
#endif
 return msg; 
}
void print_proceeding (isdn_msg_t msgs[]) 
{
}

void parse_alerting (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //ALERTING_t *alerting=(ALERTING_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing ALERTING Msg\n"); 
#endif

 
}
msg_t *build_alerting (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  ALERTING_t *alerting;
  msg_t *msg =(msg_t*)create_l3msg(CC_ALERTING | REQUEST, MT_ALERTING,  bc?bc->l3_id:-1, sizeof(ALERTING_t) ,nt); 
  
  alerting=(ALERTING_t*)((msg->data+HEADER_LEN)); 
  
  enc_ie_channel_id(&alerting->CHANNEL_ID, msg, 1,bc->channel, nt,bc);
  
  if (nt) 
    enc_ie_progress(&alerting->PROGRESS, msg, 0, nt?1:5, 8, nt,bc);
#if DEBUG 
  printf("Building ALERTING Msg\n"); 
#endif
 return msg; 
}
void print_alerting (isdn_msg_t msgs[]) 
{
}


void parse_progress (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //PROGRESS_t *progress=(PROGRESS_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing PROGRESS Msg\n"); 
#endif
}

msg_t *build_progress (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  PROGRESS_t *progress;
  msg_t *msg =(msg_t*)create_l3msg(CC_PROGRESS | REQUEST, MT_PROGRESS,  bc?bc->l3_id:-1, sizeof(PROGRESS_t) ,nt); 
 
  progress=(PROGRESS_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building PROGRESS Msg\n"); 
#endif
 return msg; 
}
void print_progress (isdn_msg_t msgs[]) 
{
}


void parse_setup (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{ 
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SETUP_t *setup= (SETUP_t*)((unsigned long)msg->data+HEADER_LEN);
  Q931_info_t *qi=(Q931_info_t*)((unsigned long)msg->data+HEADER_LEN);

#if DEBUG 
  printf("Parsing SETUP Msg\n"); 
#endif
  {
    int type,plan,present, screen;
    char id[32];
    dec_ie_calling_pn(setup->CALLING_PN, qi, &type, &plan, &present, &screen, (unsigned char *)id, sizeof(id), nt,bc);
    strcpy(bc->oad, id);
    switch (present) {
    case 0:
      if (misdn_debug>2) chan_misdn_log(" --> Pres:0\n");
      bc->pres=0; //screened
      break;
    case 1:
      if (misdn_debug>2) chan_misdn_log(" --> Pres:1\n");
      bc->pres=1; //not screened
      break;
    default:
      if (misdn_debug>2) chan_misdn_log(" --> Pres:%d\n",present);
      bc->pres=0;
    }
    switch (screen) {
    case 0:
      if (misdn_debug>3) chan_misdn_log(" --> Screen:0\n");
      break;
    default:
      if (misdn_debug>3) chan_misdn_log(" --> Screen:%d\n",screen);
    } 
  }
  {
    int  type, plan;
    char number[32]; 
    dec_ie_called_pn(setup->CALLED_PN, (Q931_info_t *)setup, &type, &plan, (unsigned char *)number, sizeof(number), nt,bc);
    strcpy(bc->dad, number);
    bc->numplan=type; 
  }
  {
    char keypad[32];
    dec_ie_keypad(setup->KEYPAD, (Q931_info_t *)setup, (unsigned char *)keypad, sizeof(keypad), nt,bc);
    strcpy(bc->keypad, keypad);
  }

  /*{
    int  useruser_protocol, useruser_len;
    char  useruser[128];
    dec_ie_useruser(setup->USER_USER, (Q931_info_t *)setup, &useruser_protocol, useruser, &useruser_len, nt,bc);
    }*/
  {
    int  sending_complete;
    dec_ie_complete(setup->COMPLETE, (Q931_info_t *)setup, &sending_complete, nt,bc);
  }
  
  {
    int  type, plan, present, screen, reason;
    char id[32]; 
    dec_ie_redir_nr(setup->REDIR_NR, (Q931_info_t *)setup, &type, &plan, &present, &screen, &reason, (unsigned char *)id, sizeof(id), nt,bc);
    
  }
  {
    int  coding, capability, mode, rate, multi, user;
    dec_ie_bearer(setup->BEARER, (Q931_info_t *)setup, &coding, &capability, &mode, &rate, &multi, &user, nt,bc);
    switch (capability) {
    case -1: bc->capability=INFO_CAPABILITY_DIGITAL_UNRESTRICTED; 
      bc->digital=1;
      if (misdn_debug>1) chan_misdn_log(" --> cap -1 -> digital\n");
      break;
    case 0: bc->capability=INFO_CAPABILITY_AUDIO;
      if (misdn_debug>1) chan_misdn_log(" --> cap Audio\n");
      break;
    case 8: bc->capability=INFO_CAPABILITY_DIGITAL_UNRESTRICTED; bc->digital=1;
      if (misdn_debug>1) chan_misdn_log(" --> cap unres Digital\n");
      break;
    case 9: bc->capability=INFO_CAPABILITY_DIGITAL_RESTRICTED;
      if (misdn_debug>1) chan_misdn_log(" --> cap res Digital\n");
      break;
    default:
      if (misdn_debug>1) chan_misdn_log(" --> cap Else\n");
      break;
    }
  }
  {
    int  exclusive, channel;
    dec_ie_channel_id(setup->CHANNEL_ID, (Q931_info_t *)setup, &exclusive, &channel, nt,bc);
    if (channel==0xff) //any channel
      channel=-1;
    
    bc->channel = channel;
  }
}

#define ANY_CHANNEL 0xff /* IE attribut for 'any channel' */
msg_t *build_setup (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SETUP_t *setup;
  msg_t *msg =(msg_t*)create_l3msg(CC_SETUP | REQUEST, MT_SETUP,  bc?bc->l3_id:-1, sizeof(SETUP_t) ,nt); 
  
  setup=(SETUP_t*)((msg->data+HEADER_LEN)); 
  
  if (misdn_debug > 1) chan_misdn_log(" --> oad %s dad %s channel %d\n",bc->oad, bc->dad,bc->channel);
  if (bc->channel == 0 || bc->channel == ANY_CHANNEL || bc->channel==-1)
    enc_ie_channel_id(&setup->CHANNEL_ID, msg, 0, bc->channel, nt,bc);
  else
    enc_ie_channel_id(&setup->CHANNEL_ID, msg, 1, bc->channel, nt,bc);
  
  {
    int type=bc->numplan,plan=1,present=bc->pres,screen=0;
    enc_ie_calling_pn(&setup->CALLING_PN, msg, type, plan, present,
		      screen, bc->oad, nt, bc);
  }
  
  {
    if (bc->dad[0])
      enc_ie_called_pn(&setup->CALLED_PN, msg, 0, 1, bc->dad, nt,bc);
  }
  
  {
    //enc_ie_complete(&setup->COMPLETE, msg, 1, nt,bc);
  }

  //strcpy(bc->display,"Hallo");
  if (strlen(bc->display)) {
    //printf("Sending %s as Display\n");
    enc_ie_display(&setup->DISPLAY, msg, bc->display, nt,bc);
  }
  
  {
    int coding=0, capability, mode=0 // 2 for packet !
      ,user, rate=0x10;
    switch (bc->capability) {
    case INFO_CAPABILITY_SPEECH: capability = 0;
      if (misdn_debug >1)chan_misdn_log("--> Speech\n");
      break;
    case INFO_CAPABILITY_DIGITAL_UNRESTRICTED: capability = 8;
      if (misdn_debug >1)chan_misdn_log("--> cap unres Digital\n");
      break;
    case INFO_CAPABILITY_DIGITAL_RESTRICTED: capability = 9;
      if (misdn_debug >1)chan_misdn_log("--> cap res Digital\n");
      break;
    default:
      if (bc->digital) {
	if (misdn_debug >1)chan_misdn_log("--> cap unres Digital\n");
	capability=8;
      } else {
	if (misdn_debug >1)chan_misdn_log("--> cap Speech\n");
	capability=0;
      }
    }

    switch (bc->law) {
    case INFO_CODEC_ULAW: user=2; break;
    case INFO_CODEC_ALAW: user=3; break;
    default:
      user=2;
    }
    
    enc_ie_bearer(&setup->BEARER, msg, coding, capability, mode, rate, -1, user, nt,bc);
  }
  
#if DEBUG 
  printf("Building SETUP Msg\n"); 
#endif
  return msg; 
}
void print_setup (isdn_msg_t msgs[]) 
{
}


void parse_connect (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  CONNECT_t *connect=(CONNECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  
  //printf("CONNECT CES: %x\n",connect->ces);
  bc->ces = connect->ces;
  bc->ces = connect->ces;
#if DEBUG 
  printf("Parsing CONNECT Msg\n"); 
#endif
}
msg_t *build_connect (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  CONNECT_t *connect;
  msg_t *msg =(msg_t*)create_l3msg(CC_CONNECT | REQUEST, MT_CONNECT,  bc?bc->l3_id:-1, sizeof(CONNECT_t) ,nt); 
  
  connect=(CONNECT_t*)((msg->data+HEADER_LEN)); 

  if (nt) {
    time_t now;
    time(&now);
    enc_ie_date(&connect->DATE, msg, now, nt,bc);
  }
  
  {
    int type=0, plan=1, present=2, screen=0;
    enc_ie_connected_pn(&connect->CONNECT_PN, msg, type,plan, present, screen, (unsigned char*) bc->oad , nt , bc);
  }

  //enc_ie_channel_id(&connect->CHANNEL_ID, msg, 1,bc->channel, nt,bc);
  
#if DEBUG 
 printf("Building CONNECT Msg\n"); 
#endif
 return msg; 
}
void print_connect (isdn_msg_t msgs[]) 
{
}


void parse_setup_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SETUP_ACKNOWLEDGE_t *setup_acknowledge=(SETUP_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

  {
    int  exclusive, channel;
    dec_ie_channel_id(setup_acknowledge->CHANNEL_ID, (Q931_info_t *)setup_acknowledge, &exclusive, &channel, nt,bc);

    if (channel==0xff) //any channel
      channel=-1;
    
    bc->channel = channel;
  }
  
#if DEBUG 
 printf("Parsing SETUP_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_setup_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SETUP_ACKNOWLEDGE_t *setup_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_SETUP_ACKNOWLEDGE | REQUEST, MT_SETUP_ACKNOWLEDGE,  bc?bc->l3_id:-1, sizeof(SETUP_ACKNOWLEDGE_t) ,nt); 
 
  setup_acknowledge=(SETUP_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 
  
  enc_ie_channel_id(&setup_acknowledge->CHANNEL_ID, msg, 1,bc->channel, nt,bc);
  
  if (nt) 
    enc_ie_progress(&setup_acknowledge->PROGRESS, msg, 0, nt?1:5, 8, nt,bc);
  
#if DEBUG 
 printf("Building SETUP_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_setup_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_connect_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //CONNECT_ACKNOWLEDGE_t *connect_acknowledge=(CONNECT_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  
#if DEBUG 
 printf("Parsing CONNECT_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_connect_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  CONNECT_ACKNOWLEDGE_t *connect_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_CONNECT | RESPONSE, MT_CONNECT,  bc?bc->l3_id:-1, sizeof(CONNECT_ACKNOWLEDGE_t) ,nt); 
 
  connect_acknowledge=(CONNECT_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 
  
  enc_ie_channel_id(&connect_acknowledge->CHANNEL_ID, msg, 1, bc->channel, nt,bc);
  
#if DEBUG 
 printf("Building CONNECT_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_connect_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_user_information (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //USER_INFORMATION_t *user_information=(USER_INFORMATION_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing USER_INFORMATION Msg\n"); 
#endif

 
}
msg_t *build_user_information (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  USER_INFORMATION_t *user_information;
  msg_t *msg =(msg_t*)create_l3msg(CC_USER_INFORMATION | REQUEST, MT_USER_INFORMATION,  bc?bc->l3_id:-1, sizeof(USER_INFORMATION_t) ,nt); 
 
  user_information=(USER_INFORMATION_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building USER_INFORMATION Msg\n"); 
#endif
 return msg; 
}
void print_user_information (isdn_msg_t msgs[]) 
{
}


void parse_suspend_reject (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //SUSPEND_REJECT_t *suspend_reject=(SUSPEND_REJECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing SUSPEND_REJECT Msg\n"); 
#endif

 
}
msg_t *build_suspend_reject (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SUSPEND_REJECT_t *suspend_reject;
  msg_t *msg =(msg_t*)create_l3msg(CC_SUSPEND_REJECT | REQUEST, MT_SUSPEND_REJECT,  bc?bc->l3_id:-1, sizeof(SUSPEND_REJECT_t) ,nt); 
 
  suspend_reject=(SUSPEND_REJECT_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building SUSPEND_REJECT Msg\n"); 
#endif
 return msg; 
}
void print_suspend_reject (isdn_msg_t msgs[]) 
{
}


void parse_resume_reject (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RESUME_REJECT_t *resume_reject=(RESUME_REJECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RESUME_REJECT Msg\n"); 
#endif

 
}
msg_t *build_resume_reject (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RESUME_REJECT_t *resume_reject;
  msg_t *msg =(msg_t*)create_l3msg(CC_RESUME_REJECT | REQUEST, MT_RESUME_REJECT,  bc?bc->l3_id:-1, sizeof(RESUME_REJECT_t) ,nt); 
 
  resume_reject=(RESUME_REJECT_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RESUME_REJECT Msg\n"); 
#endif
 return msg; 
}
void print_resume_reject (isdn_msg_t msgs[]) 
{
}


void parse_hold (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //HOLD_t *hold=(HOLD_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing HOLD Msg\n"); 
#endif

 
}
msg_t *build_hold (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  HOLD_t *hold;
  msg_t *msg =(msg_t*)create_l3msg(CC_HOLD | REQUEST, MT_HOLD,  bc?bc->l3_id:-1, sizeof(HOLD_t) ,nt); 
 
  hold=(HOLD_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building HOLD Msg\n"); 
#endif
 return msg; 
}
void print_hold (isdn_msg_t msgs[]) 
{
}


void parse_suspend (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //SUSPEND_t *suspend=(SUSPEND_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing SUSPEND Msg\n"); 
#endif

 
}
msg_t *build_suspend (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SUSPEND_t *suspend;
  msg_t *msg =(msg_t*)create_l3msg(CC_SUSPEND | REQUEST, MT_SUSPEND,  bc?bc->l3_id:-1, sizeof(SUSPEND_t) ,nt); 
 
  suspend=(SUSPEND_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building SUSPEND Msg\n"); 
#endif
 return msg; 
}
void print_suspend (isdn_msg_t msgs[]) 
{
}


void parse_resume (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RESUME_t *resume=(RESUME_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RESUME Msg\n"); 
#endif

 
}
msg_t *build_resume (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RESUME_t *resume;
  msg_t *msg =(msg_t*)create_l3msg(CC_RESUME | REQUEST, MT_RESUME,  bc?bc->l3_id:-1, sizeof(RESUME_t) ,nt); 
 
  resume=(RESUME_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RESUME Msg\n"); 
#endif
 return msg; 
}
void print_resume (isdn_msg_t msgs[]) 
{
}


void parse_hold_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //HOLD_ACKNOWLEDGE_t *hold_acknowledge=(HOLD_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing HOLD_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_hold_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  HOLD_ACKNOWLEDGE_t *hold_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_HOLD_ACKNOWLEDGE | REQUEST, MT_HOLD_ACKNOWLEDGE,  bc?bc->l3_id:-1, sizeof(HOLD_ACKNOWLEDGE_t) ,nt); 
 
  hold_acknowledge=(HOLD_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building HOLD_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_hold_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_suspend_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //SUSPEND_ACKNOWLEDGE_t *suspend_acknowledge=(SUSPEND_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing SUSPEND_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_suspend_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  SUSPEND_ACKNOWLEDGE_t *suspend_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_SUSPEND_ACKNOWLEDGE | REQUEST, MT_SUSPEND_ACKNOWLEDGE,  bc?bc->l3_id:-1, sizeof(SUSPEND_ACKNOWLEDGE_t) ,nt); 
 
  suspend_acknowledge=(SUSPEND_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building SUSPEND_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_suspend_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_resume_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RESUME_ACKNOWLEDGE_t *resume_acknowledge=(RESUME_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RESUME_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_resume_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RESUME_ACKNOWLEDGE_t *resume_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_RESUME_ACKNOWLEDGE | REQUEST, MT_RESUME_ACKNOWLEDGE,  bc?bc->l3_id:-1, sizeof(RESUME_ACKNOWLEDGE_t) ,nt); 
 
  resume_acknowledge=(RESUME_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RESUME_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_resume_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_hold_reject (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //HOLD_REJECT_t *hold_reject=(HOLD_REJECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing HOLD_REJECT Msg\n"); 
#endif

 
}
msg_t *build_hold_reject (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  HOLD_REJECT_t *hold_reject;
  msg_t *msg =(msg_t*)create_l3msg(CC_HOLD_REJECT | REQUEST, MT_HOLD_REJECT,  bc?bc->l3_id:-1, sizeof(HOLD_REJECT_t) ,nt); 
 
  hold_reject=(HOLD_REJECT_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building HOLD_REJECT Msg\n"); 
#endif
 return msg; 
}
void print_hold_reject (isdn_msg_t msgs[]) 
{
}


void parse_retrieve (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RETRIEVE_t *retrieve=(RETRIEVE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RETRIEVE Msg\n"); 
#endif

 
}
msg_t *build_retrieve (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RETRIEVE_t *retrieve;
  msg_t *msg =(msg_t*)create_l3msg(CC_RETRIEVE | REQUEST, MT_RETRIEVE,  bc?bc->l3_id:-1, sizeof(RETRIEVE_t) ,nt); 
 
  retrieve=(RETRIEVE_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RETRIEVE Msg\n"); 
#endif
 return msg; 
}
void print_retrieve (isdn_msg_t msgs[]) 
{
}


void parse_retrieve_acknowledge (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RETRIEVE_ACKNOWLEDGE_t *retrieve_acknowledge=(RETRIEVE_ACKNOWLEDGE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RETRIEVE_ACKNOWLEDGE Msg\n"); 
#endif

 
}
msg_t *build_retrieve_acknowledge (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RETRIEVE_ACKNOWLEDGE_t *retrieve_acknowledge;
  msg_t *msg =(msg_t*)create_l3msg(CC_RETRIEVE_ACKNOWLEDGE | REQUEST, MT_RETRIEVE_ACKNOWLEDGE,  bc?bc->l3_id:-1, sizeof(RETRIEVE_ACKNOWLEDGE_t) ,nt); 
 
  retrieve_acknowledge=(RETRIEVE_ACKNOWLEDGE_t*)((msg->data+HEADER_LEN)); 

  enc_ie_channel_id(&retrieve_acknowledge->CHANNEL_ID, msg, 1, bc->channel, nt,bc);
#if DEBUG 
 printf("Building RETRIEVE_ACKNOWLEDGE Msg\n"); 
#endif
 return msg; 
}
void print_retrieve_acknowledge (isdn_msg_t msgs[]) 
{
}


void parse_retrieve_reject (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //RETRIEVE_REJECT_t *retrieve_reject=(RETRIEVE_REJECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing RETRIEVE_REJECT Msg\n"); 
#endif

 
}
msg_t *build_retrieve_reject (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RETRIEVE_REJECT_t *retrieve_reject;
  msg_t *msg =(msg_t*)create_l3msg(CC_RETRIEVE_REJECT | REQUEST, MT_RETRIEVE_REJECT,  bc?bc->l3_id:-1, sizeof(RETRIEVE_REJECT_t) ,nt); 
 
  retrieve_reject=(RETRIEVE_REJECT_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RETRIEVE_REJECT Msg\n"); 
#endif
 return msg; 
}
void print_retrieve_reject (isdn_msg_t msgs[]) 
{
}


void parse_disconnect (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  DISCONNECT_t *disconnect=(DISCONNECT_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  int location;
  
  dec_ie_cause(disconnect->CAUSE, (Q931_info_t *)(disconnect), &location, &bc->cause, nt,bc);
#if DEBUG 
 printf("Parsing DISCONNECT Msg\n"); 
#endif

 
}
msg_t *build_disconnect (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  DISCONNECT_t *disconnect;
  msg_t *msg =(msg_t*)create_l3msg(CC_DISCONNECT | REQUEST, MT_DISCONNECT,  bc?bc->l3_id:-1, sizeof(DISCONNECT_t) ,nt); 
  
  disconnect=(DISCONNECT_t*)((msg->data+HEADER_LEN)); 
  
  enc_ie_cause(&disconnect->CAUSE, msg, (nt)?1:0, bc->cause,nt,bc);
  if (nt) enc_ie_progress(&disconnect->PROGRESS, msg, 0, nt?1:5, 8 ,nt,bc);
  
#if DEBUG 
 printf("Building DISCONNECT Msg\n"); 
#endif
 return msg; 
}
void print_disconnect (isdn_msg_t msgs[]) 
{
}


void parse_restart (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RESTART_t *restart=(RESTART_t*)((unsigned long)(msg->data+HEADER_LEN));
  
#if DEBUG 
  printf("Parsing RESTART Msg\n");
#endif
  
  {
    int  exclusive, channel;
    dec_ie_channel_id(restart->CHANNEL_ID, (Q931_info_t *)restart, &exclusive, &channel, nt,bc);
    if (channel==0xff) //any channel
      channel=-1;
    chan_misdn_log("CC_RESTART Request on channel:%d on port:%d\n",bc->stack->port);
    //bc->channel = channel;
  }
  
 
}
msg_t *build_restart (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RESTART_t *restart;
  msg_t *msg =(msg_t*)create_l3msg(CC_RESTART | REQUEST, MT_RESTART,  bc?bc->l3_id:-1, sizeof(RESTART_t) ,nt); 
 
  restart=(RESTART_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building RESTART Msg\n"); 
#endif
 return msg; 
}
void print_restart (isdn_msg_t msgs[]) 
{
}


void parse_release (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RELEASE_t *release=(RELEASE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  int location;
  
  dec_ie_cause(release->CAUSE, (Q931_info_t *)(release), &location, &bc->cause, nt,bc);
#if DEBUG 
 printf("Parsing RELEASE Msg\n"); 
#endif

 
}
msg_t *build_release (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RELEASE_t *release;
  msg_t *msg =(msg_t*)create_l3msg(CC_RELEASE | REQUEST, MT_RELEASE,  bc?bc->l3_id:-1, sizeof(RELEASE_t) ,nt); 
 
  release=(RELEASE_t*)((msg->data+HEADER_LEN)); 
  
  
  enc_ie_cause(&release->CAUSE, msg, nt?1:0, bc->cause, nt,bc);
  
#if DEBUG 
 printf("Building RELEASE Msg\n"); 
#endif
 return msg; 
}
void print_release (isdn_msg_t msgs[]) 
{
}


void parse_release_complete (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RELEASE_COMPLETE_t *release_complete=(RELEASE_COMPLETE_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  int location;
  iframe_t *frm = (iframe_t*) msg->data;
#ifdef MISDNUSER_JOLLY
  mISDNuser_head_t *hh;
  hh=(mISDNuser_head_t*)msg->data;
#else
  mISDN_head_t *hh;
  hh=(mISDN_head_t*)msg->data;
#endif
  
  if (nt) {
    if (hh->prim == (CC_RELEASE_COMPLETE|CONFIRM)) {
      chan_misdn_log("CC_RELEASE_COMPLETE|CONFIRM [NT] port:%d\n",bc->stack->port);
      return;
    }
  } else {
    if (frm->prim == (CC_RELEASE_COMPLETE|CONFIRM)) {
      chan_misdn_log("CC_RELEASE_COMPLETE|CONFIRM [TE] port:%d\n",bc->stack->port);
      return;
    }
  }
  dec_ie_cause(release_complete->CAUSE, (Q931_info_t *)(release_complete), &location, &bc->cause, nt,bc);

  
#if DEBUG 
 printf("Parsing RELEASE_COMPLETE Msg\n"); 
#endif

 
}
msg_t *build_release_complete (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  RELEASE_COMPLETE_t *release_complete;
  msg_t *msg =(msg_t*)create_l3msg(CC_RELEASE_COMPLETE | REQUEST, MT_RELEASE_COMPLETE,  bc?bc->l3_id:-1, sizeof(RELEASE_COMPLETE_t) ,nt); 
 
  release_complete=(RELEASE_COMPLETE_t*)((msg->data+HEADER_LEN)); 

  enc_ie_cause(&release_complete->CAUSE, msg, nt?1:0, bc->cause, nt,bc);
  
#if DEBUG 
 printf("Building RELEASE_COMPLETE Msg\n"); 
#endif
 return msg; 
}
void print_release_complete (isdn_msg_t msgs[]) 
{
}


void parse_facility (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //FACILITY_t *facility=(FACILITY_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing FACILITY Msg\n"); 
#endif

 
}
msg_t *build_facility (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  FACILITY_t *facility;
  msg_t *msg =(msg_t*)create_l3msg(CC_FACILITY | REQUEST, MT_FACILITY,  bc?bc->l3_id:-1, sizeof(FACILITY_t) ,nt); 
 
  facility=(FACILITY_t*)((msg->data+HEADER_LEN)); 

  {
    if (strlen(bc->display)) {
      printf("Sending %s as Display\n", bc->display);
      enc_ie_display(&facility->DISPLAY, msg, bc->display, nt,bc);
    }
  }
  
#if DEBUG 
 printf("Building FACILITY Msg\n"); 
#endif
 return msg; 
}
void print_facility (isdn_msg_t msgs[]) 
{
}


void parse_notify (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //NOTIFY_t *notify=(NOTIFY_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing NOTIFY Msg\n"); 
#endif

 
}
msg_t *build_notify (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  NOTIFY_t *notify;
  msg_t *msg =(msg_t*)create_l3msg(CC_NOTIFY | REQUEST, MT_NOTIFY,  bc?bc->l3_id:-1, sizeof(NOTIFY_t) ,nt); 
 
  notify=(NOTIFY_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building NOTIFY Msg\n"); 
#endif
 return msg; 
}
void print_notify (isdn_msg_t msgs[]) 
{
}


void parse_status_enquiry (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //STATUS_ENQUIRY_t *status_enquiry=(STATUS_ENQUIRY_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing STATUS_ENQUIRY Msg\n"); 
#endif

 
}
msg_t *build_status_enquiry (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  STATUS_ENQUIRY_t *status_enquiry;
  msg_t *msg =(msg_t*)create_l3msg(CC_STATUS_ENQUIRY | REQUEST, MT_STATUS_ENQUIRY,  bc?bc->l3_id:-1, sizeof(STATUS_ENQUIRY_t) ,nt); 
 
  status_enquiry=(STATUS_ENQUIRY_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building STATUS_ENQUIRY Msg\n"); 
#endif
 return msg; 
}
void print_status_enquiry (isdn_msg_t msgs[]) 
{
}


void parse_information (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  INFORMATION_t *information=(INFORMATION_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

  {
    int  type, plan;
    char number[32];
    char keypad[32];
    dec_ie_called_pn(information->CALLED_PN, (Q931_info_t *)information, &type, &plan, (unsigned char *)number, sizeof(number), nt,bc);
    dec_ie_keypad(information->KEYPAD, (Q931_info_t *)information, (unsigned char *)keypad, sizeof(keypad), nt,bc);
    strcpy(bc->info_dad, number);
    strcpy(bc->keypad,keypad);
    
  }
#if DEBUG 
 printf("Parsing INFORMATION Msg\n"); 
#endif

 
}
msg_t *build_information (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  INFORMATION_t *information;
  msg_t *msg =(msg_t*)create_l3msg(CC_INFORMATION | REQUEST, MT_INFORMATION,  bc?bc->l3_id:-1, sizeof(INFORMATION_t) ,nt); 
 
  information=(INFORMATION_t*)((msg->data+HEADER_LEN)); 
  
  {
    enc_ie_called_pn(&information->CALLED_PN, msg, 0, 1, bc->info_dad, nt,bc);
  }

  {
    if (strlen(bc->display)) {
      printf("Sending %s as Display\n", bc->display);
      enc_ie_display(&information->DISPLAY, msg, bc->display, nt,bc);
    }
  }
  
#if DEBUG 
 printf("Building INFORMATION Msg\n"); 
#endif
 return msg; 
}
void print_information (isdn_msg_t msgs[]) 
{
}


void parse_status (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  STATUS_t *status=(STATUS_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 
  int location;
  
  dec_ie_cause(status->CAUSE, (Q931_info_t *)(status), &location, &bc->cause, nt,bc);
  //dec_ie_display(status->DISPLAY, (Q931_info_t*)(status), bc->display, 84, nt,bc)
;

#if DEBUG 
 printf("Parsing STATUS Msg\n"); 
#endif

 
}
msg_t *build_status (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  STATUS_t *status;
  msg_t *msg =(msg_t*)create_l3msg(CC_STATUS | REQUEST, MT_STATUS,  bc?bc->l3_id:-1, sizeof(STATUS_t) ,nt); 
 
  status=(STATUS_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building STATUS Msg\n"); 
#endif
 return msg; 
}
void print_status (isdn_msg_t msgs[]) 
{
}


void parse_timeout (isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt) 
{
  //  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  //STATUS_t *status=(STATUS_t*)((unsigned long)(msg->data+HEADER_LEN));
  //Q931_info_t *qi=(Q931_info_t*)(msg->data+HEADER_LEN); 

#if DEBUG 
 printf("Parsing STATUS Msg\n"); 
#endif

 
}
msg_t *build_timeout (isdn_msg_t msgs[], bchannel_te_t *bc, int nt) 
{
  int HEADER_LEN = nt?mISDNUSER_HEAD_SIZE:mISDN_HEADER_LEN;
  STATUS_t *status;
  msg_t *msg =(msg_t*)create_l3msg(CC_STATUS | REQUEST, MT_STATUS,  bc?bc->l3_id:-1, sizeof(STATUS_t) ,nt); 
 
  status=(STATUS_t*)((msg->data+HEADER_LEN)); 

#if DEBUG 
 printf("Building STATUS Msg\n"); 
#endif
 return msg; 
}
void print_timeout (isdn_msg_t msgs[]) 
{
}


