// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __TrackerDog_h__
#define __TrackerDog_h__

#include "Puma/CVisitor.h"
#include "Puma/ACTree.h"
#include "Puma/CTranslationUnit.h"
#include "Puma/Stack.h"
using namespace Puma;

namespace Puma {
  class CAttributeInfo;
  class CFunctionInfo;
} // namespace Puma

class ModelBuilder;

class TrackerDog : public CVisitor {
  CTranslationUnit &_tunit;
  ModelBuilder &_jpm;
  CT_BinaryExpr *assignment;
  CT_InitDeclarator *last_init_declarator;
  Stack<CFunctionInfo*> func_stack;
  bool in_memb_init;
  int local_id;

  CSemDatabase &db () { return _tunit.db (); }

  virtual void pre_visit (CTree *node);
  virtual void post_visit (CTree *node);

  void pre_PointcutDecl (CT_PointcutDecl *node);
  void pre_AdviceDecl (CT_AdviceDecl *node);
  void pre_Call (CT_Call *node);
  void pre_FctDef (CT_FctDef *node);
  void post_FctDef (CT_FctDef *node);
  void pre_InitDeclarator (CT_InitDeclarator *node);
  void post_InitDeclarator (CT_InitDeclarator *node);
  void pre_MembPtrExpr (CT_MembPtrExpr *node);
  void pre_SimpleName (CT_SimpleName *node);
  void pre_NamespaceDef (CT_NamespaceDef *node);
  void pre_ClassDef (CT_ClassDef *node);
  void post_ClassDef (CT_ClassDef *node);
  bool register_access (CObjectInfo *obj, CTree *node);
  
public:
  
  TrackerDog (CTranslationUnit &tunit, ModelBuilder &jpm): 
    _tunit (tunit), _jpm (jpm), assignment (0), last_init_declarator (0),
    in_memb_init (false) {
    func_stack.push ((CFunctionInfo*)0);
  }
  virtual ~TrackerDog() {}

  // search all code join points
  void run () { visit (_tunit.tree ()); }
  void run (CTree *tree) { visit (tree); }
    
  // check if a function should be considered by ac++
  static CFunctionInfo *filter_func (CFunctionInfo* fi);
  static CObjectInfo *unique_object (CObjectInfo *obj);
};

#endif // __TrackerDog_h__
