// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ModelBuilder_h__
#define __ModelBuilder_h__

#include "JoinPointModel.h"
#include "TransformInfo.h"

namespace Puma {
  class CTranslationUnit;
  class CSemDatabase;
  class CStructure;
  class CScopeInfo;
  class ACAspectInfo;
  class ACIntroductionInfo;
  class ACSliceInfo;
  class ErrorStream;
  class VerboseMgr;
}
using namespace Puma;

class ACConfig;

struct AccessInfo {
  CAttributeInfo *_info;
  CTree *_tree;
  AccessInfo () {}
  AccessInfo (CAttributeInfo *info, CTree *tree) :
    _info (info), _tree (tree) {}
  
};

class ModelBuilder : public JoinPointModel {

  VerboseMgr &_vm;
  ErrorStream &_err;
  ACConfig &_conf;
  File *_tunit_file;
  int _phase;
  CSemDatabase *_db;

  // map needed to check if a file is already known
  typedef map<Unit*, File*> FileMap;
  typedef FileMap::value_type FileMapPair;
  FileMap _file_map;

  // TODO: temporary solution
  list<AccessInfo> _access_infos;
  
  void build (CTranslationUnit& tunit);
  void build (CStructure &structure, JPL_Name *jpl = 0);
  bool inside_template (CScopeInfo *scope) const;
  void advice_infos (JPL_Aspect *jpl_aspect, ACAspectInfo *acai);
  void check (JPL_Aspect *jpl_aspect, ACIntroductionInfo *acii, JPL_Introduction *intro);
  
  // determine a model element filename for a unit
  string model_filename (FileUnit *unit);
  
public:
  ModelBuilder (VerboseMgr &vm, ErrorStream &err, ACConfig &conf) :
    _vm (vm), _err (err), _conf (conf), _phase (0) {}
  void setup_phase1 (CTranslationUnit& tunit);
  void setup_phase2 (CTranslationUnit& tunit, list<CTree*> &ah_trees);
  bool is_valid_model_class (CClassInfo *ci) const;
  bool is_intro_target (CClassInfo *ci) const;
  bool is_valid_model_function (CFunctionInfo *fi) const;
  bool is_valid_model_namespace (CNamespaceInfo *ni) const;

  // create a type in the join point model from a Puma node
  TU_Type *register_type (CTypeInfo *ti);

  // create a function in the join point model from a Puma node
  TU_Function *register_function (CFunctionInfo *fi, JPL_Name *parent = 0);
  
  // create a class slice in the join point model from a Puma node
  TU_ClassSlice *register_class_slice (ACSliceInfo *acsi, JPL_Name *parent = 0);

  // create a class in the join point model from a Puma node
  TU_Class *register_class (CClassInfo *ci, JPL_Name *parent = 0);

  // create an aspect in the join point model from a Puma node
  TU_Aspect *register_aspect (ACAspectInfo *ai, JPL_Name *parent = 0);

  // create a Namespace in the join point model from a Puma node
  TU_Namespace *register_namespace (CNamespaceInfo *ni, JPL_Name *parent = 0);

  // create a new call join point in the join point model
  TU_MethodCall *register_call (CFunctionInfo *called, CT_Call *call_node,
    CObjectInfo *caller, int local_id);

  // create a new execution join point
  TU_Method *register_execution (JPL_Function *ef);
  
  // create a new construction join point
  TU_Construction *register_construction (JPL_Function *cf);
  
  // create a new construction join point
  TU_Destruction *register_destruction (JPL_Function *df);
  
  // TODO: temporary solution for dac++
  void register_attr_access (CAttributeInfo *attr, CTree *node);

  // register the scope of a given element
  JPL_Name *register_scope (CObjectInfo *obj);

  // return the name of the scope of an object
  static string scope_name (CObjectInfo *oi);
  
  // return the scope of an object
  static CScopeInfo *scope_obj (CObjectInfo *oi);

  // add the source location to a model element by using a given CObjectInfo
  void add_source_loc (JoinPointLoc *name, CObjectInfo *obj, SourceLocKind kind = SLK_NONE) {
    add_source_loc (name, obj->Tree (), kind);
  }

  // add the source location to a model element by using the syntax tree node
  void add_source_loc (JoinPointLoc *name, CTree *tree, SourceLocKind kind = SLK_NONE);
  
  // determine the file unit, which contains a specific syntax (sub-)tree
  FileUnit *source_unit (CTree *tree);
  
  // TODO: temporary solution
  const list<AccessInfo> &access_infos () const { return _access_infos; }
};

#endif
