/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class FixedAttribute
extends SimpleNodeConstructor {
    private int nameCode;
    private SimpleType schemaType;
    private int annotation;
    private int options;
    private int validationAction;

    public FixedAttribute(int n, int n2, SimpleType simpleType, int n3) {
        this.nameCode = n;
        this.schemaType = simpleType;
        this.annotation = n3;
        this.validationAction = n2;
        this.options = 0;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("attribute");
        if (namePool != null) {
            instructionDetails.setProperty("name", namePool.getDisplayName(this.nameCode));
        }
    }

    public SequenceType getResultType() {
        return new SequenceType(NodeKindTest.ATTRIBUTE, 512);
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof ExprInstruction) {
                    Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                    this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++n;
            }
        }
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
    }

    protected int evaluateNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        String string = this.expandChildren(xPathContext).toString();
        if (this.schemaType != null) {
            try {
                this.schemaType.validateContent(string, null);
            }
            catch (ValidationException validationException) {
                throw new ValidationException("Attribute value \u00ab" + string + "\u00bb does not the match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            this.annotation = controller.getConfiguration().validateAttribute(this.nameCode, string, this.validationAction);
        }
        try {
            sequenceReceiver.attribute(this.nameCode, this.annotation, string, this.options);
        }
        catch (NoOpenStartTagException noOpenStartTagException) {
            this.recoverableError("Cannot write an attribute node when no element start tag is open", controller);
        }
        catch (TransformerException transformerException) {
            throw this.styleError(transformerException, xPathContext.getController());
        }
        return null;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "attribute ");
        System.err.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        super.display(n + 1, namePool);
    }
}

