------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                      G N A T C H E C K . R U L E S                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2004-2008, AdaCore                     --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Common;
with ASIS_UL.Options;
with ASIS_UL.Output;             use ASIS_UL.Output;

with Gnatcheck.Rules.Rule_Table; use Gnatcheck.Rules.Rule_Table;

package body Gnatcheck.Rules is

   ------------------------------
   -- Analyze_Global_Structure --
   ------------------------------

   procedure Analyze_Global_Structure (Rule : Global_Rule_Template) is
      pragma Unreferenced (Rule);
   begin
      null;
   end Analyze_Global_Structure;

   ---------------------------------
   -- Check_Global_Structure_Node --
   ---------------------------------

   procedure Check_Global_Structure_Node
     (Rule          :     Global_Rule_Template;
      N             :     ASIS_UL.Global_State.GS_Node_Id;
      Detected      : out Boolean)
   is
      pragma Unreferenced (Rule);
      pragma Unreferenced (N);
      pragma Unreferenced (Detected);
   begin
      null;
   end Check_Global_Structure_Node;

   --------------------------------
   -- Collect_Global_Info_Pre_Op --
   --------------------------------

   procedure Collect_Global_Info_Pre_Op
     (Rule    : in out Global_Rule_Template;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
      pragma Unreferenced (Rule);
      pragma Unreferenced (Element);
      pragma Unreferenced (Control);
      pragma Unreferenced (State);
   begin
      null;
   end Collect_Global_Info_Pre_Op;

   ---------------------------------
   -- Collect_Global_Info_Post_Op --
   ---------------------------------

   procedure Collect_Global_Info_Post_Op
     (Rule    : in out Global_Rule_Template;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
      pragma Unreferenced (Rule);
      pragma Unreferenced (Element);
      pragma Unreferenced (Control);
      pragma Unreferenced (State);
   begin
      null;
   end Collect_Global_Info_Post_Op;

   ----------------------------
   -- Decrease_Nonexec_Level --
   ----------------------------

   procedure Decrease_Nonexec_Level (State : in out Rule_Traversal_State)
   is
   begin
      State.Level_Of_Nonexecutable_Construct :=
        State.Level_Of_Nonexecutable_Construct - 1;
   end Decrease_Nonexec_Level;

   ----------------------------
   -- Increase_Nonexec_Level --
   ----------------------------

   procedure Increase_Nonexec_Level (State : in out Rule_Traversal_State)
   is
   begin
      State.Level_Of_Nonexecutable_Construct :=
        State.Level_Of_Nonexecutable_Construct + 1;
   end Increase_Nonexec_Level;

   ---------------------------
   -- Init_Global_Structure --
   ---------------------------

   procedure Init_Global_Structure (Rule : Global_Rule_Template) is
      pragma Unreferenced (Rule);
   begin
      null;
   end Init_Global_Structure;

   --------------------------------------
   -- Init_Rule (Global_Rule_Template) --
   --------------------------------------

   procedure Init_Rule (Rule : in out Global_Rule_Template) is
   begin
      Rule.Name       := new String'("Global_Rule_Template");
      Rule.Rule_State := Disabled;
      Rule.Help_Info  := new String'("No help info");
      Rule.Diagnosis  := new String'("No diagnostic info");

      ASIS_UL.Options.Buld_Call_Graph := True;
   end Init_Rule;

   -------------------------------
   -- Init_Rule (Rule_Template) --
   --------------------------------

   procedure Init_Rule (Rule : in out Rule_Template) is
   begin
      Rule.Name       := new String'("Rule_Template");
      Rule.Rule_State := Disabled;
      Rule.Help_Info  := new String'("No help info");
      Rule.Diagnosis  := new String'("No diagnostic info");
   end Init_Rule;

   ------------------------
   -- In_Executable_Code --
   ------------------------

   function In_Executable_Code
     (State : Rule_Traversal_State)
      return  Boolean
   is
   begin
      return State.Level_Of_Nonexecutable_Construct = 0;
   end In_Executable_Code;

   ---------------
   -- Is_Enable --
   ---------------

   function Is_Enable (Rule : Rule_Template) return Boolean is
   begin
      return Rule.Rule_State = Enabled;
   end Is_Enable;

   function Is_Enable (Rule : Internal_Rule_Template) return Boolean is
   begin
      return
        Rule.Rule_State = Enabled and then
        Is_Enable (Rule.Implements.all);
   end Is_Enable;

   ---------------------
   -- Print_Rule_Help --
   ---------------------

   procedure Print_Rule_Help (Rule : Rule_Template) is
   begin
      Info
        (Message  => " " & Rule.Name.all & " - " & Rule.Help_Info.all,
         Line_Len => 79,
         Spacing  => 2);
   end Print_Rule_Help;

   procedure Print_Rule_Help (Rule : Internal_Rule_Template) is
   begin
      Info
        (Message  => " " & Rule_Name (Rule) & " - " & Rule.Help_Info.all,
         Line_Len => 79,
         Spacing  => 2);
   end Print_Rule_Help;

   ----------------------------
   -- Process_Rule_Parameter --
   ----------------------------

   procedure Process_Rule_Parameter
     (Rule    : in out Rule_Template;
      Param   :         String;
      Enable  :         Boolean)
   is
      pragma Unreferenced (Enable);
      pragma Unmodified  (Rule);
   begin
      Error ("no parameter can be set for rule " & Rule.Name.all & ", " &
             Param & " ignored");
   end Process_Rule_Parameter;

   -------------------
   -- Register_Rule --
   -------------------

   procedure Register_Rule (Rule : Rule_Access) is
      New_Rule : Rule_Id;
   begin
      Init_Rule (Rule.all);

      New_Rule := Get_Rule (Rule.Name.all);

      if not Present (New_Rule)
        and then
         Rule.Synonym /= null
      then
         --  Check if the Rule synonym, if any, name conflicts with any
         --  existing rule.
         New_Rule := Get_Rule (Rule.Synonym.all);
      end if;

      if Present (New_Rule) then
         Error ("duplicated rule - " & Rule.Name.all);
         raise ASIS_UL.Common.Fatal_Error;
      end if;

      All_Rules.Append (Rule);

   end Register_Rule;

   ------------------------
   -- Rule_Check_Post_Op --
   ------------------------

   procedure Rule_Check_Post_Op
     (Rule    : in out Rule_Template;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
      pragma Unreferenced (Rule);
      pragma Unreferenced (Element);
      pragma Unreferenced (Control);
      pragma Unreferenced (State);
   begin
      null;
   end Rule_Check_Post_Op;

   -----------------------
   -- Rule_Check_Pre_Op --
   -----------------------

   procedure Rule_Check_Pre_Op
     (Rule    : in out Rule_Template;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
      pragma Unreferenced (Rule);
      pragma Unreferenced (Element);
      pragma Unreferenced (Control);
      pragma Unreferenced (State);
   begin
      null;
   end Rule_Check_Pre_Op;

   ------------------------
   -- Internal_Rule_Name --
   ------------------------

   function Rule_Name (Rule : Rule_Template) return String is
   begin
      return Rule.Name.all;
   end Rule_Name;

   function Rule_Name (Rule : Internal_Rule_Template) return String is
   begin
      return Rule.Implements.all.Name.all &
             "("                         &
              Rule.Name.all               &
               ")";
   end Rule_Name;

end Gnatcheck.Rules;
