------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--                      A S I S _ U L . O P T I O N S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2004-2007, AdaCore                     --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING.  If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines options that are supposed to be of a common interest
--  for all the tools.

package ASIS_UL.Options is

   Verbose_Mode : Boolean := False;
   --  The verbose mode.
   --  '-v'

   Quiet_Mode : Boolean := False;
   --  The quiet mode
   --  '-q'

   Debug_Mode : Boolean := False;
   --  The debug mode
   --  '-d'

   Progress_Indicator_Mode : Boolean := False;
   --  Generate the output to be used for GPS progress indicator.
   --  '-dd'

   ASIS_2005_Mode : Boolean := True;
   --  If this flag is ON, ASIS is initialized in Ada 2005 mode, and the tool
   --  may perform some Ada-2005-specific analysis.

   Process_RTL_Units : Boolean := False;
   --  If this flag is set ON, a tool tries to look into RTL units when
   --  analyzing global properties of the argument sources, even if these RTL
   --  units are not specified as tool arguments
   --  '-a'

   Nothing_To_Do : Boolean := False;
   --  Flag indicating if a tool does not have any real work to do except,
   --  may be, generating some help information (for example, no argument is
   --  specified)

   Compute_Timing : Boolean := False;
   --  If this flag is ON, the total execution time (wall clock) of the tool
   --  is computed and printed out.
   --  '-t'

end ASIS_UL.Options;
