------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--           G N A T C H E C K . R U L E S. T R A V E R S I N G             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2004-2006, AdaCore                      --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Asis.Iterator; use Asis.Iterator;

--  This package defines the traversal engine for gnatcheck. It includes both
--  the recursive traversing of the units syntax structure and traversing
--  the global structure.

package Gnatcheck.Rules.Traversing is

   procedure All_Rules_Pre_Op
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State);
   --  For all active rules, performs the rule-specific Pre-Operation on a
   --  an argument Element. Before calling each rule-specific Pre-Operation,
   --  sets State.Detected OFF, and if after completing this pre-operation
   --  State.Detected is ON, reports the rule violation for this rule. When all
   --  the calls to rule-specific Pre-Operations are complete, put the record
   --  corresponding to the Element being visited at the top of the traversal
   --  stack.

   procedure All_Rules_Post_Op
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State);
   --  Does exactly the same for rule-specific Post-Operations. When all the
   --  calls to rule-specific Post-Operations are complete, remove the record
   --  corresponding to the Element being visited from the top of the traversal
   --  stack.

   procedure Check_Rules is new Traverse_Element
     (Rule_Traversal_State,
      All_Rules_Pre_Op,
      All_Rules_Post_Op);
   --  Traverses the syntax structure of the argument Element. Checks the local
   --  rules and collect the information for building the global structure.

   procedure Extract_Global_Information_Pre_Op
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State);
   --  Collects and stores the information needed for creating the global
   --  structure. Is supposed to be used as pre-operation for the traversing
   --  of the units that are itself not the argument units of the gnatcheck
   --  call, but that are needed by the argument units.

   procedure Extract_Global_Information_Post_Op
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State);
   --  Collects and stores the information needed for creating the global
   --  structure. Is supposed to be used as post-operation for the traversing
   --  of the units that are itself not the argument units of the gnatcheck
   --  call, but that are needed by the argument units.

   procedure Extract_Global_Information is new Traverse_Element
     (Rule_Traversal_State,
      Extract_Global_Information_Pre_Op,
      Extract_Global_Information_Post_Op);
   --  Traverses the syntax structure of the argument Element and collects the
   --  information needed for creating the global structure. Does not check any
   --  local or global rule.

   type Access_To_Traverse_Routine is access procedure
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State);
   --  This type allows "to switch" between Check_Rules and
   --  Extract_Global_Information when processing a unit (the general
   --  processing mechanism is basically the same, see the routines
   --  ASIS_Processing and Collect_Global_Info

   procedure Check_Global_Rules;
   --  Checks the global rules on the global structure from
   --  ASIS_UL.Source_Table.Gnatcheck_Processing

end Gnatcheck.Rules.Traversing;
