@echo off

if .%1. == .clean. goto clean

if .%1. == .. goto help

:install

set INSTALL_DIR=%1

rem -- we have to start from the top directory of the ASIS distribution

rem --  go into obj subdirectory and compile everything
cd obj
gnatmake -c -I../gnat -I../asis -g -O2 install_asis.adb

rem --  we do not need object and ali file created for a dummy
rem --  Install_ASIS procedure

del install_asis.o install_asis.ali

rem --  creating a library file
ar rc libasis.a *.o
ranlib libasis.a

rem --  and moving all the installation stuff into INSTALL_DIR

rem --  first, cleaning up the location for the ASIS library installation:

mkdir %INSTALL_DIR%

move *.ali         %INSTALL_DIR%
move libasis.a     %INSTALL_DIR%
del  *.o

copy ..\asis\*.ads %INSTALL_DIR%
copy ..\asis\*.adb %INSTALL_DIR%
copy ..\gnat\*.ads %INSTALL_DIR%
copy ..\gnat\*.adb %INSTALL_DIR%

rem --  locking the ALI files of the ASIS library
attrib +r          %INSTALL_DIR%\*.ali

set ADA_INCLUDE_PATH=%INSTALL_DIR%;%ADA_INCLUDE_PATH%
set ADA_OBJECTS_PATH=%INSTALL_DIR%;%ADA_OBJECTS_PATH%

rem --  ASIStant is considered as a part of a standard ASIS installation

cd ..\tools\asistant
gnatmake -g -O2 -o asistant asistant-driver.adb -largs -lasis
cd ..\..

if .%2. == .all. goto create_examples
goto done

: create_examples
rem --  creating ASIS tools and examples

cd tools

cd gnatstub
gnatmake -g -O2 -o gnatstub gnatstub-driver.adb -largs -lasis

cd ..\gnatelim
gnatmake -g -O2 -o gnatelim gnatelim-driver.adb -largs -lasis

cd ..\gnatpp
gnatmake -g -O2 -o gnatpp gnatpp-driver.adb -largs -lasis

cd ..\..\examples\ds
gnatmake -g -O2 -o ds display_source.adb -largs -lasis
cd ..

cd ..

goto done

:clean

cd tools\asistant
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd gnatelim
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd gnatstub
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd gnatpp
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd ..\examples

cd ds
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd ..

goto done

:help
echo Usage:
echo     asis_install [path]  - build ASIS and install it at location path or
echo                            at c:\local\asis if path is omitted
echo     asis_install clean   - clean up ASIS source directories

goto fin

:done
set INSTALL_DIR   =

:fin
