/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:09:06 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.MSPcrunchStreamFeature;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.PublicDBStreamFeature;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SimpleDocumentFeature_ESTest extends SimpleDocumentFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = new Key("", true);
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      assertNotNull(key0);
      
      Range range0 = new Range(2);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertNotNull(range0);
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[2]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertNotNull(rangeVector0);
      
      Location location0 = new Location(rangeVector0, true);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[2]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertNotNull(location0);
      
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      assertFalse(entryInformation0.useEMBLFormat());
      assertNotNull(entryInformation0);
      
      QualifierVector qualifierVector0 = PublicDBStreamFeature.readQualifiers(stringReader0, entryInformation0);
      assertFalse(entryInformation0.useEMBLFormat());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNotNull(qualifierVector0);
      
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[2]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertFalse(entryInformation0.useEMBLFormat());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertTrue(databaseStreamFeature0.isVisible());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSource());
      assertNotNull(databaseStreamFeature0);
      
      int int0 = databaseStreamFeature0.getFirstBase();
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[2]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertFalse(entryInformation0.useEMBLFormat());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertTrue(databaseStreamFeature0.isVisible());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSource());
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNotNull(qualifierVector0);
      
      genbankStreamFeature0.setQualifiers(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertNotNull(blastEntryInformation0);
      
      Key key0 = blastEntryInformation0.getDefaultKey();
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals("misc_feature", key0.toString());
      assertNotNull(key0);
      
      Range range0 = new Range(2821);
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertNotNull(range0);
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertEquals("[2821]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertNotNull(rangeVector0);
      
      Location location0 = new Location(rangeVector0, false);
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertEquals("[2821]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertNotNull(location0);
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNotNull(qualifierVector0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, location0, qualifierVector0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals("misc_feature", key0.toString());
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertEquals("[2821]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNotNull(mSPcrunchStreamFeature0);
      
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(mSPcrunchStreamFeature0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals("misc_feature", key0.toString());
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertEquals("[2821]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNotNull(databaseStreamFeature0);
      
      databaseStreamFeature0.setLocation(location0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals("misc_feature", key0.toString());
      assertEquals(2821, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2821, range0.getEnd());
      assertEquals("[2821]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      genbankStreamFeature0.setDirtyFlag();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Feature feature0 = genbankStreamFeature0.copy();
      assertNotSame(genbankStreamFeature0, feature0);
      assertNotSame(feature0, genbankStreamFeature0);
      assertNotNull(feature0);
      assertFalse(feature0.equals((Object)genbankStreamFeature0));
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      boolean boolean0 = genbankStreamFeature0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      QualifierVector qualifierVector0 = genbankStreamFeature0.getQualifiers();
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNotNull(qualifierVector0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0);
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNotNull(gFFStreamFeature0);
      
      QualifierVector qualifierVector0 = gFFStreamFeature0.getQualifiers();
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertEquals(1, qualifierVector0.size());
      assertFalse(qualifierVector0.isEmpty());
      assertEquals(1, qualifierVector0.capacity());
      assertNotNull(qualifierVector0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Qualifier qualifier0 = genbankStreamFeature0.getQualifierByName((String) null);
      assertNull(qualifier0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(genbankStreamFeature0);
      assertNotNull(mSPcrunchStreamFeature0);
      
      String[] stringArray0 = new String[2];
      StringVector stringVector0 = new StringVector(stringArray0);
      assertEquals(2, stringVector0.capacity());
      assertFalse(stringVector0.isEmpty());
      assertEquals(2, stringVector0.size());
      assertEquals("[null, null]", stringVector0.toString());
      assertEquals(2, stringArray0.length);
      assertNotNull(stringVector0);
      
      Qualifier qualifier0 = new Qualifier("", stringVector0);
      assertEquals(2, stringVector0.capacity());
      assertFalse(stringVector0.isEmpty());
      assertEquals(2, stringVector0.size());
      assertEquals("[null, null]", stringVector0.toString());
      assertEquals("", qualifier0.getName());
      assertEquals(2, stringArray0.length);
      assertNotNull(qualifier0);
      
      mSPcrunchStreamFeature0.setQualifier(qualifier0);
      assertEquals(2, stringVector0.capacity());
      assertFalse(stringVector0.isEmpty());
      assertEquals(2, stringVector0.size());
      assertEquals("[null, null]", stringVector0.toString());
      assertEquals("", qualifier0.getName());
      assertEquals(2, stringArray0.length);
      
      Qualifier qualifier1 = mSPcrunchStreamFeature0.getQualifierByName("");
      assertSame(qualifier1, qualifier0);
      assertEquals("", qualifier1.getName());
      assertNotNull(qualifier1);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Location location0 = genbankStreamFeature0.getLocation();
      assertNotNull(location0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertNotNull(blastEntryInformation0);
      
      Key key0 = blastEntryInformation0.getDefaultKey();
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals("misc_feature", key0.toString());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertNotNull(key0);
      
      Range range0 = new Range(623, 623);
      assertEquals(1, range0.getCount());
      assertEquals(623, range0.getEnd());
      assertEquals(623, range0.getStart());
      assertNotNull(range0);
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertEquals(1, range0.getCount());
      assertEquals(623, range0.getEnd());
      assertEquals(623, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertEquals("[623]", rangeVector0.toString());
      assertNotNull(rangeVector0);
      
      Location location0 = new Location(rangeVector0, true);
      assertEquals(1, range0.getCount());
      assertEquals(623, range0.getEnd());
      assertEquals(623, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertEquals("[623]", rangeVector0.toString());
      assertNotNull(location0);
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNotNull(qualifierVector0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(key0, location0, qualifierVector0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals("misc_feature", key0.toString());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(623, range0.getEnd());
      assertEquals(623, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertEquals("[623]", rangeVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNotNull(mSPcrunchStreamFeature0);
      
      Key key1 = mSPcrunchStreamFeature0.getKey();
      assertSame(key0, key1);
      assertSame(key1, key0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals("misc_feature", key0.toString());
      assertEquals(12, key0.length());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(623, range0.getEnd());
      assertEquals(623, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertEquals("[623]", rangeVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("misc_feature", key1.getKeyString());
      assertEquals(12, key1.length());
      assertEquals("misc_feature", key1.toString());
      assertNotNull(key1);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      Entry entry0 = emblStreamFeature0.getEntry();
      assertNull(entry0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(genbankStreamFeature0);
      assertNotNull(mSPcrunchStreamFeature0);
      
      // Undeclared exception!
      try { 
        mSPcrunchStreamFeature0.setQualifier((Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      int int0 = genbankStreamFeature0.getLastBase();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(genbankStreamFeature0);
      assertNotNull(mSPcrunchStreamFeature0);
      
      int int0 = mSPcrunchStreamFeature0.getFirstBase();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      Qualifier qualifier0 = new Qualifier();
      assertNull(qualifier0.getName());
      assertNotNull(qualifier0);
      
      // Undeclared exception!
      try { 
        emblStreamFeature0.addQualifierValues(qualifier0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // 
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      genbankStreamFeature0.removeQualifierByName("owX? _b");
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(genbankStreamFeature0);
      assertNotNull(mSPcrunchStreamFeature0);
      
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertNotNull(chadoCanonicalGene0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertNotNull(simpleEntryGroup0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotNull(aminoAcidSequence0);
      
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotNull(featurePatternPredicate0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "3NwQIv{");
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals("3NwQIv{", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertNotNull(filteredEntryGroup0);
      
      uk.ac.sanger.artemis.Entry entry0 = filteredEntryGroup0.createEntry((String) null);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals("3NwQIv{", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertNotNull(entry0);
      
      // Undeclared exception!
      try { 
        DatabaseInferredFeature.createFeature("", mSPcrunchStreamFeature0, chadoCanonicalGene0, entry0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      DatabaseStreamFeature databaseStreamFeature0 = null;
      try {
        databaseStreamFeature0 = new DatabaseStreamFeature(key0, (Location) null, (QualifierVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(genbankStreamFeature0);
      Key key0 = Key.CDS;
      gFFStreamFeature0.setKey(key0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DocumentEntry documentEntry0 = emblStreamFeature0.getDocumentEntry();
      assertNull(documentEntry0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      long long0 = genbankStreamFeature0.getNumericID();
      assertEquals(1L, long0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      EntryInformation entryInformation0 = genbankStreamFeature0.getEntryInformation();
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(genbankStreamFeature0);
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(mSPcrunchEntryInformation0, mSPcrunchDocumentEntry0, false);
      mSPcrunchStreamFeature0.setDocumentEntry(publicDBDocumentEntry0);
      assertFalse(publicDBDocumentEntry0.isReadOnly());
  }
}
