/*
 * Copyright (c) 2003 Brian Kreulen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*========================================================*/
/*	Generic Choice Dialog. A generic dialog for choosing
 * one item out of a list.
 *========================================================*/

#include "arson.h"

#include <qlistview.h>
#include <qdialog.h>
#include <qlabel.h>

#include "listwnd.h"
#include "tsutil.h"

#include "choicedlg.h"

ArsonChoiceDlg::ArsonChoiceDlg(ArsonListHeader *headers, int headerCnt, QWidget *parent)
 : ArsonChoiceDlgBase(parent), m_pLast(NULL)
{
   album_list->setListHeaders(headers, headerCnt);
   album_list->setSorting(-1);
	album_list->setAllColumnsShowFocus(true);
	album_list->setSelectionMode(QListView::Single);

   QObject::connect(
      album_list, SIGNAL(doubleClicked(QListViewItem*, const QPoint&, int)),
      this, SLOT(dblClicked(QListViewItem*, const QPoint&, int)));
}

/*========================================================*/

void ArsonChoiceDlg::addChoice(const QString &id, const QString &artist, const QString &album)
{
	m_pLast = new QListViewItem(album_list, m_pLast, id, artist, album);
}

/*========================================================*/

void ArsonChoiceDlg::setHeaders(ArsonListHeader *headers)
{
  	album_list->setListHeaders(headers, ARRSIZE(headers));
}

/*========================================================*/

void ArsonChoiceDlg::accept()
{
   m_pLast = album_list->selectedItem();
   QDialog::accept();
}

/*========================================================*/

void ArsonChoiceDlg::reject()
{
   QDialog::reject();
}

/*========================================================*/

void ArsonChoiceDlg::setDescription(const QString &str)
{
   m_ChoiceText->setText(str.data());
}

/*========================================================*/

void ArsonChoiceDlg::dblClicked(QListViewItem *pItem, const QPoint&, int)
{
   Trace("In dblClicked\n");
   accept();
}

/*========================================================*/

const QString ArsonChoiceDlg::getSelectedId()
{
   return m_pLast->text(0);
}

/*========================================================*/

void ArsonChoiceDlg::selectFirst()
{
   QListViewItem *pListItem;
   if (!(pListItem = album_list->itemAtIndex(0)))
      return;
      
   album_list->setSelected(pListItem, true);
}

/*========================================================*/
