/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PROGRAMPAGE_H__
#define __PROGRAMPAGE_H__

#include <qstringlist.h>
#include <qvaluelist.h>

#include "_programpage.h"
#include "configdlg.h"
#include "konfig.h"

/*========================================================*/

class QListViewItem;
class QComboBox;

class ArsonProgramPage : public ArsonProgramPageBase, public ArsonConfigPage
{
	Q_OBJECT

	typedef QValueList<QStringList> GROUPLIST;
	
public:
	ArsonProgramPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	virtual void program_group_changed (int cur);
	virtual void selected_program_changed (int sel);
	virtual void auto_detect_clicked (void);
	virtual void modify_clicked (void);

	void fillDriverList (QComboBox *ptr);
	void setupProgramPrefs (void);
	void saveCurrentGroup (void);
	void fillProgramList (void);

	ArsonProgramSeqs m_seq;
	int m_current_group;
	GROUPLIST m_groups;
	
private slots:
	void program_dblclk (QListViewItem *pItem);
	void url_clicked (const QString &url);
	void on_accept (void);
};

/*========================================================*/
#endif	/*	__PROGRAMPAGE_H__	*/
