/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __DEVICE_H__
#define __DEVICE_H__

#include <qmap.h>

/*========================================================*/

class ArsonDevice
{
public:
	ArsonDevice (const char *dev = NULL)
		: m_dev(dev) { }

	const QCString &dev (void) const { return m_dev; }
	void setDev (const char *dev) { m_dev = dev; }

	virtual const QCString id (void) const { return QCString(); }
	virtual void setId (const char *id) { }
	virtual bool scsiDevice (void) const { return false; }

	virtual QString description (void) const;
	virtual QString display (void) const;

private:
	QCString m_dev;
};

/*========================================================*/

class ArsonScsiDevice : public ArsonDevice
{
public:
	ArsonScsiDevice (const char *id = NULL, const char *make = NULL,
		const char *model = NULL, const char *ver = NULL,
		const char *type = NULL);

	virtual const QCString id (void) const { return m_id; }
	virtual void setId (const char *id) { m_id = id; }
	virtual bool scsiDevice (void) const { return true; }

	virtual QString description (void) const;
	virtual QString display (void) const;

private:
	QCString m_id;
	QCString m_make;
	QCString m_model;
	QCString m_version;
	QCString m_type;
};

/*========================================================*/

class ArsonDeviceList;
class QComboBox;

class ArsonDeviceUiList
{
public:
	ArsonDeviceUiList (void) : m_devs(NULL) { }
	ArsonDeviceUiList (const QStringList &sl, const ArsonDeviceList *pd);

	const QStringList &keys (void) const { return m_keys; }
	
	void fillList (QComboBox *pl, const char *sel) const;
	QCString fromList (QComboBox *pl) const;

private:
	const ArsonDeviceList *m_devs;
	QStringList m_keys;
};

/*========================================================*/

class KConfig;

class ArsonDeviceList
{
	typedef QMap<QCString,ArsonDevice*> DEVICES;

public:
	ArsonDeviceList (void);
	ArsonDeviceList (const ArsonDeviceList &obj);	
	~ArsonDeviceList (void);

	ArsonDeviceList &operator= (const ArsonDeviceList &obj);

	bool addIoctlDev (const char *dev);
	bool delIoctlDev (const char *dev);

	ArsonDeviceUiList uiList (bool scsiOnly) const;

	QStringList keys (void) const;
	void clear (void);

	uint count (void) const { return m_devs.count(); }
	uint ioctlCount (void) const { return count(false); }
	uint scsiCount (void) const { return count(true); }

	const ArsonDevice *device (const char *dev) const;
	ArsonDevice *device (const char *dev);

	int scanbus (void);

	void load (KConfig *pk);
	void save (KConfig *pk);
	
private:
	void addDev (const char *dev, ArsonDevice *ptr);
	void delDev (const char *dev);
	uint count (bool scsi) const;
	void clear (bool scsi);

	DEVICES m_devs;
};

/*========================================================*/
#endif	/*	__DEVICE_H__	*/
