/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gStuff.h"
#include "tSysTime.h"
#include "tDirectories.h"
#include "tLocale.h"
#include "rViewport.h"
#include "rConsole.h"
#include "gGame.h"
#include "gLogo.h"
#include "eSound.h"
#include "rScreen.h"
#include "rSysdep.h"
#include "uInputQueue.h"
//#include "eTess.h"
#include "rTexture.h"
#include "tConfiguration.h"
#include "eAdvWall.h"
#include "eGameObject.h"
#include "uMenu.h"
#include "ePlayer.h"
#include "gLanguageMenu.h"
#include "gAICharacter.h"
#include "gCycle.h"
//#include <unistd>
#include <stdio.h>
#include <stdlib.h> 
#include <fstream>

#include "nServerInfo.h"

#ifndef DEDICATED
#include "rRender.h"
#include "rSDL.h"
#endif

static bool use_directx=false;
#ifdef WIN32
static tConfItem<bool> udx("USE_DIRECTX","makes use of the DirectX input "
						   "fuctions; causes some graphic cards to fail to work (VooDoo 3,...)",
						   use_directx);
#endif

extern void exit_game_objects(eGrid *grid);

#ifndef DEDICATED
static void welcome(){
	bool textOutBack = sr_textOut;
	sr_textOut = false;

#ifdef DEBUG_XXXX
	{
		for (int i = 20; i>=0; i--)
		{
			sr_ClearGL();
			{
				rTextField c(-.8,.6, .1, .1);
				tString s;
				s << ColorString(1,1,1);
				s << "Test";
				s << ColorString(1,0,0);
				s << "bla bla blubb blaa blaa blubbb blaaa blaaa blubbbb blaaaa blaaaa blubbbbb blaaaaa blaaaaa blubbbbbb blaaaaaa\n";
				c << s;
			}
			sr_SwapGL();
		}
	}
#endif

	if ( sr_glOut )
	{
		sr_ClearGL();
		rFont::s_defaultFont.Select();
		rFont::s_defaultFontSmall.Select();
		gLogo::Display();
		sr_ClearGL();
		sr_SwapGL();
	}

	REAL timeout = tSysTimeFloat() + .2;
	SDL_Event tEvent;

	if (st_FirstUse)
    {
		st_FirstUse=false;
		sr_LoadDefaultConfig();
		textOutBack = sr_textOut;
		sr_textOut = false;
		gLogo::SetBig(false);
		gLogo::SetSpinning(true);
    }
	else
    {
#ifndef DEBUG
		timeout = tSysTimeFloat() + 6;

		while((!su_GetSDLInput(tEvent) || tEvent.type!=SDL_KEYDOWN) && sr_glOut &&
			  tSysTimeFloat() < timeout){
	
			sr_ResetRenderState(true);
			rViewport::s_viewportFullscreen.Select();
	
			sr_ClearGL();
    
			uMenu::GenericBackground();

			sr_SwapGL();
		}
#endif

		// catch some keyboard input
		while (su_GetSDLInput(tEvent));

		sr_textOut = textOutBack;
		return;
    }
  
	sg_LanguageMenu();

	// catch some keyboard input
	while (su_GetSDLInput(tEvent));

	timeout = tSysTimeFloat() + 10;

	sr_UnlockSDL();
	while((!su_GetSDLInput(tEvent) || tEvent.type!=SDL_KEYDOWN) && sr_glOut &&
		  tSysTimeFloat() < timeout){
    
		sr_ResetRenderState(true);
		rViewport::s_viewportFullscreen.Select();
    
		sr_ClearGL();
    
		uMenu::GenericBackground();
    
		REAL w=16*3/640.0;
		REAL h=32*3/480.0;
    
    
		//REAL middle=-.6;
    
		Color(1,1,1);
		DisplayText(0,.8,w,h,tOutput("$welcome_message_heading"));

		w/=3;
		h/=3;

		rTextField c(-.8,.6, w, h);

    
		c << tOutput("$welcome_message_intro");

		c.SetIndent(12);

		c << tOutput("$welcome_message_vendor")   << gl_vendor   << '\n';
		c << tOutput("$welcome_message_renderer") << gl_renderer << '\n';
		c << tOutput("$welcome_message_version")  << gl_version  << '\n';

		c.SetIndent(0);

		c << tOutput("$welcome_message_finish");
    
		sr_SwapGL();
	}
	sr_LockSDL();

	sr_textOut = textOutBack;
}
#endif

void cleanup(eGrid *grid){
	static bool reentry=true;
	if (reentry){
		reentry=false;
		su_contInput=false;

		exit_game_objects(grid);
		/*
		  for(int i=MAX_PLAYERS-1;i>=0;i--){
		  if (playerConfig[i])
		  destroy(playerConfig[i]->cam);
		  }
    
    
		  gNetPlayerWall::Clear();

		  eFace::Clear();
		  eEdge::Clear();
		  ePoint::Clear();
    
		  eFace::Clear();
		  eEdge::Clear();
		  ePoint::Clear();
    
		  eGameObject::DeleteAll();


		*/

#ifdef POWERPAK_DEB
		if (pp_out){
			PD_Quit();
			PP_Quit();     
		}
#endif
		nNetObject::ClearAll();
    
		if (sr_glOut){
			rTexture::UnloadAll();
		}
    
		se_SoundExit();
		sr_glOut=false;
		sr_ExitDisplay();

#ifndef DEDICATED
		sr_RendererCleanup();
#endif

	}
}

#ifndef DEDICATED
int filter(const SDL_Event *tEvent){
	// recursion avoidance
	static bool recursion = false;
	if ( !recursion )
	{
		class RecursionGuard
		{
		public:
			RecursionGuard( bool& recursion )
			:recursion_( recursion )
			{
				recursion = true;
			}

			~RecursionGuard()
			{
				recursion_ = false;
			}

		private:
			bool& recursion_;
		};
	
		RecursionGuard guard( recursion );

		// boss key or OS X quit command
		if ((tEvent->type==SDL_KEYDOWN && tEvent->key.keysym.sym==27 &&
			tEvent->key.keysym.mod & KMOD_SHIFT) || 
				(tEvent->type==SDL_KEYDOWN && tEvent->key.keysym.sym==113 &&
			tEvent->key.keysym.mod & KMOD_META) || 
					(tEvent->type==SDL_QUIT)){
			// sn_SetNetState(nSTANDALONE);
			// sn_Receive();
			st_SaveConfig();
			uMenu::quickexit=true;
			return false;
		}
  
		if(tEvent->type==SDL_MOUSEMOTION)
			if(tEvent->motion.x==sr_screenWidth/2 && tEvent->motion.y==sr_screenHeight/2)
				return 0;
		if (su_mouseGrab && 
			tEvent->type!=SDL_MOUSEBUTTONDOWN &&
			tEvent->type!=SDL_MOUSEBUTTONUP &&
			((tEvent->motion.x>=sr_screenWidth-10  || tEvent->motion.x<=10) ||
			 (tEvent->motion.y>=sr_screenHeight-10 || tEvent->motion.y<=10)))
			SDL_WarpMouse(sr_screenWidth/2,sr_screenHeight/2);

	   // fetch alt-tab
  
		if (tEvent->type==SDL_ACTIVEEVENT)
		{
			int flags = SDL_APPINPUTFOCUS;
			if ( tEvent->active.gain && tEvent->active.state & flags )
				Activate(true);
			if ( !tEvent->active.gain && tEvent->active.state & flags )
				Activate(false);
			return false;
		}

		if (su_prefetchInput){
			return su_StoreSDLEvent(*tEvent);
		}

		}

	return 1;
}
#endif

//from game.C
void Update_netPlayer();

int main(int argc,char **argv){
	//std::cout << "enter\n";
	//  net_test();

  //  std::cout << "Running " << argv[0] << "...\n";

	tCommandLineData commandLine;
	commandLine.programVersion_  = &sn_programVersion;
	if ( commandLine.Analyse(argc, argv) )
	{
		tLocale::Load("languages.txt");

		ePlayer::Init();

		st_LoadConfig();
  
		if ( commandLine.fullscreen_ )
			currentScreensetting.fullscreen   = true;
		if ( commandLine.windowed_ )
			currentScreensetting.fullscreen   = false;
		if ( commandLine.use_directx_ )
			use_directx                       = true;
		if ( commandLine.dont_use_directx_ )
			use_directx                       = false;

		gAICharacter::LoadAll("aiplayers.cfg");

		sg_LanguageInit();
		atexit(tLocale::Clear);

		if ( commandLine.Execute() )
		{
			gCycle::PrivateSettings();

			{
				std::ifstream t;
    
				if ( !tDirectories::Config().Open( t, "settings.cfg" ) )
				{
		#ifdef WIN32
					tERR_ERROR( "Data files not found. You have to run Armagetron from its own directory." );
		#else
					tERR_ERROR( "Data files not found. You have to run Armagetron from its own directory or use the wrapper script installed in /usr/local/bin" );
		#endif
				}
			}

			{
				std::ofstream s;
				if (! tDirectories::Var().Open( s, "scorelog.txt", std::ios::app ) )
				{
		#ifdef WIN32
					tERR_ERROR( "var directory not writable or does not exist. You have to run Armagetron from its own directory and make sure there is a writable var subdirectory." );
		#else
					tERR_ERROR( "var directory not writable or does not exist. Don't start Armagetron directly, use the wrapper script in /usr/local/bin." );
		#endif
				}
			}

			{
				std::ifstream t;
    
				if ( tDirectories::Data().Open( t, "moviepack/settings.cfg" ) )
				{
					sg_moviepackInstalled=true;
				}
			}

		#ifndef DEDICATED
			sr_glOut=1;
		#endif
  
			//std::cout << "checked mp\n";

		  // while DGA mouse is buggy in XFree 4.0:
		#ifdef linux
			// Sam 5/23 - Don't ever use DGA, we don't need it for this game.
			if ( ! getenv("SDL_VIDEO_X11_DGAMOUSE") ) {
				putenv("SDL_VIDEO_X11_DGAMOUSE=0");
			}
		#endif

		#ifdef WIN32
			// disable DirectX by default; it causes problems with some boards.
			if (!use_directx && !getenv("SDL_VIDEODRIVER") ) {
				putenv("SDL_VIDEODRIVER=windib");
			}
		#endif

		#ifndef WIN32
		#ifdef DEBUG
		#define NOSOUND
		#endif
		#endif

		#ifndef DEDICATED
			if (
		#ifndef NOSOUND
				SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO) < 0 &&
		#endif
				SDL_Init(SDL_INIT_VIDEO) < 0 )
			{
				tERR_ERROR("Couldn't initialize SDL: " << SDL_GetError());
			}
			atexit(SDL_Quit);

			sr_glRendererInit();

			SDL_SetEventFilter(&filter);

		  //std::cout << "set filter\n";

			rTexture::SetIcon();

			tConsole::RegisterMessageCallback(&uMenu::Message);

			if (sr_InitDisplay()){

				//std::cout << "init disp\n";
    
				se_SoundInit();
		#ifndef DEBUG
				se_SoundExit();
				se_SoundInit();
		#endif
				atexit(se_SoundExit);

				//std::cout << "init sound\n";
    
				welcome();
    

				//std::cout << "atexit\n";
    
				sr_con.autoDisplayAtSwap=false;
    
				se_SoundPause(false);
    
				//std::cout << "sound started\n";

				gLogo::SetBig(false);
				gLogo::SetSpinning(true);

				sn_bigBrotherString = renderer_identification + "VER=" + sn_programVersion + "\n\n";

				MainMenu();

				nNetObject::ClearAll();

				rTexture::UnloadAll();
				sr_RendererCleanup();
				sr_ExitDisplay();

				//std::cout << "exit\n";
    
				st_SaveConfig();

				//std::cout << "saved\n";
    
				//    cleanup(grid);
			}
		#else
			if (!commandLine.daemon_)
				sr_Unblock_stdin();

			sr_glOut=0;

			//  nServerInfo::TellMasterAboutMe();
  
			while (!uMenu::quickexit)
				sg_HostGame();
		#endif

			nNetObject::ClearAll();
			nServerInfo::DeleteAll();
		}

		ePlayer::Exit();
    

	//	tLocale::Clear();
	}

	return 0;
}



