/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gWinZone.h"
#include "eTimer.h"
#include "gCycle.h"
#include "gGame.h"
#include "ePlayer.h"
#include "rRender.h"
#include "nConfig.h"

static REAL sg_expansionSpeed = 1.0f;
static REAL sg_initialSize = 5.0f;

static nSettingItem< REAL > sg_expansionSpeedConf( "WIN_ZONE_EXPANSION", sg_expansionSpeed );
static nSettingItem< REAL > sg_initialSizeConf( "WIN_ZONE_INITIAL_SIZE", sg_initialSize );

gWinZone::gWinZone(eGrid *grid, const eCoord &pos)
:eNetGameObject( grid, pos, eCoord( 0,0 ), NULL, true )
{
	this->createTime_ = se_GameTime();
	lastTime = createTime_;

	sn_ConsoleOut( tOutput( "$instant_win_activated" ) );
}

gWinZone::gWinZone(nMessage &m)
:eNetGameObject( m )
{
	m >> createTime_;
	lastTime = createTime_;
}

gWinZone::~gWinZone()
{
}

void gWinZone::InteractWith( eGameObject *target,REAL time,int recursion )
{
	lastTime = se_GameTime();

	gCycle* c = dynamic_cast< gCycle* >( target );
	if ( c )
	{
		REAL r = this->Radius();
		if ( ( c->Position() - this->Position() ).NormSquared() < r*r )
		{
			if ( c->Player() )
				sg_DeclareWinner( c->Player()->CurrentTeam() );
		}
	}
}

void gWinZone::WriteCreate(nMessage &m)
{
	eNetGameObject::WriteCreate( m );

	m << createTime_;
}

void gWinZone::WriteSync(nMessage &m)
{
	eNetGameObject::WriteSync( m );
}

void gWinZone::ReadSync(nMessage &m)
{
	eNetGameObject::ReadSync( m );
}

REAL gWinZone::Radius() const
{
	return sg_expansionSpeed * ( lastTime - createTime_ ) + sg_initialSize;
}

static nNOInitialisator<gWinZone> winzone_init(340,"winzone");

nDescriptor& gWinZone::CreatorDescriptor() const
{
	return winzone_init;
}

void gWinZone::Render(const eCamera *cam)
{
	lastTime = se_GameTime();
#ifndef DEDICATED

	const REAL speed = .3f;

	GLfloat s=sin(lastTime * speed );
	GLfloat c=cos(lastTime * speed );

	GLfloat m[4][4]={{c,s,0,0},
					 {-s,c,0,0},
					 {0,0,1,0},
					 {pos.x,pos.y,5,1}};

	ModelMatrix();
	glPushMatrix();

	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHT1);
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glBlendFunc( GL_SRC_ALPHA, GL_ONE );

	//glDisable(GL_TEXTURE);
	glDisable(GL_TEXTURE_2D);

	gRealColor color;
	color.r=1.0f;
	color.g=0.0f;
	color.b=0.0f;
	REAL alpha = ( lastTime - createTime_ ) * .2f;
	if ( alpha > 1.0f )
		alpha = 1.0f;

//	glTranslatef(pos.x,pos.y,0);

	glMultMatrixf(&m[0][0]);
//	glScalef(.5,.5,.5);

	BeginQuads();

	const int segments = 11;
	const REAL seglen = .2f;
	const REAL bot = 0.0f;
	const REAL top = 5.0f + ( lastTime - createTime_ ) * .1f;

	glColor4f( color.r ,color.g,color.b, alpha );

	REAL r = Radius();
	for ( int i = segments; i>=0; --i )
	{
		REAL a = i * 2 * 3.14159 / REAL( segments );
		REAL b = a + seglen;

		REAL sa = r * sin(a);
		REAL ca = r * cos(a);
		REAL sb = r * sin(b);
		REAL cb = r * cos(b);

		glVertex3f(sa, ca, bot);
		glVertex3f(sa, ca, top);
		glVertex3f(sb, cb, top);
		glVertex3f(sb, cb, bot);
	}
	
	RenderEnd();

	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

	glPopMatrix();
#endif
}
