/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_tDirectories_H
#define ArmageTron_tDirectories_H

#include <fstream>
#include "tArray.h"
#include "tString.h"

class tString;

class tPath
{
 public:
	bool	Open				( std::ifstream& f,
								  const char* filename	  ) const;	// opens a file to read

	bool	Open				( std::ofstream& f,
								  const char* filename,
								  std::ios::openmode mode = std::ios::out ) const;	// opens a file to write

	tString GetReadPath			( const char* filename	  ) const;	// finds the full path to a file to read
	tString GetWritePath		( const char* filename	  ) const;	// finds the full path to a file to write

	tPath(){};
	virtual ~tPath(){};
 protected:
	virtual void	  	Paths	( tArray< tString >& paths ) const = 0;		// maximum priority
};

class tDirectories
{
 public:
	static const tPath& Data();    	// directory for game data
	static const tPath& Config();  	// directory for static configuration files
	static const tPath& Var();    	// directory for dynamic logs and highscores
};

// data structure for command line parsing
struct tCommandLineData
{
	tString  name_;
	bool     daemon_;
	bool     fullscreen_;
	bool     windowed_;
	tString* programVersion_;
	bool     use_directx_;
	bool     dont_use_directx_;

	bool Analyse(int argc,char **argv ); // analyse the command line
	bool Execute();

	tCommandLineData()
	{
			programVersion_ = NULL;
			daemon_ = false;
			windowed_ = false;
			fullscreen_ = false;
			use_directx_ = false;
			dont_use_directx_ = false;
			doc_ = false;
	}

private:
	bool doc_;
};

#endif
