/*
 * Copyright (c) 2018-2019 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifdef __ARM_FEATURE_SVE


#include "../../asmlib.hpp"

namespace arm_gemm {

void sve_interleaved_fp32_mla_3VLx8(const float *Apanel, const float *Bpanel, float *Cpanel, int ablocks, int bblocks, int K) {
    const float *a_ptr = Apanel;
    float *c_ptr = Cpanel;

    const long loops_count = (K / 2) - 1;
    const long tails_count = K % 2;

    for (int yb=0; yb<ablocks; yb++) {
        const float *a_ptr0 = a_ptr;
        const float *b_ptr = Bpanel;

        for (int xb=0; xb<bblocks; xb++) {
            a_ptr = a_ptr0;
            long loops = loops_count;
            long tails = tails_count;

            __asm __volatile (
                "mov z8.s, #0\n"
                "ptrue p0.s\n"
                "mov z9.s, #0\n"
                "mov z10.s, #0\n"
                "mov z11.s, #0\n"
                "mov z12.s, #0\n"
                "ld1rqw z0.s, p0/z, [%[a_ptr]]\n"
                "mov z13.s, #0\n"
                "ld1w z4.s, p0/z, [%[b_ptr]]\n"
                "mov z14.s, #0\n"
                "ld1rqw z1.s, p0/z, [%[a_ptr], #0x10]\n"
                "mov z15.s, #0\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #1, MUL VL]\n"
                "mov z16.s, #0\n"
                "ld1rqw z2.s, p0/z, [%[a_ptr], #0x20]\n"
                "mov z17.s, #0\n"
                "add %[a_ptr], %[a_ptr], #0x40\n"
                "mov z18.s, #0\n"
                "addvl %[b_ptr], %[b_ptr], #3\n"
                "mov z19.s, #0\n"
                "mov z20.s, #0\n"
                "mov z21.s, #0\n"
                "mov z22.s, #0\n"
                "mov z23.s, #0\n"
                "mov z24.s, #0\n"
                "mov z25.s, #0\n"
                "mov z26.s, #0\n"
                "mov z27.s, #0\n"
                "mov z28.s, #0\n"
                "mov z29.s, #0\n"
                "mov z30.s, #0\n"
                "mov z31.s, #0\n"
                "cbz %[loops], 1f\n"
                "2:\n"
                "fmla z8.s, z4.s, z0.s[0]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                "fmla z9.s, z4.s, z0.s[1]\n"
                "ld1rqw z3.s, p0/z, [%[a_ptr], #-0x10]\n"
                "fmla z10.s, z4.s, z0.s[2]\n"
                "subs %[loops], %[loops], #0x1\n"
                "fmla z11.s, z4.s, z0.s[3]\n"
                "fmla z20.s, z4.s, z1.s[0]\n"
                "fmla z21.s, z4.s, z1.s[1]\n"
                "fmla z22.s, z4.s, z1.s[2]\n"
                "fmla z23.s, z4.s, z1.s[3]\n"
                "ld1w z4.s, p0/z, [%[b_ptr]]\n"
                "fmla z12.s, z5.s, z0.s[0]\n"
                "fmla z13.s, z5.s, z0.s[1]\n"
                "fmla z14.s, z5.s, z0.s[2]\n"
                "fmla z15.s, z5.s, z0.s[3]\n"
                "fmla z24.s, z5.s, z1.s[0]\n"
                "fmla z25.s, z5.s, z1.s[1]\n"
                "fmla z26.s, z5.s, z1.s[2]\n"
                "fmla z27.s, z5.s, z1.s[3]\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #1, MUL VL]\n"
                "fmla z16.s, z6.s, z0.s[0]\n"
                "fmla z17.s, z6.s, z0.s[1]\n"
                "fmla z18.s, z6.s, z0.s[2]\n"
                "fmla z19.s, z6.s, z0.s[3]\n"
                "ld1rqw z0.s, p0/z, [%[a_ptr]]\n"
                "fmla z28.s, z6.s, z1.s[0]\n"
                "fmla z29.s, z6.s, z1.s[1]\n"
                "fmla z30.s, z6.s, z1.s[2]\n"
                "fmla z31.s, z6.s, z1.s[3]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #2, MUL VL]\n"
                "fmla z8.s, z4.s, z2.s[0]\n"
                "ld1rqw z1.s, p0/z, [%[a_ptr], #0x10]\n"
                "fmla z9.s, z4.s, z2.s[1]\n"
                "add %[a_ptr], %[a_ptr], #0x40\n"
                "fmla z10.s, z4.s, z2.s[2]\n"
                "addvl %[b_ptr], %[b_ptr], #6\n"
                "fmla z11.s, z4.s, z2.s[3]\n"
                "fmla z20.s, z4.s, z3.s[0]\n"
                "fmla z21.s, z4.s, z3.s[1]\n"
                "fmla z22.s, z4.s, z3.s[2]\n"
                "fmla z23.s, z4.s, z3.s[3]\n"
                "ld1w z4.s, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                "fmla z12.s, z5.s, z2.s[0]\n"
                "fmla z13.s, z5.s, z2.s[1]\n"
                "fmla z14.s, z5.s, z2.s[2]\n"
                "fmla z15.s, z5.s, z2.s[3]\n"
                "fmla z24.s, z5.s, z3.s[0]\n"
                "fmla z25.s, z5.s, z3.s[1]\n"
                "fmla z26.s, z5.s, z3.s[2]\n"
                "fmla z27.s, z5.s, z3.s[3]\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                "fmla z16.s, z6.s, z2.s[0]\n"
                "fmla z17.s, z6.s, z2.s[1]\n"
                "fmla z18.s, z6.s, z2.s[2]\n"
                "fmla z19.s, z6.s, z2.s[3]\n"
                "ld1rqw z2.s, p0/z, [%[a_ptr], #-0x20]\n"
                "fmla z28.s, z6.s, z3.s[0]\n"
                "fmla z29.s, z6.s, z3.s[1]\n"
                "fmla z30.s, z6.s, z3.s[2]\n"
                "fmla z31.s, z6.s, z3.s[3]\n"
                "b.ne 2b\n"
                "1:\n"
                "cbz %[tails], 3f\n"
                "fmla z8.s, z4.s, z0.s[0]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                "fmla z9.s, z4.s, z0.s[1]\n"
                "ld1rqw z3.s, p0/z, [%[a_ptr], #-0x10]\n"
                "fmla z10.s, z4.s, z0.s[2]\n"
                "fmla z11.s, z4.s, z0.s[3]\n"
                "fmla z20.s, z4.s, z1.s[0]\n"
                "fmla z21.s, z4.s, z1.s[1]\n"
                "fmla z22.s, z4.s, z1.s[2]\n"
                "fmla z23.s, z4.s, z1.s[3]\n"
                "ld1w z4.s, p0/z, [%[b_ptr]]\n"
                "fmla z12.s, z5.s, z0.s[0]\n"
                "fmla z13.s, z5.s, z0.s[1]\n"
                "fmla z14.s, z5.s, z0.s[2]\n"
                "fmla z15.s, z5.s, z0.s[3]\n"
                "fmla z24.s, z5.s, z1.s[0]\n"
                "fmla z25.s, z5.s, z1.s[1]\n"
                "fmla z26.s, z5.s, z1.s[2]\n"
                "fmla z27.s, z5.s, z1.s[3]\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #1, MUL VL]\n"
                "fmla z16.s, z6.s, z0.s[0]\n"
                "fmla z17.s, z6.s, z0.s[1]\n"
                "fmla z18.s, z6.s, z0.s[2]\n"
                "fmla z19.s, z6.s, z0.s[3]\n"
                "ld1rqw z0.s, p0/z, [%[a_ptr]]\n"
                "fmla z28.s, z6.s, z1.s[0]\n"
                "fmla z29.s, z6.s, z1.s[1]\n"
                "fmla z30.s, z6.s, z1.s[2]\n"
                "fmla z31.s, z6.s, z1.s[3]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #2, MUL VL]\n"
                "fmla z8.s, z4.s, z2.s[0]\n"
                "ld1rqw z1.s, p0/z, [%[a_ptr], #0x10]\n"
                "fmla z9.s, z4.s, z2.s[1]\n"
                "add %[a_ptr], %[a_ptr], #0x20\n"
                "fmla z10.s, z4.s, z2.s[2]\n"
                "addvl %[b_ptr], %[b_ptr], #6\n"
                "fmla z11.s, z4.s, z2.s[3]\n"
                "fmla z20.s, z4.s, z3.s[0]\n"
                "fmla z21.s, z4.s, z3.s[1]\n"
                "fmla z22.s, z4.s, z3.s[2]\n"
                "fmla z23.s, z4.s, z3.s[3]\n"
                "ld1w z4.s, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                "fmla z12.s, z5.s, z2.s[0]\n"
                "fmla z13.s, z5.s, z2.s[1]\n"
                "fmla z14.s, z5.s, z2.s[2]\n"
                "fmla z15.s, z5.s, z2.s[3]\n"
                "fmla z24.s, z5.s, z3.s[0]\n"
                "fmla z25.s, z5.s, z3.s[1]\n"
                "fmla z26.s, z5.s, z3.s[2]\n"
                "fmla z27.s, z5.s, z3.s[3]\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                "fmla z16.s, z6.s, z2.s[0]\n"
                "fmla z17.s, z6.s, z2.s[1]\n"
                "fmla z18.s, z6.s, z2.s[2]\n"
                "fmla z19.s, z6.s, z2.s[3]\n"
                "fmla z28.s, z6.s, z3.s[0]\n"
                "fmla z29.s, z6.s, z3.s[1]\n"
                "fmla z30.s, z6.s, z3.s[2]\n"
                "fmla z31.s, z6.s, z3.s[3]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                "fmla z8.s, z4.s, z0.s[0]\n"
                "fmla z9.s, z4.s, z0.s[1]\n"
                "fmla z10.s, z4.s, z0.s[2]\n"
                "fmla z11.s, z4.s, z0.s[3]\n"
                "fmla z20.s, z4.s, z1.s[0]\n"
                "st1w z8.s, p0, [%[c_ptr]]\n"
                "fmla z21.s, z4.s, z1.s[1]\n"
                "fmla z22.s, z4.s, z1.s[2]\n"
                "fmla z23.s, z4.s, z1.s[3]\n"
                "fmla z12.s, z5.s, z0.s[0]\n"
                "fmla z13.s, z5.s, z0.s[1]\n"
                "fmla z14.s, z5.s, z0.s[2]\n"
                "fmla z15.s, z5.s, z0.s[3]\n"
                "fmla z24.s, z5.s, z1.s[0]\n"
                "st1w z12.s, p0, [%[c_ptr], #1, MUL VL]\n"
                "fmla z25.s, z5.s, z1.s[1]\n"
                "fmla z26.s, z5.s, z1.s[2]\n"
                "fmla z27.s, z5.s, z1.s[3]\n"
                "fmla z16.s, z6.s, z0.s[0]\n"
                "fmla z17.s, z6.s, z0.s[1]\n"
                "fmla z18.s, z6.s, z0.s[2]\n"
                "fmla z19.s, z6.s, z0.s[3]\n"
                "fmla z28.s, z6.s, z1.s[0]\n"
                "st1w z16.s, p0, [%[c_ptr], #2, MUL VL]\n"
                "fmla z29.s, z6.s, z1.s[1]\n"
                "fmla z30.s, z6.s, z1.s[2]\n"
                "fmla z31.s, z6.s, z1.s[3]\n"
                "b 4f\n"
                "3:\n"
                "fmla z8.s, z4.s, z0.s[0]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                "fmla z9.s, z4.s, z0.s[1]\n"
                "ld1rqw z3.s, p0/z, [%[a_ptr], #-0x10]\n"
                "fmla z10.s, z4.s, z0.s[2]\n"
                "addvl %[b_ptr], %[b_ptr], #3\n"
                "fmla z11.s, z4.s, z0.s[3]\n"
                "fmla z20.s, z4.s, z1.s[0]\n"
                "fmla z21.s, z4.s, z1.s[1]\n"
                "fmla z22.s, z4.s, z1.s[2]\n"
                "fmla z23.s, z4.s, z1.s[3]\n"
                "ld1w z4.s, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                "fmla z12.s, z5.s, z0.s[0]\n"
                "fmla z13.s, z5.s, z0.s[1]\n"
                "fmla z14.s, z5.s, z0.s[2]\n"
                "fmla z15.s, z5.s, z0.s[3]\n"
                "fmla z24.s, z5.s, z1.s[0]\n"
                "fmla z25.s, z5.s, z1.s[1]\n"
                "fmla z26.s, z5.s, z1.s[2]\n"
                "fmla z27.s, z5.s, z1.s[3]\n"
                "ld1w z5.s, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                "fmla z16.s, z6.s, z0.s[0]\n"
                "fmla z17.s, z6.s, z0.s[1]\n"
                "fmla z18.s, z6.s, z0.s[2]\n"
                "fmla z19.s, z6.s, z0.s[3]\n"
                "fmla z28.s, z6.s, z1.s[0]\n"
                "fmla z29.s, z6.s, z1.s[1]\n"
                "fmla z30.s, z6.s, z1.s[2]\n"
                "fmla z31.s, z6.s, z1.s[3]\n"
                "ld1w z6.s, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                "fmla z8.s, z4.s, z2.s[0]\n"
                "fmla z9.s, z4.s, z2.s[1]\n"
                "fmla z10.s, z4.s, z2.s[2]\n"
                "fmla z11.s, z4.s, z2.s[3]\n"
                "fmla z20.s, z4.s, z3.s[0]\n"
                "st1w z8.s, p0, [%[c_ptr]]\n"
                "fmla z21.s, z4.s, z3.s[1]\n"
                "fmla z22.s, z4.s, z3.s[2]\n"
                "fmla z23.s, z4.s, z3.s[3]\n"
                "fmla z12.s, z5.s, z2.s[0]\n"
                "fmla z13.s, z5.s, z2.s[1]\n"
                "fmla z14.s, z5.s, z2.s[2]\n"
                "fmla z15.s, z5.s, z2.s[3]\n"
                "fmla z24.s, z5.s, z3.s[0]\n"
                "st1w z12.s, p0, [%[c_ptr], #1, MUL VL]\n"
                "fmla z25.s, z5.s, z3.s[1]\n"
                "fmla z26.s, z5.s, z3.s[2]\n"
                "fmla z27.s, z5.s, z3.s[3]\n"
                "fmla z16.s, z6.s, z2.s[0]\n"
                "fmla z17.s, z6.s, z2.s[1]\n"
                "fmla z18.s, z6.s, z2.s[2]\n"
                "fmla z19.s, z6.s, z2.s[3]\n"
                "fmla z28.s, z6.s, z3.s[0]\n"
                "st1w z16.s, p0, [%[c_ptr], #2, MUL VL]\n"
                "fmla z29.s, z6.s, z3.s[1]\n"
                "fmla z30.s, z6.s, z3.s[2]\n"
                "fmla z31.s, z6.s, z3.s[3]\n"
                "4:\n"
                "st1w z9.s, p0, [%[c_ptr], #3, MUL VL]\n"
                "st1w z13.s, p0, [%[c_ptr], #4, MUL VL]\n"
                "st1w z17.s, p0, [%[c_ptr], #5, MUL VL]\n"
                "st1w z10.s, p0, [%[c_ptr], #6, MUL VL]\n"
                "st1w z14.s, p0, [%[c_ptr], #7, MUL VL]\n"
                "addvl %[c_ptr], %[c_ptr], #16\n"
                "st1w z18.s, p0, [%[c_ptr], #-8, MUL VL]\n"
                "st1w z11.s, p0, [%[c_ptr], #-7, MUL VL]\n"
                "st1w z15.s, p0, [%[c_ptr], #-6, MUL VL]\n"
                "st1w z19.s, p0, [%[c_ptr], #-5, MUL VL]\n"
                "st1w z20.s, p0, [%[c_ptr], #-4, MUL VL]\n"
                "st1w z24.s, p0, [%[c_ptr], #-3, MUL VL]\n"
                "st1w z28.s, p0, [%[c_ptr], #-2, MUL VL]\n"
                "st1w z21.s, p0, [%[c_ptr], #-1, MUL VL]\n"
                "st1w z25.s, p0, [%[c_ptr]]\n"
                "st1w z29.s, p0, [%[c_ptr], #1, MUL VL]\n"
                "st1w z22.s, p0, [%[c_ptr], #2, MUL VL]\n"
                "st1w z26.s, p0, [%[c_ptr], #3, MUL VL]\n"
                "st1w z30.s, p0, [%[c_ptr], #4, MUL VL]\n"
                "st1w z23.s, p0, [%[c_ptr], #5, MUL VL]\n"
                "st1w z27.s, p0, [%[c_ptr], #6, MUL VL]\n"
                "st1w z31.s, p0, [%[c_ptr], #7, MUL VL]\n"
                "addvl %[c_ptr], %[c_ptr], #8\n"
            : [a_ptr] "+r" (a_ptr), [b_ptr] "+r" (b_ptr), [c_ptr] "+r" (c_ptr),
              [loops] "+r" (loops), [tails] "+r" (tails)
            :
            : "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31", "cc", "memory"
            );
        }
    }
}

} // namespace arm_gemm

#endif // __ARM_FEATURE_SVE
