/* $Id: Server.cpp,v 1.13 2002/10/11 03:31:34 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <Ark/ArkConfig.h>
#include <Ark/ArkSystem.h>
#include <Server/Server.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

namespace Server
{
  Server *g_Server = NULL;

  static void KillServer()
  {
     static bool shutdown = false;

     if (shutdown == false && g_Server != NULL)
     {
	shutdown = true;
	delete g_Server;
	g_Server = NULL;
     }
  }

  Server *GetServer ()
  {
    assert (g_Server != NULL);
    return g_Server;
  }

  Server::Server ()
  {
     g_Server = this;
     m_Engine = new Ark::Engine(&m_Cache, true);
     m_Network = new Network ("5555");

     Ark::Sys()->AtExit (&KillServer);
  }

  Server::~Server ()
  {
     delete m_Network;
     delete m_Engine;
  }

  int Server::Loop ()
  {
    int fps = Ark::Sys()->Cfg()->GetInt ("Server::FPS", 70);
    Ark::Sys()->Log ("[Server::Loop] Starting accept loop...\n");

    scalar T = 1.0/fps, last_delta = 0;
    // second/frame (period)

    while (1)
    {
      Ark::Timer frametmr;

      m_Network->Accept ();
      m_Network->Receive();
      m_Engine->Update  (last_delta);
      m_Network->Update ();

      // Compute time delta, and if we haven't reached the time
      // a frame should take, sleep a bit to release CPU
      scalar remaining = T - frametmr.GetDelta();

      if (remaining > 0.001)
      {
        m_SleepTime += remaining;
        usleep ((int) (remaining * 1e6));
      }

      last_delta = frametmr.GetDelta();
    }

    return 0;
  }

}

int main (int argc, char **argv)
{
   Ark::System::Init (&argc, &argv);
   Ark::Math::Init ();

   Server::Server server;
   return server.Loop();
}
