/* $Id: ArkTimer.h,v 1.4 2002/10/11 01:10:05 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_TIMER_H
#define ARK_TIMER_H

#include <Ark/ArkTypes.h>

namespace Ark
{

//  ==========================================================================
/// Timer class : used to compute time differences, etc...
//  ==========================================================================

class ARK_DLL_API Timer
{
  scalar m_Time;

public:
  /// Initialises the timer
  Timer ();

  /// Destroy the timer. Stub.
  ~Timer ();

  /** To get the current time, in seconds. REMARK: the returned value
  * can only be used to compute differences, etc (ie. elapsed time),
  * since it may be relative to the start of the program.
  */
  static scalar GetTime ();

  /// Set the timer time to the current time
  void Update ();

  /// Get the difference between the current time and the timer time
  scalar GetDelta ();
};

};

#endif
