/* $Id: ArkStream.h,v 1.11 2002/10/11 01:10:05 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_STREAM_H
#define ARK_STREAM_H

#include <Ark/Ark.h>
#include <Ark/ArkString.h>


#include <iostream>
#include <fstream>

#if 0
#include <Ark/zfstream.h>
#endif 


namespace Ark
{
    typedef std::istream ReadStream;
    typedef std::ostream WriteStream;

    /// By default, Stream objects are ReadStream objects.
    typedef ReadStream Stream;

    /// Stream object with some intelligence (later for it)
    class ARK_DLL_API AutoReadStream
    {
	protected:
	    std::ifstream* m_Stream;

	public:
	    AutoReadStream(const String& filename, std::ios::openmode mode = std::ios::in);

	    ~AutoReadStream();
	    
	    inline std::ifstream& Get() const 
	    { 
		assert(m_Stream && "stream in AutoStream is NULL!"); 
		return *m_Stream; 
	    }
    };

    typedef AutoReadStream AutoStream;
    
    typedef std::ofstream FileWriteStream;
    
/* namespace Ark */
}

#endif
