/* $Id: ArkModelWrite.cpp,v 1.20 2003/03/26 15:43:01 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Ark/ArkModel.h>

namespace Ark
{
   
#if 0
   //static const char *channels[6] = {"X", "Y", "Z", "RX", "RY", "RZ"};
   void
   OutputVector3 (WriteStream &stream,
		  const String &name, 
		  const Vector3 &v,
		  const String &indent = String())
   {
       //stream.setf(std::ios::fixed);
       stream << indent << '<' << name
	      << " X=\"" << v.X << "\" Y=\""
	      << v.Y << "\" Z=\"" << v.Z << "\">\n";
       stream << indent << "</" << name << ">\n";
   }
#endif

   bool
   Model::Write (WriteStream &stream)
   {
       //stream.setf(std::ios::fixed);
      size_t i;
      stream << "ArkModel\n\n"
	  << "Materials\n"
	  << "{\n";

      for (i = 0; i < m_Skin.m_Materials.size(); i++)
      {
	 stream << "  \"" 
		<< Basename(m_Skin.m_Materials[i]->Name()) << "\"\n";
      }
      
      stream <<  "}\n\n"
	  << "SubModels " << m_SubModels.size() << "\n{\n";

      for (i = 0; i < m_SubModels.size(); i++)
      {
	 SubModel &sm = m_SubModels[i];
	 size_t j;

	 stream << "  SubModel\n  {\n"
		<< "    VertexBuffer " << sm.m_VB.Size();
	 
	 if ((m_Skeleton != 0) && sm.m_BoneBindings.size() > 0)
	    stream << " bone";
	 if (sm.m_VB.Format() & VertexBuffer::VB_HAS_COLOR)
	    stream << " color";
	 if (sm.m_VB.Format() & VertexBuffer::VB_HAS_UV0)
	    stream << " uv0";

	 stream << "\n    {\n";

	 for (j = 0; j < sm.m_VB.Size(); j++)
	 {
	    Vector3 &coord = sm.m_VB.Coord(j);
	    Vector3 &normal = sm.m_VB.Normal(j);

	    stream << "      "
		// "%2.3f %2.3f %2.3f %0.4f %0.4f %0.4f"
		<< coord.X << ' ' << coord.Y << ' ' << coord.Z
		<< ' ' << normal.X << ' ' << normal.Y << ' ' << normal.Z;
	    
	    if (sm.m_VB.Format() & VertexBuffer::VB_HAS_UV0)
	    {
	       Vector2 &uv0 = sm.m_VB.UV0(j);
	       //Printf (stream, " %0.3f %0.3f", uv0.X, uv0.Y);
	       stream << ' ' << uv0.X << ' ' << uv0.Y;
	    }

	    if (sm.m_VB.Format() & VertexBuffer::VB_HAS_COLOR)
	    {
	       RGBA &col = sm.m_VB.Color4(j);
	       stream << ' ' << (int)col.R
		      << ' ' << (int)col.G
		      << ' ' << (int)col.B
		      << ' ' << (int)col.A;
	    }

	    stream << "\n";
	 }
	 stream << "    }\n\n";

	 if (m_Skeleton != 0 && sm.m_BoneBindings.size() > 0)
	 {
	    stream << "    BoneBindings "
		<< "\n    {\n      ";

	    for (size_t j = 0; j < sm.m_BoneBindings.size(); j++)
	    {
	       if (j % 20 == 0)
		  stream << "\n      ";

	       stream << (int)sm.m_BoneBindings[j] << " ";
	    }

	    if (sm.m_BoneBindings.size() % 20)
	       stream << '\n';

	    stream << "    }\n\n";
	 }

	 for (j = 0; j < sm.m_Meshes.size(); j++)
	 {
	    Mesh &mesh = sm.m_Meshes[j];

	    stream << "    Mesh " << mesh.m_Material
		<< "\n    {\n";

	    for (BlockList::iterator pb = mesh.m_Blocks.begin();
		 pb != mesh.m_Blocks.end(); ++pb)
	    {
	       stream << "      Triangle ";
 	       switch (pb->Type())
	       {
		  case PRIM_TRIANGLES : 
		     stream << "block ";
		     break;
		  case PRIM_TRIANGLE_STRIP : 
		     stream << "strip ";
		     break;
		  case PRIM_TRIANGLE_FAN : 
		     stream << "fan ";
		     break;
		  default:
		     break;
	       }

	       // Block
	       stream << pb->Size() << "\n      {\n      ";

	       for (size_t l = 0; l < pb->Size(); l++)
	       {
		  if ((l % 10) == 0)
		     stream << "\n        ";

		  stream << (*pb)[l] << " ";
	       }
	       stream << "\n      }\n\n";

	    }

	    stream << "    }\n";
	 }

	 stream << "  }\n";

      }

      stream << "}\n";

      if (m_Skeleton)
	 m_Skeleton->Write (stream);

      if (m_Optimized)
	 stream << "Optimized\n";
      return true;
   }

   bool operator == (Ark::Matrix44 &m1, Ark::Matrix44 &m2)
   {
      for(size_t j = 0; j < 16; j++)
	 if(m1.m_Elems[j] != m2.m_Elems[j])
	    return false;

      return true;
   }

   void
   Skeleton::Write (WriteStream &stream)
   {
      stream << "Skeleton " << m_Bones.size() << "\n{\n";

      for (size_t i = 0; i < m_Bones.size(); i++)
      {
	 Bone &bone = m_Bones[i];

	 stream << "  \"" << bone.m_Name << "\" "
	     << bone.m_DefPosition.X << ' '
	     << bone.m_DefPosition.Y << ' '
	     << bone.m_DefPosition.Z << ' '
	     << bone.m_DefRotation.X << ' '
	     << bone.m_DefRotation.Y << ' '
	     << bone.m_DefRotation.Z << ' ';

	 if (bone.m_Parent >= 0)
	    stream << '"' << m_Bones[bone.m_Parent].m_Name << "\"\n";
	 else
	    stream << "\"*\"\n";
      }

      stream << "  SeqList = \"" << m_SeqList << "\";\n";

      Matrix44 m, m2;
      m2.MakeRotationX(-90.0f);
      m.MakeRotationY(90.0f);
      m2.Multiply(m);

      if (m_RootMatrix == m2)
	 stream << "  FixXRot;\n";

      stream << "}\n";
   }
}
