/* $Id: ArkFactory.h,v 1.7 2002/11/16 16:40:01 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_FACTORY_H
#define ARK_FACTORY_H

#include <Ark/Ark.h>
#include <Ark/ArkString.h>
#include <Ark/ArkConfig.h>

#include <map>
#include <vector>

namespace Ark
{

   class LibraryMap;
   class Factory;

   typedef std::map<String,Factory*> FactoryMap;
   typedef FactoryMap::iterator FactoryMapIt;

   struct VersionInfo
   {
	 const char *m_Interface;
	 int m_Major, m_Minor, m_Micro, m_Release;
   };

   class FactoryList
   {
	 LibraryMap *m_Libraries;
	 FactoryMap m_Factories;
	 Config m_Config;

	 bool LoadConfig();
	 
      public:
	 ARK_DLL_API FactoryList();
	 ARK_DLL_API ~FactoryList();

	 ARK_DLL_API bool LoadLibrary(const String &name);
	 
	 ARK_DLL_API Factory *GetFactory(const String &name,
					 const VersionInfo &info);
	 template<class T>  bool GetFactory(String name, T **factory,
					    const VersionInfo &info)
	 {
	    assert (factory != NULL);
	    *factory = static_cast<T*>(GetFactory(name, info));
	    
	    return (*factory) != NULL;
	 }

	 ARK_DLL_API bool RegisterFactory(const String &name, Factory *fact);
   };

   class ARK_DLL_API RegisterList
   {
	 friend class FactoryList;

	 struct ARK_DLL_API Entry 
	 {
		String name; 
		Factory *fact;
		Entry(const String& name_, Factory* fact_) :
		   name(name_), fact(fact_) {}
	 };
	 static std::vector<Entry> s_Entries;


      public:
	 RegisterList(const String &name, Factory *fact);
   };

   class ARK_DLL_API Factory
   {
      public:
	 VersionInfo m_Version;
      public:
	 Factory (VersionInfo version);
   };
};

#endif
