/* $Id: Ark.cpp,v 1.19 2002/10/11 01:10:01 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef WIN32
#include <windows.h>
#endif

#include <Ark/Ark.h>
#include <Ark/ArkSystem.h>

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>


namespace Ark
{
/* Stubs */
System::System () {}
System::~System () {}

/* Tell the system there was an error/warning/etc */
/* Does the real stuff */
void
System::Report (ErrorLevel el, const char *format, va_list args)
{
  const char *lev;

  switch (el)
  {
    case E_WARNING: lev = "Ark-WARNING"; break;
    case E_ERROR:   lev = "Ark-ERROR"; break;
    case E_FATAL:   lev = "Ark-FATAL"; break;
    default:      lev = NULL; break;
  }

  if (lev) fprintf (stderr, "%s: ", lev);
  vfprintf (stderr, format, args);
  if (lev) fprintf (stderr, "\n");

#ifdef WIN32
  if (el == E_ERROR || el == E_FATAL)
  {
	char	*str;
	int		outp;

	 if ((outp	= vprintf(format, args)) > 0)
	 {
		str	= (char	*)malloc(outp);
		vsprintf(str, format, args);
	 }
	else
	{
		str	= (char	*)malloc(14);
		sprintf(str, "unknown error");
	}
     MessageBox (NULL, str, "Ark Runtime Error",
				MB_OK|MB_ICONEXCLAMATION);
  }
#endif

  if (el == E_FATAL)
    abort ();
}

#define REPORT(el,format)    \
{                            \
  va_list args;              \
  va_start (args, format);   \
  Report (el, format, args); \
  va_end (args);             \
}

/* Helpers */
void
System::Report (ErrorLevel el, const char *format, ...)
{ REPORT (el, format); }

void
System::Log (const char *format, ...)
{ REPORT (E_LOG, format); }

void
System::Warning (const char *format, ...)
{ REPORT (E_WARNING, format); }

void
System::Error (const char *format, ...)
{ REPORT (E_ERROR, format); }

void
System::Fatal (const char *format, ...)
{ REPORT (E_FATAL, format); }

void System::GetVersion (int *major, int *minor, int *micro)
{
  assert (minor != NULL);

  *major = VERSION_MAJOR;
  *minor = VERSION_MINOR;
  *micro = VERSION_MICRO;
}

/* Checks wether the header & library versions are the
** same, and returns false if there are incompatibilities
*/
void System::CheckVersion (int major, int minor, int micro)
{
  assert (major == VERSION_MAJOR
       && minor == VERSION_MINOR
       && micro == VERSION_MICRO);
}

/* namespace Ark */
}
